/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdVectorString
implements Native.assignable<std.vectorString>,
NativeCloneable<std.vectorString>,
Native.NativeComparable<std.vectorString>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<std.string>,
Destructors.ClassWithDestructor {
    protected final std.string defaultValue;
    protected std.string[] array;
    private static final Object[] EMPTY = new std.string[0];
    protected int end;

    protected StdVectorString(std.string defaultValue) {
        this.array = (std.string[])EMPTY;
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected StdVectorString(long initialSize, std.string defaultValue) {
        this(Unsigned.long2uint(initialSize), defaultValue);
    }

    protected StdVectorString(int initialSize, std.string defaultValue) {
        this(defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected StdVectorString(std.string[] array2, long length, std.string defaultValue) {
        this(array2, Unsigned.long2uint(length), defaultValue);
    }

    protected StdVectorString(std.string[] array2, int length, std.string defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected StdVectorString(type$iterator<?, std.string> iter, long length, std.string defaultValue) {
        this(iter, (type$iterator)iter.$add(length), defaultValue);
    }

    protected StdVectorString(type$iterator<?, std.string> iter, int length, std.string defaultValue) {
        this(iter, (type$iterator)iter.$add(length), defaultValue);
    }

    protected StdVectorString(type$iterator<?, std.string> begin, type$iterator<?, std.string> end, std.string defaultValue) {
        this(defaultValue);
        this.append(begin, end);
    }

    protected StdVectorString(std.vectorString other) {
        this(other.defaultValue);
        this.append(other.begin(), other.end());
    }

    @Override
    public std.vectorString $assign(std.vectorString other) {
        this.array = other.array;
        this.end = other.end;
        return (std.vectorString)this;
    }

    public std.vectorString $assignMove(std.vectorString other) {
        std.string[] tmpArray = this.array;
        int tmpEnd = this.end;
        this.array = other.array;
        this.end = other.end;
        other.array = tmpArray;
        other.end = tmpEnd;
        return (std.vectorString)this;
    }

    public void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void resize(long newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(int newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(long newSize, std.string defaultValue) {
        this.resize(Unsigned.long2uint(newSize), defaultValue);
    }

    public void resize(int newSize, std.string defaultValue) {
        if (newSize < this.array.length) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.array.length) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
    }

    public void reserve(long N) {
        this.reserve(Unsigned.long2uint(N));
    }

    public void reserve(int N) {
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public void assign(long NumElts, std.string Elt) {
        this.assign(Unsigned.long2uint(NumElts), Elt);
    }

    public void assign(int NumElts, std.string Elt) {
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public void assign(type$iterator<?, std.string> __first, type$iterator<?, std.string> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public void swap(StdVectorString RHS) {
        std.string[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final long find(Object elem) {
        return this.find(elem, 0L);
    }

    public final long find(Object elem, long from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = Unsigned.long2uint(from); i < this.end; ++i) {
            if (!Native.$eq(this.array[i], elem, isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(Object elem) {
        return this.find(elem) != (long)std.string.npos;
    }

    public final boolean erase(Object elem) {
        long _index = this.find(elem);
        if (_index == (long)std.string.npos) {
            return false;
        }
        int index = Unsigned.long2uint(_index);
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy(this.array, index + 1, this.end - index, this.array, index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy(I.$add(1), this.end(), I);
        this.pop_back();
        return N;
    }

    public iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = std.copy(E, this.end(), S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public iterator insert(iterator I, std.string Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public iterator insert(iterator I, long NumToInsert, std.string Elt) {
        return this.insert(I, Unsigned.long2uint(NumToInsert), Elt);
    }

    public iterator insert(iterator I, int NumToInsert, std.string Elt) {
        assert (NumToInsert >= 0);
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.fill_n(I, NumToInsert, Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        std.fill_n(I, NumOverwritten, Elt);
        std.fill_n(OldEnd, NumToInsert - NumOverwritten, Elt);
        return I;
    }

    public iterator insert(iterator I, type$iterator<?, std.string> From, type$iterator<?, std.string> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.copy(From, To, I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, OldEnd);
        return I;
    }

    public void append(type$iterator<?, std.string> in_start, type$iterator<?, std.string> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if ((long)NumInputs > (long)(this.capacity() - this.size())) {
            this.grow(this.size() + NumInputs);
        }
        type$iterator iter = (type$iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, (std.string)iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public void append(long NumInputs, std.string Elt) {
        this.append(Unsigned.long2uint(NumInputs), Elt);
    }

    public void append(int NumInputs, std.string Elt) {
        assert (NumInputs >= 0);
        if ((long)NumInputs > (long)(this.capacity() - this.size())) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    @Override
    public boolean $eq(std.vectorString RHS) {
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), RHS.begin());
    }

    @Override
    public boolean $noteq(std.vectorString RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $less(Object obj) {
        return std.lexicographical_compare(this.begin(), this.end(), ((StdVectorString)obj).begin(), ((StdVectorString)obj).end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((std.vectorString)obj);
    }

    public type$ref<std.string> ref$at(int idx) {
        return NativePointer.create_type$ref(this.array, idx);
    }

    public type$ref<std.string> ref$at(long idx) {
        return NativePointer.create_type$ref(this.array, idx);
    }

    public std.string $at(int idx) {
        return this.array[idx];
    }

    public std.string $at(long idx) {
        return this.array[(int)idx];
    }

    public std.string $set(int idx, std.string value) {
        this.array[idx] = this.defaultValue == null ? value : Native.$tryAssign(this.array[idx], value, false);
        return value;
    }

    public std.string $set(long idx, std.string value) {
        this.array[(int)idx] = this.defaultValue == null ? value : Native.$tryAssign(this.array[(int)idx], value, false);
        return value;
    }

    public boolean empty() {
        return this.size() == 0;
    }

    @Override
    public void $destroy() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void push_back(std.string val) {
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public std.string pop_back_val() {
        std.string val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public std.reverse_iterator<std.string> rbegin() {
        return new std.reverse_iterator<std.string>(NativePointer.create_type$ptr(this.array, (long)this.end));
    }

    public std.reverse_iterator<std.string> rend() {
        return new std.reverse_iterator<std.string>(NativePointer.create_type$ptr(this.array));
    }

    public type$ptr<std.string> data() {
        return NativePointer.create_type$ptr(this.array);
    }

    public std.string front() {
        return this.array[0];
    }

    public std.string back() {
        return this.array[this.end - 1];
    }

    public type$ref<std.string> ref$front() {
        return new type$ref<std.string>(){
            private final std.string stored;
            private final int index = 0;
            {
                this.stored = StdVectorString.this.array[0];
                this.index = 0;
            }

            @Override
            public std.string $deref() {
                return this.stored;
            }

            @Override
            public std.string $set(std.string value) {
                if (StdVectorString.this.defaultValue != null && this.stored != null) {
                    this.stored.$assign(value);
                } else {
                    StdVectorString.this.array[0] = value;
                }
                return value;
            }

            @Override
            public type$ptr<std.string> deref$ptr() {
                return (type$ptr)StdVectorString.this.data().$add(0);
            }
        };
    }

    public type$ref<std.string> ref$back() {
        return new type$ref<std.string>(){
            private final std.string stored;
            private final int index;
            {
                this.stored = StdVectorString.this.array[StdVectorString.this.end - 1];
                this.index = StdVectorString.this.end - 1;
            }

            @Override
            public std.string $deref() {
                return this.stored;
            }

            @Override
            public std.string $set(std.string value) {
                if (StdVectorString.this.defaultValue != null && this.stored != null) {
                    this.stored.$assign(value);
                } else {
                    StdVectorString.this.array[this.index] = value;
                }
                return value;
            }

            @Override
            public type$ptr<std.string> deref$ptr() {
                return (type$ptr)StdVectorString.this.data().$add(this.index);
            }
        };
    }

    public int size() {
        return this.end;
    }

    public int max_size() {
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        return this.array.length;
    }

    @Override
    public long $sizeof() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (std.string elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.capacity() * oneElemSize;
    }

    public type$ptr<std.string> ptr$at(int idx) {
        return NativePointer.create_type$ptr(this.array, (long)idx);
    }

    public type$ptr<std.string> ptr$at(long idx) {
        return NativePointer.create_type$ptr(this.array, idx);
    }

    @Override
    public std.vectorString clone() {
        return new std.vectorString((std.vectorString)this);
    }

    public void set_size(long N) {
        this.set_size(Unsigned.long2uint(N));
    }

    public void set_size(int N) {
        assert (N >= 0);
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (long i = (long)from; i < (long)to; ++i) {
            if (this.defaultValue == null) {
                this.array[(int)i] = null;
                continue;
            }
            Native.destroy(this.array[(int)i]);
        }
    }

    private void destroy_range(long from, long to) {
        for (long i = from; i < to; ++i) {
            if (this.defaultValue == null) {
                this.array[(int)i] = null;
                continue;
            }
            Native.destroy(this.array[(int)i]);
        }
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int newSize) {
        this.array = NativePointer.copyOf$Object(this.array, newSize);
    }

    private void grow() {
        this.grow(this.capacity() > 0 ? this.capacity() * 2 : 1);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(long to) {
        this.end = (int)to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<std.string> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\n").append(this.getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            std.string element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}").append(this.getClass().getSimpleName()).append("}\n");
        return out.toString();
    }

    private static final class JavaIterator
    implements Iterator<std.string> {
        private final iterator begin;
        private final iterator end;

        public JavaIterator(iterator begin, iterator end) {
            this.begin = Native.$tryClone(begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public std.string next() {
            std.string val = this.begin.$star();
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator
    implements type$iterator<iterator, std.string>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final StdVectorString delegate;
        private int index;

        public iterator(StdVectorString delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        @Override
        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public std.string $arrow() {
            return this.$at(0);
        }

        @Override
        public std.string $star() {
            return this.$at(0);
        }

        @Override
        public type$ref<std.string> star$ref() {
            return this.ref$at(0);
        }

        @Override
        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        @Override
        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        @Override
        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        @Override
        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        @Override
        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        @Override
        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        @Override
        public iterator $inc(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index + amount);
            return this;
        }

        @Override
        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        @Override
        public iterator $dec(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index - amount);
            return this;
        }

        @Override
        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        @Override
        public iterator $add(long amount) {
            return new iterator(this.delegate, (int)((long)this.index + amount), false);
        }

        @Override
        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        @Override
        public iterator $sub(long amount) {
            return new iterator(this.delegate, (int)((long)this.index - amount), false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        @Override
        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        @Override
        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        @Override
        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        @Override
        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        @Override
        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        @Override
        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public std.string $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public std.string $at(long index) {
            return this.delegate.$at((long)this.index + index);
        }

        public type$ref<std.string> ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public type$ref<std.string> ref$at(long index) {
            return this.delegate.ref$at((long)this.index + index);
        }

        public type$ptr<std.string> toPointer() {
            return NativePointer.create_type$ptr(this.delegate.array, (long)this.index);
        }

        public int $index() {
            return this.index;
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

