/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.abstract$assignable;
import org.clank.support.abstract_pointer;
import org.clank.support.aliases.type$memory;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ptr$heavy;
import org.clank.support.void$ptr;

public abstract class AbstractHeavyPointerType<T extends abstract_pointer, M extends NativeMemory.memory>
extends abstract$assignable<T, type$memory<T>>
implements abstract_pointer<T>,
NativeCloneable<T> {
    protected M memory;
    protected long index;

    public AbstractHeavyPointerType(M memory2, long index, type$memory<T> selfMemory, int selfIndex) {
        super(selfMemory, selfIndex);
        this.memory = memory2;
        this.index = index;
    }

    @Override
    public boolean $isNull() {
        return this.memory == null;
    }

    @Override
    public int $sub(T ptr2) {
        if (ptr2 instanceof AbstractHeavyPointerType) {
            AbstractHeavyPointerType other = (AbstractHeavyPointerType)ptr2;
            NativeMemory.MemoryPoint p1 = NativePointer.extractMemoryPoint(this);
            NativeMemory.MemoryPoint p2 = NativePointer.extractMemoryPoint(other);
            return NativeMemory.getMemoryPointsDistance(p1, p2);
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "'" + ", but found '" + (ptr2 != null ? ptr2.getClass() : "null") + "'");
    }

    @Override
    public T $assign(T value) {
        if (value instanceof AbstractHeavyPointerType) {
            AbstractHeavyPointerType other = (AbstractHeavyPointerType)value;
            this.memory = other.memory;
            this.index = other.index;
            return (T)this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "'" + ", but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public T $preInc() {
        ++this.index;
        return (T)this;
    }

    @Override
    public T $preDec() {
        --this.index;
        return (T)this;
    }

    @Override
    public T $postInc() {
        Object prev = this.clone();
        ++this.index;
        return (T)prev;
    }

    @Override
    public T $postDec() {
        Object prev = this.clone();
        --this.index;
        return (T)prev;
    }

    @Override
    public T $inc(int amount) {
        this.index += (long)amount;
        return (T)this;
    }

    @Override
    public T $inc(long amount) {
        this.index += amount;
        return (T)this;
    }

    @Override
    public T $dec(int amount) {
        this.index -= (long)amount;
        return (T)this;
    }

    @Override
    public T $dec(long amount) {
        this.index -= amount;
        return (T)this;
    }

    @Override
    public T $add(int amount) {
        Object created = this.clone();
        return (T)((abstract_pointer)created.$inc(amount));
    }

    @Override
    public T $add(long amount) {
        Object created = this.clone();
        return (T)((abstract_pointer)created.$inc(amount));
    }

    @Override
    public T $sub(int amount) {
        Object created = this.clone();
        return (T)((abstract_pointer)created.$dec(amount));
    }

    @Override
    public T $sub(long amount) {
        Object created = this.clone();
        return (T)((abstract_pointer)created.$dec(amount));
    }

    @Override
    public type$ptr<T> $addr() {
        return new type$ptr$heavy(this.selfMemory, this.selfIndex);
    }

    @Override
    public boolean $eq(Object p) {
        if (p == this) {
            return true;
        }
        return NativePointer.arePointersEqual(this, (void$ptr)p);
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return NativePointer.arePointersComparable(this, other);
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof void$ptr) {
            return NativePointer.comparePointers(this, (void$ptr)obj) < 0;
        }
        return false;
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof void$ptr) {
            return NativePointer.comparePointers(this, (void$ptr)obj) <= 0;
        }
        return false;
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof void$ptr) {
            return NativePointer.comparePointers(this, (void$ptr)obj) > 0;
        }
        return false;
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof void$ptr) {
            return NativePointer.comparePointers(this, (void$ptr)obj) >= 0;
        }
        return false;
    }

    @Override
    public long $hashcode() {
        return NativePointer.calcHashCode(this);
    }

    @Override
    protected type$memory<T> createMemory() {
        return new NativeMemory.type.mem<AbstractHeavyPointerType>(this);
    }

    @Override
    public T clone() {
        try {
            return (T)((abstract_pointer)super.clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Clone is not supported!");
        }
    }

    @Override
    public T const_clone() {
        try {
            return (T)((abstract_pointer)super.clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Clone is not supported!");
        }
    }
}

