/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

public final class BitFieldsUtils {
    private BitFieldsUtils() {
    }

    public static int setLastBits(int flagsField, int LastBits, int Value) {
        int LHSMask;
        assert (LastBits <= 32) : LastBits;
        int n = LHSMask = LastBits == 32 ? 0 : -1 << LastBits;
        assert ((Value & LHSMask) == 0) : "using more than " + LastBits + " in " + Integer.toBinaryString(Value);
        flagsField = BitFieldsUtils.setLastMaskedBits(flagsField, LHSMask, Value);
        assert (BitFieldsUtils.getLastBits(flagsField, LastBits) == Value) : Value + " vs " + BitFieldsUtils.getLastBits(flagsField, LastBits);
        return flagsField;
    }

    public static int setLastMaskedBits(int flagsField, int ClearOldValueMask, int Value) {
        assert ((Value & ClearOldValueMask) == 0) : "using more bits than in " + ClearOldValueMask + " for " + Integer.toBinaryString(Value);
        flagsField = flagsField & ClearOldValueMask | Value;
        assert (BitFieldsUtils.getLastMaskedBits(flagsField, ~ClearOldValueMask) == Value) : Value + " vs " + BitFieldsUtils.getLastMaskedBits(flagsField, ~ClearOldValueMask);
        return flagsField;
    }

    public static int setMiddleBits(int flagsField, int FirstBitIndex, int BitsNum, int Value) {
        int lastBits = FirstBitIndex - BitsNum;
        assert (lastBits >= 0) : " FirstBitIndex " + FirstBitIndex + " less than BitsNum " + BitsNum;
        int afterLastBitsValue = lastBits == 0 ? 0 : BitFieldsUtils.getLastBits(flagsField, lastBits);
        flagsField = BitFieldsUtils.setLastBits(flagsField, FirstBitIndex, Value << lastBits) | afterLastBitsValue;
        assert (BitFieldsUtils.getMiddleBits(flagsField, FirstBitIndex, BitsNum) == Value) : Value + " vs " + BitFieldsUtils.getMiddleBits(flagsField, FirstBitIndex, BitsNum);
        return flagsField;
    }

    public static int setBit(int flagsField, int Bit, boolean val) {
        assert (Bit <= 32) : Bit;
        int Mask = 1 << Bit;
        flagsField = BitFieldsUtils.setMaskedBit(flagsField, Mask, val);
        assert (BitFieldsUtils.getBit(flagsField, Bit) == val) : val + " vs " + BitFieldsUtils.getBit(flagsField, Bit);
        return flagsField;
    }

    public static int setMaskedBit(int flagsField, int Mask, boolean val) {
        assert ((Mask & Mask - 1) == 0) : "must have only one bit" + Integer.toBinaryString(Mask);
        flagsField = val ? (flagsField |= Mask) : (flagsField &= ~Mask);
        assert (BitFieldsUtils.getMaskedBit(flagsField, Mask) == val) : val + " vs " + BitFieldsUtils.getMaskedBit(flagsField, Mask);
        return flagsField;
    }

    public static int getLastBits(int flagsField, int LastBits) {
        assert (LastBits <= 32) : LastBits;
        int Mask = LastBits == 32 ? -1 : (1 << LastBits) - 1;
        return BitFieldsUtils.getLastMaskedBits(flagsField, Mask);
    }

    public static int getLastMaskedBits(int flagsField, int MaskForLastBits) {
        return flagsField & MaskForLastBits;
    }

    public static int getMiddleBits(int flagsField, int FirstBitIndex, int BitsNum) {
        int BitsAfter = FirstBitIndex - BitsNum;
        assert (BitsAfter >= 0) : " FirstBitIndex " + FirstBitIndex + " less than BitsNum " + BitsNum;
        int Value = BitFieldsUtils.getLastBits(flagsField >> BitsAfter, BitsNum);
        return Value;
    }

    public static boolean getBit(int flagsField, int Bit) {
        assert (Bit <= 32) : Bit;
        int Mask = 1 << Bit;
        return (flagsField & Mask) == Mask;
    }

    public static boolean getMaskedBit(int flagsField, int Mask) {
        assert ((Mask & Mask - 1) == 0) : "must have only one bit" + Integer.toBinaryString(Mask);
        return (flagsField & Mask) == Mask;
    }
}

