/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support.aliases;

import java.io.PrintWriter;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;
import org.clank.support.void$ptr;

public final class type$ptr$array<T>
extends AbstractArrayPointerType<type$ptr<T>>
implements type$ptr<T> {
    protected T[] array;
    private static long instances = 0L;

    protected type$ptr$array(type$ptr$array<T> other, boolean makeConst) {
        super(other, makeConst);
        this.array = other.array;
        type$ptr$array.trackInstance();
    }

    public type$ptr$array() {
        this((T[])null, 0, false);
    }

    public type$ptr$array(T[] arr) {
        this(arr, 0, false);
    }

    public type$ptr$array(T[] arr, long idx) {
        this(arr, Unsigned.long2uint(idx), false);
    }

    public type$ptr$array(T[] arr, int idx) {
        this(arr, idx, false);
    }

    public type$ptr$array(T[] arr, boolean makeConst) {
        this(arr, 0, makeConst);
    }

    public type$ptr$array(T[] arr, long idx, boolean makeConst) {
        this(arr, Unsigned.long2uint(idx), makeConst);
    }

    public type$ptr$array(T[] arr, int idx, boolean makeConst) {
        super(makeConst);
        this.array = arr;
        assert (idx >= 0) : "can not be negative " + idx;
        this.index = idx;
        type$ptr$array.trackInstance();
    }

    @Override
    public boolean $isNull() {
        return this.array == null;
    }

    @Override
    public T $star() {
        return this.array[this.index];
    }

    @Override
    public T $set(T value) {
        return this.$set(0, value);
    }

    @Override
    public T $at(int index) {
        return this.array[this.index + index];
    }

    @Override
    public T $at(long index) {
        return this.array[(int)((long)this.index + index)];
    }

    @Override
    public int $sub(type$ptr<T> other) {
        assert (other instanceof type$ptr$array) : "unexpected object " + other;
        return this.index - ((type$ptr$array)other).index;
    }

    @Override
    public type$ptr$array<T> $add(int amount) {
        type$ptr$array<T> cloned = new type$ptr$array<T>(this, false);
        cloned.index += amount;
        return cloned;
    }

    @Override
    public type$ptr$array<T> $add(long amount) {
        type$ptr$array<T> cloned = new type$ptr$array<T>(this, false);
        cloned.index = (int)((long)cloned.index + amount);
        return cloned;
    }

    @Override
    public type$ptr$array<T> $sub(int amount) {
        type$ptr$array<T> cloned = new type$ptr$array<T>(this, false);
        cloned.index -= amount;
        return cloned;
    }

    @Override
    public type$ptr$array<T> $sub(long amount) {
        type$ptr$array<T> cloned = new type$ptr$array<T>(this, false);
        cloned.index = (int)((long)cloned.index - amount);
        return cloned;
    }

    @Override
    public T $set(int index, T value) {
        T t = value;
        this.array[this.index + index] = t;
        return t;
    }

    @Override
    public T $set(long index, T value) {
        T t = value;
        this.array[(int)((long)this.index + index)] = t;
        return t;
    }

    @Override
    public type$ptr<T> $assign(type$ptr<T> value) {
        assert (!this._isConst()) : "Cannot modify const object!";
        if (value instanceof type$ptr$array) {
            type$ptr$array val = (type$ptr$array)value;
            this.array = val.array;
            this.index = val.index;
            return this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "'" + ", but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return other instanceof type$ptr$array && ((type$ptr$array)other).array == this.array;
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index < 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index <= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index > 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)obj;
            return other.array == this.array && this.index - other.index >= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $eq(Object p) {
        if (p instanceof type$ptr$array) {
            type$ptr$array other = (type$ptr$array)p;
            return other.array == this.array && this.index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public type$ref<T> star$ref() {
        return new type$ref<T>(){
            type$ptr$array<T> localPtr;
            {
                this.localPtr = type$ptr$array.this;
            }

            @Override
            public T $deref() {
                return this.localPtr.$star();
            }

            @Override
            public T $set(T value) {
                return this.localPtr.$set(value);
            }

            @Override
            public type$ptr<T> deref$ptr() {
                if (this.localPtr == type$ptr$array.this) {
                    this.localPtr = this.localPtr.clone();
                }
                return this.localPtr;
            }
        };
    }

    @Override
    public long $hashcode() {
        return (long)System.identityHashCode(this.array) ^ (long)this.index;
    }

    @Override
    public type$ptr$array<T> clone() {
        return new type$ptr$array<T>(this, false);
    }

    @Override
    public type$ptr$array<T> const_clone() {
        return super._isConst() ? this : new type$ptr$array<T>(this, true);
    }

    public String toString() {
        if (this.array == null || this.array.length == 0) {
            return "<EMPTY>";
        }
        StringBuilder sb = new StringBuilder("\n" + type$ptr$array.class.getSimpleName() + "{range=[" + this.index + "-" + this.array.length + "]\n");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.array.length + 1)) + "d";
        for (int i = this.index; i < this.array.length; ++i) {
            T b = this.array[i];
            sb.append(i == this.index ? "*[" : " [").append(String.format(fmt, i)).append("]");
            sb.append(b).append("\n");
            if (i - this.index <= 256) continue;
            sb.append("....");
            break;
        }
        sb.append("}").append(type$ptr$array.class.getSimpleName()).append("\n");
        return sb.toString();
    }

    public static void trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
    }

    public static void clearStatistics() {
        instances = 0L;
    }

    public static void printStatistics(PrintWriter out) {
        out.printf("%22s created:\t%s%n", type$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(instances));
    }

    @Override
    public final T[] $array() {
        return this.array;
    }
}

