/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.commands.BugzillaExecutor;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepositoryController;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.MylynUtils;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.UnsubmittedTasksContainer;
import org.netbeans.modules.mylyn.util.commands.GetRepositoryTasksCommand;
import org.netbeans.modules.mylyn.util.commands.SimpleQueryCommand;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.netbeans.modules.team.spi.RepositoryUser;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BugzillaRepository {
    private static final String ICON_PATH = "org/netbeans/modules/bugtracking/ui/resources/repository.png";
    private RepositoryInfo info;
    private TaskRepository taskRepository;
    private BugzillaRepositoryController controller;
    private Set<BugzillaQuery> queries = null;
    private Cache cache;
    private BugzillaExecutor executor;
    private Image icon;
    private BugzillaConfiguration bc;
    private PropertyChangeSupport support;
    private final Object RC_LOCK = new Object();
    private final Object CACHE_LOCK = new Object();
    private UnsubmittedTasksContainer unsubmittedTasksContainer;
    private PropertyChangeListener unsubmittedTasksListener;
    private boolean queryCleanedup = false;

    public BugzillaRepository() {
        this.icon = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        this.support = new PropertyChangeSupport(this);
    }

    public BugzillaRepository(RepositoryInfo info) {
        this();
        this.info = this.checkAndPatchNetbeansUrl(info);
        String name = this.info.getDisplayName();
        String url = this.info.getUrl();
        boolean shortLoginEnabled = Boolean.parseBoolean(this.info.getValue("bugzilla.shortLoginEnabled"));
        this.taskRepository = BugzillaRepository.setupTaskRepository(name, null, url, "", new char[0], "", new char[0], shortLoginEnabled);
    }

    public RepositoryInfo getInfo() {
        return this.info;
    }

    public String getID() {
        return this.info.getID();
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public BugzillaQuery createQuery() {
        BugzillaConfiguration conf = this.getConfiguration();
        if (conf == null || !conf.isValid()) {
            return null;
        }
        BugzillaQuery q = new BugzillaQuery(this);
        return q;
    }

    public BugzillaIssue createIssue() {
        BugzillaConfiguration conf = this.getConfiguration();
        if (conf == null || !conf.isValid()) {
            return null;
        }
        String product = null;
        String component = null;
        for (String productCandidate : conf.getProducts()) {
            List<String> components = conf.getComponents(productCandidate);
            if (components.isEmpty()) continue;
            product = productCandidate;
            component = components.get(0);
            break;
        }
        try {
            NbTask task = MylynSupport.getInstance().createTask(this.taskRepository, (ITaskMapping)new TaskMapping(product, component));
            return this.getIssueForTask(task);
        }
        catch (OperationCanceledException ex) {
            Bugzilla.LOG.log(Level.FINE, null, ex);
            return null;
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.WARNING, null, ex);
            return null;
        }
    }

    public void remove() {
        BugzillaQuery[] toRemove;
        Collection<BugzillaQuery> qs = this.getQueries();
        for (BugzillaQuery q : toRemove = qs.toArray(new BugzillaQuery[qs.size()])) {
            this.removeQuery(q);
        }
        this.resetRepository(true);
        if (this.getTaskRepository() != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugzillaIssue getIssueForTask(NbTask task) {
        BugzillaIssue issue = null;
        if (task != null) {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                String taskId = BugzillaIssue.getID((NbTask)task);
                Cache issueCache = this.getIssueCache();
                issue = issueCache.getIssue(taskId);
                if (issue == null) {
                    issue = issueCache.setIssue(taskId, new BugzillaIssue(task, this));
                }
            }
        }
        return issue;
    }

    public void taskDeleted(String taskId) {
        this.getIssueCache().removeIssue(taskId);
    }

    public Collection<BugzillaIssue> getUnsubmittedIssues() {
        try {
            UnsubmittedTasksContainer cont = this.getUnsubmittedTasksContainer();
            List unsubmittedTasks = cont.getTasks();
            ArrayList<BugzillaIssue> unsubmittedIssues = new ArrayList<BugzillaIssue>(unsubmittedTasks.size());
            for (NbTask task : unsubmittedTasks) {
                BugzillaIssue issue = this.getIssueForTask(task);
                if (issue == null) continue;
                unsubmittedIssues.add(issue);
            }
            return unsubmittedIssues;
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.INFO, null, ex);
            return Collections.emptyList();
        }
    }

    public BugzillaQuery createPersistentQuery(String queryName, String urlParams, boolean urlDef) {
        IRepositoryQuery query = null;
        try {
            query = MylynSupport.getInstance().getRepositoryQuery(this.getTaskRepository(), queryName);
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.WARNING, null, ex);
        }
        return new BugzillaQuery(queryName, query, this, urlParams, true, urlDef, true);
    }

    synchronized void resetRepository(boolean keepConfiguration) {
        if (!keepConfiguration) {
            this.bc = null;
        }
    }

    public String getDisplayName() {
        return this.info.getDisplayName();
    }

    private String getTooltip(String repoName, String user, String url) {
        return NbBundle.getMessage(BugzillaRepository.class, (String)"LBL_RepositoryTooltip", (Object[])new Object[]{repoName, user, url});
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getUsername() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return c != null ? c.getUserName() : "";
    }

    public char[] getPassword() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return c != null ? c.getPassword().toCharArray() : new char[]{};
    }

    public String getHttpUsername() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return c != null ? c.getUserName() : "";
    }

    public char[] getHttpPassword() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return c != null ? c.getPassword().toCharArray() : new char[]{};
    }

    public List<BugzillaIssue> getIssues(String ... ids) {
        LinkedList<BugzillaIssue> ret = new LinkedList<BugzillaIssue>();
        try {
            MylynSupport supp = MylynSupport.getInstance();
            HashSet<String> unknownTasks = new HashSet<String>(ids.length);
            for (String id : ids) {
                BugzillaIssue issue = this.findUnsubmitted(id);
                if (issue == null) {
                    issue = this.getIssueForTask(supp.getTask(this.getTaskRepository().getUrl(), id));
                }
                if (issue == null) {
                    unknownTasks.add(id);
                    continue;
                }
                ret.add(issue);
            }
            if (!unknownTasks.isEmpty()) {
                GetRepositoryTasksCommand cmd = supp.getCommandFactory().createGetRepositoryTasksCommand(this.taskRepository, unknownTasks);
                this.getExecutor().execute((BugtrackingCommand)cmd, true);
                for (NbTask task : cmd.getTasks()) {
                    BugzillaIssue issue = this.getIssueForTask(task);
                    if (issue == null) continue;
                    ret.add(issue);
                }
            }
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.INFO, null, ex);
        }
        return ret;
    }

    public BugzillaIssue getIssue(String id) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        BugzillaIssue issue = this.findUnsubmitted(id);
        if (issue == null) {
            issue = this.getIssueForTask(BugzillaUtil.getTask(this, id, true));
        }
        return issue;
    }

    public Collection<BugzillaIssue> simpleSearch(String criteria) {
        QueryParameter[] additionalParams;
        BugzillaIssue issue;
        assert (this.taskRepository != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        String[] keywords = criteria.split(" ");
        ArrayList<BugzillaIssue> issues = new ArrayList<BugzillaIssue>();
        if (keywords.length == 1 && this.isInteger(keywords[0]) && (issue = this.getIssueForTask(BugzillaUtil.getTask(this, keywords[0], false))) != null) {
            issues.add(issue);
        }
        StringBuilder url = new StringBuilder();
        url.append("/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=");
        for (int i = 0; i < keywords.length; ++i) {
            String val = keywords[i].trim();
            if (val.equals("")) continue;
            try {
                val = URLEncoder.encode(val, this.getTaskRepository().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException ueex) {
                Bugzilla.LOG.log(Level.INFO, null, ueex);
                try {
                    val = URLEncoder.encode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            url.append(val);
            if (i >= keywords.length - 1) continue;
            url.append("+");
        }
        for (QueryParameter qp : additionalParams = this.getSimpleSearchParameters()) {
            url.append(qp.get(true));
        }
        try {
            IRepositoryQuery iquery = MylynSupport.getInstance().createNewQuery(this.taskRepository, "bugzilla simple search query");
            iquery.setUrl(url.toString());
            SimpleQueryCommand cmd = MylynSupport.getInstance().getCommandFactory().createSimpleQueryCommand(this.taskRepository, iquery);
            this.getExecutor().execute((BugtrackingCommand)cmd, false);
            for (NbTask task : cmd.getTasks()) {
                BugzillaIssue issue2 = this.getIssueForTask(task);
                if (issue2 == null) continue;
                issues.add(issue2);
            }
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.WARNING, null, ex);
        }
        return issues;
    }

    public RepositoryController getController() {
        if (this.controller == null) {
            this.controller = new BugzillaRepositoryController(this);
        }
        return this.controller;
    }

    public Collection<BugzillaQuery> getQueries() {
        return this.getQueriesIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getIssueCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = new Cache();
            }
            return this.cache;
        }
    }

    public void removeQuery(BugzillaQuery query) {
        Bugzilla.LOG.log(Level.FINE, "removing query {0} for repository {1}", new Object[]{query.getDisplayName(), this.getDisplayName()});
        BugzillaConfig.getInstance().removeQuery(this, query);
        this.getQueriesIntern().remove(query);
        this.fireQueryListChanged();
    }

    public void saveQuery(BugzillaQuery query) {
        assert (this.info != null);
        Bugzilla.LOG.log(Level.FINE, "saving query {0} for repository {1}", new Object[]{query.getDisplayName(), this.getDisplayName()});
        BugzillaConfig.getInstance().putQuery(this, query);
        this.getQueriesIntern().add(query);
        this.fireQueryListChanged();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private void fireQueryListChanged() {
        Bugzilla.LOG.log(Level.FINER, "firing query list changed for repository {0}", new Object[]{this.getDisplayName()});
        this.support.firePropertyChange("bugtracking.repository.queries.changed", null, null);
    }

    private void fireUnsubmittedIssuesChanged() {
        Bugzilla.LOG.log(Level.FINER, "firing unsubmitted issues changed for repository {0}", new Object[]{this.getDisplayName()});
        this.support.firePropertyChange("bugtracking.repository.unsubmittedIssues.changed", null, null);
    }

    private Set<BugzillaQuery> getQueriesIntern() {
        if (this.queries == null) {
            String[] qs;
            if (!this.queryCleanedup) {
                this.queryCleanedup = true;
                try {
                    Set iqs = MylynSupport.getInstance().getRepositoryQueries(this.taskRepository);
                    for (IRepositoryQuery q : iqs) {
                        if (!q.getSummary().startsWith("bugzilla ad-hoc query nr. ")) continue;
                        MylynSupport.getInstance().deleteQuery(q);
                    }
                }
                catch (CoreException ex) {
                    Bugzilla.LOG.log(Level.INFO, null, ex);
                }
            }
            this.queries = new HashSet<BugzillaQuery>(10);
            for (String queryName : qs = BugzillaConfig.getInstance().getQueries(this.getID())) {
                BugzillaQuery q = BugzillaConfig.getInstance().getQuery(this, queryName);
                if (q != null) {
                    this.queries.add(q);
                    continue;
                }
                Bugzilla.LOG.log(Level.WARNING, "Couldn''t find query with stored name {0}", queryName);
            }
        }
        return this.queries;
    }

    public synchronized void setInfoValues(String user, char[] password) {
        this.info = this.createInfo(this.info.getID(), this.info.getUrl(), this.info.getDisplayName(), user, null, password, null, Boolean.parseBoolean(this.info.getValue("bugzilla.shortLoginEnabled")));
        this.setTaskRepository(this.info.getDisplayName(), this.info.getUrl(), user, password, null, null, Boolean.parseBoolean(this.info.getValue("bugzilla.shortLoginEnabled")));
    }

    synchronized void setInfoValues(String name, String url, String user, char[] password, String httpUser, char[] httpPassword, boolean localUserEnabled) {
        String id = this.info != null ? this.info.getID() : name + System.currentTimeMillis();
        this.info = this.createInfo(id, url, name, user, httpUser, password, httpPassword, localUserEnabled);
        this.setTaskRepository(name, url, user, password, httpUser, httpPassword, localUserEnabled);
    }

    protected RepositoryInfo createInfo(String id, String url, String name, String user, String httpUser, char[] password, char[] httpPassword, boolean localUserEnabled) {
        RepositoryInfo ri = new RepositoryInfo(id, "org.netbeans.modules.bugzilla", url, name, this.getTooltip(name, user, url), user, httpUser, password, httpPassword);
        ri.putValue("bugzilla.shortLoginEnabled", Boolean.toString(localUserEnabled));
        return ri;
    }

    public void ensureCredentials() {
        this.setCredentials(this.info.getUsername(), this.info.getPassword(), this.info.getHttpUsername(), this.info.getHttpPassword(), true);
    }

    public void setCredentials(String user, char[] password, String httpUser, char[] httpPassword) {
        this.setCredentials(user, password, httpUser, httpPassword, false);
    }

    private synchronized void setCredentials(String user, char[] password, String httpUser, char[] httpPassword, boolean keepConfiguration) {
        MylynUtils.setCredentials((TaskRepository)this.taskRepository, (String)user, (char[])password, (String)httpUser, (char[])httpPassword);
        this.resetRepository(keepConfiguration);
    }

    protected synchronized void setTaskRepository(String user, char[] password) {
        this.setTaskRepository(this.info.getDisplayName(), this.info.getUrl(), user, password, null, null, Boolean.parseBoolean(this.info.getValue("bugzilla.shortLoginEnabled")));
    }

    private void setTaskRepository(String name, String url, String user, char[] password, String httpUser, char[] httpPassword, boolean shortLoginEnabled) {
        String oldUrl = this.taskRepository != null ? this.taskRepository.getUrl() : "";
        AuthenticationCredentials c = this.taskRepository != null ? this.taskRepository.getCredentials(AuthenticationType.REPOSITORY) : null;
        String oldUser = c != null ? c.getUserName() : "";
        this.taskRepository = BugzillaRepository.setupTaskRepository(name, oldUrl.equals(url) ? null : oldUrl, url, user, password, httpUser, httpPassword, shortLoginEnabled);
        this.resetRepository(oldUrl.equals(url) && oldUser.equals(user));
    }

    private static TaskRepository setupTaskRepository(String name, String oldUrl, String url, String user, char[] password, String httpUser, char[] httpPassword, boolean shortLoginEnabled) {
        TaskRepository repository;
        if (oldUrl == null) {
            repository = MylynSupport.getInstance().getTaskRepository((AbstractRepositoryConnector)Bugzilla.getInstance().getRepositoryConnector(), url);
        } else {
            repository = MylynSupport.getInstance().getTaskRepository((AbstractRepositoryConnector)Bugzilla.getInstance().getRepositoryConnector(), oldUrl);
            try {
                MylynSupport.getInstance().setRepositoryUrl(repository, url);
            }
            catch (CoreException ex) {
                Bugzilla.LOG.log(Level.WARNING, null, ex);
            }
        }
        BugzillaRepository.setupProperties(repository, name, user, password, httpUser, httpPassword, shortLoginEnabled);
        return repository;
    }

    static TaskRepository createTemporaryTaskRepository(String name, String url, String user, char[] password, String httpUser, char[] httpPassword, boolean localUserEnabled) {
        TaskRepository taskRepository = new TaskRepository(Bugzilla.getInstance().getRepositoryConnector().getConnectorKind(), url);
        BugzillaRepository.setupProperties(taskRepository, name, user, password, httpUser, httpPassword, localUserEnabled);
        return taskRepository;
    }

    private static void setupProperties(TaskRepository repository, String displayName, String user, char[] password, String httpUser, char[] httpPassword, boolean shortLoginEnabled) {
        repository.setRepositoryLabel(displayName);
        MylynUtils.setCredentials((TaskRepository)repository, (String)user, (char[])password, (String)httpUser, (char[])httpPassword);
        repository.setProperty("bugzilla.shortLoginEnabled", shortLoginEnabled ? "true" : "false");
    }

    public String getUrl() {
        return this.taskRepository != null ? this.taskRepository.getUrl() : null;
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public BugzillaExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new BugzillaExecutor(this);
        }
        return this.executor;
    }

    public boolean authenticate(String errroMsg) {
        return Bugzilla.getInstance().getBugtrackingFactory().editRepository((Object)this, errroMsg);
    }

    public boolean isShortUsernamesEnabled() {
        return this.taskRepository != null && "true".equals(this.taskRepository.getProperty("bugzilla.shortLoginEnabled"));
    }

    public Collection<RepositoryUser> getUsers() {
        return Collections.emptyList();
    }

    public OwnerInfo getOwnerInfo(Node[] nodes) {
        OwnerInfo ownerInfo;
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        if (BugzillaUtil.isNbRepository(this) && nodes != null && nodes.length > 0 && (ownerInfo = TeamAccessorUtils.getOwnerInfo((Node)nodes[0])) != null) {
            return ownerInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugzillaConfiguration getConfiguration() {
        Object object = this.RC_LOCK;
        synchronized (object) {
            if (this.bc == null) {
                this.bc = this.createConfiguration(false);
            } else if (!this.bc.isValid()) {
                this.bc = this.createConfiguration(false);
            }
            return this.bc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshConfiguration() {
        Object object = this.RC_LOCK;
        synchronized (object) {
            BugzillaConfiguration conf = this.createConfiguration(true);
            if (conf.isValid()) {
                this.bc = conf;
            }
        }
    }

    protected BugzillaConfiguration createConfiguration(boolean forceRefresh) {
        BugzillaConfiguration conf = new BugzillaConfiguration();
        conf.initialize(this, forceRefresh);
        return conf;
    }

    public void refreshAllQueries() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Collection<BugzillaQuery> qs = BugzillaRepository.this.getQueries();
                for (BugzillaQuery q : qs) {
                    Bugzilla.LOG.log(Level.FINER, "preparing to refresh query {0} - {1}", new Object[]{q.getDisplayName(), BugzillaRepository.this.getDisplayName()});
                    QueryController qc = q.getController();
                    qc.onRefresh();
                }
            }
        });
    }

    public String toString() {
        return super.toString() + " (" + this.getDisplayName() + ')';
    }

    protected QueryParameter[] getSimpleSearchParameters() {
        return new QueryParameter[0];
    }

    private BugzillaIssue findUnsubmitted(String id) {
        try {
            for (NbTask task : this.getUnsubmittedTasksContainer().getTasks()) {
                if (!id.equals("-" + task.getTaskId())) continue;
                return this.getIssueForTask(task);
            }
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnsubmittedTasksContainer getUnsubmittedTasksContainer() throws CoreException {
        BugzillaRepository bugzillaRepository = this;
        synchronized (bugzillaRepository) {
            if (this.unsubmittedTasksContainer == null) {
                this.unsubmittedTasksContainer = MylynSupport.getInstance().getUnsubmittedTasksContainer(this.getTaskRepository());
                this.unsubmittedTasksListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("mylyn.unsubmitted_tasks.changed".equals(evt.getPropertyName())) {
                            BugzillaRepository.this.fireUnsubmittedIssuesChanged();
                        }
                    }
                };
                this.unsubmittedTasksContainer.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.unsubmittedTasksListener, (Object)this.unsubmittedTasksContainer));
            }
            return this.unsubmittedTasksContainer;
        }
    }

    private RepositoryInfo checkAndPatchNetbeansUrl(RepositoryInfo info) {
        if (BugzillaUtil.isNbRepository(info.getUrl()) && info.getUrl().startsWith("http://")) {
            RepositoryInfo i = new RepositoryInfo(info.getID(), info.getConnectorId(), "https://netbeans.org/bugzilla", info.getDisplayName(), info.getTooltip(), info.getUsername(), info.getHttpUsername(), info.getPassword(), info.getHttpPassword());
            i.putValue("bugzilla.shortLoginEnabled", info.getValue("bugzilla.shortLoginEnabled"));
            Bugzilla.LOG.warning("Changed NetBeans repository url protocol to https");
            return i;
        }
        return info;
    }

    public class Cache {
        private final Map<String, Reference<BugzillaIssue>> issues = new HashMap<String, Reference<BugzillaIssue>>();

        Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BugzillaIssue getIssue(String id) {
            Object object = BugzillaRepository.this.CACHE_LOCK;
            synchronized (object) {
                Reference<BugzillaIssue> issueRef = this.issues.get(id);
                return issueRef == null ? null : issueRef.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BugzillaIssue setIssue(String id, BugzillaIssue issue) {
            Object object = BugzillaRepository.this.CACHE_LOCK;
            synchronized (object) {
                this.issues.put(id, new SoftReference<BugzillaIssue>(issue));
            }
            return issue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeIssue(String id) {
            Object object = BugzillaRepository.this.CACHE_LOCK;
            synchronized (object) {
                this.issues.remove(id);
            }
        }
    }

    private static class TaskMapping
    extends org.eclipse.mylyn.tasks.core.TaskMapping {
        private final String component;
        private final String product;

        public TaskMapping(String product, String component) {
            this.product = product;
            this.component = component;
        }

        public String getProduct() {
            return this.product;
        }

        public String getComponent() {
            return this.component;
        }
    }
}

