/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.editor.BaseDocument;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

class LineTranslations {
    private static LineTranslations translations;
    private ChangeListener changedFilesListener;
    private Map<Object, Registry> timeStampToRegistry = new WeakHashMap<Object, Registry>();
    private Map<LineBreakpoint, BreakpointLineUpdater> lineUpdaters = new HashMap<LineBreakpoint, BreakpointLineUpdater>();
    private Map<Object, Map<LineBreakpoint, Integer>> originalBreakpointLines = new WeakHashMap<Object, Map<LineBreakpoint, Integer>>();
    private Map<Object, PropertyChangeListener> breakpointListeners = new WeakHashMap<Object, PropertyChangeListener>();

    private LineTranslations() {
    }

    static synchronized LineTranslations getTranslations() {
        if (translations == null) {
            translations = new LineTranslations();
        }
        return translations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTimeStamp(Object timeStamp) {
        Set modifiedDataObjects = DataObject.getRegistry().getModifiedSet();
        Registry r = new Registry();
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            this.timeStampToRegistry.put(timeStamp, r);
            for (DataObject dobj : modifiedDataObjects) {
                r.register(dobj);
            }
            if (this.changedFilesListener == null) {
                this.changedFilesListener = new ChangedFilesListener();
                DataObject.getRegistry().addChangeListener(this.changedFilesListener);
            }
        }
    }

    synchronized void disposeTimeStamp(Object timeStamp) {
        this.timeStampToRegistry.remove(timeStamp);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
        this.originalBreakpointLines.remove(timeStamp);
        this.breakpointListeners.remove(timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOriginalLineNumber(LineBreakpoint lb, final Object timeStamp) {
        PropertyChangeListener lineNumberListener;
        Map<LineBreakpoint, Integer> bpLines;
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            bpLines = this.originalBreakpointLines.get(timeStamp);
            if (bpLines != null) {
                Integer line = bpLines.get(lb);
                if (line != null) {
                    return line;
                }
            } else {
                bpLines = new WeakHashMap<LineBreakpoint, Integer>();
                this.originalBreakpointLines.put(timeStamp, bpLines);
            }
        }
        int line = this.getOriginalLineNumber(lb.getURL(), lb.getLineNumber(), timeStamp);
        LineTranslations lineTranslations2 = this;
        synchronized (lineTranslations2) {
            bpLines.put(lb, line);
            lineNumberListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lineNumber".equals(evt.getPropertyName())) {
                        Map bpLines;
                        LineTranslations lineTranslations = LineTranslations.this;
                        synchronized (lineTranslations) {
                            bpLines = (Map)LineTranslations.this.originalBreakpointLines.get(timeStamp);
                            if (bpLines == null) {
                                return;
                            }
                        }
                        LineBreakpoint lb = (LineBreakpoint)evt.getSource();
                        int line = LineTranslations.this.getOriginalLineNumber(lb.getURL(), lb.getLineNumber(), timeStamp);
                        LineTranslations lineTranslations2 = LineTranslations.this;
                        synchronized (lineTranslations2) {
                            bpLines.put(lb, line);
                        }
                    }
                }
            };
            this.breakpointListeners.put(timeStamp, lineNumberListener);
        }
        lb.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)lineNumberListener, (Object)lb));
        return line;
    }

    int getOriginalLineNumber(String url, int currentLineNumber, Object timeStamp) {
        if (timeStamp == null) {
            return currentLineNumber;
        }
        Line.Set lineSet = this.getLineSet(url, timeStamp);
        if (lineSet == null) {
            return currentLineNumber;
        }
        try {
            lineSet.getOriginal(0);
        }
        catch (IndexOutOfBoundsException ioobex) {
            // empty catch block
        }
        try {
            return lineSet.getOriginalLineNumber(lineSet.getCurrent(currentLineNumber));
        }
        catch (IndexOutOfBoundsException ioobex) {
            return currentLineNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimeStamp(Object timeStamp, String url) {
        DataObject dobj = LineTranslations.getDataObject(url);
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            Registry registry = this.timeStampToRegistry.get(timeStamp);
            registry.register(dobj);
            Map<LineBreakpoint, Integer> bpLines = this.originalBreakpointLines.get(timeStamp);
            if (bpLines != null) {
                HashSet<LineBreakpoint> bpts = new HashSet<LineBreakpoint>(bpLines.keySet());
                for (LineBreakpoint bp : bpts) {
                    if (!url.equals(bp.getURL())) continue;
                    bpLines.remove(bp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set getLineSet(String url, Object timeStamp) {
        LineCookie lineCookie;
        DataObject dataObject = LineTranslations.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        if (timeStamp != null) {
            LineTranslations lineTranslations = this;
            synchronized (lineTranslations) {
                Line.Set ls;
                Registry registry = this.timeStampToRegistry.get(timeStamp);
                if (registry != null && (ls = registry.getLineSet(dataObject)) != null) {
                    return ls;
                }
            }
        }
        if ((lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class)) == null) {
            return null;
        }
        return lineCookie.getLineSet();
    }

    Line getLine(String url, int lineNumber, Object timeStamp) {
        Line.Set ls = this.getLineSet(url, timeStamp);
        if (ls == null) {
            return null;
        }
        try {
            if (timeStamp == null) {
                return ls.getCurrent(lineNumber - 1);
            }
            return ls.getOriginal(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForLineUpdates(LineBreakpoint lb) {
        DataObject dobj = LineTranslations.getDataObject(lb.getURL());
        if (dobj != null) {
            BreakpointLineUpdater blu = new BreakpointLineUpdater(lb, dobj);
            try {
                blu.attach();
                LineTranslations lineTranslations = this;
                synchronized (lineTranslations) {
                    this.lineUpdaters.put(lb, blu);
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterFromLineUpdates(LineBreakpoint lb) {
        BreakpointLineUpdater blu;
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            blu = this.lineUpdaters.remove(lb);
        }
        if (blu != null) {
            blu.destroy();
        }
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private class BreakpointLineUpdater
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener {
        private final LineBreakpoint lb;
        private DataObject dataObject;
        private Line line;
        private final List<Line> lineHasChanged = new ArrayList<Line>();
        private final Timer lineChangePostProcess = new Timer(1000, this);
        private boolean updatingLine = false;

        public BreakpointLineUpdater(LineBreakpoint lb, DataObject dataObject) {
            this.lb = lb;
            this.dataObject = dataObject;
            this.lineChangePostProcess.setRepeats(false);
            DataEditorSupport des = (DataEditorSupport)dataObject.getLookup().lookup(DataEditorSupport.class);
            if (des != null) {
                des.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attach() throws IOException {
            DataObject dobj;
            BreakpointLineUpdater breakpointLineUpdater = this;
            synchronized (breakpointLineUpdater) {
                dobj = this.dataObject;
            }
            LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.lb.addPropertyChangeListener((PropertyChangeListener)this);
            try {
                final Line lineNew = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                BreakpointLineUpdater breakpointLineUpdater2 = this;
                synchronized (breakpointLineUpdater2) {
                    if (this.line != null) {
                        this.line.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.line = lineNew;
                }
                lineNew.addPropertyChangeListener((PropertyChangeListener)this);
                StyledDocument document = NbDocument.getDocument((Lookup.Provider)new Lookup.Provider(){

                    public Lookup getLookup() {
                        return lineNew.getLookup();
                    }
                });
                if (document instanceof BaseDocument) {
                    BaseDocument bd = (BaseDocument)document;
                    bd.addPostModificationDocumentListener((DocumentListener)this);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public synchronized void detach() {
            this.lb.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.line != null) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void destroy() {
            this.detach();
            DataEditorSupport des = (DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class);
            if (des != null) {
                des.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(Line l) {
            try {
                int ln;
                BreakpointLineUpdater breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    this.updatingLine = true;
                    ln = l.getLineNumber() + 1;
                }
                this.lb.setLineNumber(ln);
            }
            finally {
                BreakpointLineUpdater breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    this.updatingLine = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean ul;
            Line l;
            String propertyName = evt.getPropertyName();
            if ("openedPanes".equals(propertyName)) {
                DataEditorSupport des = (DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class);
                JEditorPane[] openedPanes = des != null ? des.getOpenedPanes() : null;
                if (openedPanes == null) {
                    BreakpointLineUpdater breakpointLineUpdater = this;
                    synchronized (breakpointLineUpdater) {
                        if (this.line != null) {
                            this.detach();
                            this.line = null;
                        }
                    }
                }
                BreakpointLineUpdater breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    if (this.line == null) {
                        try {
                            this.attach();
                        }
                        catch (IOException ioex) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            BreakpointLineUpdater breakpointLineUpdater = this;
            synchronized (breakpointLineUpdater) {
                l = this.line;
                if (l == null) {
                    return;
                }
                ul = this.updatingLine;
            }
            if ("lineNumber".equals(propertyName) && l == evt.getSource()) {
                this.lineHasChanged(l);
                return;
            }
            if ("text".equals(propertyName) && l == evt.getSource()) {
                String text = l.getText();
                if (text.trim().length() == 0 && text.indexOf(10) >= 0) {
                    Line newLine;
                    DataObject dobj2;
                    BreakpointLineUpdater breakpointLineUpdater2 = this;
                    synchronized (breakpointLineUpdater2) {
                        this.line.removePropertyChangeListener((PropertyChangeListener)this);
                        if (this.dataObject == null) {
                            return;
                        }
                        dobj2 = this.dataObject;
                    }
                    LineCookie lc = (LineCookie)dobj2.getLookup().lookup(LineCookie.class);
                    try {
                        int lineNumber = l.getLineNumber();
                        int newLineNumber = lc.getLineSet().getOriginal(lineNumber).getLineNumber();
                        for (int i = lineNumber + 1; i < newLineNumber; ++i) {
                            if (lc.getLineSet().getCurrent(i).getText().trim().length() == 0) continue;
                            newLineNumber = i;
                            break;
                        }
                        newLine = lc.getLineSet().getCurrent(newLineNumber);
                        newLine.addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        return;
                    }
                    BreakpointLineUpdater ioobex = this;
                    synchronized (ioobex) {
                        this.line = newLine;
                    }
                    this.update(newLine);
                }
                return;
            }
            if (!ul && "lineNumber".equals(propertyName)) {
                Line newLine;
                DataObject dobj;
                BreakpointLineUpdater dobj2 = this;
                synchronized (dobj2) {
                    this.line.removePropertyChangeListener((PropertyChangeListener)this);
                    if (this.dataObject == null) {
                        return;
                    }
                    dobj = this.dataObject;
                }
                try {
                    LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                    newLine = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                    newLine.addPropertyChangeListener((PropertyChangeListener)this);
                }
                catch (IndexOutOfBoundsException ioobex) {
                    newLine = null;
                }
                BreakpointLineUpdater ioobex = this;
                synchronized (ioobex) {
                    this.line = newLine;
                }
            }
            if ("url".equals(propertyName)) {
                Line newLine;
                DataObject newDO;
                DataEditorSupport des = (DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class);
                if (des != null) {
                    des.removePropertyChangeListener((PropertyChangeListener)this);
                }
                if ((newDO = LineTranslations.getDataObject(this.lb.getURL())) != null) {
                    LineCookie lc = (LineCookie)newDO.getLookup().lookup(LineCookie.class);
                    try {
                        newLine = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                        newLine.addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        newLine = null;
                    }
                } else {
                    newLine = null;
                }
                BreakpointLineUpdater breakpointLineUpdater3 = this;
                synchronized (breakpointLineUpdater3) {
                    if (this.line != null) {
                        this.line.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.dataObject = newDO;
                    this.line = newLine;
                }
                des = (DataEditorSupport)newDO.getLookup().lookup(DataEditorSupport.class);
                if (des != null) {
                    des.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }

        private void lineHasChanged(Line l) {
            if (!this.lineHasChanged.contains(l)) {
                this.lineHasChanged.add(l);
            }
            this.lineChangePostProcess.restart();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.lineMightChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.lineMightChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.lineMightChange();
        }

        private void lineMightChange() {
            while (!this.lineHasChanged.isEmpty()) {
                Line l = this.lineHasChanged.remove(0);
                this.update(l);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.lineMightChange();
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            HashSet newDOs = new HashSet(DataObject.getRegistry().getModifiedSet());
            LineTranslations lineTranslations = LineTranslations.this;
            synchronized (lineTranslations) {
                for (Registry r : LineTranslations.this.timeStampToRegistry.values()) {
                    for (DataObject dobj : newDOs) {
                        r.registerIfNotThere(dobj);
                    }
                }
            }
        }
    }

    private static class Registry {
        private Map<DataObject, Line.Set> dataObjectToLineSet = new HashMap<DataObject, Line.Set>();

        private Registry() {
        }

        synchronized void register(DataObject dataObject) {
            LineCookie lc = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lc.getLineSet());
        }

        synchronized void registerIfNotThere(DataObject dataObject) {
            if (!this.dataObjectToLineSet.containsKey(dataObject)) {
                this.register(dataObject);
            }
        }

        synchronized Line.Set getLineSet(DataObject dataObject) {
            return this.dataObjectToLineSet.get(dataObject);
        }
    }
}

