/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.spi.utils.FileObjectRedirector;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class ItemRedirector
implements FileObjectRedirector {
    public FileObject redirect(FileObject fo) {
        ExecutionEnvironment env;
        if (!this.isEnabled(fo)) {
            return null;
        }
        try {
            env = FileSystemProvider.getExecutionEnvironment((FileSystem)fo.getFileSystem());
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
        if (env.isLocal()) {
            return ItemRedirector.resolveSymbolicLink(fo);
        }
        try {
            String path;
            if (FileSystemProvider.isLink((FileObject)fo) && (path = FileSystemProvider.resolveLink((FileObject)fo)) != null) {
                return fo.getFileSystem().findResource(path);
            }
            return null;
        }
        catch (Exception ex) {
            CndUtils.printStackTraceOnce((Throwable)ex);
            return null;
        }
    }

    public static FileObject resolveSymbolicLink(final FileObject fo) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileObject>(){

                @Override
                public FileObject run() throws IOException {
                    URI uri = fo.toURI();
                    Path path = Paths.get(uri);
                    for (int i = 0; i < 5; ++i) {
                        Path to;
                        if (Files.isSymbolicLink(path)) {
                            to = Files.readSymbolicLink(path);
                            if (!to.isAbsolute()) {
                                to = path.getParent().resolve(to).normalize();
                            }
                            if (Files.isRegularFile(to, new LinkOption[0])) {
                                return FileUtil.toFileObject((File)to.toFile());
                            }
                        } else {
                            return null;
                        }
                        path = to;
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            CndUtils.printStackTraceOnce((Throwable)ex);
            return null;
        }
    }

    private boolean isEnabled(FileObject fo) {
        MakeConfiguration activeConfiguration;
        MakeConfigurationDescriptor cd;
        ConfigurationDescriptorProvider cdp;
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner != null && (cdp = (ConfigurationDescriptorProvider)owner.getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && cdp.gotDescriptor() && (cd = cdp.getConfigurationDescriptor()) != null && (activeConfiguration = cd.getActiveConfiguration()) != null) {
            return activeConfiguration.getCodeAssistanceConfiguration().getResolveSymbolicLinks().getValue();
        }
        return false;
    }
}

