/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.Locale;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.NamedBooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ArchiverConfiguration
implements AllOptionsProvider,
Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration output;
    private NamedBooleanConfiguration runRanlib;
    private BooleanConfiguration replaceOption;
    private BooleanConfiguration verboseOption;
    private BooleanConfiguration supressOption;
    private OptionsConfiguration commandLineConfiguration;
    private OptionsConfiguration additionalDependencies;
    private StringConfiguration tool;
    private StringConfiguration ranlibTool;

    public ArchiverConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.output = new StringConfiguration(null, "");
        this.runRanlib = new NamedBooleanConfiguration(true, "", "$(RANLIB)");
        this.replaceOption = new BooleanConfiguration(true);
        this.verboseOption = new BooleanConfiguration(true);
        this.supressOption = new BooleanConfiguration(false);
        this.commandLineConfiguration = new OptionsConfiguration();
        this.additionalDependencies = new OptionsConfiguration();
        this.tool = new StringConfiguration(null, "ar");
        this.ranlibTool = new StringConfiguration(null, "ranlib");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setRunRanlib(NamedBooleanConfiguration runRanlib) {
        this.runRanlib = runRanlib;
    }

    public NamedBooleanConfiguration getRunRanlib() {
        return this.runRanlib;
    }

    public void setReplaceOption(BooleanConfiguration replaceOption) {
        this.replaceOption = replaceOption;
    }

    public BooleanConfiguration getReplaceOption() {
        return this.replaceOption;
    }

    public void setVerboseOption(BooleanConfiguration verboseOption) {
        this.verboseOption = verboseOption;
    }

    public BooleanConfiguration getVerboseOption() {
        return this.verboseOption;
    }

    public void setSupressOption(BooleanConfiguration supressOption) {
        this.supressOption = supressOption;
    }

    public BooleanConfiguration getSupressOption() {
        return this.supressOption;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
        this.commandLineConfiguration = commandLineConfiguration;
    }

    public OptionsConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setAdditionalDependencies(OptionsConfiguration additionalDependencies) {
        this.additionalDependencies = additionalDependencies;
    }

    public void setTool(StringConfiguration tool) {
        this.tool = tool;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void setRanlibTool(StringConfiguration ranlibTool) {
        this.ranlibTool = ranlibTool;
    }

    public StringConfiguration getRanlibTool() {
        return this.ranlibTool;
    }

    public void assign(ArchiverConfiguration conf) {
        this.getOutput().assign(conf.getOutput());
        this.getRunRanlib().assign(conf.getRunRanlib());
        this.getReplaceOption().assign(conf.getReplaceOption());
        this.getVerboseOption().assign(conf.getVerboseOption());
        this.getSupressOption().assign(conf.getSupressOption());
        this.getAdditionalDependencies().assign(conf.getAdditionalDependencies());
        this.getCommandLineConfiguration().assign(conf.getCommandLineConfiguration());
        this.getTool().assign(conf.getTool());
        this.getRanlibTool().assign(conf.getRanlibTool());
    }

    public ArchiverConfiguration clone() {
        ArchiverConfiguration clone = new ArchiverConfiguration(this.getMakeConfiguration());
        clone.setOutput(this.getOutput().clone());
        clone.setRunRanlib(this.getRunRanlib().clone());
        clone.setReplaceOption(this.getReplaceOption().clone());
        clone.setVerboseOption(this.getVerboseOption().clone());
        clone.setSupressOption(this.getSupressOption().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setTool(this.getTool().clone());
        clone.setRanlibTool(this.getRanlibTool().clone());
        return clone;
    }

    public String getOptions() {
        String options = this.getAllOptions(false) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        options = options + this.getOutputValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        return this.getAllOptions(true);
    }

    private String getAllOptions(boolean includeOutput) {
        StringBuilder options = new StringBuilder();
        options.append(this.getReplaceOption().getValue() ? "r" : "");
        options.append(this.getVerboseOption().getValue() ? "v" : "");
        options.append(this.getSupressOption().getValue() ? "c" : "");
        if (options.length() > 0) {
            options.insert(0, "-");
        }
        options.append(" ");
        if (includeOutput) {
            options.append(this.getOutputValue());
            options.append(" ");
        }
        return CppUtils.reformatWhitespaces(options.toString());
    }

    public Sheet getGeneralSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set1 = new Sheet.Set();
        set1.setName("General");
        set1.setDisplayName(ArchiverConfiguration.getString("GeneralTxt"));
        set1.setShortDescription(ArchiverConfiguration.getString("GeneralHint"));
        set1.put((Node.Property)new OutputNodeProp(this.getOutput(), this.getOutputValue(), "Output", ArchiverConfiguration.getString("OutputTxt"), ArchiverConfiguration.getString("OutputHint")));
        set1.put((Node.Property)new BooleanNodeProp(this.getRunRanlib(), true, "RunRanlib", ArchiverConfiguration.getString("RunRanlibTxt"), ArchiverConfiguration.getString("RunRanlibHint")));
        sheet.put(set1);
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("Options");
        set2.setDisplayName(ArchiverConfiguration.getString("OptionsTxt"));
        set2.setShortDescription(ArchiverConfiguration.getString("OptionsHint"));
        set2.put((Node.Property)new BooleanNodeProp(this.getVerboseOption(), true, "Verbose", ArchiverConfiguration.getString("VerboseTxt"), ArchiverConfiguration.getString("VerboseHint")));
        set2.put((Node.Property)new BooleanNodeProp(this.getSupressOption(), true, "SupressDiagnostics", ArchiverConfiguration.getString("SupressDiagnosticsTxt"), ArchiverConfiguration.getString("SupressDiagnosticsHint")));
        sheet.put(set2);
        Sheet.Set set3 = new Sheet.Set();
        String[] texts = new String[]{ArchiverConfiguration.getString("AdditionalDependenciesTxt1"), ArchiverConfiguration.getString("AdditionalDependenciesHint"), ArchiverConfiguration.getString("AdditionalDependenciesTxt2"), ArchiverConfiguration.getString("InheritedValuesTxt")};
        set3.setName("Input");
        set3.setDisplayName(ArchiverConfiguration.getString("InputTxt"));
        set3.setShortDescription(ArchiverConfiguration.getString("InputHint"));
        set3.put((Node.Property)new OptionsNodeProp(this.getAdditionalDependencies(), null, new AdditionalDependenciesOptions(), null, ",", texts));
        sheet.put(set3);
        Sheet.Set set4 = new Sheet.Set();
        set4.setName("Tool");
        set4.setDisplayName(ArchiverConfiguration.getString("ToolTxt1"));
        set4.setShortDescription(ArchiverConfiguration.getString("ToolHint1"));
        set4.put((Node.Property)new StringNodeProp(this.getTool(), "Tool", ArchiverConfiguration.getString("ToolTxt2"), ArchiverConfiguration.getString("ToolHint2")));
        set4.put((Node.Property)new StringNodeProp(this.getRanlibTool(), "ranlibTool", ArchiverConfiguration.getString("RanlibToolTxt"), ArchiverConfiguration.getString("RanlibToolHint")));
        sheet.put(set4);
        texts = new String[]{ArchiverConfiguration.getString("AdditionalOptionsTxt1"), ArchiverConfiguration.getString("AdditionalOptionsHint"), ArchiverConfiguration.getString("AdditionalOptionsTxt2"), ArchiverConfiguration.getString("AllOptionsTxt")};
        set2 = new Sheet.Set();
        set2.setName("CommandLine");
        set2.setDisplayName(ArchiverConfiguration.getString("CommandLineTxt"));
        set2.setShortDescription(ArchiverConfiguration.getString("CommandLineHint"));
        set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, null, null, texts));
        sheet.put(set2);
        return sheet;
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    private String getOutputDefault() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir()).toLowerCase(Locale.getDefault());
        switch (this.getMakeConfiguration().getConfigurationType().getValue()) {
            case 3: {
                outputName = "lib" + outputName + ".a";
            }
        }
        outputName = ConfigurationSupport.makeNameLegal(outputName);
        return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/" + outputName;
    }

    public String getOutputDefault27() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir()).toLowerCase(Locale.getDefault());
        outputName = "lib" + outputName + ".a";
        return "dist/" + this.getMakeConfiguration().getName() + "/" + outputName;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(ArchiverConfiguration.class, (String)s);
    }

    private static class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String def, String txt1, String txt2, String txt3) {
            super(stringConfiguration, def, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            if (CndPathUtilities.hasMakeSpecialCharacters((String)v)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ArchiverConfiguration.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(v);
        }
    }

    private class AdditionalDependenciesOptions
    implements AllOptionsProvider {
        private AdditionalDependenciesOptions() {
        }

        public String getOptions() {
            return null;
        }

        @Override
        public String getAllOptions(Tool tool) {
            String options = "";
            options = options + ArchiverConfiguration.this.additionalDependencies.getPreDefined();
            return CppUtils.reformatWhitespaces(options);
        }
    }
}

