/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CodeAssistanceConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.RequiredProjectsConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CommonConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.platform.StdLibraries;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.dlight.libs.common.PerformanceLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.xml.sax.Attributes;

class ConfigurationXMLCodec
extends CommonConfigurationXMLCodec {
    private final String tag;
    private final FileObject projectDirectory;
    private int descriptorVersion = -1;
    private final MakeConfigurationDescriptor projectDescriptor;
    private final RemoteProject remoteProject;
    private final Project project;
    private final List<Configuration> confs = new ArrayList<Configuration>();
    private Configuration currentConf = null;
    private ItemConfiguration currentItemConfiguration = null;
    private FolderConfiguration currentFolderConfiguration = null;
    private CCCCompilerConfiguration currentCCCCompilerConfiguration = null;
    private BasicCompilerConfiguration currentBasicCompilerConfiguration = null;
    private CCompilerConfiguration currentCCompilerConfiguration = null;
    private CCCompilerConfiguration currentCCCompilerConfiguration = null;
    private FortranCompilerConfiguration currentFortranCompilerConfiguration = null;
    private AssemblerConfiguration currentAsmConfiguration = null;
    private CustomToolConfiguration currentCustomToolConfiguration = null;
    private LinkerConfiguration currentLinkerConfiguration = null;
    private CodeAssistanceConfiguration currentCodeAssistanceConfiguration = null;
    private PackagingConfiguration currentPackagingConfiguration = null;
    private ArchiverConfiguration currentArchiverConfiguration = null;
    private LibrariesConfiguration currentLibrariesConfiguration = null;
    private RequiredProjectsConfiguration currentRequiredProjectsConfiguration = null;
    private QmakeConfiguration currentQmakeConfiguration = null;
    private List<String> currentList = null;
    private int defaultConf = -1;
    private final Stack<Folder> currentFolderStack = new Stack();
    private Folder currentFolder = null;
    private String relativeOffset;
    private final Map<String, String> cache = new HashMap<String, String>();
    private Map<String, String> dictionary;
    private final Map<String, String> rootDecoder = new HashMap<String, String>();
    private List<XMLDecoder> decoders = new ArrayList<XMLDecoder>();

    public ConfigurationXMLCodec(String tag, FileObject projectDirectory, MakeConfigurationDescriptor projectDescriptor, String relativeOffset) {
        super(projectDescriptor, true);
        this.tag = tag;
        this.projectDirectory = projectDirectory;
        this.projectDescriptor = projectDescriptor;
        this.project = projectDescriptor.getProject();
        this.remoteProject = (RemoteProject)this.project.getLookup().lookup(RemoteProject.class);
        if (this.remoteProject == null) {
            throw new IllegalStateException("RemoteProject not found in lookup for" + projectDescriptor.getProject().getProjectDirectory().getPath());
        }
        this.relativeOffset = relativeOffset;
    }

    public String tag() {
        return this.tag;
    }

    public void start(Attributes atts) throws VersionException {
        String versionString = atts.getValue("version");
        if (versionString != null) {
            this.descriptorVersion = Integer.parseInt(versionString);
            this.projectDescriptor.setVersion(this.descriptorVersion);
        }
    }

    public void end() {
        Configuration[] confsA = new Configuration[this.confs.size()];
        confsA = this.confs.toArray(confsA);
        if (this.defaultConf < 0) {
            this.defaultConf = 0;
            for (int i = 0; i < confsA.length; ++i) {
                if (!confsA[i].isDefault()) continue;
                this.defaultConf = i;
            }
        }
        this.projectDescriptor.init(confsA, this.defaultConf);
    }

    public void startElement(String element, Attributes atts) {
        if (element.equals("conf")) {
            int confType = 0;
            String customizerId = null;
            String type = atts.getValue("type");
            if (type == null) {
                confType = 0;
            } else if (type.equals("0")) {
                confType = 0;
            } else if (type.equals("1")) {
                confType = 1;
            } else if (type.equals("2")) {
                confType = 2;
            } else if (type.equals("3")) {
                confType = 3;
            } else if (type.equals("4")) {
                confType = 4;
            } else if (type.equals("5")) {
                confType = 5;
            } else if (type.equals("6")) {
                confType = 6;
            } else if (type.equals("7")) {
                confType = 7;
            } else if (type.equals("10")) {
                confType = 10;
                customizerId = atts.getValue("customizerid");
            }
            this.currentConf = this.createNewConfiguration(this.projectDirectory, atts.getValue("name"), confType, customizerId, "true".equals(atts.getValue("platformSpecific")));
            for (int dx = 0; dx < this.decoders.size(); ++dx) {
                XMLDecoder decoder = this.decoders.get(dx);
                this.deregisterXMLDecoder(decoder);
            }
            ConfigurationAuxObject[] profileAuxObjects = this.currentConf.getAuxObjects();
            this.decoders = new ArrayList<XMLDecoder>();
            for (int i = 0; i < profileAuxObjects.length; ++i) {
                if (!profileAuxObjects[i].shared()) continue;
                XMLDecoder newDecoder = profileAuxObjects[i].getXMLDecoder();
                this.registerXMLDecoder(newDecoder);
                this.decoders.add(newDecoder);
            }
        } else if (element.equals("neoConf")) {
            this.currentConf = this.createNewConfiguration(this.projectDirectory, atts.getValue("name"), 1, null, "true".equals(atts.getValue("platformSpecific")));
        } else if (element.equals("extConf")) {
            this.currentConf = this.createNewConfiguration(this.projectDirectory, atts.getValue("name"), 0, null, "true".equals(atts.getValue("platformSpecific")));
        } else if (element.equals("sourceFolders")) {
            this.currentFolder = new Folder(this.projectDescriptor, this.projectDescriptor.getLogicalFolders(), "ExternalFiles", "Important Files", false, Folder.Kind.IMPORTANT_FILES_FOLDER);
            this.projectDescriptor.setExternalFileItems(this.currentFolder);
            this.projectDescriptor.getLogicalFolders().addFolder(this.currentFolder, true);
        } else if (element.equals("logicalFolder")) {
            if (this.currentFolderStack.isEmpty()) {
                this.currentFolder = this.projectDescriptor.getLogicalFolders();
                this.currentFolderStack.push(this.currentFolder);
            } else {
                String name = this.getString(atts.getValue("name"));
                String displayName = this.getString(atts.getValue("displayName"));
                if (displayName == null) {
                    displayName = name;
                }
                boolean projectFiles = atts.getValue("projectFiles").equals("true");
                String kindAttr = atts.getValue("kind");
                String root = this.getString(atts.getValue("root"));
                this.currentFolder = this.currentFolder.addNewFolder(name, displayName, projectFiles, kindAttr);
                if (root != null) {
                    this.currentFolder.setRoot(root);
                }
                if (!projectFiles) {
                    this.projectDescriptor.setExternalFileItems(this.currentFolder);
                }
                this.currentFolderStack.push(this.currentFolder);
            }
        } else if (element.equals("df")) {
            if (this.currentFolderStack.isEmpty()) {
                this.currentFolder = this.projectDescriptor.getLogicalFolders();
                this.currentFolderStack.push(this.currentFolder);
            } else {
                String name = this.getString(atts.getValue("name"));
                String root = this.getString(atts.getValue("root"));
                String displayName = name;
                if (root != null) {
                    String absRootPath = CndPathUtilities.toAbsolutePath((FileObject)this.projectDescriptor.getBaseDirFileObject(), (String)root);
                    absRootPath = RemoteFileUtil.normalizeAbsolutePath((String)absRootPath, (Project)this.projectDescriptor.getProject());
                    displayName = CndPathUtilities.getBaseName((String)absRootPath);
                    if (name == null) {
                        name = displayName;
                    }
                    String id = MakeProjectUtils.getDiskFolderId(this.project, this.currentFolderStack.peek());
                    this.rootDecoder.put(name, id);
                    name = id;
                }
                this.currentFolder = this.currentFolder.addNewFolder(name, displayName, true, Folder.Kind.SOURCE_DISK_FOLDER);
                if (root != null) {
                    this.currentFolder.setRoot(root);
                }
                this.currentFolderStack.push(this.currentFolder);
            }
        } else if (element.equals("sourceRootList")) {
            this.currentList = new ArrayList<String>();
        } else if (element.equals("testRootList")) {
            this.currentList = new ArrayList<String>();
        } else if (element.equals("item")) {
            String path = atts.getValue("path");
            Item item = this.projectDescriptor.findProjectItemByPath(path = this.getString(this.adjustOffset(path)));
            if (item != null) {
                ItemConfiguration itemConfiguration;
                this.currentItemConfiguration = itemConfiguration = new ItemConfiguration(this.currentConf, item);
                this.currentConf.addAuxObject(itemConfiguration);
                if (this.descriptorVersion >= 57) {
                    String excluded = atts.getValue("ex");
                    int tool = Integer.parseInt(atts.getValue("tool"));
                    itemConfiguration.getExcluded().setValue(excluded.equals("true"));
                    itemConfiguration.setTool(PredefinedToolKind.getTool((int)tool));
                    String flavor = atts.getValue("flavor2");
                    if (flavor != null) {
                        itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.fromExternal((int)Integer.parseInt(flavor)));
                    }
                    if ((flavor = atts.getValue("flavor")) != null) {
                        itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.fromExternal((int)Integer.parseInt(flavor)));
                    }
                }
            } else {
                System.err.println("Not found item: " + path);
            }
        } else if (element.equals("folder")) {
            String root;
            String id;
            int i;
            String path = this.getString(atts.getValue("path"));
            Folder folder = this.projectDescriptor.findFolderByPath(path);
            if (folder == null && (i = path.indexOf(47)) > 0 && (id = this.rootDecoder.get(root = path.substring(0, i))) != null) {
                path = this.getString(id + path.substring(i));
                folder = this.projectDescriptor.findFolderByPath(path);
            }
            if (folder != null) {
                FolderConfiguration folderConfiguration;
                this.currentFolderConfiguration = folderConfiguration = folder.getFolderConfiguration(this.currentConf);
            } else {
                System.err.println("Not found folder: " + path);
            }
        } else if (element.equals("codeAssistance")) {
            if (this.currentConf != null) {
                this.currentCodeAssistanceConfiguration = ((MakeConfiguration)this.currentConf).getCodeAssistanceConfiguration();
            }
        } else if (element.equals("envVariables")) {
            if (this.currentCodeAssistanceConfiguration != null) {
                this.currentList = this.currentCodeAssistanceConfiguration.getEnvironmentVariables().getValue();
            }
        } else if (element.equals("transientMacros")) {
            if (this.currentCodeAssistanceConfiguration != null) {
                this.currentList = this.currentCodeAssistanceConfiguration.getTransientMacros().getValue();
            }
        } else if (!element.equals("compilerTool")) {
            if (element.equals("flagsDictionary")) {
                this.dictionary = new HashMap<String, String>();
            } else if (element.equals("element")) {
                if (this.dictionary != null) {
                    String id = this.getString(atts.getValue("flagsID"));
                    String flags = this.getString(atts.getValue("commonFlags"));
                    if (id != null && flags != null) {
                        this.dictionary.put(id, flags);
                    }
                }
            } else if (element.equals("cTool") || element.equals("cCompilerTool") || element.equals("sunCCompilerTool")) {
                this.currentCCompilerConfiguration = this.currentItemConfiguration != null ? this.currentItemConfiguration.getCCompilerConfiguration() : (this.currentFolderConfiguration != null ? this.currentFolderConfiguration.getCCompilerConfiguration() : ((MakeConfiguration)this.currentConf).getCCompilerConfiguration());
                this.currentCCCCompilerConfiguration = this.currentCCompilerConfiguration;
                this.currentBasicCompilerConfiguration = this.currentCCompilerConfiguration;
                String importantFlags = this.getString(atts.getValue("flags"));
                if (importantFlags != null) {
                    String candidate;
                    if (this.dictionary != null && (candidate = this.dictionary.get(importantFlags)) != null) {
                        importantFlags = candidate;
                    }
                    this.currentCCCCompilerConfiguration.getImportantFlags().setValue(importantFlags);
                }
            } else if (element.equals("ccTool") || element.equals("ccCompilerTool") || element.equals("sunCCCompilerTool")) {
                this.currentCCCompilerConfiguration = this.currentItemConfiguration != null ? this.currentItemConfiguration.getCCCompilerConfiguration() : (this.currentFolderConfiguration != null ? this.currentFolderConfiguration.getCCCompilerConfiguration() : ((MakeConfiguration)this.currentConf).getCCCompilerConfiguration());
                this.currentCCCCompilerConfiguration = this.currentCCCompilerConfiguration;
                this.currentBasicCompilerConfiguration = this.currentCCCompilerConfiguration;
                String importantFlags = this.getString(atts.getValue("flags"));
                if (importantFlags != null) {
                    String candidate;
                    if (this.dictionary != null && (candidate = this.dictionary.get(importantFlags)) != null) {
                        importantFlags = candidate;
                    }
                    this.currentCCCCompilerConfiguration.getImportantFlags().setValue(importantFlags);
                }
            } else if (element.equals("fortranCompilerTool")) {
                this.currentFortranCompilerConfiguration = this.currentItemConfiguration != null ? this.currentItemConfiguration.getFortranCompilerConfiguration() : ((MakeConfiguration)this.currentConf).getFortranCompilerConfiguration();
                this.currentCCCCompilerConfiguration = null;
                this.currentBasicCompilerConfiguration = this.currentFortranCompilerConfiguration;
            } else if (element.equals("asmTool")) {
                this.currentAsmConfiguration = this.currentItemConfiguration != null ? this.currentItemConfiguration.getAssemblerConfiguration() : ((MakeConfiguration)this.currentConf).getAssemblerConfiguration();
                this.currentCCCCompilerConfiguration = null;
                this.currentBasicCompilerConfiguration = this.currentAsmConfiguration;
            } else if (element.equals("customTool")) {
                if (this.currentItemConfiguration != null) {
                    this.currentCustomToolConfiguration = this.currentItemConfiguration.getCustomToolConfiguration();
                }
            } else if (element.equals("linkerTool")) {
                this.currentLinkerConfiguration = this.currentFolderConfiguration != null && this.currentFolderConfiguration.getLinkerConfiguration() != null ? this.currentFolderConfiguration.getLinkerConfiguration() : ((MakeConfiguration)this.currentConf).getLinkerConfiguration();
            } else if (element.equals("packaging")) {
                this.currentPackagingConfiguration = ((MakeConfiguration)this.currentConf).getPackagingConfiguration();
                this.currentPackagingConfiguration.getFiles().getValue().clear();
            } else if (element.equals("packInfoList")) {
                List<PackagerInfoElement> toBeRemove = this.currentPackagingConfiguration.getHeaderSubList(this.currentPackagingConfiguration.getType().getValue());
                for (PackagerInfoElement elem : toBeRemove) {
                    this.currentPackagingConfiguration.getInfo().getValue().remove(elem);
                }
            } else if (element.equals("archiverTool")) {
                this.currentArchiverConfiguration = ((MakeConfiguration)this.currentConf).getArchiverConfiguration();
            } else if (element.equals("incDir") || element.equals("includeDirectories")) {
                if (this.currentCCCCompilerConfiguration != null) {
                    this.currentList = this.currentCCCCompilerConfiguration.getIncludeDirectories().getValue();
                }
            } else if (element.equals("incFile")) {
                if (this.currentCCCCompilerConfiguration != null) {
                    this.currentList = this.currentCCCCompilerConfiguration.getIncludeFiles().getValue();
                }
            } else if (element.equals("preprocessorList")) {
                if (this.currentCCCCompilerConfiguration != null) {
                    this.currentList = this.currentCCCCompilerConfiguration.getPreprocessorConfiguration().getValue();
                }
            } else if (element.equals("undefinedList")) {
                if (this.currentCCCCompilerConfiguration != null) {
                    this.currentList = this.currentCCCCompilerConfiguration.getUndefinedPreprocessorConfiguration().getValue();
                }
            } else if (element.equals("linkerAddLib")) {
                if (this.currentLinkerConfiguration != null) {
                    this.currentList = this.currentLinkerConfiguration.getAdditionalLibs().getValue();
                }
            } else if (element.equals("linkerDynSerch")) {
                if (this.currentLinkerConfiguration != null) {
                    this.currentList = this.currentLinkerConfiguration.getDynamicSearch().getValue();
                }
            } else if (element.equals("linkerLibItems")) {
                this.currentLibrariesConfiguration = this.currentLinkerConfiguration.getLibrariesConfiguration();
            } else if (element.equals("requiredProjects")) {
                this.currentRequiredProjectsConfiguration = ((MakeConfiguration)this.currentConf).getRequiredProjectsConfiguration();
            } else if (element.equals("makeArtifact")) {
                String pl = atts.getValue("PL");
                pl = this.getString(this.adjustOffset(pl));
                String ct = this.getString(atts.getValue("CT"));
                String cn = this.getString(atts.getValue("CN"));
                String ac = this.getString(atts.getValue("AC"));
                String bl = this.getString(atts.getValue("BL"));
                String wd = atts.getValue("WD");
                wd = this.getString(this.adjustOffset(wd));
                String bc = this.getString(atts.getValue("BC"));
                String cc = this.getString(atts.getValue("CC"));
                String op = this.getString(atts.getValue("OP"));
                LibraryItem.ProjectItem projectItem = new LibraryItem.ProjectItem(new MakeArtifact(pl, Integer.parseInt(ct), cn, ac.equals("true"), bl != null ? bl.equals("true") : true, wd, bc, cc, op, (MakeConfiguration)this.currentConf));
                if (this.currentLibrariesConfiguration != null) {
                    this.currentLibrariesConfiguration.add(projectItem);
                } else if (this.currentRequiredProjectsConfiguration != null) {
                    this.currentRequiredProjectsConfiguration.add(projectItem);
                }
            } else if (element.equals("packFileListElem")) {
                String type = atts.getValue("type");
                String to = this.getString(atts.getValue("to"));
                String from = atts.getValue("from");
                from = this.getString(this.adjustOffset(from));
                String perm = this.getString(atts.getValue("perm"));
                String owner = this.getString(atts.getValue("owner"));
                String group = this.getString(atts.getValue("group"));
                PackagerFileElement fileElement = new PackagerFileElement(PackagerFileElement.toFileType(type), from, to, perm, owner, group);
                if (this.currentPackagingConfiguration != null) {
                    this.currentPackagingConfiguration.getFiles().add(fileElement);
                }
            } else if (element.equals("packInfoListElem")) {
                String name = this.getString(atts.getValue("name"));
                String value = this.getString(atts.getValue("value"));
                String mandatory = atts.getValue("mandatory");
                if (this.currentPackagingConfiguration != null) {
                    PackagerInfoElement infoElement = new PackagerInfoElement(this.currentPackagingConfiguration.getType().getValue(), name, value, mandatory.equals("true"), false);
                    this.currentPackagingConfiguration.getInfo().add(infoElement);
                }
            } else if (element.equals("qt")) {
                this.currentQmakeConfiguration = ((MakeConfiguration)this.currentConf).getQmakeConfiguration();
            } else if (element.equals("defs")) {
                this.currentList = this.currentQmakeConfiguration.getCustomDefs().getValue();
            } else if (element.equals("packAddInfosListElem")) {
                this.currentList = this.currentPackagingConfiguration.getAdditionalInfo().getValue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String element, String currentText) {
        block253: {
            block284: {
                block283: {
                    block282: {
                        block281: {
                            block280: {
                                block279: {
                                    block278: {
                                        block277: {
                                            block276: {
                                                block275: {
                                                    block274: {
                                                        block273: {
                                                            block272: {
                                                                block271: {
                                                                    block270: {
                                                                        block269: {
                                                                            block268: {
                                                                                block267: {
                                                                                    block266: {
                                                                                        block265: {
                                                                                            block264: {
                                                                                                block263: {
                                                                                                    block262: {
                                                                                                        block261: {
                                                                                                            block260: {
                                                                                                                block259: {
                                                                                                                    block258: {
                                                                                                                        block257: {
                                                                                                                            block256: {
                                                                                                                                block255: {
                                                                                                                                    block254: {
                                                                                                                                        block252: {
                                                                                                                                            if (!element.equals("conf")) break block252;
                                                                                                                                            this.confs.add(this.currentConf);
                                                                                                                                            this.currentConf = null;
                                                                                                                                            break block253;
                                                                                                                                        }
                                                                                                                                        if (!element.equals("neoConf")) break block254;
                                                                                                                                        this.confs.add(this.currentConf);
                                                                                                                                        this.currentConf = null;
                                                                                                                                        break block253;
                                                                                                                                    }
                                                                                                                                    if (!element.equals("extConf")) break block255;
                                                                                                                                    this.confs.add(this.currentConf);
                                                                                                                                    this.currentConf = null;
                                                                                                                                    break block253;
                                                                                                                                }
                                                                                                                                if (!element.equals("compilerSet")) break block256;
                                                                                                                                if (this.descriptorVersion <= 33) {
                                                                                                                                    currentText = currentText.equals("1") ? "GNU" : "Sun";
                                                                                                                                }
                                                                                                                                ((MakeConfiguration)this.currentConf).getCompilerSet().restore(currentText, this.descriptorVersion);
                                                                                                                                break block253;
                                                                                                                            }
                                                                                                                            if (!element.equals("developmentServer")) break block257;
                                                                                                                            ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)currentText);
                                                                                                                            env = CppUtils.convertAfterReading(env, (MakeConfiguration)this.currentConf);
                                                                                                                            ((MakeConfiguration)this.currentConf).getDevelopmentHost().setHost(env);
                                                                                                                            break block253;
                                                                                                                        }
                                                                                                                        if (!element.equals("remoteSyncFactory")) break block258;
                                                                                                                        RemoteSyncFactory fixedSyncFactory = RemoteSyncFactory.fromID((String)currentText);
                                                                                                                        CndUtils.assertNotNull((Object)fixedSyncFactory, (String)("Can not restore fixed sync factory " + currentText));
                                                                                                                        ((MakeConfiguration)this.currentConf).setFixedRemoteSyncFactory(fixedSyncFactory);
                                                                                                                        break block253;
                                                                                                                    }
                                                                                                                    if (!element.equals("cRequired")) break block259;
                                                                                                                    if (this.descriptorVersion <= 41) {
                                                                                                                        return;
                                                                                                                    }
                                                                                                                    ((MakeConfiguration)this.currentConf).getCRequired().setValue(currentText.equals("true"), !currentText.equals("true"));
                                                                                                                    break block253;
                                                                                                                }
                                                                                                                if (!element.equals("cppRequired")) break block260;
                                                                                                                if (this.descriptorVersion <= 41) {
                                                                                                                    return;
                                                                                                                }
                                                                                                                ((MakeConfiguration)this.currentConf).getCppRequired().setValue(currentText.equals("true"), !currentText.equals("true"));
                                                                                                                break block253;
                                                                                                            }
                                                                                                            if (!element.equals("fortranRequired")) break block261;
                                                                                                            if (this.descriptorVersion <= 41) {
                                                                                                                return;
                                                                                                            }
                                                                                                            ((MakeConfiguration)this.currentConf).getFortranRequired().setValue(currentText.equals("true"), !currentText.equals("true"));
                                                                                                            break block253;
                                                                                                        }
                                                                                                        if (!element.equals("assemblerRequired")) break block262;
                                                                                                        ((MakeConfiguration)this.currentConf).getAssemblerRequired().setValue(currentText.equals("true"), !currentText.equals("true"));
                                                                                                        break block253;
                                                                                                    }
                                                                                                    if (!element.equals("platform")) break block263;
                                                                                                    int set = Integer.parseInt(currentText);
                                                                                                    if (this.descriptorVersion <= 37 && set == 4) {
                                                                                                        set = 5;
                                                                                                    }
                                                                                                    ((MakeConfiguration)this.currentConf).getDevelopmentHost().setBuildPlatform(set);
                                                                                                    break block253;
                                                                                                }
                                                                                                if (!element.equals("dependencyChecking")) break block264;
                                                                                                boolean ds = currentText.equals("true");
                                                                                                ((MakeConfiguration)this.currentConf).getDependencyChecking().setValue(ds);
                                                                                                break block253;
                                                                                            }
                                                                                            if (!element.equals("rebuildPropChanged")) break block265;
                                                                                            boolean ds = currentText.equals("true");
                                                                                            ((MakeConfiguration)this.currentConf).getRebuildPropChanged().setValue(ds);
                                                                                            break block253;
                                                                                        }
                                                                                        if (!element.equals("defaultConf")) break block266;
                                                                                        this.defaultConf = Integer.parseInt(currentText);
                                                                                        break block253;
                                                                                    }
                                                                                    if (!element.equals("projectmakefile")) break block267;
                                                                                    this.projectDescriptor.setProjectMakefileName(this.getString(currentText));
                                                                                    break block253;
                                                                                }
                                                                                if (!element.equals("optimizationLevel")) break block268;
                                                                                int ol = Integer.parseInt(currentText);
                                                                                if (this.currentCCCCompilerConfiguration != null) {
                                                                                    if (ol == 0) {
                                                                                        this.currentCCCCompilerConfiguration.getDevelopmentMode().setValue(1);
                                                                                    } else if (ol == 1) {
                                                                                        this.currentCCCCompilerConfiguration.getDevelopmentMode().setValue(4);
                                                                                    } else {
                                                                                        this.currentCCCCompilerConfiguration.getDevelopmentMode().setValue(5);
                                                                                    }
                                                                                }
                                                                                break block253;
                                                                            }
                                                                            if (!element.equals("debuggingSymbols")) break block269;
                                                                            boolean ds = currentText.equals("true");
                                                                            if (this.currentCCCCompilerConfiguration != null) {
                                                                                if (ds) {
                                                                                    this.currentCCCCompilerConfiguration.getDevelopmentMode().setValue(1);
                                                                                } else {
                                                                                    this.currentCCCCompilerConfiguration.getDevelopmentMode().setValue(5);
                                                                                }
                                                                            }
                                                                            break block253;
                                                                        }
                                                                        if (!element.equals("developmentMode")) break block270;
                                                                        int ol = Integer.parseInt(currentText);
                                                                        if (this.currentBasicCompilerConfiguration != null) {
                                                                            this.currentBasicCompilerConfiguration.getDevelopmentMode().setValue(ol);
                                                                        }
                                                                        break block253;
                                                                    }
                                                                    if (!element.equals("buildCommandWorkingDir")) break block271;
                                                                    String path = currentText;
                                                                    path = this.getString(this.adjustOffset(path));
                                                                    ((MakeConfiguration)this.currentConf).getMakefileConfiguration().getBuildCommandWorkingDir().setValue(path);
                                                                    break block253;
                                                                }
                                                                if (!element.equals("buildCommand")) break block272;
                                                                String val = this.getString(currentText);
                                                                if (this.descriptorVersion < 76) {
                                                                    val = val.replace("$(MAKE)", "${MAKE}");
                                                                }
                                                                ((MakeConfiguration)this.currentConf).getMakefileConfiguration().getBuildCommand().setValue(val);
                                                                break block253;
                                                            }
                                                            if (!element.equals("cleanCommand")) break block273;
                                                            String val = this.getString(currentText);
                                                            if (this.descriptorVersion < 76) {
                                                                val = val.replace("$(MAKE)", "${MAKE}");
                                                            }
                                                            ((MakeConfiguration)this.currentConf).getMakefileConfiguration().getCleanCommand().setValue(val);
                                                            break block253;
                                                        }
                                                        if (!element.equals("preBuildCommandWorkingDir")) break block274;
                                                        String val = this.getString(currentText);
                                                        ((MakeConfiguration)this.currentConf).getPreBuildConfiguration().getPreBuildCommandWorkingDir().setValue(val);
                                                        break block253;
                                                    }
                                                    if (!element.equals("preBuildCommand")) break block275;
                                                    String val = this.getString(currentText);
                                                    ((MakeConfiguration)this.currentConf).getPreBuildConfiguration().getPreBuildCommand().setValue(val);
                                                    break block253;
                                                }
                                                if (!element.equals("preBuildFirst")) break block276;
                                                String val = this.getString(currentText);
                                                ((MakeConfiguration)this.currentConf).getPreBuildConfiguration().getPreBuildFirst().setValue("true".equals(val));
                                                break block253;
                                            }
                                            if (!element.equals("executablePath")) break block277;
                                            String path = currentText;
                                            path = this.getString(this.adjustOffset(path));
                                            ((MakeConfiguration)this.currentConf).getMakefileConfiguration().getOutput().setValue(path);
                                            break block253;
                                        }
                                        if (!element.equals("folderPath")) break block278;
                                        this.currentFolder.addItem(this.createItem(this.getString(currentText)));
                                        break block253;
                                    }
                                    if (element.equals("sourceFolders")) break block253;
                                    if (!element.equals("logicalFolder") && !element.equals("df")) break block279;
                                    Folder processedFolder = this.currentFolderStack.pop();
                                    processedFolder.pack();
                                    this.currentFolder = this.currentFolderStack.size() > 0 ? this.currentFolderStack.peek() : null;
                                    break block253;
                                }
                                if (!element.equals("sourceEncoding")) break block280;
                                ((MakeProject)this.projectDescriptor.getProject()).setSourceEncoding(this.getString(currentText));
                                break block253;
                            }
                            if (!element.equals("preprocessorList")) break block281;
                            this.currentList = null;
                            break block253;
                        }
                        if (!element.equals("undefinedList")) break block282;
                        this.currentList = null;
                        break block253;
                    }
                    if (!element.equals("itemPath")) break block283;
                    String path = currentText;
                    path = this.getString(this.adjustOffset(path));
                    this.currentFolder.addItem(this.createItem(path));
                    break block253;
                }
                if (!element.equals("in")) break block284;
                String path = this.currentFolder.getRootPath() + '/' + currentText;
                if (path.startsWith("./")) {
                    path = path.substring(2);
                }
                path = this.getString(this.adjustOffset(path));
                PerformanceLogger.PerformaceAction performanceEvent = PerformanceLogger.getLogger().start("CREATE_ITEM_PERFORMANCE_EVENT", (Object)path);
                Item createItem = null;
                try {
                    performanceEvent.setTimeOut(30);
                    createItem = this.createItem(path);
                    this.currentFolder.addItem(createItem);
                }
                catch (Throwable throwable) {
                    performanceEvent.log(new Object[]{createItem});
                    throw throwable;
                }
                performanceEvent.log(new Object[]{createItem});
                break block253;
            }
            if (element.equals("itemExcluded") || element.equals("excluded")) {
                CndUtils.assertNotNullInConsole((Object)this.currentItemConfiguration, (String)"null currentItemConfiguration");
                if (this.currentItemConfiguration != null) {
                    this.currentItemConfiguration.getExcluded().setValue(currentText.equals("true"));
                }
            } else if (element.equals("itemTool") || element.equals("tool")) {
                CndUtils.assertNotNullInConsole((Object)this.currentItemConfiguration, (String)"null currentItemConfiguration");
                if (this.currentItemConfiguration != null) {
                    int tool = Integer.parseInt(currentText);
                    this.currentItemConfiguration.setTool(PredefinedToolKind.getTool((int)tool));
                }
            } else if (!element.equals("conformanceLevel") && !element.equals("compatibilityMode")) {
                if (element.equals("libraryLevel")) {
                    int ol = Integer.parseInt(currentText);
                    this.currentCCCompilerConfiguration.getLibraryLevel().setValue(ol);
                } else if (element.equals("customToolCommandline")) {
                    this.currentCustomToolConfiguration.getCommandLine().setValue(this.getString(currentText));
                } else if (element.equals("customToolDescription")) {
                    this.currentCustomToolConfiguration.getDescription().setValue(this.getString(currentText));
                } else if (element.equals("customToolOutputs")) {
                    this.currentCustomToolConfiguration.getOutputs().setValue(this.getString(currentText));
                } else if (element.equals("customToolAdditionalDep")) {
                    this.currentCustomToolConfiguration.getAdditionalDependencies().setValue(this.getString(currentText));
                } else if (element.equals("item")) {
                    if (this.currentItemConfiguration != null) {
                        this.currentItemConfiguration.clearChanged();
                        this.currentItemConfiguration = null;
                    }
                } else if (element.equals("folder")) {
                    if (this.currentFolderConfiguration != null) {
                        this.currentFolderConfiguration.clearChanged();
                        this.currentFolderConfiguration = null;
                    }
                } else if (element.equals("codeAssistance")) {
                    this.currentCCCCompilerConfiguration = null;
                } else if (element.equals("buildAnalyzer")) {
                    if (this.currentCodeAssistanceConfiguration != null) {
                        boolean ba = currentText.equals("true");
                        this.currentCodeAssistanceConfiguration.getBuildAnalyzer().setValue(ba);
                    }
                } else if (element.equals("resolveSymbolicLinks")) {
                    if (this.currentCodeAssistanceConfiguration != null) {
                        boolean ba = currentText.equals("true");
                        this.currentCodeAssistanceConfiguration.getResolveSymbolicLinks().setValue(ba);
                    }
                } else if (element.equals("includeAdditional")) {
                    if (this.currentCodeAssistanceConfiguration != null) {
                        boolean ba = currentText.equals("true");
                        this.currentCodeAssistanceConfiguration.getIncludeInCA().setValue(ba);
                    }
                } else if (element.equals("excludePattern")) {
                    if (this.currentCodeAssistanceConfiguration != null) {
                        boolean ba = currentText.equals("true");
                        this.currentCodeAssistanceConfiguration.getExcludeInCA().setValue(currentText);
                    }
                } else if (element.equals("buildAnalyzerTools")) {
                    if (this.currentCodeAssistanceConfiguration != null) {
                        this.currentCodeAssistanceConfiguration.getTools().setValue(this.getString(currentText));
                    }
                } else if (element.equals("envVariables")) {
                    this.currentList = null;
                } else if (element.equals("transientMacros")) {
                    this.currentList = null;
                } else if (!element.equals("compilerTool")) {
                    if (element.equals("cTool") || element.equals("cCompilerTool") || element.equals("sunCCompilerTool")) {
                        this.currentCCompilerConfiguration = null;
                        this.currentCCCCompilerConfiguration = null;
                        this.currentBasicCompilerConfiguration = null;
                    } else if (element.equals("ccTool") || element.equals("ccCompilerTool") || element.equals("sunCCCompilerTool")) {
                        this.currentCCCompilerConfiguration = null;
                        this.currentCCCCompilerConfiguration = null;
                        this.currentBasicCompilerConfiguration = null;
                    } else if (element.equals("fortranCompilerTool")) {
                        this.currentFortranCompilerConfiguration = null;
                        this.currentBasicCompilerConfiguration = null;
                    } else if (element.equals("asmTool")) {
                        this.currentAsmConfiguration = null;
                        this.currentBasicCompilerConfiguration = null;
                    } else if (element.equals("customTool")) {
                        this.currentCustomToolConfiguration = null;
                    } else if (element.equals("linkerTool")) {
                        if (this.descriptorVersion <= 27 && !this.currentLinkerConfiguration.getOutput().getModified()) {
                            this.currentLinkerConfiguration.getOutput().setValue(this.currentLinkerConfiguration.getOutputDefault27());
                        }
                        this.currentLinkerConfiguration = null;
                    } else if (element.equals("packaging")) {
                        this.currentPackagingConfiguration = null;
                    } else if (element.equals("archiverTool")) {
                        if (this.descriptorVersion <= 27 && !this.currentArchiverConfiguration.getOutput().getModified()) {
                            this.currentArchiverConfiguration.getOutput().setValue(this.currentArchiverConfiguration.getOutputDefault27());
                        }
                        this.currentArchiverConfiguration = null;
                    } else if (element.equals("incDir") || element.equals("includeDirectories")) {
                        if (this.descriptorVersion < 93 && this.currentList != null && !this.currentList.isEmpty() && this.currentCCCCompilerConfiguration != null) {
                            List<String> files = this.currentCCCCompilerConfiguration.getIncludeFiles().getValue();
                            for (String path : this.currentList) {
                                if (!path.endsWith(".h") && !path.endsWith(".hpp") && !path.endsWith(".hxx") && !path.endsWith(".def") && !path.endsWith(".inc")) continue;
                                files.add(path);
                            }
                            for (String path : files) {
                                this.currentList.remove(path);
                            }
                        }
                        this.currentList = null;
                    } else if (element.equals("linkerAddLib")) {
                        this.currentList = null;
                    } else if (element.equals("linkerDynSerch")) {
                        this.currentList = null;
                    } else if (element.equals("sourceFolderFilter")) {
                        this.projectDescriptor.setFolderVisibilityQuery(currentText);
                    } else if (element.equals("sourceRootList")) {
                        for (String sf : this.currentList) {
                            this.projectDescriptor.addSourceRootRaw(sf);
                        }
                        this.currentList = null;
                    } else if (element.equals("testRootList")) {
                        for (String sf : this.currentList) {
                            this.projectDescriptor.addTestRootRaw(sf);
                        }
                        this.currentList = null;
                    } else if (element.equals("directoryPath") || element.equals("pElem")) {
                        if (this.currentList != null) {
                            String path = this.getString(this.adjustOffset(currentText));
                            this.currentList.add(path);
                        }
                    } else if (element.equals("Elem")) {
                        if (this.currentList != null) {
                            this.currentList.add(this.getString(currentText));
                        }
                    } else if (element.equals("commandLine")) {
                        if (this.currentBasicCompilerConfiguration != null) {
                            this.currentBasicCompilerConfiguration.getCommandLineConfiguration().setValue(this.getString(currentText));
                        }
                        if (this.currentLinkerConfiguration != null) {
                            this.currentLinkerConfiguration.getCommandLineConfiguration().setValue(this.getString(currentText));
                        }
                        if (this.currentArchiverConfiguration != null) {
                            this.currentArchiverConfiguration.getCommandLineConfiguration().setValue(this.getString(currentText));
                        }
                    } else if (element.equals("commandlineTool")) {
                        if (this.currentBasicCompilerConfiguration != null) {
                            this.currentBasicCompilerConfiguration.getTool().setValue(this.getString(currentText));
                        }
                        if (this.currentLinkerConfiguration != null) {
                            this.currentLinkerConfiguration.getTool().setValue(this.getString(currentText));
                        }
                        if (this.currentArchiverConfiguration != null) {
                            this.currentArchiverConfiguration.getTool().setValue(this.getString(currentText));
                        }
                        if (this.currentPackagingConfiguration != null) {
                            this.currentPackagingConfiguration.getTool().setValue(this.getString(currentText));
                        }
                    } else if (element.equals("verbose")) {
                        if (this.currentPackagingConfiguration != null) {
                            boolean val = currentText.equals("true");
                            this.currentPackagingConfiguration.getVerbose().setValue(val);
                        }
                    } else if (element.equals("packTopDir")) {
                        if (this.currentPackagingConfiguration != null) {
                            this.currentPackagingConfiguration.getTopDir().setValue(this.getString(currentText));
                        }
                    } else if (element.equals("additionalOptions")) {
                        if (this.currentPackagingConfiguration != null) {
                            this.currentPackagingConfiguration.getOptions().setValue(this.getString(currentText));
                        }
                    } else if (element.equals("packType")) {
                        if (this.currentPackagingConfiguration != null) {
                            int i;
                            String type = this.descriptorVersion <= 50 ? ((i = Integer.parseInt(currentText)) == 0 ? "Tar" : (i == 1 ? "Zip" : (i == 2 ? "SVR4" : (i == 3 ? "RPM" : (i == 4 ? "Debian" : "Tar"))))) : currentText;
                            this.currentPackagingConfiguration.getType().setValue(type);
                        }
                    } else if (element.equals("preprocessor")) {
                        if (this.currentCCCCompilerConfiguration != null) {
                            ArrayList<String> list = CppUtils.tokenizeString(currentText);
                            ArrayList<String> res = new ArrayList<String>();
                            for (String val : list) {
                                res.add(this.getString(val));
                            }
                            this.currentCCCCompilerConfiguration.getPreprocessorConfiguration().getValue().addAll(res);
                        }
                    } else if (element.equals("stripSymbols")) {
                        boolean ds = currentText.equals("true");
                        if (this.currentBasicCompilerConfiguration != null) {
                            this.currentBasicCompilerConfiguration.getStrip().setValue(ds);
                        }
                        if (this.currentLinkerConfiguration != null) {
                            this.currentLinkerConfiguration.getStripOption().setValue(ds);
                        }
                    } else if (element.equals("sixtyfourBits")) {
                        boolean ds = currentText.equals("true");
                        if (this.currentBasicCompilerConfiguration != null) {
                            this.currentBasicCompilerConfiguration.getSixtyfourBits().setValue(ds ? 2 : 0);
                        }
                    } else if (element.equals("architecture")) {
                        int val = Integer.parseInt(currentText);
                        if (this.currentBasicCompilerConfiguration != null) {
                            this.currentBasicCompilerConfiguration.getSixtyfourBits().setValue(val);
                        }
                    } else if (element.equals("standard")) {
                        int val = Integer.parseInt(currentText);
                        if (this.currentCCCompilerConfiguration != null) {
                            this.currentCCCompilerConfiguration.setCppStandardExternal(val);
                        } else if (this.currentCCompilerConfiguration != null) {
                            this.currentCCompilerConfiguration.setCStandardExternal(val);
                        }
                    } else if (element.equals("inheritIncValues")) {
                        boolean ds = currentText.equals("true");
                        if (this.currentCCCCompilerConfiguration != null) {
                            this.currentCCCCompilerConfiguration.getInheritIncludes().setValue(ds);
                            if (this.descriptorVersion < 93) {
                                this.currentCCCCompilerConfiguration.getInheritFiles().setValue(ds);
                            }
                        }
                    } else if (element.equals("inheritFileValues")) {
                        boolean ds = currentText.equals("true");
                        if (this.currentCCCCompilerConfiguration != null) {
                            this.currentCCCCompilerConfiguration.getInheritFiles().setValue(ds);
                        }
                    } else if (element.equals("inheritPreValues")) {
                        boolean ds = currentText.equals("true");
                        if (this.currentCCCCompilerConfiguration != null) {
                            this.currentCCCCompilerConfiguration.getInheritPreprocessor().setValue(ds);
                        }
                    } else if (element.equals("useLinkerLibraries")) {
                        boolean ds = currentText.equals("true");
                        if (this.currentCCCCompilerConfiguration != null) {
                            this.currentCCCCompilerConfiguration.getUseLinkerLibraries().setValue(ds);
                        }
                    } else if (element.equals("supressWarnings")) {
                        boolean ds = currentText.equals("true");
                        if (this.currentCCCCompilerConfiguration != null && ds) {
                            this.currentCCCCompilerConfiguration.getWarningLevel().setValue(0);
                        }
                    } else if (element.equals("warningLevel")) {
                        int ol = Integer.parseInt(currentText);
                        if (this.currentBasicCompilerConfiguration != null) {
                            this.currentBasicCompilerConfiguration.getWarningLevel().setValue(ol);
                        }
                    } else if (element.equals("mtLevel")) {
                        int ol = Integer.parseInt(currentText);
                        if (this.currentCCCCompilerConfiguration != null) {
                            this.currentCCCCompilerConfiguration.getMTLevel().setValue(ol);
                        }
                    } else if (element.equals("standardsEvolution")) {
                        int ol = Integer.parseInt(currentText);
                        if (this.currentCCCCompilerConfiguration != null) {
                            this.currentCCCCompilerConfiguration.getStandardsEvolution().setValue(ol);
                        }
                    } else if (element.equals("languageExtension")) {
                        int ol = Integer.parseInt(currentText);
                        if (this.currentCCCCompilerConfiguration != null) {
                            this.currentCCCCompilerConfiguration.getLanguageExt().setValue(ol);
                        }
                    } else if (!element.equals("cppstylecomments")) {
                        if (element.equals("output")) {
                            String output = currentText;
                            if (this.descriptorVersion <= 51 && output.contains("{PLATFORM}")) {
                                output = output.replace("PLATFORM", "CND_PLATFORM");
                            }
                            if (this.currentLinkerConfiguration != null) {
                                this.currentLinkerConfiguration.getOutput().setValue(this.getString(output));
                            }
                            if (this.currentArchiverConfiguration != null) {
                                this.currentArchiverConfiguration.getOutput().setValue(this.getString(output));
                            }
                            if (this.currentPackagingConfiguration != null) {
                                this.currentPackagingConfiguration.getOutput().setValue(this.getString(output));
                            }
                        } else if (element.equals("linkerKpic")) {
                            boolean ds = currentText.equals("true");
                            if (this.currentLinkerConfiguration != null) {
                                this.currentLinkerConfiguration.getPICOption().setValue(ds);
                            }
                        } else if (element.equals("linkerNorunpath")) {
                            boolean ds = currentText.equals("true");
                            if (this.currentLinkerConfiguration != null) {
                                this.currentLinkerConfiguration.getNorunpathOption().setValue(ds);
                            }
                        } else if (element.equals("linkerAssign")) {
                            boolean ds = currentText.equals("true");
                            if (this.currentLinkerConfiguration != null) {
                                this.currentLinkerConfiguration.getNameassignOption().setValue(ds);
                            }
                        } else if (element.equals("additionalDep")) {
                            if (this.currentLinkerConfiguration != null) {
                                this.currentLinkerConfiguration.getAdditionalDependencies().setValue(this.getString(currentText));
                            }
                            if (this.currentArchiverConfiguration != null) {
                                this.currentArchiverConfiguration.getAdditionalDependencies().setValue(this.getString(currentText));
                            }
                            if (this.currentBasicCompilerConfiguration != null) {
                                this.currentBasicCompilerConfiguration.getAdditionalDependencies().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("archiverVerbose")) {
                            boolean ds = currentText.equals("true");
                            if (this.currentArchiverConfiguration != null) {
                                this.currentArchiverConfiguration.getVerboseOption().setValue(ds);
                            }
                        } else if (element.equals("ranlibTool")) {
                            if (this.currentArchiverConfiguration != null) {
                                this.currentArchiverConfiguration.getRanlibTool().setValue(currentText);
                            }
                        } else if (element.equals("runRanlib")) {
                            boolean ds = currentText.equals("true");
                            if (this.currentArchiverConfiguration != null) {
                                this.currentArchiverConfiguration.getRunRanlib().setValue(ds);
                            }
                        } else if (element.equals("archiverSupress")) {
                            boolean ds = currentText.equals("true");
                            if (this.currentArchiverConfiguration != null) {
                                this.currentArchiverConfiguration.getSupressOption().setValue(ds);
                            }
                        } else if (element.equals("linkerLibItems")) {
                            this.currentLibrariesConfiguration = null;
                        } else if (element.equals("requiredProjects")) {
                            this.currentRequiredProjectsConfiguration = null;
                        } else if (element.equals("linkerOptionItem")) {
                            if (this.currentLibrariesConfiguration != null) {
                                this.currentLibrariesConfiguration.add(new LibraryItem.OptionItem(this.getString(currentText)));
                            }
                        } else if (element.equals("linkerLibFileItem")) {
                            if (this.currentLibrariesConfiguration != null) {
                                this.currentLibrariesConfiguration.add(new LibraryItem.LibFileItem(this.getString(currentText)));
                            }
                        } else if (element.equals("linkerLibLibItem")) {
                            if (this.currentLibrariesConfiguration != null) {
                                this.currentLibrariesConfiguration.add(new LibraryItem.LibItem(this.getString(currentText)));
                            }
                        } else if (element.equals("linkerLibStdlibItem")) {
                            LibraryItem.StdLibItem stdLibItem = StdLibraries.getStandardLibary(currentText);
                            if (this.currentLibrariesConfiguration != null && stdLibItem != null) {
                                this.currentLibrariesConfiguration.add(stdLibItem);
                            }
                        } else if (element.equals("buildMode")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getBuildMode().setValue(Integer.parseInt(currentText));
                            }
                        } else if (element.equals("destdir")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getDestdir().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("target")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getTarget().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("version")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getVersion().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("modules")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.setEnabledModules(currentText);
                            }
                        } else if (element.equals("mocDir")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getMocDir().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("rccDir")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getRccDir().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("uiDir")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getUiDir().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("qmakeSpec")) {
                            if (this.currentQmakeConfiguration != null) {
                                this.currentQmakeConfiguration.getQmakeSpec().setValue(this.getString(currentText));
                            }
                        } else if (element.equals("packAddInfosListElem")) {
                            this.currentList = null;
                        }
                    }
                }
            }
        }
    }

    private Item createItem(String path) {
        return Item.createInBaseDir(this.remoteProject.getSourceBaseDirFileObject(), path);
    }

    private String adjustOffset(String path) {
        if (this.relativeOffset != null && path.startsWith("..")) {
            path = CndPathUtilities.trimDotDot((String)(this.relativeOffset + path));
        }
        return path;
    }

    private MakeConfiguration createNewConfiguration(FileObject projectDirectory, String value, int confType, String customizerId, boolean platformSpecific) {
        FSPath fsPath;
        String host = this.descriptorVersion < 46 ? "localhost" : CppUtils.getDefaultDevelopmentHost(projectDirectory);
        try {
            fsPath = new FSPath(projectDirectory.getFileSystem(), projectDirectory.getPath());
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException(ex);
        }
        MakeConfiguration makeConfiguration = MakeConfiguration.createConfiguration(fsPath, this.getString(value), confType, customizerId, host, platformSpecific);
        return makeConfiguration;
    }

    private String getString(String s) {
        String res = this.cache.get(s);
        if (res == null) {
            this.cache.put(s, s);
            return s;
        }
        return res;
    }

    @Override
    protected void writeToolsSetBlock(XMLEncoderStream xes, MakeConfiguration makeConfiguration) {
        xes.elementOpen("toolsSet");
        RemoteSyncFactory fixedSyncFactory = makeConfiguration.getFixedRemoteSyncFactory();
        if (fixedSyncFactory != null) {
            xes.element("remoteSyncFactory", fixedSyncFactory.getID());
        }
        xes.element("compilerSet", "" + makeConfiguration.getCompilerSet().getNameAndFlavor());
        if (makeConfiguration.getPlatformSpecific().getValue()) {
            xes.element("platform", "" + makeConfiguration.getDevelopmentHost().getBuildPlatform());
        }
        if (makeConfiguration.getCRequired().getValue() != makeConfiguration.getCRequired().getDefault()) {
            xes.element("cRequired", "" + makeConfiguration.getCRequired().getValue());
        }
        if (makeConfiguration.getCppRequired().getValue() != makeConfiguration.getCppRequired().getDefault()) {
            xes.element("cppRequired", "" + makeConfiguration.getCppRequired().getValue());
        }
        if (makeConfiguration.getFortranRequired().getValue() != makeConfiguration.getFortranRequired().getDefault()) {
            xes.element("fortranRequired", "" + makeConfiguration.getFortranRequired().getValue());
        }
        if (makeConfiguration.getAssemblerRequired().getValue() != makeConfiguration.getAssemblerRequired().getDefault()) {
            xes.element("assemblerRequired", "" + makeConfiguration.getAssemblerRequired().getValue());
        }
        xes.element("dependencyChecking", "" + makeConfiguration.getDependencyChecking().getValue());
        xes.element("rebuildPropChanged", "" + makeConfiguration.getRebuildPropChanged().getValue());
        xes.elementClose("toolsSet");
    }

    @Override
    protected void writeCompileConfBlock(XMLEncoderStream xes, MakeConfiguration makeConfiguration) {
    }
}

