/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.api.xml.XMLDocReader;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectTypeImpl;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.configurations.AuxConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.spi.ProjectMetadataFactory;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.xml.sax.Attributes;

public class ConfigurationXMLReader
extends XMLDocReader {
    private static final int DEPRECATED_VERSIONS = 26;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private final FileObject projectDirectory;
    private final Project project;
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("ConfigurationXMLReader", 10);
    private static final boolean TRACE_LONG_LOADING = false;

    public ConfigurationXMLReader(Project project, FileObject projectDirectory) {
        this.project = project;
        this.projectDirectory = projectDirectory;
    }

    public void read(final MakeConfigurationDescriptor configurationDescriptor, final String relativeOffset, final Interrupter interrupter) throws IOException {
        FileObject xml;
        String tag;
        FileObject fo = this.projectDirectory.getFileObject("nbproject/configurations.xml");
        if (fo == null) {
            tag = "projectDescriptor";
            xml = this.projectDirectory.getFileObject("nbproject/projectDescriptor.xml");
        } else {
            tag = "configurationDescriptor";
            xml = fo;
        }
        if (xml == null) {
            this.displayErrorDialog();
            configurationDescriptor.setState(ConfigurationDescriptor.State.BROKEN);
            return;
        }
        configurationDescriptor.setState(ConfigurationDescriptor.State.READING);
        RequestProcessor.Task task = REQUEST_PROCESSOR.post((Runnable)new NamedRunnable("Reading project configuraion"){

            protected void runImpl() {
                try {
                    if (ConfigurationXMLReader.this._read(relativeOffset, interrupter, tag, xml, configurationDescriptor) == null) {
                        configurationDescriptor.setState(ConfigurationDescriptor.State.BROKEN);
                        return;
                    }
                    String customizerId = configurationDescriptor.getActiveConfiguration() == null ? null : configurationDescriptor.getActiveConfiguration().getCustomizerId();
                    for (ProjectMetadataFactory f : Lookups.forPath((String)MakeProjectTypeImpl.projectMetadataFactoryPath(customizerId)).lookupAll(ProjectMetadataFactory.class)) {
                        f.read(ConfigurationXMLReader.this.projectDirectory);
                    }
                }
                catch (IOException ex) {
                    configurationDescriptor.setState(ConfigurationDescriptor.State.BROKEN);
                }
            }
        });
        configurationDescriptor.setInitTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationDescriptor _read(String relativeOffset, Interrupter interrupter, String tag, FileObject xml, final MakeConfigurationDescriptor configurationDescriptor) throws IOException {
        boolean success;
        ConfigurationXMLCodec decoder = new ConfigurationXMLCodec(tag, this.projectDirectory, configurationDescriptor, relativeOffset);
        this.registerXMLDecoder(decoder);
        InputStream inputStream = null;
        try {
            inputStream = xml.getInputStream();
            success = this.read(inputStream, xml.getPath(), interrupter);
            if (this.getMasterComment() != null && this.project instanceof MakeProject) {
                ((MakeProject)this.project).setConfigurationXMLComment(this.getMasterComment());
            }
        }
        finally {
            this.deregisterXMLDecoder(decoder);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (!success) {
            this.displayErrorDialog();
            return null;
        }
        xml = this.projectDirectory.getFileObject("nbproject/private/configurations.xml");
        if (xml != null) {
            AuxConfigurationXMLCodec auxDecoder = new AuxConfigurationXMLCodec(tag, configurationDescriptor);
            this.registerXMLDecoder(auxDecoder);
            inputStream = null;
            try {
                inputStream = xml.getInputStream();
                success = this.read(inputStream, this.projectDirectory.getName(), interrupter);
            }
            finally {
                this.deregisterXMLDecoder(auxDecoder);
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (!success) {
                return null;
            }
        }
        if (this.project != null) {
            int activeIndex = ((MakeProject)this.project).getActiveConfigurationIndexFromPrivateXML();
            if (activeIndex >= 0) {
                configurationDescriptor.getConfs().setActive(activeIndex);
            } else {
                PlatformInfo aDefault = PlatformInfo.getDefault((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
                int localPlatform = aDefault.getPlatform();
                int i = 0;
                for (Configuration conf : configurationDescriptor.getConfs().getConfigurations()) {
                    MakeConfiguration mk = (MakeConfiguration)conf;
                    if (mk.getPlatformSpecific().getValue()) {
                        if (localPlatform == mk.getDevelopmentHost().getBuildPlatform()) {
                            configurationDescriptor.getConfs().setActive(i);
                            break;
                        }
                    } else {
                        configurationDescriptor.getConfs().setActive(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        Item[] projectItems = configurationDescriptor.getProjectItems();
        for (Configuration configuration : configurationDescriptor.getConfs().getConfigurations()) {
            for (Item item : projectItems) {
                if (item.getItemConfiguration(configuration) != null) continue;
                ItemConfiguration itemConfiguration = new ItemConfiguration(configuration, item);
                configuration.addAuxObject(itemConfiguration);
                if (configurationDescriptor.getVersion() < 88) continue;
                itemConfiguration.getExcluded().setValue(true);
            }
        }
        boolean schemeWithExcludedItems = false;
        if (configurationDescriptor.getVersion() >= 0 && configurationDescriptor.getVersion() < 88) {
            schemeWithExcludedItems = true;
        }
        this.prepareFoldersTask(configurationDescriptor, schemeWithExcludedItems, interrupter);
        configurationDescriptor.setState(ConfigurationDescriptor.State.READY);
        boolean isMakefileProject = false;
        for (Configuration configuration : configurationDescriptor.getConfs().getConfigurations()) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
            if (!makeConfiguration.isMakefileConfiguration()) continue;
            isMakefileProject = true;
            break;
        }
        FileObject makeImpl = this.projectDirectory.getFileObject("nbproject/Makefile-impl.mk");
        configurationDescriptor.setModified(!isMakefileProject && makeImpl == null || relativeOffset != null);
        if (configurationDescriptor.getVersion() >= 0 && configurationDescriptor.getVersion() <= 26) {
            final String message = NbBundle.getMessage(ConfigurationXMLReader.class, (String)"OLD_VERSION_WARNING", (Object)this.projectDirectory.getPath());
            if (CndUtils.isStandalone()) {
                System.err.print(message);
                System.err.println(NbBundle.getMessage(ConfigurationXMLReader.class, (String)"OLD_VERSION_WARNING_AUTO"));
                configurationDescriptor.setModified();
            } else {
                Runnable warning = new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor nd = new NotifyDescriptor((Object)message, NbBundle.getMessage(ConfigurationXMLReader.class, (String)"CONVERT_DIALOG_TITLE"), 0, 3, null, NotifyDescriptor.YES_OPTION);
                        Object ret = DialogDisplayer.getDefault().notify(nd);
                        if (ret == NotifyDescriptor.YES_OPTION) {
                            configurationDescriptor.setModified();
                        }
                    }
                };
                SwingUtilities.invokeLater(warning);
            }
        }
        if (configurationDescriptor.isModified()) {
            configurationDescriptor.setVersion(97);
        }
        ConfigurationDescriptorProvider.recordMetrics("USG_PROJECT_OPEN_CND", configurationDescriptor);
        return configurationDescriptor;
    }

    private void displayErrorDialog() {
    }

    private void prepareFoldersTask(final MakeConfigurationDescriptor configurationDescriptor, final boolean oldSchemeWasRestored, final Interrupter interrupter) {
        final List<Folder> firstLevelFolders = configurationDescriptor.getLogicalFolders().getFolders();
        REQUEST_PROCESSOR.post(new Runnable(){
            private boolean restoreInOldScheme;
            {
                this.restoreInOldScheme = oldSchemeWasRestored;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String postfix = configurationDescriptor.getBaseDir();
                String threadName = "Attach listeners and refresh content of all disk folders " + postfix;
                LOGGER.log(Level.FINE, "Start {0}", threadName);
                long time = System.currentTimeMillis();
                String oldName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(threadName);
                    for (Folder f : firstLevelFolders) {
                        if (!f.isDiskFolder()) continue;
                        if (this.restoreInOldScheme) {
                            LOGGER.log(Level.FINE, "Restore based on old scheme {0}", f);
                            this.restoreInOldScheme = false;
                            f.refreshDiskFolderAfterRestoringOldScheme(interrupter);
                        } else {
                            LOGGER.log(Level.FINE, "Restore based on new scheme {0}", f);
                            f.refreshDiskFolder(interrupter);
                        }
                        f.attachListeners(interrupter);
                    }
                    LOGGER.log(Level.FINE, "End attach listeners and refresh content of all disk folders, time {0}ms. {1}", new Object[]{System.currentTimeMillis() - time, postfix});
                }
                finally {
                    Thread.currentThread().setName(oldName);
                }
            }
        });
    }

    protected String tag() {
        return null;
    }

    public void start(Attributes atts) {
    }

    public void end() {
    }

    public void startElement(String name, Attributes atts) {
    }

    public void endElement(String name, String currentText) {
    }
}

