/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.utils.DirectoryChooserInnerPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProjectPropPanel
extends JPanel
implements MakeContext.Savable {
    private final SourceRootChooser sourceRootChooser;
    private final Project project;
    private final MakeConfigurationDescriptor makeConfigurationDescriptor;
    private String originalEncoding;
    private JComboBox encoding;
    private JLabel encodingLabel;
    private JPanel encodingPanel;
    private JPanel ignoreFolderPanel;
    private JButton ignoreFoldersDefaultButton;
    private JLabel ignoreFoldersLabel;
    private JTextField ignoreFoldersTextField;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JLabel seeAlsoLabel;
    private JPanel sourceRootPanel;
    private JPanel testRootPanel;

    public ProjectPropPanel(Project project, ConfigurationDescriptor configurationDescriptor) {
        this.project = project;
        this.makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptor;
        this.initComponents();
        this.projectTextField.setText(project.getProjectDirectory().getPath());
        ExecutionEnvironment env = ExecutionEnvironmentFactory.getLocal();
        this.sourceRootChooser = new SourceRootChooser(configurationDescriptor.getBaseDir(), this.makeConfigurationDescriptor.getSourceRoots(), MakeProjectUtils.getSourceFileSystemHost(project));
        this.sourceRootPanel.add((Component)((Object)this.sourceRootChooser));
        this.ignoreFoldersTextField.setText(this.makeConfigurationDescriptor.getFolderVisibilityQuery().getRegEx());
        MakeCustomizerProvider makeCustomizerProvider = (MakeCustomizerProvider)project.getLookup().lookup(MakeCustomizerProvider.class);
        this.originalEncoding = ((MakeProject)project).getSourceEncoding();
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(ProjectCustomizer.encodingModel((String)this.originalEncoding));
        this.encoding.setRenderer(ProjectCustomizer.encodingRenderer());
        this.encoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProjectPropPanel.this.handleEncodingChange();
            }
        });
    }

    private void handleEncodingChange() {
    }

    @Override
    public void save() {
        Charset enc = (Charset)this.encoding.getSelectedItem();
        String encName = enc != null ? enc.name() : this.originalEncoding;
        ((MakeProject)this.project).setSourceEncoding(encName);
        this.makeConfigurationDescriptor.setSourceRoots(this.sourceRootChooser.getListData());
        try {
            Pattern.compile(this.ignoreFoldersTextField.getText());
            this.makeConfigurationDescriptor.setFolderVisibilityQuery(this.ignoreFoldersTextField.getText());
        }
        catch (PatternSyntaxException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.incorrectRegEx", (Object)ex.getMessage().trim()), 0));
        }
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.sourceRootPanel = new JPanel();
        this.ignoreFolderPanel = new JPanel();
        this.ignoreFoldersLabel = new JLabel();
        this.ignoreFoldersTextField = new JTextField();
        this.ignoreFoldersDefaultButton = new JButton();
        this.seeAlsoLabel = new JLabel();
        this.testRootPanel = new JPanel();
        this.encodingPanel = new JPanel();
        this.encodingLabel = new JLabel();
        this.encoding = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.projectLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.projectLabel.ad"));
        this.projectTextField.setEditable(false);
        this.projectTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropPanel.this.projectTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.sourceRootPanel.setBackground(new Color(255, 255, 255));
        this.sourceRootPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.sourceRootPanel, gridBagConstraints);
        this.ignoreFolderPanel.setLayout(new GridBagLayout());
        this.ignoreFoldersLabel.setLabelFor(this.ignoreFoldersTextField);
        Mnemonics.setLocalizedText((JLabel)this.ignoreFoldersLabel, (String)NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.ignoreFoldersLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.ignoreFolderPanel.add((Component)this.ignoreFoldersLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.ignoreFolderPanel.add((Component)this.ignoreFoldersTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreFoldersDefaultButton, (String)NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.ignoreFoldersDefaultButton.text"));
        this.ignoreFoldersDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropPanel.this.ignoreFoldersDefaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.ignoreFolderPanel.add((Component)this.ignoreFoldersDefaultButton, gridBagConstraints);
        this.seeAlsoLabel.setText(NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.seeAlsoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.ignoreFolderPanel.add((Component)this.seeAlsoLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.ignoreFolderPanel, gridBagConstraints);
        this.testRootPanel.setBackground(new Color(255, 255, 255));
        this.testRootPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.testRootPanel, gridBagConstraints);
        this.encodingLabel.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.encodingLabel.text"));
        GroupLayout encodingPanelLayout = new GroupLayout(this.encodingPanel);
        this.encodingPanel.setLayout(encodingPanelLayout);
        encodingPanelLayout.setHorizontalGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingPanelLayout.createSequentialGroup().addComponent(this.encodingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encoding, -2, 137, -2).addContainerGap(-1, Short.MAX_VALUE)));
        encodingPanelLayout.setVerticalGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingLabel).addComponent(this.encoding, -2, -1, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.encodingPanel, gridBagConstraints);
    }

    private void ignoreFoldersDefaultButtonActionPerformed(ActionEvent evt) {
        this.ignoreFoldersTextField.setText("^(nbproject|build|test|tests)$");
    }

    private void projectTextFieldActionPerformed(ActionEvent evt) {
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ProjectPropPanel.class, (String)key);
    }

    private static class SourceRootChooser
    extends DirectoryChooserInnerPanel {
        public SourceRootChooser(String baseDir, List<String> feed, ExecutionEnvironment env) {
            super(baseDir, feed, env);
            this.getCopyButton().setVisible(false);
            this.getEditButton().setVisible(false);
        }

        @Override
        public String getListLabelText() {
            return ProjectPropPanel.getString("ProjectPropPanel.sourceRootLabel.text");
        }

        @Override
        public char getListLabelMnemonic() {
            return ProjectPropPanel.getString("ProjectPropPanel.sourceRootLabel.mn").charAt(0);
        }

        @Override
        public char getAddButtonMnemonics() {
            return ProjectPropPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        @Override
        public String getAddButtonText() {
            return ProjectPropPanel.getString("ADD_BUTTON_TXT");
        }
    }
}

