/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.LoadingNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.RefreshableItemsContainer;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

abstract class BaseMakeViewChildren
extends Children.Keys<Object>
implements ChangeListener,
RefreshableItemsContainer {
    private final RequestProcessor.Task refreshKeysTask;
    private final KeyUpdater keyUpdater;
    static final int WAIT_DELAY = 50;
    private Folder folder;
    protected final MakeLogicalViewProvider provider;

    public BaseMakeViewChildren(Folder folder, MakeLogicalViewProvider provider) {
        this.folder = folder;
        this.provider = provider;
        this.keyUpdater = new KeyUpdater();
        this.refreshKeysTask = provider.getAnnotationRP().create((Runnable)this.keyUpdater, true);
    }

    protected final MakeProject getProject() {
        return this.provider.getProject();
    }

    protected boolean isRoot() {
        return false;
    }

    protected void onFolderChange(Folder folder) {
    }

    protected void addNotify() {
        if (this.provider.isFindPathMode()) {
            super.addNotify();
            this.getAddNotifyRunnable().run();
        } else if (SwingUtilities.isEventDispatchThread()) {
            super.addNotify();
            this.resetKeys(Collections.singleton(this.getWaitNode()));
            this.provider.getAnnotationRP().post(this.getAddNotifyRunnable(), 50);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseMakeViewChildren.this.addNotify();
                }
            });
        }
    }

    private synchronized void resetKeys(Collection<?> keysSet) {
        this.setKeys(keysSet);
    }

    private Runnable getAddNotifyRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                MakeConfigurationDescriptor mcd;
                if (BaseMakeViewChildren.this.isRoot() && BaseMakeViewChildren.this.folder == null && (mcd = BaseMakeViewChildren.this.provider.getMakeConfigurationDescriptor()) != null) {
                    BaseMakeViewChildren.this.folder = mcd.getLogicalFolders();
                    BaseMakeViewChildren.this.onFolderChange(BaseMakeViewChildren.this.folder);
                }
                if (BaseMakeViewChildren.this.folder != null) {
                    BaseMakeViewChildren.this.folder.addChangeListener(BaseMakeViewChildren.this);
                    if (BaseMakeViewChildren.this.getProject().getProjectDirectory() != null && BaseMakeViewChildren.this.getProject().getProjectDirectory().isValid()) {
                        BaseMakeViewChildren.this.resetKeys(BaseMakeViewChildren.this.getKeys(null));
                    }
                }
            }
        };
    }

    private Node getWaitNode() {
        return new LoadingNode();
    }

    @Override
    public void refreshItem(Item item) {
        this.refreshKey(item);
    }

    protected void removeNotify() {
        this.refreshKeysTask.cancel();
        this.keyUpdater.cancel();
        this.resetKeys(Collections.EMPTY_SET);
        if (this.folder != null) {
            this.folder.removeChangeListener(this);
        }
        super.removeNotify();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof Item) {
            Item[] items;
            for (final Item item : items = this.getFolder().getItemsAsArray()) {
                if (e.getSource() != item) continue;
                Runnable todo = new Runnable(){

                    @Override
                    public void run() {
                        BaseMakeViewChildren.this.refreshItem(item);
                    }
                };
                this.provider.getAnnotationRP().post(todo);
                break;
            }
        } else {
            this.refreshKeysTask.schedule(50);
        }
    }

    protected abstract Collection<Object> getKeys(AtomicBoolean var1);

    public Folder getFolder() {
        return this.folder;
    }

    private class KeyUpdater
    implements Runnable {
        private AtomicBoolean canceled = new AtomicBoolean(false);

        private KeyUpdater() {
        }

        private synchronized void cancel() {
            this.canceled.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            KeyUpdater keyUpdater = this;
            synchronized (keyUpdater) {
                this.canceled = new AtomicBoolean(false);
            }
            Collection<Object> keys = BaseMakeViewChildren.this.getKeys(this.canceled);
            if (!this.canceled.get()) {
                BaseMakeViewChildren.this.resetKeys(keys);
            }
        }
    }
}

