/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.RemoteSyncActions;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class NodeActionFactory {
    private static final boolean DOWNLOAD_ACTION = Boolean.getBoolean("cnd.remote.download.project.action");
    private static StandardNodeAction renameAction = null;
    private static StandardNodeAction deleteAction = null;

    NodeActionFactory() {
    }

    static StandardNodeAction createRenameAction() {
        if (renameAction == null) {
            renameAction = new RenameNodeAction();
        }
        return renameAction;
    }

    static StandardNodeAction createDeleteAction() {
        if (deleteAction == null) {
            deleteAction = new DeleteNodeAction();
        }
        return deleteAction;
    }

    static void addSyncActions(List<Action> actions) {
        actions.add(RemoteSyncActions.createUploadAction());
        if (DOWNLOAD_ACTION) {
            actions.add(RemoteSyncActions.createDownloadAction());
        }
    }

    static Action[] insertSyncActions(Action[] actions, Class<?> insertAfter) {
        Action[] result = actions;
        if (DOWNLOAD_ACTION) {
            result = NodeActionFactory.insertAfter(result, new Action[]{RemoteSyncActions.createDownloadAction()}, insertAfter);
        }
        result = NodeActionFactory.insertAfter(result, new Action[]{RemoteSyncActions.createUploadAction()}, insertAfter);
        return result;
    }

    static Action[] insertAfter(Action[] actions, Action[] actionsToInsert, Class<?> insertAfter) {
        if (actionsToInsert == null || actionsToInsert.length == 0) {
            return actions;
        }
        int insertPos = -1;
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null || !actions[i].getClass().equals(insertAfter)) continue;
            insertPos = i + 1;
            break;
        }
        if (insertPos < 0) {
            return actions;
        }
        Action[] newActions = new Action[actions.length + actionsToInsert.length];
        System.arraycopy(actions, 0, newActions, 0, insertPos);
        int rest = actions.length - insertPos;
        int newIndex = insertPos;
        for (Action action : actionsToInsert) {
            newActions[newIndex++] = action;
        }
        if (rest > 0) {
            System.arraycopy(actions, insertPos, newActions, newIndex, rest);
        }
        return newActions;
    }

    static Action[] insertAfter(Action[] actions, Action[] actionsToInsert) {
        if (actionsToInsert == null || actionsToInsert.length == 0) {
            return actions;
        }
        Action[] newActions = new Action[actions.length + actionsToInsert.length];
        System.arraycopy(actions, 0, newActions, 0, actions.length);
        System.arraycopy(actionsToInsert, 0, newActions, actions.length, actionsToInsert.length);
        return newActions;
    }

    static final class DeleteNodeAction
    extends StandardNodeAction {
        public DeleteNodeAction() {
            super(SystemAction.get(DeleteAction.class));
        }
    }

    static final class RenameNodeAction
    extends StandardNodeAction {
        public RenameNodeAction() {
            super(SystemAction.get(RenameAction.class));
        }

        @Override
        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length == 1;
        }
    }

    static class StandardNodeAction
    extends NodeAction {
        private final SystemAction systemAction;

        public StandardNodeAction(SystemAction systemAction) {
            this.systemAction = systemAction;
        }

        protected void performAction(Node[] activatedNodes) {
            Action a;
            if (activatedNodes.length == 0) {
                return;
            }
            final ArrayList<MakeConfigurationDescriptor> projects = new ArrayList<MakeConfigurationDescriptor>();
            final AtomicBoolean isItem = new AtomicBoolean(false);
            for (Node activatedNode : activatedNodes) {
                MakeConfigurationDescriptor mcd;
                Folder folder = (Folder)activatedNodes[0].getLookup().lookup(Folder.class);
                if (folder == null) {
                    ViewItemNode vin = (ViewItemNode)activatedNode.getLookup().lookup(ViewItemNode.class);
                    if (vin == null) {
                        return;
                    }
                    folder = vin.getFolder();
                    if (folder == null) {
                        return;
                    }
                    isItem.set(true);
                }
                if ((mcd = folder.getConfigurationDescriptor()) == null) {
                    return;
                }
                if (projects.contains(mcd)) continue;
                projects.add(mcd);
            }
            for (MakeConfigurationDescriptor mcd : projects) {
                if (mcd.okToChange()) continue;
                return;
            }
            InstanceContent ic = new InstanceContent();
            for (Node activatedNode : activatedNodes) {
                ic.add((Object)activatedNode);
            }
            AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
            if (this.systemAction instanceof NodeAction) {
                a = ((NodeAction)this.systemAction).createContextAwareInstance((Lookup)actionContext);
            } else if (this.systemAction instanceof CallbackSystemAction) {
                a = ((CallbackSystemAction)this.systemAction).createContextAwareInstance((Lookup)actionContext);
            } else {
                assert (false);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    a.actionPerformed(new ActionEvent((Object)StandardNodeAction.this, 0, null));
                    for (final MakeConfigurationDescriptor mcd : projects) {
                        if (isItem.get()) {
                            ViewItemNode.getRP().post(new Runnable(){

                                @Override
                                public void run() {
                                    mcd.save();
                                }
                            });
                            continue;
                        }
                        MakeLogicalViewProvider provider = (MakeLogicalViewProvider)mcd.getProject().getLookup().lookup(MakeLogicalViewProvider.class);
                        provider.getAnnotationRP().post(new Runnable(){

                            @Override
                            public void run() {
                                mcd.save();
                            }
                        });
                    }
                }
            });
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return this.systemAction.getHelpCtx();
        }

        public String getName() {
            return this.systemAction.getName();
        }
    }
}

