/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ViewItemPasteType
extends PasteType {
    private static final RequestProcessor RP = new RequestProcessor("ViewItemPasteType", 1);
    private final Folder toFolder;
    private final Folder fromFolder;
    private final Item fromItem;
    private final int type;
    private final MakeLogicalViewProvider provider;

    ViewItemPasteType(Folder toFolder, ViewItemNode viewItemNode, int type, MakeLogicalViewProvider provider) {
        this.toFolder = toFolder;
        this.fromItem = viewItemNode.getItem();
        this.fromFolder = viewItemNode.getFolder();
        this.type = type;
        this.provider = provider;
    }

    ViewItemPasteType(Folder toFolder, Folder fromFolder, Item fromItem, int type, MakeLogicalViewProvider provider) {
        this.toFolder = toFolder;
        this.fromItem = fromItem;
        this.fromFolder = fromFolder;
        this.type = type;
        this.provider = provider;
    }

    private void copyItemConfigurations(ItemConfiguration[] newConfigurations, ItemConfiguration[] oldConfigurations) {
        if (newConfigurations == null || oldConfigurations == null) {
            return;
        }
        assert (newConfigurations.length == oldConfigurations.length);
        if (newConfigurations.length == 0 || oldConfigurations.length == 0) {
            return;
        }
        for (int i = 0; i < newConfigurations.length; ++i) {
            if (oldConfigurations[i] == null || newConfigurations[i] == null) continue;
            newConfigurations[i].assignValues(oldConfigurations[i]);
        }
    }

    public Transferable paste() throws IOException {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewItemPasteType.this.pasteImpl();
                }
                catch (IOException ex) {
                    String message = null;
                    if (ViewItemPasteType.this.type == 2) {
                        message = NbBundle.getMessage(ViewItemPasteType.class, (String)"paste_operation_move", (Object)ViewItemPasteType.this.fromItem.getAbsPath());
                    } else if (ViewItemPasteType.this.type == 1 || ViewItemPasteType.this.type == 0) {
                        message = NbBundle.getMessage(ViewItemPasteType.class, (String)"paste_operation_copy", (Object)ViewItemPasteType.this.fromItem.getAbsPath());
                    }
                    if (message != null) {
                        StatusDisplayer.getDefault().setStatusText(message);
                    }
                    ex.printStackTrace(System.err);
                }
            }
        });
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pasteImpl() throws IOException {
        if (!this.provider.gotMakeConfigurationDescriptor() || !this.provider.getMakeConfigurationDescriptor().okToChange()) {
            return;
        }
        ItemConfiguration[] oldConfigurations = this.fromItem.getItemConfigurations();
        FileObject itemFO = this.fromItem.getFileObject();
        if (this.type == 2) {
            if (this.toFolder.getProject() == this.fromFolder.getProject()) {
                if (this.toFolder.isDiskFolder()) {
                    Folder folder;
                    if (!itemFO.isValid()) return;
                    String toFolderPath = CndPathUtilities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                    if (toFolderFO == null || !toFolderFO.isValid()) {
                        return;
                    }
                    String newName = CndPathUtilities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getName(), (String)itemFO.getExt());
                    FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
                    String itemPath = movedFileFO.getPath();
                    itemPath = CndPathUtilities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                    Item movedItem = this.toFolder.findItemByPath(itemPath = CndPathUtilities.normalizeSlashes((String)itemPath));
                    if (movedItem != null) {
                        this.copyItemConfigurations(movedItem.getItemConfigurations(), oldConfigurations);
                    }
                    if ((folder = this.fromItem.getFolder()) == null) return;
                    folder.removeItemAction(this.fromItem);
                    return;
                } else {
                    if (!this.fromFolder.removeItem(this.fromItem)) return;
                    this.toFolder.addItem(this.fromItem);
                    this.copyItemConfigurations(this.fromItem.getItemConfigurations(), oldConfigurations);
                }
                return;
            } else {
                if (this.toFolder.isDiskFolder()) {
                    if (!itemFO.isValid()) return;
                    String toFolderPath = CndPathUtilities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                    String newName = CndPathUtilities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getName(), (String)itemFO.getExt());
                    FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
                    if (!this.fromItem.getFolder().isDiskFolder() && !this.fromFolder.removeItemAction(this.fromItem)) return;
                }
                if (this.toFolder.getConfigurationDescriptor().getBaseDirFileSystem().equals(itemFO.getFileSystem()) && (CndPathUtilities.isPathAbsolute((CharSequence)this.fromItem.getPath()) || this.fromItem.getPath().startsWith(".."))) {
                    if (CndPathUtilities.isPathAbsolute((CharSequence)this.fromItem.getPath())) {
                        if (!this.fromFolder.removeItem(this.fromItem)) return;
                        this.toFolder.addItem(this.fromItem);
                        return;
                    } else {
                        String originalFilePath = this.fromFolder.getProject().getProjectDirectory().getPath();
                        String newFilePath = this.toFolder.getProject().getProjectDirectory().getPath();
                        String fromNewToOriginal = CndPathUtilities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                        fromNewToOriginal = CndPathUtilities.normalizeSlashes((String)fromNewToOriginal);
                        String newPath = fromNewToOriginal + this.fromItem.getPath();
                        newPath = CndPathUtilities.trimDotDot((String)newPath);
                        if (!this.fromFolder.removeItemAction(this.fromItem)) return;
                        this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilities.normalizeSlashes((String)newPath)));
                    }
                    return;
                } else {
                    if (!itemFO.isValid()) return;
                    Project toProject = this.toFolder.getProject();
                    String newName = CndPathUtilities.createUniqueFileName((FileObject)toProject.getProjectDirectory(), (String)itemFO.getName(), (String)itemFO.getExt());
                    FileObject copy = itemFO.copy(toProject.getProjectDirectory(), newName, itemFO.getExt());
                    String newPath = CndPathUtilities.toRelativePath((String)toProject.getProjectDirectory().getPath(), (String)copy.getPath());
                    if (!this.fromFolder.removeItemAction(this.fromItem)) return;
                    itemFO.delete();
                    this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilities.normalizeSlashes((String)newPath)));
                }
            }
            return;
        } else {
            if (this.type != 1 && this.type != 0) return;
            if (this.toFolder.getProject() == this.fromFolder.getProject()) {
                if (CndPathUtilities.isPathAbsolute((CharSequence)this.fromItem.getPath())) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                } else {
                    String ext = itemFO.getExt();
                    if (this.toFolder.isDiskFolder()) {
                        if (!itemFO.isValid()) return;
                        String toFolderPath = CndPathUtilities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                        FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                        String newName = CndPathUtilities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getName(), (String)ext);
                        FileObject copiedFileObject = itemFO.copy(toFolderFO, newName, ext);
                        String itemPath = copiedFileObject.getPath();
                        itemPath = CndPathUtilities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                        Item copiedItemItem = this.toFolder.findItemByPath(itemPath = CndPathUtilities.normalizeSlashes((String)itemPath));
                        if (copiedItemItem == null) return;
                        this.copyItemConfigurations(copiedItemItem.getItemConfigurations(), oldConfigurations);
                        return;
                    } else {
                        if (!itemFO.isValid()) return;
                        String parent = itemFO.getParent().getPath();
                        String newName = CndPathUtilities.createUniqueFileName((FileObject)itemFO.getParent(), (String)itemFO.getName(), (String)ext);
                        itemFO.copy(itemFO.getParent(), newName, ext);
                        String newPath = parent + "/" + newName;
                        if (ext.length() > 0) {
                            newPath = newPath + "." + ext;
                        }
                        newPath = CndPathUtilities.toRelativePath((String)this.fromFolder.getProject().getProjectDirectory().getPath(), (String)newPath);
                        Item newItem = Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilities.normalizeSlashes((String)newPath));
                        this.toFolder.addItemAction(newItem);
                        this.copyItemConfigurations(newItem.getItemConfigurations(), oldConfigurations);
                    }
                }
                return;
            } else if (this.toFolder.isDiskFolder()) {
                if (!itemFO.isValid()) return;
                String ext = itemFO.getExt();
                String toFolderPath = CndPathUtilities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                String newName = CndPathUtilities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getName(), (String)ext);
                itemFO.copy(toFolderFO, newName, ext);
                return;
            } else if (this.toFolder.getConfigurationDescriptor().getBaseDirFileSystem().equals(itemFO.getFileSystem()) && (CndPathUtilities.isPathAbsolute((CharSequence)this.fromItem.getPath()) || this.fromItem.getPath().startsWith(".."))) {
                if (CndPathUtilities.isPathAbsolute((CharSequence)this.fromItem.getPath())) {
                    this.toFolder.addItem(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), this.fromItem.getPath()));
                    return;
                } else {
                    String originalFilePath = this.fromFolder.getProject().getProjectDirectory().getPath();
                    String newFilePath = this.toFolder.getProject().getProjectDirectory().getPath();
                    String fromNewToOriginal = CndPathUtilities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                    fromNewToOriginal = CndPathUtilities.normalizeSlashes((String)fromNewToOriginal);
                    String newPath = fromNewToOriginal + this.fromItem.getPath();
                    newPath = CndPathUtilities.trimDotDot((String)newPath);
                    this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilities.normalizeSlashes((String)newPath)));
                }
                return;
            } else {
                if (!itemFO.isValid()) return;
                Project toProject = this.toFolder.getProject();
                String ext = itemFO.getExt();
                String newName = CndPathUtilities.createUniqueFileName((FileObject)toProject.getProjectDirectory(), (String)itemFO.getName(), (String)ext);
                itemFO.copy(toProject.getProjectDirectory(), newName, ext);
                String newPath = newName;
                if (ext.length() > 0) {
                    newPath = newPath + "." + ext;
                }
                this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilities.normalizeSlashes((String)newPath)));
            }
        }
    }
}

