/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.project;

import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.nbimpl.project.Bundle;
import org.netbeans.modules.profiler.spi.project.ProjectProfilingSupportProvider;
import org.openide.filesystems.FileObject;

public abstract class JavaProjectProfilingSupportProvider
extends ProjectProfilingSupportProvider.Basic {
    private final Project project;
    private JavaPlatform customProjectJavaPlatform = null;

    public boolean isProfilingSupported() {
        return true;
    }

    public boolean isAttachSupported() {
        return true;
    }

    public boolean isFileObjectSupported(FileObject file) {
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)file);
        return src != null && src.isRunnable();
    }

    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        return this.getProjectJavaPlatform() != null;
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        JavaPlatform platform = this.getProjectJavaPlatform();
        if (platform != null) {
            ss.setSystemArchitecture(platform.getPlatformArchitecture());
            ss.setJavaVersionString(platform.getPlatformJDKVersion());
            ss.setJavaExecutable(platform.getPlatformJavaFile());
        }
    }

    public synchronized JavaPlatform getProjectJavaPlatform() {
        ProfilerIDESettings gps = ProfilerIDESettings.getInstance();
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)gps.getJavaPlatformForProfiling());
        JavaPlatform projectJavaPlatform = this.resolveProjectJavaPlatform();
        if (!(platform != null || (platform = projectJavaPlatform) != null && MiscUtils.isSupportedJVM((Map)platform.getSystemProperties()))) {
            if (this.customProjectJavaPlatform == null) {
                this.customProjectJavaPlatform = JavaPlatformSelector.getDefault().selectPlatformToUse();
                if (this.customProjectJavaPlatform == null) {
                    return null;
                }
            }
            platform = this.customProjectJavaPlatform;
        }
        if (projectJavaPlatform != null) {
            Boolean ret;
            while (projectJavaPlatform.getVersion().compareTo(platform.getVersion()) > 0 && !Boolean.TRUE.equals(ret = ProfilerDialogs.displayCancellableConfirmation((String)Bundle.IncorrectJavaSpecVersionDialogMsg(), (String)Bundle.IncorrectJavaSpecVersionDialogCaption()))) {
                if (Boolean.FALSE.equals(ret)) {
                    this.customProjectJavaPlatform = JavaPlatformSelector.getDefault().selectPlatformToUse();
                    if (this.customProjectJavaPlatform == null) {
                        return null;
                    }
                    platform = this.customProjectJavaPlatform;
                    continue;
                }
                return null;
            }
        }
        return platform;
    }

    protected abstract JavaPlatform resolveProjectJavaPlatform();

    protected final JavaPlatform getPlatformByName(String platformName) {
        if (platformName == null || platformName.equals("default_platform")) {
            return JavaPlatform.getDefaultPlatform();
        }
        return JavaPlatform.getJavaPlatformById((String)platformName);
    }

    protected final Project getProject() {
        return this.project;
    }

    protected JavaProjectProfilingSupportProvider(Project project) {
        this.project = project;
    }
}

