/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.type;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.jumpto.type.TypeBrowser;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.jumpto.common.AbstractModelFilter;
import org.netbeans.modules.jumpto.common.CurrentSearch;
import org.netbeans.modules.jumpto.common.ItemRenderer;
import org.netbeans.modules.jumpto.common.Models;
import org.netbeans.modules.jumpto.common.Utils;
import org.netbeans.modules.jumpto.type.FilteredListModel;
import org.netbeans.modules.jumpto.type.GoToPanel;
import org.netbeans.modules.jumpto.type.TypeComparator;
import org.netbeans.modules.jumpto.type.TypeProviderAccessor;
import org.netbeans.modules.jumpto.type.UiOptions;
import org.netbeans.modules.sampler.Sampler;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class GoToTypeAction
extends AbstractAction
implements GoToPanel.ContentProvider {
    static final Logger LOGGER = Logger.getLogger(GoToTypeAction.class.getName());
    private SearchType nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToTypeAction-RequestProcessor", 1);
    private static final RequestProcessor PROFILE_RP = new RequestProcessor("GoToTypeAction-Profile", 1);
    private Worker running;
    private RequestProcessor.Task task;
    GoToPanel panel;
    private Dialog dialog;
    private JButton okButton;
    private Collection<? extends TypeProvider> typeProviders;
    private final Collection<? extends TypeProvider> implicitTypeProviders;
    private final TypeBrowser.Filter typeFilter;
    private final String title;
    private final boolean multiSelection;
    private final CurrentSearch<TypeDescriptor> currentSearch;
    private Dimension initialDimension;

    public GoToTypeAction() {
        this(NbBundle.getMessage(GoToTypeAction.class, (String)"DLG_GoToType"), null, true, new TypeProvider[0]);
    }

    public GoToTypeAction(String title, TypeBrowser.Filter typeFilter, boolean multiSelection, TypeProvider ... typeProviders) {
        super(NbBundle.getMessage(GoToTypeAction.class, (String)"TXT_GoToType"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GoToTypeAction.class).getString("editor-popup-TXT_GoToType"));
        this.title = title;
        this.typeFilter = typeFilter;
        this.implicitTypeProviders = typeProviders.length == 0 ? null : Collections.unmodifiableCollection(Arrays.asList(typeProviders));
        this.multiSelection = multiSelection;
        this.currentSearch = new CurrentSearch<TypeDescriptor>(new Callable<AbstractModelFilter<TypeDescriptor>>(){

            @Override
            public AbstractModelFilter<TypeDescriptor> call() throws Exception {
                return new AbstractModelFilter<TypeDescriptor>(){

                    @Override
                    @NonNull
                    protected String getItemValue(@NonNull TypeDescriptor item) {
                        return item.getSimpleName();
                    }

                    @Override
                    protected void update(@NonNull TypeDescriptor item) {
                        String searchText = this.getSearchText();
                        if (searchText == null) {
                            searchText = "";
                        }
                        TypeProviderAccessor.DEFAULT.setHighlightText(item, searchText);
                    }
                };
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Iterable<? extends TypeDescriptor> selectedTypes = this.getSelectedTypes();
        if (selectedTypes.iterator().hasNext()) {
            JumpList.checkAddEntry();
            for (TypeDescriptor typeDescriptor : selectedTypes) {
                typeDescriptor.open();
            }
        }
    }

    public Iterable<? extends TypeDescriptor> getSelectedTypes() {
        return this.getSelectedTypes(true);
    }

    public Iterable<? extends TypeDescriptor> getSelectedTypes(boolean visible) {
        return this.getSelectedTypes(visible, null);
    }

    public Iterable<? extends TypeDescriptor> getSelectedTypes(boolean visible, String initSearchText) {
        Iterable<Object> result = Collections.emptyList();
        try {
            this.panel = new GoToPanel(this, this.multiSelection);
            this.dialog = this.createDialog(this.panel);
            if (initSearchText != null) {
                this.panel.setInitialText(initSearchText);
            } else {
                JEditorPane recentPane;
                EditorCookie ec;
                Node[] arr = TopComponent.getRegistry().getActivatedNodes();
                if (arr.length > 0 && (ec = (EditorCookie)arr[0].getCookie(EditorCookie.class)) != null && (recentPane = NbDocument.findRecentEditorPane((EditorCookie)ec)) != null) {
                    initSearchText = Utilities.getSelectionOrIdentifier((JTextComponent)recentPane);
                    if (initSearchText != null && org.openide.util.Utilities.isJavaIdentifier((String)initSearchText)) {
                        this.panel.setInitialText(initSearchText);
                    } else {
                        this.panel.setInitialText(arr[0].getName());
                    }
                }
            }
            this.dialog.setVisible(visible);
            result = this.panel.getSelectedTypes();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    @Override
    public ListCellRenderer getListCellRenderer(@NonNull JList list, @NonNull ButtonModel caseSensitive) {
        Parameters.notNull((CharSequence)"list", (Object)list);
        Parameters.notNull((CharSequence)"caseSensitive", (Object)caseSensitive);
        return ItemRenderer.Builder.create(list, caseSensitive, new TypeDescriptorConvertor()).build();
    }

    @Override
    public boolean setListModel(GoToPanel panel, String text) {
        assert (SwingUtilities.isEventDispatchThread());
        this.enableOK(false);
        final GoToPanel goToPanel = panel;
        MouseAdapter warningMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (GoToTypeAction.this.running != null) {
                    GoToTypeAction.this.running.cancel();
                    GoToTypeAction.this.task.cancel();
                    GoToTypeAction.this.running = null;
                }
                goToPanel.setListPanelContent(NbBundle.getMessage(GoToPanel.class, (String)"TXT_SearchCanceled"), false);
            }
        };
        panel.setMouseListener(warningMouseListener);
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (text == null) {
            this.currentSearch.resetFilter();
            panel.setModel(EMPTY_LIST_MODEL);
            return false;
        }
        boolean exact = text.endsWith(" ");
        if ((text = text.trim()).length() == 0 || !Utils.isValidInput(text)) {
            this.currentSearch.resetFilter();
            panel.setModel(EMPTY_LIST_MODEL);
            return false;
        }
        this.nameKind = Utils.getSearchType(text, exact, panel.isCaseSensitive(), null, null);
        if (this.nameKind == SearchType.REGEXP || this.nameKind == SearchType.CASE_INSENSITIVE_REGEXP) {
            text = Utils.removeNonNeededWildCards(text);
        }
        Pair<String, String> nameAndScope = Utils.splitNameAndScope(text.trim());
        String name = (String)nameAndScope.first();
        String scope = (String)nameAndScope.second();
        if (name.isEmpty() && scope == null) {
            this.currentSearch.resetFilter();
            panel.setModel(EMPTY_LIST_MODEL);
            return false;
        }
        if (this.currentSearch.isNarrowing(this.nameKind, name, scope, true)) {
            this.currentSearch.filter(this.nameKind, name, null);
            this.enableOK(panel.revalidateModel());
            return false;
        }
        this.running = new Worker(text, panel.isCaseSensitive());
        this.task = rp.post((Runnable)this.running, 220);
        if (panel.time != -1L) {
            LOGGER.log(Level.FINE, "Worker posted after {0} ms.", System.currentTimeMillis() - panel.time);
        }
        return true;
    }

    @Override
    public void closeDialog() {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setVisible(false);
        this.cleanup();
    }

    @Override
    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    private Dialog createDialog(GoToPanel panel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToTypeAction.class, (String)"CTL_OK"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.okButton.getText());
        this.okButton.setEnabled(false);
        panel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToTypeAction.class, (String)"AN_GoToType"));
        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToTypeAction.class, (String)"AD_GoToType"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, this.title, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(panel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        int width = UiOptions.GoToTypeDialog.getWidth();
        int height = UiOptions.GoToTypeDialog.getHeight();
        if (width != -1 && height != -1) {
            d.setPreferredSize(new Dimension(width, height));
        }
        Rectangle r = org.openide.util.Utilities.getUsableScreenBounds();
        int maxW = r.width * 9 / 10;
        int maxH = r.height * 9 / 10;
        Dimension dim = d.getPreferredSize();
        dim.width = Math.min(dim.width, maxW);
        dim.height = Math.min(dim.height, maxH);
        d.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dim));
        this.initialDimension = dim;
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GoToTypeAction.this.cleanup();
            }
        });
        return d;
    }

    private void cleanup() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.dialog != null) {
            int currentWidth = this.dialog.getWidth();
            int currentHeight = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != currentWidth || this.initialDimension.height != currentHeight)) {
                UiOptions.GoToTypeDialog.setHeight(currentHeight);
                UiOptions.GoToTypeDialog.setWidth(currentWidth);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            if (this.running != null) {
                this.running.cancel();
                this.task.cancel();
                this.running = null;
            }
            rp.submit(new Runnable(){

                @Override
                public void run() {
                    assert (rp.isRequestProcessorThread());
                    if (GoToTypeAction.this.typeProviders != null) {
                        for (TypeProvider provider : GoToTypeAction.this.typeProviders) {
                            provider.cleanup();
                        }
                        GoToTypeAction.this.typeProviders = null;
                    }
                }
            });
        }
    }

    private void enableOK(boolean enable) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enable);
        }
    }

    final void waitSearchFinished() {
        assert (SwingUtilities.isEventDispatchThread());
        this.task.waitFinished();
    }

    private Profile initializeProfiling() {
        boolean assertsOn = false;
        if (!$assertionsDisabled) {
            assertsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertsOn) {
            return null;
        }
        Sampler profiler = Sampler.createSampler((String)"jumpto");
        if (profiler == null) {
            return null;
        }
        return new Profile(profiler).start();
    }

    private static final class FilterAdaptor
    implements Models.Filter<TypeDescriptor> {
        private final TypeBrowser.Filter filter;

        FilterAdaptor(@NonNull TypeBrowser.Filter filter) {
            Parameters.notNull((CharSequence)"filter", (Object)filter);
            this.filter = filter;
        }

        @Override
        public boolean accept(TypeDescriptor item) {
            return this.filter.accept(item);
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
        }

        @Override
        public void remmoveChangeListener(ChangeListener listener) {
        }
    }

    private class Profile
    implements Runnable {
        private final long time = System.currentTimeMillis();
        private volatile Sampler profiler;
        private volatile boolean profiling;

        public Profile(Sampler profiler) {
            this.profiler = profiler;
        }

        Profile start() {
            PROFILE_RP.post((Runnable)this, 3000);
            return this;
        }

        @Override
        public synchronized void run() {
            if (this.profiler != null) {
                this.profiling = true;
                this.profiler.start();
            }
        }

        private synchronized void stop() throws Exception {
            long delta = System.currentTimeMillis() - this.time;
            Sampler ss = this.profiler;
            this.profiler = null;
            if (!this.profiling) {
                return;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(out);
                ss.stopAndWriteTo(dos);
                dos.close();
                if (dos.size() > 0) {
                    Object[] params = new Object[]{out.toByteArray(), delta, "GoToType"};
                    Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Slowness detected", params);
                } else {
                    LOGGER.log(Level.WARNING, "no snapshot taken");
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToPanel panel;

        public DialogButtonListener(GoToPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GoToTypeAction.this.okButton) {
                this.panel.setSelectedTypes();
            }
        }
    }

    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private volatile TypeProvider current;
        private final String text;
        private final boolean caseSensitive;
        private final long createTime;

        public Worker(String text, boolean caseSensitive) {
            this.text = text;
            this.caseSensitive = caseSensitive;
            this.createTime = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "Worker for {0} - created after {1} ms.", new Object[]{text, System.currentTimeMillis() - GoToTypeAction.this.panel.time});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Future f = OpenProjects.getDefault().openProjects();
            if (!f.isDone()) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GoToTypeAction.this.panel.updateMessage(NbBundle.getMessage(GoToTypeAction.class, (String)"TXT_LoadingProjects"));
                        }
                    });
                    f.get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    try {
                        LOGGER.fine(ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GoToTypeAction.this.panel.updateMessage(NbBundle.getMessage(GoToTypeAction.class, (String)"TXT_Searching"));
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            int lastSize = -1;
            while (true) {
                int[] retry = new int[1];
                Profile profile = GoToTypeAction.this.initializeProfiling();
                try {
                    boolean resultChanged;
                    LOGGER.log(Level.FINE, "Worker for {0} - started {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                    List<? extends TypeDescriptor> types = this.getTypeNames(this.text, retry);
                    if (this.isCanceled) {
                        LOGGER.log(Level.FINE, "Worker for {0} exited after cancel {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                        return;
                    }
                    int newSize = types.size();
                    final boolean done = retry[0] <= 0;
                    boolean bl = resultChanged = lastSize != newSize;
                    if (resultChanged || done) {
                        ListModel fmodel;
                        lastSize = newSize;
                        if (resultChanged) {
                            ListModel model = Models.fromList(types, GoToTypeAction.this.currentSearch.resetFilter(), null);
                            if (GoToTypeAction.this.typeFilter != null) {
                                model = FilteredListModel.create(model, new FilterAdaptor(GoToTypeAction.this.typeFilter), NbBundle.getMessage(GoToTypeAction.class, (String)"LBL_Computing"));
                            }
                            fmodel = model;
                        } else {
                            fmodel = null;
                        }
                        if (this.isCanceled) {
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (done) {
                                    Pair<String, String> nameAndScope = Utils.splitNameAndScope(Worker.this.text);
                                    GoToTypeAction.this.currentSearch.searchCompleted(GoToTypeAction.this.nameKind, (String)nameAndScope.first(), (String)nameAndScope.second());
                                }
                                if (fmodel != null && !Worker.this.isCanceled) {
                                    GoToTypeAction.this.enableOK(GoToTypeAction.this.panel.setModel(fmodel));
                                }
                            }
                        });
                    }
                }
                finally {
                    if (profile != null) {
                        try {
                            profile.stop();
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.INFO, "Cannot stop profiling", ex);
                        }
                    }
                }
                if (retry[0] <= 0) break;
                try {
                    Thread.sleep(retry[0]);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            TypeProvider _provider;
            if (GoToTypeAction.this.panel.time != -1L) {
                LOGGER.log(Level.FINE, "Worker for text {0} canceled after {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
            }
            Worker worker = this;
            synchronized (worker) {
                this.isCanceled = true;
                _provider = this.current;
            }
            if (_provider != null) {
                _provider.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<? extends TypeDescriptor> getTypeNames(String text, int[] retry) {
            HashSet items = new HashSet();
            String[] message = new String[1];
            TypeProvider.Context context = TypeProviderAccessor.DEFAULT.createContext(null, text, GoToTypeAction.this.nameKind);
            assert (rp.isRequestProcessorThread());
            if (GoToTypeAction.this.typeProviders == null) {
                GoToTypeAction.this.typeProviders = GoToTypeAction.this.implicitTypeProviders != null ? GoToTypeAction.this.implicitTypeProviders : Lookup.getDefault().lookupAll(TypeProvider.class);
            }
            for (TypeProvider provider : GoToTypeAction.this.typeProviders) {
                if (this.isCanceled) {
                    return null;
                }
                this.current = provider;
                long start = System.currentTimeMillis();
                try {
                    LOGGER.log(Level.FINE, "Calling TypeProvider: {0}", provider);
                    TypeProvider.Result result = TypeProviderAccessor.DEFAULT.createResult(items, message, context);
                    provider.computeTypeNames(context, result);
                    retry[0] = this.mergeRetryTimeOut(retry[0], TypeProviderAccessor.DEFAULT.getRetry(result));
                }
                finally {
                    this.current = null;
                }
                long delta = System.currentTimeMillis() - start;
                LOGGER.log(Level.FINE, "Provider ''{0}'' took {1} ms.", new Object[]{provider.getDisplayName(), delta});
            }
            if (!this.isCanceled) {
                ArrayList result = new ArrayList(items);
                Collections.sort(result, new TypeComparator(this.caseSensitive));
                GoToTypeAction.this.panel.setWarning(message[0]);
                return result;
            }
            return null;
        }

        private int mergeRetryTimeOut(int t1, int t2) {
            if (t1 == 0) {
                return t2;
            }
            if (t2 == 0) {
                return t1;
            }
            return Math.min(t1, t2);
        }
    }

    private static final class TypeDescriptorConvertor
    implements ItemRenderer.Convertor<TypeDescriptor> {
        private TypeDescriptorConvertor() {
        }

        @Override
        public String getName(@NonNull TypeDescriptor item) {
            return item.getTypeName();
        }

        @Override
        public String getHighlightText(@NonNull TypeDescriptor item) {
            return TypeProviderAccessor.DEFAULT.getHighlightText(item);
        }

        @Override
        public String getOwnerName(@NonNull TypeDescriptor item) {
            return item.getContextName();
        }

        @Override
        public String getProjectName(@NonNull TypeDescriptor item) {
            return item.getProjectName();
        }

        @Override
        public String getFilePath(@NonNull TypeDescriptor item) {
            return item.getFileDisplayPath();
        }

        @Override
        public Icon getItemIcon(@NonNull TypeDescriptor item) {
            return item.getIcon();
        }

        @Override
        public Icon getProjectIcon(@NonNull TypeDescriptor item) {
            return item.getProjectIcon();
        }

        @Override
        public boolean isFromCurrentProject(@NonNull TypeDescriptor item) {
            return false;
        }
    }
}

