/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.fxml;

import java.awt.Toolkit;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class FXMLHyperlinkProvider
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        return FXMLHyperlinkProvider.getIdentifierSpan(doc, offset);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        EditCookie ec = this.getEditorCookie(doc, offset);
        if (ec != null) {
            ec.edit();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return null;
    }

    private EditCookie getEditorCookie(Document doc, int offset) {
        String name;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(Language.find((String)"text/x-fxml+xml"));
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        FileObject fo = FXMLHyperlinkProvider.getFileObject(doc);
        FileObject props = FXMLHyperlinkProvider.findFile(fo, name = t.text().toString());
        if (props != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)props);
                return (EditCookie)dobj.getLookup().lookup(EditCookie.class);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    @CheckForNull
    private static FileObject findFile(FileObject docFO, String path) {
        String cssPath;
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)docFO);
        if (prj == null) {
            return null;
        }
        Sources srcs = ProjectUtils.getSources((Project)prj);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        if (grps.length == 0) {
            return null;
        }
        FileObject rootFolder = grps[0].getRootFolder();
        ClassPath cp = ClassPath.getClassPath((FileObject)rootFolder, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        String rootPath = FileUtil.normalizePath((String)rootFolder.getPath());
        String docPath = FileUtil.normalizePath((String)docFO.getParent().getPath());
        if (!docPath.startsWith(rootPath)) {
            return null;
        }
        String javaPath = path.trim().replace("\"", "").replace('.', '/') + ".java";
        FileObject fo = cp.findResource(javaPath);
        if (fo == null) {
            javaPath = docPath.substring(rootPath.length()) + '/' + javaPath;
            fo = cp.findResource(javaPath);
        }
        if (fo == null && (fo = cp.findResource(cssPath = path.trim().replace("\"", "").replace("@", ""))) == null) {
            cssPath = docPath.substring(rootPath.length()) + '/' + cssPath;
            fo = cp.findResource(cssPath);
        }
        return fo;
    }

    public static int[] getIdentifierSpan(Document doc, int offset) {
        FileObject fo = FXMLHyperlinkProvider.getFileObject(doc);
        if (fo == null) {
            return null;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        if (prj == null) {
            return null;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(Language.find((String)"text/x-fxml+xml"));
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        if (FXMLHyperlinkProvider.findFile(fo, t.text().toString()) != null) {
            return new int[]{ts.offset() + 1, ts.offset() + t.length() - 1};
        }
        return null;
    }

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }
}

