/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.LangOptions;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.VersionTuple;
import org.clang.driver.AnalyzeJobAction;
import org.clang.driver.AssembleJobAction;
import org.clang.driver.BackendJobAction;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.CompileJobAction;
import org.clang.driver.Driver;
import org.clang.driver.DriverGlobals;
import org.clang.driver.FallbackCommand;
import org.clang.driver.JobAction;
import org.clang.driver.MigrateJobAction;
import org.clang.driver.PrecompileJobAction;
import org.clang.driver.PreprocessJobAction;
import org.clang.driver.SanitizerArgs;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.VerifyPCHJobAction;
import org.clang.driver.impl.EHFlags;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.arm;
import org.clang.driver.tools.impl.mips;
import org.clang.driver.tools.impl.visualstudio;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptGlobals;
import org.llvm.option.OptSpecifier;
import org.llvm.option.Option;
import org.llvm.option.arg_iterator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class Clang
extends Tool
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<visualstudio.Compile> CLFallback = new std_ptr.unique_ptr();

    public static char.ptr getBaseInputName(ArgList Args, SmallVector<InputInfo> Inputs) {
        return Args.MakeArgString(path.filename((StringRef)new StringRef(((InputInfo)Inputs.$at(0)).getBaseInput())));
    }

    public static char.ptr getBaseInputStem(ArgList Args, SmallVector<InputInfo> Inputs) {
        char.ptr Str = Native.$tryClone((char.ptr)Clang.getBaseInputName(Args, Inputs));
        char.ptr End = Native.$tryClone((char.ptr)std.strrchr((char.ptr)Str, (byte)NativePointer.$((char)'.')));
        if (End != null) {
            return Args.MakeArgString(new std.string((char.iterator)Str, (char.iterator)End));
        }
        return Str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char.ptr getDependencyFileName(ArgList Args, SmallVector<InputInfo> Inputs) {
        std.string Res = null;
        try {
            Res = new std.string();
            Arg OutputOpt = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_o.getValue()));
            if (OutputOpt != null) {
                std.string Str = null;
                try {
                    Str = new std.string(OutputOpt.getValue());
                    Res.$assign(Str.substr(0, Str.rfind(NativePointer.$((char)'.'))));
                }
                finally {
                    if (Str != null) {
                        Str.$destroy();
                    }
                }
            } else {
                Res.$assign(Clang.getBaseInputStem(Args, Inputs));
            }
            char.ptr ptr2 = Args.MakeArgString(std.$plus_str_T((std.string)Res, (char.iterator)NativePointer.$((String)".d")));
            return ptr2;
        }
        finally {
            if (Res != null) {
                Res.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AddPreprocessingOptions(Compilation C, JobAction JA, Driver D, ArgList Args, ArgStringList CmdArgs, InputInfo Output, SmallVector<InputInfo> Inputs) {
        StringRef sysroot;
        SmallString P;
        ToolsStatics.CheckPreprocessingOptions(D, Args);
        Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_C.getValue()));
        Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_CC.getValue()));
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_M.getValue()), new OptSpecifier((long)options.ID.OPT_MM.getValue()));
        if (A != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_MD.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_MMD.getValue()))) != null) {
            char.ptr DepFile;
            Arg MF = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_MF.getValue()));
            if (MF != null) {
                DepFile = Native.$tryClone((char.ptr)MF.getValue());
                C.addFailureResultFile(DepFile, JA);
            } else if (Output.getType() == types.ID.TY_Dependencies) {
                DepFile = Native.$tryClone((char.ptr)Output.getFilename());
            } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_M.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_MM.getValue()))) {
                DepFile = NativePointer.$((String)"-");
            } else {
                DepFile = Native.$tryClone((char.ptr)Clang.getDependencyFileName(Args, Inputs));
                C.addFailureResultFile(DepFile, JA);
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-dependency-file"));
            CmdArgs.push_back((Object)DepFile);
            if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_MT.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_MQ.getValue()))) {
                SmallString Quoted = null;
                try {
                    char.ptr DepTarget;
                    Arg OutputOpt = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_o.getValue()));
                    if (OutputOpt != null && Output.getType() != types.ID.TY_Dependencies) {
                        DepTarget = Native.$tryClone((char.ptr)OutputOpt.getValue());
                    } else {
                        P = null;
                        try {
                            P = new SmallString(new StringRef(((InputInfo)Inputs.$at(0)).getBaseInput()), 128);
                            path.replace_extension((SmallString)P, (Twine)new Twine(NativePointer.$((String)"o")));
                            DepTarget = Native.$tryClone((char.ptr)Args.MakeArgString(path.filename((StringRef)P.$StringRef())));
                        }
                        finally {
                            if (P != null) {
                                P.$destroy();
                            }
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-MT"));
                    Quoted = new SmallString(128);
                    ToolsStatics.QuoteTarget(new StringRef(DepTarget), (SmallVectorImplChar)Quoted);
                    CmdArgs.push_back((Object)Args.MakeArgString(Quoted.$StringRef()));
                }
                finally {
                    if (Quoted != null) {
                        Quoted.$destroy();
                    }
                }
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_M.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_MD.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-sys-header-deps"));
            }
            if (llvm.isa(PrecompileJobAction.class, (Object)JA)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-module-file-deps"));
            }
        }
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_MG.getValue()))) {
            if (A == null || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_MD.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_MMD.getValue()))) {
                D.Diag(334L).$destroy();
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-MG"));
        }
        Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_MP.getValue()));
        arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_MT.getValue()), new OptSpecifier((long)options.ID.OPT_MQ.getValue()));
        arg_iterator ie = Args.filtered_end();
        while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it), (arg_iterator)new arg_iterator(ie))) {
            Arg _A = it.$star();
            _A.claim();
            if (_A.getOption().matches(new OptSpecifier((long)options.ID.OPT_MQ.getValue()))) {
                SmallString Quoted = null;
                try {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-MT"));
                    Quoted = new SmallString(128);
                    ToolsStatics.QuoteTarget(new StringRef(_A.getValue()), (SmallVectorImplChar)Quoted);
                    CmdArgs.push_back((Object)Args.MakeArgString(Quoted.$StringRef()));
                }
                finally {
                    if (Quoted != null) {
                        Quoted.$destroy();
                    }
                }
            } else {
                _A.render(Args, (SmallVector)CmdArgs);
            }
            it.$preInc();
        }
        boolean RenderedImplicitInclude = false;
        arg_iterator it2 = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_clang_i_Group.getValue()));
        arg_iterator ie2 = Args.filtered_end();
        while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it2), (arg_iterator)new arg_iterator(ie2))) {
            block51: {
                Arg _A;
                block50: {
                    _A = it2.$ArgPtr();
                    if (_A.getOption().matches(new OptSpecifier((long)options.ID.OPT_include.getValue()))) {
                        P = null;
                        try {
                            boolean IsFirstImplicitInclude = !RenderedImplicitInclude;
                            RenderedImplicitInclude = true;
                            boolean UsePCH = D.CCCUsePCH;
                            boolean FoundPTH = false;
                            boolean FoundPCH = false;
                            P = new SmallString(new StringRef(_A.getValue()), 128);
                            P.$addassign((CharSequence)".dummy");
                            if (UsePCH) {
                                path.replace_extension((SmallString)P, (Twine)new Twine(NativePointer.$((String)"pch")));
                                if (fs.exists((Twine)new Twine(P.str()))) {
                                    FoundPCH = true;
                                }
                            }
                            if (!FoundPCH) {
                                path.replace_extension((SmallString)P, (Twine)new Twine(NativePointer.$((String)"pth")));
                                if (fs.exists((Twine)new Twine(P.str()))) {
                                    FoundPTH = true;
                                }
                            }
                            if (!FoundPCH && !FoundPTH) {
                                path.replace_extension((SmallString)P, (Twine)new Twine(NativePointer.$((String)"gch")));
                                if (fs.exists((Twine)new Twine(P.str()))) {
                                    FoundPCH = UsePCH;
                                    boolean bl = FoundPTH = !UsePCH;
                                }
                            }
                            if (!FoundPCH && !FoundPTH) break block50;
                            if (IsFirstImplicitInclude) {
                                _A.claim();
                                if (UsePCH) {
                                    CmdArgs.push_back((Object)NativePointer.$((String)"-include-pch"));
                                } else {
                                    CmdArgs.push_back((Object)NativePointer.$((String)"-include-pth"));
                                }
                                CmdArgs.push_back((Object)Args.MakeArgString(P.str()));
                                break block51;
                            }
                            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(376L), (StringRef)P.str()), (StringRef)new StringRef(_A.getAsString(Args))).$destroy();
                        }
                        finally {
                            if (P != null) {
                                P.$destroy();
                            }
                        }
                    }
                }
                _A.claim();
                _A.render(Args, (SmallVector)CmdArgs);
            }
            it2.$preInc();
        }
        Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_D.getValue()), new OptSpecifier((long)options.ID.OPT_U.getValue()));
        Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_I_Group.getValue()), new OptSpecifier((long)options.ID.OPT_F.getValue()), new OptSpecifier((long)options.ID.OPT_index_header_map.getValue()));
        Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Wp_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xpreprocessor.getValue()));
        Arg _A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_I_.getValue()));
        if (_A != null) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(305L), (StringRef)new StringRef(_A.getAsString(Args))).$destroy();
        }
        if (llvm.$noteq_StringRef((StringRef)new StringRef(sysroot = C.getSysRoot()), (StringRef)StringRef.EMPTY) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_isysroot.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-isysroot"));
            CmdArgs.push_back((Object)C.getArgs().MakeArgString(new StringRef(sysroot)));
        }
        ToolsStatics.addDirectoryList(Args, CmdArgs, NativePointer.$((String)"-I"), NativePointer.$((String)"CPATH"));
        ToolsStatics.addDirectoryList(Args, CmdArgs, NativePointer.$((String)"-c-isystem"), NativePointer.$((String)"C_INCLUDE_PATH"));
        ToolsStatics.addDirectoryList(Args, CmdArgs, NativePointer.$((String)"-cxx-isystem"), NativePointer.$((String)"CPLUS_INCLUDE_PATH"));
        ToolsStatics.addDirectoryList(Args, CmdArgs, NativePointer.$((String)"-objc-isystem"), NativePointer.$((String)"OBJC_INCLUDE_PATH"));
        ToolsStatics.addDirectoryList(Args, CmdArgs, NativePointer.$((String)"-objcxx-isystem"), NativePointer.$((String)"OBJCPLUS_INCLUDE_PATH"));
        if (types.isCXX(((InputInfo)Inputs.$at(0)).getType())) {
            this.getToolChain().AddClangCXXStdlibIncludeArgs(Args, CmdArgs);
        }
        this.getToolChain().AddClangSystemIncludeArgs(Args, CmdArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AddAArch64TargetArgs(ArgList Args, ArgStringList CmdArgs) {
        Triple Triple2 = null;
        try {
            std.string TripleStr = this.getToolChain().ComputeEffectiveClangTriple(Args);
            Triple2 = new Triple(new Twine(TripleStr));
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mred_zone.getValue()), new OptSpecifier((long)options.ID.OPT_mno_red_zone.getValue()), true) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-disable-red-zone"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mimplicit_float.getValue()), new OptSpecifier((long)options.ID.OPT_mno_implicit_float.getValue()), true)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-no-implicit-float"));
            }
            char.ptr ABIName = null;
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mabi_EQ.getValue()));
            ABIName = A != null ? Native.$tryClone((char.ptr)A.getValue()) : (Triple2.isOSDarwin() ? NativePointer.$((String)"darwinpcs") : NativePointer.$((String)"aapcs"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-target-abi"));
            CmdArgs.push_back((Object)ABIName);
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mno_unaligned_access.getValue()), new OptSpecifier((long)options.ID.OPT_munaligned_access.getValue()));
            if (A != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mno_unaligned_access.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-aarch64-strict-align"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-aarch64-no-strict-align"));
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mfix_cortex_a53_835769.getValue()), new OptSpecifier((long)options.ID.OPT_mno_fix_cortex_a53_835769.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mfix_cortex_a53_835769.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-aarch64-fix-cortex-a53-835769=1"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-aarch64-fix-cortex-a53-835769=0"));
                }
            } else if (Triple2.getEnvironment() == Triple.EnvironmentType.Android) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-aarch64-fix-cortex-a53-835769=1"));
            }
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mglobal_merge.getValue()), new OptSpecifier((long)options.ID.OPT_mno_global_merge.getValue()));
            if (A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mno_global_merge.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mno-global-merge"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ffixed_x18.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-aarch64-reserve-x18"));
            }
        }
        finally {
            if (Triple2 != null) {
                Triple2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AddARMTargetArgs(ArgList Args, ArgStringList CmdArgs, boolean KernelOrKext) {
        Triple Triple2 = null;
        try {
            Arg A;
            Driver D = this.getToolChain().getDriver();
            std.string TripleStr = this.getToolChain().ComputeEffectiveClangTriple(Args);
            Triple2 = new Triple(new Twine(TripleStr));
            std.string CPUName = arm.getARMTargetCPU(Args, Triple2).$basic_string();
            char.ptr ABIName = null;
            Arg A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mabi_EQ.getValue()));
            if (A2 != null) {
                ABIName = Native.$tryClone((char.ptr)A2.getValue());
            } else if (Triple2.isOSBinFormatMachO()) {
                ABIName = Triple2.getEnvironment() == Triple.EnvironmentType.EABI || Triple2.getOS() == Triple.OSType.UnknownOS || new StringRef(CPUName).startswith((CharSequence)"cortex-m") ? NativePointer.$((String)"aapcs") : NativePointer.$((String)"apcs-gnu");
            } else if (Triple2.isOSWindows()) {
                ABIName = NativePointer.$((String)"aapcs");
            } else {
                switch (Triple2.getEnvironment()) {
                    case Android: 
                    case GNUEABI: 
                    case GNUEABIHF: {
                        ABIName = NativePointer.$((String)"aapcs-linux");
                        break;
                    }
                    case EABIHF: 
                    case EABI: {
                        ABIName = NativePointer.$((String)"aapcs");
                        break;
                    }
                    default: {
                        ABIName = Triple2.getOS() == Triple.OSType.NetBSD ? NativePointer.$((String)"apcs-gnu") : NativePointer.$((String)"aapcs");
                    }
                }
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-target-abi"));
            CmdArgs.push_back((Object)ABIName);
            StringRef FloatABI = arm.getARMFloatABI(D, Args, Triple2);
            if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft")))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-msoft-float"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-mfloat-abi"));
                CmdArgs.push_back((Object)NativePointer.$((String)"soft"));
            } else if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"softfp")))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mfloat-abi"));
                CmdArgs.push_back((Object)NativePointer.$((String)"soft"));
            } else {
                assert (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef((CharSequence)"hard"))) : "Invalid float abi!";
                CmdArgs.push_back((Object)NativePointer.$((String)"-mfloat-abi"));
                CmdArgs.push_back((Object)NativePointer.$((String)"hard"));
            }
            if (KernelOrKext) {
                if (!Triple2.isiOS() || Triple2.isOSVersionLT(6L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-arm-long-calls"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-arm-strict-align"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-arm-use-movt=0"));
            }
            if (!KernelOrKext && (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mno_unaligned_access.getValue()), new OptSpecifier((long)options.ID.OPT_munaligned_access.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mno_unaligned_access.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-arm-strict-align"));
                } else {
                    if (Triple2.getSubArch() == Triple.SubArchType.ARMSubArch_v6m) {
                        ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(31L), (char.ptr)NativePointer.$((String)"v6m")).$destroy();
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-arm-no-strict-align"));
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mglobal_merge.getValue()), new OptSpecifier((long)options.ID.OPT_mno_global_merge.getValue()))) != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mno_global_merge.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mno-global-merge"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mimplicit_float.getValue()), new OptSpecifier((long)options.ID.OPT_mno_implicit_float.getValue()), true)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-no-implicit-float"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ffixed_r9.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-arm-reserve-r9"));
            }
        }
        finally {
            if (Triple2 != null) {
                Triple2.$destroy();
            }
        }
    }

    private void AddARM64TargetArgs(ArgList Args, ArgStringList CmdArgs) {
    }

    private void AddMIPSTargetArgs(ArgList Args, ArgStringList CmdArgs) {
        Driver D = this.getToolChain().getDriver();
        StringRef CPUName = new StringRef();
        StringRef ABIName = new StringRef();
        Triple Triple2 = this.getToolChain().getTriple();
        mips.getMipsCPUAndABI(Args, Triple2, CPUName, ABIName);
        CmdArgs.push_back((Object)NativePointer.$((String)"-target-abi"));
        CmdArgs.push_back((Object)ABIName.data());
        StringRef FloatABI = ToolsStatics.getMipsFloatABI(D, Args);
        if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft")))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-msoft-float"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-mfloat-abi"));
            CmdArgs.push_back((Object)NativePointer.$((String)"soft"));
        } else {
            assert (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef((CharSequence)"hard"))) : "Invalid float abi!";
            CmdArgs.push_back((Object)NativePointer.$((String)"-mfloat-abi"));
            CmdArgs.push_back((Object)NativePointer.$((String)"hard"));
        }
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mxgot.getValue()), new OptSpecifier((long)options.ID.OPT_mno_xgot.getValue()));
        if (A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mxgot.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-mxgot"));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mldc1_sdc1.getValue()), new OptSpecifier((long)options.ID.OPT_mno_ldc1_sdc1.getValue()))) != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mno_ldc1_sdc1.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-mno-ldc1-sdc1"));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcheck_zero_division.getValue()), new OptSpecifier((long)options.ID.OPT_mno_check_zero_division.getValue()))) != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mno_check_zero_division.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-mno-check-zero-division"));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_G.getValue()))) != null) {
            StringRef v = new StringRef(A.getValue());
            CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-mips-ssection-threshold="), (StringRef)v)));
            A.claim();
        }
    }

    private void AddPPCTargetArgs(ArgList Args, ArgStringList CmdArgs) {
        char.ptr ABIName = null;
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mabi_EQ.getValue()));
        if (A != null) {
            ABIName = Native.$tryClone((char.ptr)A.getValue());
        } else if (this.getToolChain().getTriple().isOSLinux()) {
            switch (this.getToolChain().getArch()) {
                case ppc64: {
                    ABIName = NativePointer.$((String)"elfv1");
                    break;
                }
                case ppc64le: {
                    ABIName = NativePointer.$((String)"elfv2");
                    break;
                }
            }
        }
        if (ABIName != null) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-target-abi"));
            CmdArgs.push_back((Object)ABIName);
        }
    }

    private void AddR600TargetArgs(ArgList Args, ArgStringList CmdArgs) {
    }

    private void AddSparcTargetArgs(ArgList Args, ArgStringList CmdArgs) {
        Driver D = this.getToolChain().getDriver();
        StringRef FloatABI = new StringRef();
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()), new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()))) {
                FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
            } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()))) {
                FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
            }
        }
        if (FloatABI.empty()) {
            FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(367L), (char.ptr)NativePointer.$((String)"soft")).$destroy();
        }
        if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft")))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-msoft-float"));
        } else {
            assert (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef((CharSequence)"hard"))) : "Invalid float abi!";
            CmdArgs.push_back((Object)NativePointer.$((String)"-mhard-float"));
        }
    }

    private void AddSystemZTargetArgs(ArgList Args, ArgStringList CmdArgs) {
    }

    private void AddX86TargetArgs(ArgList Args, ArgStringList CmdArgs) {
        if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mred_zone.getValue()), new OptSpecifier((long)options.ID.OPT_mno_red_zone.getValue()), true) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-disable-red-zone"));
        }
        boolean NoImplicitFloat = Args.hasArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue()));
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()), new OptSpecifier((long)options.ID.OPT_mno_soft_float.getValue()), new OptSpecifier((long)options.ID.OPT_mimplicit_float.getValue()), new OptSpecifier((long)options.ID.OPT_mno_implicit_float.getValue()));
        if (A != null) {
            Option O = A.getOption();
            boolean bl = NoImplicitFloat = O.matches(new OptSpecifier((long)options.ID.OPT_mno_implicit_float.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()));
        }
        if (NoImplicitFloat) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-no-implicit-float"));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_masm_EQ.getValue()))) != null) {
            StringRef Value = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"intel"))) || llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"att")))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-x86-asm-syntax="), (StringRef)Value)));
            } else {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getToolChain().getDriver().Diag(356L), (StringRef)A.getOption().getName()), (StringRef)new StringRef(Value)).$destroy();
            }
        }
    }

    private void AddHexagonTargetArgs(ArgList Args, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)NativePointer.$((String)"-fno-signed-char"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-mqdsp6-compat"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-Wreturn-type"));
        std.string SmallDataThreshold = ToolsStatics.GetHexagonSmallDataThresholdValue(Args);
        if (!SmallDataThreshold.empty()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
            CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-hexagon-small-data-threshold="), (std.string)SmallDataThreshold)));
        }
        if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fno_short_enums.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fshort-enums"));
        }
        if (Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mieee_rnd_near.getValue())) != null) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-enable-hexagon-ieee-rnd-near"));
        }
        CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-machine-sink-split=0"));
    }

    private ObjCRuntime AddObjCRuntimeArgs(ArgList args, ArgStringList cmdArgs, RewriteKind rewriteKind) {
        Arg runtimeArg = args.getLastArg(new OptSpecifier((long)options.ID.OPT_fnext_runtime.getValue()), new OptSpecifier((long)options.ID.OPT_fgnu_runtime.getValue()), new OptSpecifier((long)options.ID.OPT_fobjc_runtime_EQ.getValue()));
        if (runtimeArg != null && runtimeArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fobjc_runtime_EQ.getValue()))) {
            ObjCRuntime runtime = new ObjCRuntime();
            StringRef value = new StringRef(runtimeArg.getValue());
            if (runtime.tryParse(new StringRef(value))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getToolChain().getDriver().Diag(351L), (StringRef)new StringRef(value)).$destroy();
            }
            runtimeArg.render(args, (SmallVector)cmdArgs);
            return runtime;
        }
        long objcABIVersion = 1L;
        Arg abiArg = args.getLastArg(new OptSpecifier((long)options.ID.OPT_fobjc_abi_version_EQ.getValue()));
        if (abiArg != null) {
            StringRef value = new StringRef(abiArg.getValue());
            if (llvm.$eq_StringRef((StringRef)new StringRef(value), (StringRef)new StringRef(NativePointer.$((String)"1")))) {
                objcABIVersion = 1L;
            } else if (llvm.$eq_StringRef((StringRef)new StringRef(value), (StringRef)new StringRef(NativePointer.$((String)"2")))) {
                objcABIVersion = 2L;
            } else if (llvm.$eq_StringRef((StringRef)new StringRef(value), (StringRef)new StringRef(NativePointer.$((String)"3")))) {
                objcABIVersion = 3L;
            } else {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getToolChain().getDriver().Diag(309L), (StringRef)new StringRef(value)).$destroy();
            }
        } else {
            boolean nonFragileABIIsDefault;
            boolean bl = nonFragileABIIsDefault = rewriteKind == RewriteKind.RK_NonFragile || rewriteKind == RewriteKind.RK_None && this.getToolChain().IsObjCNonFragileABIDefault();
            if (args.hasFlag(new OptSpecifier((long)options.ID.OPT_fobjc_nonfragile_abi.getValue()), new OptSpecifier((long)options.ID.OPT_fno_objc_nonfragile_abi.getValue()), nonFragileABIIsDefault)) {
                long nonFragileABIVersion = 2L;
                Arg _abiArg = args.getLastArg(new OptSpecifier((long)options.ID.OPT_fobjc_nonfragile_abi_version_EQ.getValue()));
                if (_abiArg != null) {
                    StringRef value = new StringRef(_abiArg.getValue());
                    if (llvm.$eq_StringRef((StringRef)new StringRef(value), (StringRef)new StringRef(NativePointer.$((String)"1")))) {
                        nonFragileABIVersion = 1L;
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(value), (StringRef)new StringRef(NativePointer.$((String)"2")))) {
                        nonFragileABIVersion = 2L;
                    } else {
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getToolChain().getDriver().Diag(309L), (StringRef)new StringRef(value)).$destroy();
                    }
                }
                objcABIVersion = 1L + nonFragileABIVersion;
            } else {
                objcABIVersion = 1L;
            }
        }
        boolean isNonFragile = objcABIVersion != 1L;
        ObjCRuntime runtime = new ObjCRuntime();
        if (runtimeArg == null) {
            switch (rewriteKind) {
                case RK_None: {
                    runtime.$assign(this.getToolChain().getDefaultObjCRuntime(isNonFragile));
                    break;
                }
                case RK_Fragile: {
                    runtime.$assign(new ObjCRuntime(ObjCRuntime.Kind.FragileMacOSX, new VersionTuple()));
                    break;
                }
                case RK_NonFragile: {
                    runtime.$assign(new ObjCRuntime(ObjCRuntime.Kind.MacOSX, new VersionTuple()));
                }
            }
        } else if (runtimeArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fnext_runtime.getValue()))) {
            if (this.getToolChain().getTriple().isOSDarwin()) {
                runtime.$assign(this.getToolChain().getDefaultObjCRuntime(isNonFragile));
            } else {
                runtime.$assign(new ObjCRuntime(ObjCRuntime.Kind.MacOSX, new VersionTuple()));
            }
        } else {
            assert (runtimeArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fgnu_runtime.getValue())));
            if (isNonFragile) {
                runtime.$assign(new ObjCRuntime(ObjCRuntime.Kind.GNUstep, new VersionTuple(1L, 6L)));
            } else {
                runtime.$assign(new ObjCRuntime(ObjCRuntime.Kind.GCC, new VersionTuple()));
            }
        }
        cmdArgs.push_back((Object)args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-fobjc-runtime="), (std.string)runtime.getAsString())));
        return runtime;
    }

    private void AddClangCLArgs(ArgList Args, ArgStringList CmdArgs) {
        Arg A;
        Arg A2;
        long RTOptionID = options.ID.OPT__SLASH_MT.getValue();
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_LDd.getValue()))) {
            RTOptionID = options.ID.OPT__SLASH_MTd.getValue();
        }
        if ((A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_M_Group.getValue()))) != null) {
            RTOptionID = A2.getOption().getID();
        }
        switch (options.ID.valueOf(RTOptionID)) {
            case OPT__SLASH_MD: {
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_LDd.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-D_DEBUG"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_MT"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_DLL"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--dependent-lib=msvcrt"));
                break;
            }
            case OPT__SLASH_MDd: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_DEBUG"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_MT"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_DLL"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--dependent-lib=msvcrtd"));
                break;
            }
            case OPT__SLASH_MT: {
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_LDd.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-D_DEBUG"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_MT"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--dependent-lib=libcmt"));
                break;
            }
            case OPT__SLASH_MTd: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_DEBUG"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-D_MT"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--dependent-lib=libcmtd"));
                break;
            }
            default: {
                throw new llvm_unreachable((CharSequence)"Unexpected option ID.");
            }
        }
        CmdArgs.push_back((Object)NativePointer.$((String)"--dependent-lib=oldnames"));
        if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_E.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_EP.getValue())) && (A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_show_includes.getValue()))) != null) {
            A2.render(Args, (SmallVector)CmdArgs);
        }
        if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT__SLASH_GR_.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_GR.getValue()), false)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fno-rtti-data"));
        }
        Driver D = this.getToolChain().getDriver();
        EHFlags EH = ToolsStatics.parseClangCLEHFlags(D, Args);
        if (EH.Synch || EH.Asynch) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fexceptions"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-fcxx-exceptions"));
        }
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_EP.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-E"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-P"));
        }
        Arg MostGeneralArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_vmg.getValue()));
        Arg BestCaseArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_vmb.getValue()));
        if (MostGeneralArg != null && BestCaseArg != null) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(MostGeneralArg.getAsString(Args))), (StringRef)new StringRef(BestCaseArg.getAsString(Args))).$destroy();
        }
        if (MostGeneralArg != null) {
            Arg SecondConflict;
            Arg SingleArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_vms.getValue()));
            Arg MultipleArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_vmm.getValue()));
            Arg VirtualArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_vmv.getValue()));
            Arg FirstConflict = SingleArg != null ? SingleArg : MultipleArg;
            Arg arg = SecondConflict = VirtualArg != null ? VirtualArg : MultipleArg;
            if (FirstConflict != null && SecondConflict != null && FirstConflict != SecondConflict) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(FirstConflict.getAsString(Args))), (StringRef)new StringRef(SecondConflict.getAsString(Args))).$destroy();
            }
            if (SingleArg != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fms-memptr-rep=single"));
            } else if (MultipleArg != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fms-memptr-rep=multiple"));
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fms-memptr-rep=virtual"));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_vtordisp_mode_EQ.getValue()))) != null) {
            A.render(Args, (SmallVector)CmdArgs);
        }
        if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fdiagnostics_format_EQ.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fdiagnostics-format"));
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_fallback.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"msvc-fallback"));
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"msvc"));
            }
        }
    }

    private visualstudio.Compile getCLFallback() {
        if (!this.CLFallback.$boolean()) {
            this.CLFallback.reset((Object)new visualstudio.Compile(this.getToolChain()));
        }
        return (visualstudio.Compile)this.CLFallback.get();
    }

    public Clang(ToolChain TC) {
        super(NativePointer.$((String)"clang"), NativePointer.$((String)"clang frontend"), TC, Tool.ResponseFileSupport.RF_Full);
    }

    @Override
    public boolean hasGoodDiagnostics() {
        return true;
    }

    @Override
    public boolean hasIntegratedAssembler() {
        return true;
    }

    @Override
    public boolean hasIntegratedCPP() {
        return true;
    }

    @Override
    public boolean canEmitIR() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
        ArgStringList CmdArgs = null;
        Triple TT = null;
        Triple Triple2 = null;
        Triple ETriple = null;
        SmallString ModuleCachePath = null;
        try {
            Arg A;
            Arg A2;
            boolean EnableSLPVec;
            boolean EnableVec;
            Arg execCharset;
            Object value;
            Arg inputCharset;
            std.string MaxTypeAlignStr;
            Arg A3;
            Arg GCArg;
            boolean ARC;
            ObjCRuntime objcRuntime;
            boolean AllowedInCXX;
            Arg Asm;
            Arg WriteStrings;
            Arg A4;
            Arg Unsupported;
            Arg A5;
            std.string ETripleStr;
            std.string CPU;
            boolean TBAAOnByDefault;
            boolean OFastEnabled;
            Arg A6;
            boolean PIC;
            boolean KernelOrKext = Args.hasArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue()), new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue()));
            Driver D = this.getToolChain().getDriver();
            CmdArgs = new ArgStringList();
            boolean IsWindowsGNU = this.getToolChain().getTriple().isWindowsGNUEnvironment();
            boolean IsWindowsCygnus = this.getToolChain().getTriple().isWindowsCygwinEnvironment();
            boolean IsWindowsMSVC = this.getToolChain().getTriple().isWindowsMSVCEnvironment();
            assert (Inputs.size() == 1) : "Unable to handle multiple inputs.";
            CmdArgs.push_back((Object)NativePointer.$((String)"-cc1"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-triple"));
            std.string TripleStr = this.getToolChain().ComputeEffectiveClangTriple(Args);
            CmdArgs.push_back((Object)Args.MakeArgString(new std.string(TripleStr)));
            TT = new Triple(new Twine(TripleStr));
            if (TT.isOSWindows() && (TT.getArch() == Triple.ArchType.arm || TT.getArch() == Triple.ArchType.thumb)) {
                int Offset = TT.getArch() == Triple.ArchType.arm ? 4 : 6;
                uint.ref Version = NativePointer.create_uint$ref();
                TT.getArchName().substr(Offset).getAsInteger(10, Version);
                if (Version.$deref() < 7L) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(360L), (StringRef)TT.getArchName()), (StringRef)new StringRef(TripleStr)).$destroy();
                }
            }
            this.getToolChain().addClangWarningOptions(CmdArgs);
            RewriteKind rewriteKind = RewriteKind.RK_None;
            if (llvm.isa(AnalyzeJobAction.class, (Object)JA)) {
                assert (JA.getType() == types.ID.TY_Plist) : "Invalid output type.";
                CmdArgs.push_back((Object)NativePointer.$((String)"-analyze"));
            } else if (llvm.isa(MigrateJobAction.class, (Object)JA)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-migrate"));
            } else if (llvm.isa(PreprocessJobAction.class, (Object)JA)) {
                if (Output.getType() == types.ID.TY_Dependencies) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Eonly"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-E"));
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rewrite_objc.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-P"));
                    }
                }
            } else if (llvm.isa(AssembleJobAction.class, (Object)JA)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-emit-obj"));
                ToolsStatics.CollectArgsForIntegratedAssembler(C, Args, CmdArgs, D);
                Args.hasArg(new OptSpecifier((long)options.ID.OPT_force__cpusubtype__ALL.getValue()));
            } else if (llvm.isa(PrecompileJobAction.class, (Object)JA)) {
                boolean UsePCH = D.CCCUsePCH;
                if (JA.getType() == types.ID.TY_Nothing) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fsyntax-only"));
                } else if (UsePCH) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-emit-pch"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-emit-pth"));
                }
            } else if (llvm.isa(VerifyPCHJobAction.class, (Object)JA)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-verify-pch"));
            } else {
                assert (llvm.isa(CompileJobAction.class, (Object)JA) || llvm.isa(BackendJobAction.class, (Object)JA)) : "Invalid action for clang tool.";
                if (JA.getType() == types.ID.TY_Nothing) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fsyntax-only"));
                } else if (JA.getType() == types.ID.TY_LLVM_IR || JA.getType() == types.ID.TY_LTO_IR) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-emit-llvm"));
                } else if (JA.getType() == types.ID.TY_LLVM_BC || JA.getType() == types.ID.TY_LTO_BC) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-emit-llvm-bc"));
                } else if (JA.getType() == types.ID.TY_PP_Asm) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-S"));
                } else if (JA.getType() == types.ID.TY_AST) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-emit-pch"));
                } else if (JA.getType() == types.ID.TY_ModuleFile) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-module-file-info"));
                } else if (JA.getType() == types.ID.TY_RewrittenObjC) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-rewrite-objc"));
                    rewriteKind = RewriteKind.RK_NonFragile;
                } else if (JA.getType() == types.ID.TY_RewrittenLegacyObjC) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-rewrite-objc"));
                    rewriteKind = RewriteKind.RK_Fragile;
                } else assert (JA.getType() == types.ID.TY_PP_Asm) : "Unexpected output type!";
            }
            if (!C.isForDiagnostics()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-disable-free"));
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-main-file-name"));
            CmdArgs.push_back((Object)Clang.getBaseInputName(Args, Inputs));
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-static-define"));
            }
            if (llvm.isa(AnalyzeJobAction.class, (Object)JA)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-store=region"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-opt-analyze-nested-blocks"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-eagerly-assume"));
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT__analyzer_no_default_checks.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=core"));
                    if (!IsWindowsMSVC) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=unix"));
                    }
                    if (this.getToolChain().getTriple().getVendor() == Triple.VendorType.Apple) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=osx"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=deadcode"));
                    if (types.isCXX(((InputInfo)Inputs.$at(0)).getType())) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=cplusplus"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=security.insecureAPI.UncheckedReturn"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=security.insecureAPI.getpw"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=security.insecureAPI.gets"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=security.insecureAPI.mktemp"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=security.insecureAPI.mkstemp"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-checker=security.insecureAPI.vfork"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-analyzer-output"));
                Arg A7 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__analyzer_output.getValue()));
                if (A7 != null) {
                    CmdArgs.push_back((Object)A7.getValue());
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"plist"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-w"));
                Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Xanalyzer.getValue()));
            }
            ToolsStatics.CheckCodeGenerationOptions(D, Args);
            boolean PIE = this.getToolChain().isPIEDefault();
            boolean IsPICLevelTwo = PIC = PIE || this.getToolChain().isPICDefault();
            if (this.getToolChain().getTriple().getEnvironment() == Triple.EnvironmentType.Android) {
                switch (this.getToolChain().getTriple().getArch()) {
                    case arm: 
                    case armeb: 
                    case thumb: 
                    case thumbeb: 
                    case aarch64: 
                    case mips: 
                    case mipsel: 
                    case mips64: 
                    case mips64el: {
                        PIC = true;
                        break;
                    }
                    case x86: 
                    case x86_64: {
                        PIC = true;
                        IsPICLevelTwo = true;
                        break;
                    }
                }
            }
            if (this.getToolChain().getTriple().getOS() == Triple.OSType.OpenBSD) {
                switch (this.getToolChain().getTriple().getArch()) {
                    case mips64: 
                    case mips64el: 
                    case x86: 
                    case x86_64: 
                    case sparc: {
                        IsPICLevelTwo = false;
                        break;
                    }
                    case ppc: 
                    case sparcv9: {
                        IsPICLevelTwo = true;
                        break;
                    }
                }
            }
            Arg LastPICArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fPIC.getValue()), new OptSpecifier((long)options.ID.OPT_fno_PIC.getValue()), new OptSpecifier((long)options.ID.OPT_fpic.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pic.getValue()), new OptSpecifier((long)options.ID.OPT_fPIE.getValue()), new OptSpecifier((long)options.ID.OPT_fno_PIE.getValue()), new OptSpecifier((long)options.ID.OPT_fpie.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pie.getValue()));
            if (!this.getToolChain().isPICDefaultForced() && LastPICArg != null) {
                Option O = new Option(LastPICArg.getOption());
                if (O.matches(new OptSpecifier((long)options.ID.OPT_fPIC.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fpic.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fPIE.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fpie.getValue()))) {
                    PIE = O.matches(new OptSpecifier((long)options.ID.OPT_fPIE.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fpie.getValue()));
                    PIC = PIE || O.matches(new OptSpecifier((long)options.ID.OPT_fPIC.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fpic.getValue()));
                    IsPICLevelTwo = O.matches(new OptSpecifier((long)options.ID.OPT_fPIE.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fPIC.getValue()));
                } else {
                    PIC = false;
                    PIE = false;
                }
            }
            if (PIC && this.getToolChain().getTriple().isOSDarwin()) {
                IsPICLevelTwo |= this.getToolChain().isPICDefault();
            }
            Triple2 = new Triple(new Twine(TripleStr));
            if (KernelOrKext && (!Triple2.isiOS() || Triple2.isOSVersionLT(6L))) {
                PIE = false;
                PIC = false;
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                PIE = false;
                PIC = false;
            }
            if ((A6 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mdynamic_no_pic.getValue()))) != null) {
                if (!this.getToolChain().getTriple().isOSDarwin()) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(355L), (StringRef)A6.getSpelling()), (StringRef)new StringRef(this.getToolChain().getTriple().str())).$destroy();
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-mrelocation-model"));
                CmdArgs.push_back((Object)NativePointer.$((String)"dynamic-no-pic"));
                if (this.getToolChain().isPICDefault() && this.getToolChain().isPICDefaultForced()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pic-level"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"2"));
                }
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mrelocation-model"));
                CmdArgs.push_back((Object)(PIC ? NativePointer.$((String)"pic") : NativePointer.$((String)"static")));
                if (PIC) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pic-level"));
                    CmdArgs.push_back((Object)(IsPICLevelTwo ? NativePointer.$((String)"2") : NativePointer.$((String)"1")));
                    if (PIE) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-pie-level"));
                        CmdArgs.push_back((Object)(IsPICLevelTwo ? NativePointer.$((String)"2") : NativePointer.$((String)"1")));
                    }
                }
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-mthread-model"));
            A6 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mthread_model.getValue()));
            if (A6 != null) {
                CmdArgs.push_back((Object)A6.getValue());
            } else {
                CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().getThreadModel()));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fmerge_all_constants.getValue()), new OptSpecifier((long)options.ID.OPT_fno_merge_all_constants.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-merge-all-constants"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_frewrite_map_file.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_frewrite_map_file_EQ.getValue()))) {
                arg_iterator MFI = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_frewrite_map_file.getValue()), new OptSpecifier((long)options.ID.OPT_frewrite_map_file_EQ.getValue()));
                arg_iterator MFE = Args.filtered_end();
                while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(MFI), (arg_iterator)new arg_iterator(MFE))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-frewrite-map-file"));
                    CmdArgs.push_back((Object)MFI.$star().getValue());
                    MFI.$star().claim();
                    MFI.$preInc();
                }
            }
            if ((A6 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_Wframe_larger_than_EQ.getValue()))) != null) {
                StringRef v = new StringRef(A6.getValue());
                CmdArgs.push_back((Object)NativePointer.$((String)"-mllvm"));
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-warn-stack-size="), (StringRef)v)));
                A6.claim();
            }
            if ((A6 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mregparm_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mregparm"));
                CmdArgs.push_back((Object)A6.getValue());
            }
            if ((A6 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fpcc_struct_return.getValue()), new OptSpecifier((long)options.ID.OPT_freg_struct_return.getValue()))) != null) {
                if (this.getToolChain().getArch() != Triple.ArchType.x86) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(355L), (StringRef)A6.getSpelling()), (StringRef)new StringRef(this.getToolChain().getTriple().str())).$destroy();
                } else if (A6.getOption().matches(new OptSpecifier((long)options.ID.OPT_fpcc_struct_return.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fpcc-struct-return"));
                } else {
                    assert (A6.getOption().matches(new OptSpecifier((long)options.ID.OPT_freg_struct_return.getValue())));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-freg-struct-return"));
                }
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mrtd.getValue()), new OptSpecifier((long)options.ID.OPT_mno_rtd.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mrtd"));
            }
            if (ToolsStatics.shouldUseFramePointer(Args, this.getToolChain().getTriple())) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mdisable-fp-elim"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fzero_initialized_in_bss.getValue()), new OptSpecifier((long)options.ID.OPT_fno_zero_initialized_in_bss.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mno-zero-initialized-in-bss"));
            }
            OptSpecifier StrictAliasingAliasOption = new OptSpecifier((OFastEnabled = DriverGlobals.isOptimizationLevelFast(Args)) ? (long)options.ID.OPT_Ofast.getValue() : (long)options.ID.OPT_fstrict_aliasing.getValue());
            boolean bl = TBAAOnByDefault = !this.getToolChain().getDriver().IsCLMode();
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fstrict_aliasing.getValue()), new OptSpecifier(StrictAliasingAliasOption), new OptSpecifier((long)options.ID.OPT_fno_strict_aliasing.getValue()), TBAAOnByDefault)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-relaxed-aliasing"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fstruct_path_tbaa.getValue()), new OptSpecifier((long)options.ID.OPT_fno_struct_path_tbaa.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-no-struct-path-tbaa"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fstrict_enums.getValue()), new OptSpecifier((long)options.ID.OPT_fno_strict_enums.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fstrict-enums"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_foptimize_sibling_calls.getValue()), new OptSpecifier((long)options.ID.OPT_fno_optimize_sibling_calls.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mdisable-tail-calls"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fsplit_stack.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-split-stacks"));
            }
            OptSpecifier FastMathAliasOption = new OptSpecifier(OFastEnabled ? (long)options.ID.OPT_Ofast.getValue() : (long)options.ID.OPT_ffast_math.getValue());
            Arg A8 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_ffinite_math_only.getValue()), new OptSpecifier((long)options.ID.OPT_fno_finite_math_only.getValue()), new OptSpecifier((long)options.ID.OPT_fhonor_infinities.getValue()), new OptSpecifier((long)options.ID.OPT_fno_honor_infinities.getValue()));
            if (A8 != null && A8.getOption().getID() != (long)options.ID.OPT_fno_fast_math.getValue() && A8.getOption().getID() != (long)options.ID.OPT_fno_finite_math_only.getValue() && A8.getOption().getID() != (long)options.ID.OPT_fhonor_infinities.getValue()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-menable-no-infs"));
            }
            if ((A8 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_ffinite_math_only.getValue()), new OptSpecifier((long)options.ID.OPT_fno_finite_math_only.getValue()), new OptSpecifier((long)options.ID.OPT_fhonor_nans.getValue()), new OptSpecifier((long)options.ID.OPT_fno_honor_nans.getValue()))) != null && A8.getOption().getID() != (long)options.ID.OPT_fno_fast_math.getValue() && A8.getOption().getID() != (long)options.ID.OPT_fno_finite_math_only.getValue() && A8.getOption().getID() != (long)options.ID.OPT_fhonor_nans.getValue()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-menable-no-nans"));
            }
            boolean MathErrno = this.getToolChain().IsMathErrnoDefault();
            Arg A9 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_fmath_errno.getValue()), new OptSpecifier((long)options.ID.OPT_fno_math_errno.getValue()));
            if (A9 != null) {
                if (A9.getOption().getID() == (long)options.ID.OPT_fno_math_errno.getValue() || A9.getOption().getID() == (long)options.ID.OPT_ffast_math.getValue() || A9.getOption().getID() == (long)options.ID.OPT_Ofast.getValue()) {
                    MathErrno = false;
                } else if (A9.getOption().getID() == (long)options.ID.OPT_fmath_errno.getValue()) {
                    MathErrno = true;
                }
            }
            if (MathErrno) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fmath-errno"));
            }
            boolean AssociativeMath = false;
            Arg A10 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_funsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_fassociative_math.getValue()), new OptSpecifier((long)options.ID.OPT_fno_associative_math.getValue()));
            if (A10 != null && A10.getOption().getID() != (long)options.ID.OPT_fno_fast_math.getValue() && A10.getOption().getID() != (long)options.ID.OPT_fno_unsafe_math_optimizations.getValue() && A10.getOption().getID() != (long)options.ID.OPT_fno_associative_math.getValue()) {
                AssociativeMath = true;
            }
            boolean ReciprocalMath = false;
            Arg A11 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_funsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_freciprocal_math.getValue()), new OptSpecifier((long)options.ID.OPT_fno_reciprocal_math.getValue()));
            if (A11 != null && A11.getOption().getID() != (long)options.ID.OPT_fno_fast_math.getValue() && A11.getOption().getID() != (long)options.ID.OPT_fno_unsafe_math_optimizations.getValue() && A11.getOption().getID() != (long)options.ID.OPT_fno_reciprocal_math.getValue()) {
                ReciprocalMath = true;
            }
            boolean SignedZeros = true;
            Arg A12 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_funsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_fsigned_zeros.getValue()), new OptSpecifier((long)options.ID.OPT_fno_signed_zeros.getValue()));
            if (A12 != null && A12.getOption().getID() != (long)options.ID.OPT_fno_fast_math.getValue() && A12.getOption().getID() != (long)options.ID.OPT_fno_unsafe_math_optimizations.getValue() && A12.getOption().getID() != (long)options.ID.OPT_fsigned_zeros.getValue()) {
                SignedZeros = false;
            }
            boolean TrappingMath = true;
            Arg A13 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_funsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unsafe_math_optimizations.getValue()), new OptSpecifier((long)options.ID.OPT_ftrapping_math.getValue()), new OptSpecifier((long)options.ID.OPT_fno_trapping_math.getValue()));
            if (A13 != null && A13.getOption().getID() != (long)options.ID.OPT_fno_fast_math.getValue() && A13.getOption().getID() != (long)options.ID.OPT_fno_unsafe_math_optimizations.getValue() && A13.getOption().getID() != (long)options.ID.OPT_ftrapping_math.getValue()) {
                TrappingMath = false;
            }
            if (!MathErrno && AssociativeMath && ReciprocalMath && !SignedZeros && !TrappingMath) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-menable-unsafe-fp-math"));
            }
            if ((A13 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier((long)options.ID.OPT_ffp_contract.getValue()))) != null) {
                if (A13.getOption().getID() == (long)options.ID.OPT_ffp_contract.getValue()) {
                    StringRef Val = new StringRef(A13.getValue());
                    if (llvm.$eq_StringRef((StringRef)new StringRef(Val), (StringRef)new StringRef(NativePointer.$((String)"fast"))) || llvm.$eq_StringRef((StringRef)new StringRef(Val), (StringRef)new StringRef(NativePointer.$((String)"on"))) || llvm.$eq_StringRef((StringRef)new StringRef(Val), (StringRef)new StringRef(NativePointer.$((String)"off")))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-ffp-contract="), (StringRef)Val)));
                    } else {
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(356L), (StringRef)A13.getOption().getName()), (StringRef)new StringRef(Val)).$destroy();
                    }
                } else if (A13.getOption().matches(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue())) || OFastEnabled && A13.getOption().matches(new OptSpecifier((long)options.ID.OPT_Ofast.getValue()))) {
                    CmdArgs.push_back((Object)Args.MakeArgString(NativePointer.$((String)"-ffp-contract=fast")));
                }
            }
            if ((A13 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffast_math.getValue()), new OptSpecifier(FastMathAliasOption), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()))) != null && !A13.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ffast-math"));
            }
            if ((A13 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ffinite_math_only.getValue()), new OptSpecifier((long)options.ID.OPT_fno_fast_math.getValue()))) != null && A13.getOption().matches(new OptSpecifier((long)options.ID.OPT_ffinite_math_only.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ffinite-math-only"));
            }
            boolean IsIntegratedAssemblerDefault = this.getToolChain().IsIntegratedAssemblerDefault();
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fverbose_asm.getValue()), new OptSpecifier((long)options.ID.OPT_fno_verbose_asm.getValue()), IsIntegratedAssemblerDefault) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_dA.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-masm-verbose"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fintegrated_as.getValue()), new OptSpecifier((long)options.ID.OPT_fno_integrated_as.getValue()), IsIntegratedAssemblerDefault)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-no-integrated-as"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fdebug_pass_structure.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mdebug-pass"));
                CmdArgs.push_back((Object)NativePointer.$((String)"Structure"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fdebug_pass_arguments.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mdebug-pass"));
                CmdArgs.push_back((Object)NativePointer.$((String)"Arguments"));
            }
            if (!this.getToolChain().getTriple().isOSDarwin()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mconstructor-aliases"));
            }
            if (KernelOrKext && this.getToolChain().getTriple().isOSDarwin()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fforbid-guard-variables"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_mms_bitfields.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mms-bitfields"));
            }
            boolean AsynchronousUnwindTables = Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fasynchronous_unwind_tables.getValue()), new OptSpecifier((long)options.ID.OPT_fno_asynchronous_unwind_tables.getValue()), (this.getToolChain().IsUnwindTablesDefault() || this.getToolChain().getSanitizerArgs().needsUnwindTables()) && !KernelOrKext);
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_funwind_tables.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unwind_tables.getValue()), AsynchronousUnwindTables)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-munwind-tables"));
            }
            this.getToolChain().addClangTargetOptions(Args, CmdArgs);
            Arg A14 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_flimited_precision_EQ.getValue()));
            if (A14 != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mlimit-float-precision"));
                CmdArgs.push_back((Object)A14.getValue());
            }
            Args.hasArg(new OptSpecifier((long)options.ID.OPT_mtune_EQ.getValue()));
            A14 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcmodel_EQ.getValue()));
            if (A14 != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mcode-model"));
                CmdArgs.push_back((Object)A14.getValue());
            }
            if (!(CPU = ToolsStatics.getCPUName(Args, ETriple = new Triple(new Twine(ETripleStr = this.getToolChain().ComputeEffectiveClangTriple(Args))))).empty()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-target-cpu"));
                CmdArgs.push_back((Object)Args.MakeArgString(new std.string(CPU)));
            }
            if ((A5 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mfpmath_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mfpmath"));
                CmdArgs.push_back((Object)A5.getValue());
            }
            ToolsStatics.getTargetFeatures(D, ETriple, Args, CmdArgs, false);
            switch (this.getToolChain().getArch()) {
                default: {
                    break;
                }
                case arm: 
                case armeb: 
                case thumb: 
                case thumbeb: {
                    this.AddARMTargetArgs(Args, CmdArgs, KernelOrKext);
                    break;
                }
                case aarch64: 
                case aarch64_be: {
                    this.AddAArch64TargetArgs(Args, CmdArgs);
                    break;
                }
                case mips: 
                case mipsel: 
                case mips64: 
                case mips64el: {
                    this.AddMIPSTargetArgs(Args, CmdArgs);
                    break;
                }
                case ppc64: 
                case ppc64le: 
                case ppc: {
                    this.AddPPCTargetArgs(Args, CmdArgs);
                    break;
                }
                case sparc: 
                case sparcv9: {
                    this.AddSparcTargetArgs(Args, CmdArgs);
                    break;
                }
                case x86: 
                case x86_64: {
                    this.AddX86TargetArgs(Args, CmdArgs);
                    break;
                }
                case hexagon: {
                    this.AddHexagonTargetArgs(Args, CmdArgs);
                }
            }
            if (this.getToolChain().getDriver().IsCLMode()) {
                this.AddClangCLArgs(Args, CmdArgs);
            }
            if ((A5 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mlinker_version_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-target-linker-version"));
                CmdArgs.push_back((Object)A5.getValue());
            }
            if (!ToolsStatics.shouldUseLeafFramePointer(Args, this.getToolChain().getTriple())) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-momit-leaf-frame-pointer"));
            }
            types.ID InputType = ((InputInfo)Inputs.$at(0)).getType();
            if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fallow_unsupported.getValue())) && types.isCXX(InputType) && this.getToolChain().getTriple().isOSDarwin() && this.getToolChain().getArch() == Triple.ArchType.x86 && ((Unsupported = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue()))) != null || (Unsupported = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue()))) != null)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(310L), (StringRef)Unsupported.getOption().getName()).$destroy();
            }
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_v.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_H.getValue()));
            if (D.CCPrintHeaders && !D.CCGenDiagnostics) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-header-include-file"));
                CmdArgs.push_back((Object)(D.CCPrintHeadersFilename != null ? D.CCPrintHeadersFilename : NativePointer.$((String)"-")));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_P.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_print_ivar_layout.getValue()));
            if (D.CCLogDiagnostics && !D.CCGenDiagnostics) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-diagnostic-log-file"));
                CmdArgs.push_back((Object)(D.CCLogDiagnosticsFilename != null ? D.CCLogDiagnosticsFilename : NativePointer.$((String)"-")));
            }
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()));
            Arg A15 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()));
            if (A15 != null) {
                Triple _Triple;
                if (A15.getOption().matches(new OptSpecifier((long)options.ID.OPT_gline_tables_only.getValue())) || A15.getOption().matches(new OptSpecifier((long)options.ID.OPT_g1.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-gline-tables-only"));
                    _Triple = this.getToolChain().getTriple();
                    if (_Triple.isOSDarwin() || _Triple.getOS() == Triple.OSType.OpenBSD || _Triple.getOS() == Triple.OSType.FreeBSD || _Triple.getOS() == Triple.OSType.Solaris) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-gdwarf-2"));
                    }
                } else if (A15.getOption().matches(new OptSpecifier((long)options.ID.OPT_gdwarf_2.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-gdwarf-2"));
                } else if (A15.getOption().matches(new OptSpecifier((long)options.ID.OPT_gdwarf_3.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-gdwarf-3"));
                } else if (A15.getOption().matches(new OptSpecifier((long)options.ID.OPT_gdwarf_4.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-gdwarf-4"));
                } else if (!A15.getOption().matches(new OptSpecifier((long)options.ID.OPT_g0.getValue())) && !A15.getOption().matches(new OptSpecifier((long)options.ID.OPT_ggdb0.getValue()))) {
                    _Triple = this.getToolChain().getTriple();
                    if (_Triple.isOSDarwin() || _Triple.getOS() == Triple.OSType.OpenBSD || _Triple.getOS() == Triple.OSType.FreeBSD || _Triple.getOS() == Triple.OSType.Solaris) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-gdwarf-2"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-g"));
                    }
                }
            }
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_g_flags_Group.getValue()));
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_gcolumn_info.getValue()), new OptSpecifier((long)options.ID.OPT_gno_column_info.getValue()), true)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-dwarf-column-info"));
            }
            if (this.getToolChain().getTriple().isOSLinux() && Args.hasArg(new OptSpecifier((long)options.ID.OPT_gsplit_dwarf.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-g"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-split-dwarf=Enable"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ggnu_pubnames.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-generate-gnu-dwarf-pub-sections"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_gdwarf_aranges.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-generate-arange-section"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fdebug_types_section.getValue()), new OptSpecifier((long)options.ID.OPT_fno_debug_types_section.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-generate-type-units"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_ffunction_sections.getValue()), new OptSpecifier((long)options.ID.OPT_fno_function_sections.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ffunction-sections"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fdata_sections.getValue()), new OptSpecifier((long)options.ID.OPT_fno_data_sections.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fdata-sections"));
            }
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_finstrument_functions.getValue()));
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_generate.getValue())) && (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_use.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_use_EQ.getValue())))) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(306L), (char.ptr)NativePointer.$((String)"-fprofile-instr-generate")), (char.ptr)NativePointer.$((String)"-fprofile-instr-use")).$destroy();
            }
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fprofile_instr_generate.getValue()));
            A15 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_use_EQ.getValue()));
            if (A15 != null) {
                A15.render(Args, (SmallVector)CmdArgs);
            } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_use.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fprofile-instr-use=pgo-data"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ftest_coverage.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_coverage.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-femit-coverage-notes"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fprofile_arcs.getValue()), new OptSpecifier((long)options.ID.OPT_fno_profile_arcs.getValue()), false) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_coverage.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-femit-coverage-data"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fcoverage_mapping.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_generate.getValue()))) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(307L), (char.ptr)NativePointer.$((String)"-fcoverage-mapping")), (char.ptr)NativePointer.$((String)"-fprofile-instr-generate")).$destroy();
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fcoverage_mapping.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fcoverage-mapping"));
            }
            if ((C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_c.getValue())) || C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_S.getValue()))) && Output.isFilename()) {
                SmallString CoverageFilename = null;
                try {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-coverage-file"));
                    CoverageFilename = new SmallString(128);
                    Arg FinalOutput = C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT_o.getValue()));
                    if (FinalOutput != null) {
                        CoverageFilename.$assign(FinalOutput.getValue());
                    } else {
                        CoverageFilename.$assign(path.filename((StringRef)new StringRef(Output.getBaseInput())));
                    }
                    if (path.is_relative((Twine)new Twine(CoverageFilename.str()))) {
                        SmallString Pwd = null;
                        try {
                            Pwd = new SmallString(128);
                            if (!fs.current_path((SmallString)Pwd).$boolean()) {
                                path.append((SmallString)Pwd, (SmallVectorImplChar)CoverageFilename);
                                CoverageFilename.swap((SmallVectorImplChar)Pwd);
                            }
                        }
                        finally {
                            if (Pwd != null) {
                                Pwd.$destroy();
                            }
                        }
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(CoverageFilename.$StringRef()));
                }
                finally {
                    if (CoverageFilename != null) {
                        CoverageFilename.$destroy();
                    }
                }
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdinc.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-nostdsysteminc"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-nobuiltininc"));
            } else {
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-nostdsysteminc"));
                }
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_nobuiltininc.getValue()));
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-resource-dir"));
            CmdArgs.push_back((Object)D.ResourceDir.c_str());
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_working_directory.getValue()));
            boolean ARCMTEnabled = false;
            if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fno_objc_arc.getValue()), new OptSpecifier((long)options.ID.OPT_fobjc_arc.getValue()))) {
                A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ccc_arcmt_check.getValue()), new OptSpecifier((long)options.ID.OPT_ccc_arcmt_modify.getValue()), new OptSpecifier((long)options.ID.OPT_ccc_arcmt_migrate.getValue()));
                if (A4 != null) {
                    ARCMTEnabled = true;
                    switch (options.ID.valueOf(A4.getOption().getID())) {
                        default: {
                            throw new llvm_unreachable((CharSequence)"missed a case");
                        }
                        case OPT_ccc_arcmt_check: {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-arcmt-check"));
                            break;
                        }
                        case OPT_ccc_arcmt_modify: {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-arcmt-modify"));
                            break;
                        }
                        case OPT_ccc_arcmt_migrate: {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-arcmt-migrate"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-mt-migrate-directory"));
                            CmdArgs.push_back((Object)A4.getValue());
                            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_arcmt_migrate_report_output.getValue()));
                            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_arcmt_migrate_emit_arc_errors.getValue()));
                        }
                    }
                }
            } else {
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_ccc_arcmt_check.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_ccc_arcmt_modify.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_ccc_arcmt_migrate.getValue()));
            }
            A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ccc_objcmt_migrate.getValue()));
            if (A4 != null) {
                if (ARCMTEnabled) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(A4.getAsString(Args))), (char.ptr)NativePointer.$((String)"-ccc-arcmt-migrate")).$destroy();
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-mt-migrate-directory"));
                CmdArgs.push_back((Object)A4.getValue());
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_objcmt_migrate_literals.getValue()), new OptSpecifier((long)options.ID.OPT_objcmt_migrate_subscripting.getValue()), new OptSpecifier((long)options.ID.OPT_objcmt_migrate_property.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-objcmt-migrate-literals"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-objcmt-migrate-subscripting"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-objcmt-migrate-property"));
                } else {
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_literals.getValue()));
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_subscripting.getValue()));
                    Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_property.getValue()));
                }
            } else {
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_literals.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_subscripting.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_property.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_all.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_readonly_property.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_readwrite_property.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_annotation.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_instancetype.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_nsmacros.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_protocol_conformance.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_atomic_property.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_returns_innerpointer_property.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_ns_nonatomic_iosonly.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_migrate_designated_init.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_objcmt_whitelist_dir_path.getValue()));
            }
            if (types.getPreprocessedType(InputType) != types.ID.TY_INVALID) {
                this.AddPreprocessingOptions(C, JA, D, Args, CmdArgs, Output, Inputs);
            }
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_D.getValue()));
            A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_O_Group.getValue()));
            if (A4 != null) {
                if (A4.getOption().matches(new OptSpecifier((long)options.ID.OPT_O4.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-O3"));
                    D.Diag(364L).$destroy();
                } else {
                    A4.render(Args, (SmallVector)CmdArgs);
                }
            }
            arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_clang_ignored_gcc_optimization_f_Group.getValue()));
            arg_iterator ie = Args.filtered_end();
            while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it), (arg_iterator)new arg_iterator(ie))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(380L), (StringRef)new StringRef(it.$star().getAsString(Args))).$destroy();
                it.$preInc();
            }
            ToolsStatics.claimNoWarnArgs(Args);
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_R_Group.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_W_Group.getValue()));
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_pedantic.getValue()), new OptSpecifier((long)options.ID.OPT_no_pedantic.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-pedantic"));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_pedantic_errors.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_w.getValue()));
            Arg Std = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_std_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_ansi.getValue()));
            if (Std != null) {
                if (Std.getOption().matches(new OptSpecifier((long)options.ID.OPT_ansi.getValue()))) {
                    if (types.isCXX(InputType)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-std=c++98"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-std=c89"));
                    }
                } else {
                    Std.render(Args, (SmallVector)CmdArgs);
                }
                Arg A16 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_std_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_ansi.getValue()), new OptSpecifier((long)options.ID.OPT_ftrigraphs.getValue()), new OptSpecifier((long)options.ID.OPT_fno_trigraphs.getValue()));
                if (A16 != null && A16 != Std) {
                    A16.render(Args, (SmallVector)CmdArgs);
                }
            } else {
                if (!types.isCXX(InputType)) {
                    Args.AddAllArgsTranslated((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_std_default_EQ.getValue()), NativePointer.$((String)"-std="), true);
                } else if (IsWindowsMSVC) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-std=c++11"));
                }
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_ftrigraphs.getValue()), new OptSpecifier((long)options.ID.OPT_fno_trigraphs.getValue()));
            }
            if (!types.isCXX(InputType) && (WriteStrings = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_Wwrite_strings.getValue()), new OptSpecifier((long)options.ID.OPT_Wno_write_strings.getValue()), new OptSpecifier((long)options.ID.OPT_w.getValue()))) != null && WriteStrings.getOption().matches(new OptSpecifier((long)options.ID.OPT_Wwrite_strings.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fconst-strings"));
            }
            if (types.isCXX(InputType) && Args.hasFlag(new OptSpecifier((long)options.ID.OPT_Wdeprecated.getValue()), new OptSpecifier((long)options.ID.OPT_Wno_deprecated.getValue()), true)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fdeprecated-macro"));
            }
            if ((Asm = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fasm.getValue()), new OptSpecifier((long)options.ID.OPT_fno_asm.getValue()))) != null) {
                if (Asm.getOption().matches(new OptSpecifier((long)options.ID.OPT_fasm.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fgnu-keywords"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fno-gnu-keywords"));
                }
            }
            if (ToolsStatics.ShouldDisableDwarfDirectory(Args, this.getToolChain())) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-dwarf-directory-asm"));
            }
            if (ToolsStatics.ShouldDisableAutolink(Args, this.getToolChain())) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-autolink"));
            }
            ToolsStatics.addDebugCompDirArg(Args, CmdArgs);
            A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ftemplate_depth_.getValue()), new OptSpecifier((long)options.ID.OPT_ftemplate_depth_EQ.getValue()));
            if (A4 != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ftemplate-depth"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_foperator_arrow_depth_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-foperator-arrow-depth"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fconstexpr_depth_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fconstexpr-depth"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fconstexpr_steps_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fconstexpr-steps"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fbracket_depth_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fbracket-depth"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_Wlarge_by_value_copy_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_Wlarge_by_value_copy_def.getValue()))) != null) {
                if (A4.getNumValues() != 0L) {
                    StringRef bytes = new StringRef(A4.getValue());
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-Wlarge-by-value-copy="), (StringRef)bytes)));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Wlarge-by-value-copy=64"));
                }
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_relocatable_pch.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-relocatable-pch"));
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fconstant_string_class_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fconstant-string-class"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ftabstop_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ftabstop"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-ferror-limit"));
            A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ferror_limit_EQ.getValue()));
            if (A4 != null) {
                CmdArgs.push_back((Object)A4.getValue());
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"19"));
            }
            A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fmacro_backtrace_limit_EQ.getValue()));
            if (A4 != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fmacro-backtrace-limit"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ftemplate_backtrace_limit_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ftemplate-backtrace-limit"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fconstexpr_backtrace_limit_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fconstexpr-backtrace-limit"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            if ((A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fspell_checking_limit_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fspell-checking-limit"));
                CmdArgs.push_back((Object)A4.getValue());
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-fmessage-length"));
            A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fmessage_length_EQ.getValue()));
            if (A4 != null) {
                CmdArgs.push_back((Object)A4.getValue());
            } else {
                long N = Process.StandardErrColumns();
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(JavaDifferentiators.Uint.INSTANCE, N)));
            }
            A4 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fvisibility_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_fvisibility_ms_compat.getValue()));
            if (A4 != null) {
                if (A4.getOption().matches(new OptSpecifier((long)options.ID.OPT_fvisibility_EQ.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fvisibility"));
                    CmdArgs.push_back((Object)A4.getValue());
                } else {
                    assert (A4.getOption().matches(new OptSpecifier((long)options.ID.OPT_fvisibility_ms_compat.getValue())));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fvisibility"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"hidden"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-ftype-visibility"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"default"));
                }
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fvisibility_inlines_hidden.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_ftlsmodel_EQ.getValue()));
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_ffreestanding.getValue()), new OptSpecifier((long)options.ID.OPT_fhosted.getValue()), false) || KernelOrKext) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ffreestanding"));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_femit_all_decls.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fheinous_gnu_extensions.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fstandalone_debug.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fno_standalone_debug.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fno_operator_names.getValue()));
            if (!llvm.isa(PreprocessJobAction.class, (Object)JA) || Output.getType() != types.ID.TY_PP_Asm) {
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_faltivec.getValue()));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fdiagnostics_show_template_tree.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fno_elide_type.getValue()));
            SanitizerArgs Sanitize = this.getToolChain().getSanitizerArgs();
            Sanitize.addArgs(Args, CmdArgs);
            Arg A17 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_faltivec.getValue()));
            if (A17 != null && this.getToolChain().getArch() != Triple.ArchType.ppc && this.getToolChain().getArch() != Triple.ArchType.ppc64 && this.getToolChain().getArch() != Triple.ArchType.ppc64le) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(307L), (StringRef)new StringRef(A17.getAsString(Args))), (char.ptr)NativePointer.$((String)"ppc/ppc64/ppc64le")).$destroy();
            }
            if (this.getToolChain().SupportsProfiling()) {
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_pg.getValue()));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_flax_vector_conversions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_lax_vector_conversions.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-lax-vector-conversions"));
            }
            if (Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue())) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fapple-kext"));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fobjc_sender_dependent_dispatch.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fdiagnostics_print_source_range_info.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fdiagnostics_parseable_fixits.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_ftime_report.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_ftrapv.getValue()));
            A17 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ftrapv_handler_EQ.getValue()));
            if (A17 != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ftrapv-handler"));
                CmdArgs.push_back((Object)A17.getValue());
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_ftrap_function_EQ.getValue()));
            A17 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fwrapv.getValue()), new OptSpecifier((long)options.ID.OPT_fno_wrapv.getValue()));
            if (A17 != null) {
                if (A17.getOption().matches(new OptSpecifier((long)options.ID.OPT_fwrapv.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fwrapv"));
                }
            } else {
                Arg _A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fstrict_overflow.getValue()), new OptSpecifier((long)options.ID.OPT_fno_strict_overflow.getValue()));
                if (_A != null && _A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_strict_overflow.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fwrapv"));
                }
            }
            if ((A17 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_freroll_loops.getValue()), new OptSpecifier((long)options.ID.OPT_fno_reroll_loops.getValue()))) != null && A17.getOption().matches(new OptSpecifier((long)options.ID.OPT_freroll_loops.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-freroll-loops"));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fwritable_strings.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_funroll_loops.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unroll_loops.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_pthread.getValue()));
            long StackProtectorLevel = 0L;
            Arg A18 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fno_stack_protector.getValue()), new OptSpecifier((long)options.ID.OPT_fstack_protector_all.getValue()), new OptSpecifier((long)options.ID.OPT_fstack_protector_strong.getValue()), new OptSpecifier((long)options.ID.OPT_fstack_protector.getValue()));
            if (A18 != null) {
                if (A18.getOption().matches(new OptSpecifier((long)options.ID.OPT_fstack_protector.getValue()))) {
                    StackProtectorLevel = std.max((int)LangOptions.StackProtectorMode.SSPOn.getValue(), (long)this.getToolChain().GetDefaultStackProtectorLevel(KernelOrKext));
                } else if (A18.getOption().matches(new OptSpecifier((long)options.ID.OPT_fstack_protector_strong.getValue()))) {
                    StackProtectorLevel = LangOptions.StackProtectorMode.SSPStrong.getValue();
                } else if (A18.getOption().matches(new OptSpecifier((long)options.ID.OPT_fstack_protector_all.getValue()))) {
                    StackProtectorLevel = LangOptions.StackProtectorMode.SSPReq.getValue();
                }
            } else {
                StackProtectorLevel = this.getToolChain().GetDefaultStackProtectorLevel(KernelOrKext);
            }
            if (StackProtectorLevel != 0L) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-stack-protector"));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(JavaDifferentiators.Uint.INSTANCE, StackProtectorLevel)));
            }
            arg_iterator it2 = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT__param.getValue()));
            arg_iterator ie2 = Args.filtered_end();
            while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it2), (arg_iterator)new arg_iterator(ie2))) {
                StringRef Str = new StringRef(it2.$star().getValue());
                if (Str.startswith((CharSequence)"ssp-buffer-size=")) {
                    if (StackProtectorLevel != 0L) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-stack-protector-buffer-size"));
                        CmdArgs.push_back((Object)Args.MakeArgString(Str.drop_front(16)));
                    }
                    it2.$star().claim();
                }
                it2.$preInc();
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mstackrealign.getValue()), new OptSpecifier((long)options.ID.OPT_mno_stackrealign.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-force-align-stack"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mno_stackrealign.getValue()), new OptSpecifier((long)options.ID.OPT_mstackrealign.getValue()), false)) {
                CmdArgs.push_back((Object)Args.MakeArgString(NativePointer.$((String)"-mstackrealign")));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_mstack_alignment.getValue()))) {
                StringRef alignment = Args.getLastArgValue(new OptSpecifier((long)options.ID.OPT_mstack_alignment.getValue()));
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-mstack-alignment="), (StringRef)alignment)));
            }
            if (this.getToolChain().getTriple().getArch() == Triple.ArchType.aarch64 || this.getToolChain().getTriple().getArch() == Triple.ArchType.aarch64_be) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fallow-half-arguments-and-returns"));
            }
            if ((A18 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mrestrict_it.getValue()), new OptSpecifier((long)options.ID.OPT_mno_restrict_it.getValue()))) != null) {
                if (A18.getOption().matches(new OptSpecifier((long)options.ID.OPT_mrestrict_it.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-arm-restrict-it"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-arm-no-restrict-it"));
                }
            } else if (TT.isOSWindows() && (TT.getArch() == Triple.ArchType.arm || TT.getArch() == Triple.ArchType.thumb)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-arm-restrict-it"));
            }
            if ((TT.getArch() == Triple.ArchType.arm || TT.getArch() == Triple.ArchType.thumb) && (A18 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mlong_calls.getValue()), new OptSpecifier((long)options.ID.OPT_mno_long_calls.getValue()))) != null && A18.getOption().matches(new OptSpecifier((long)options.ID.OPT_mlong_calls.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-backend-option"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-arm-long-calls"));
            }
            if ((A18 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fprofile_sample_use_EQ.getValue()))) != null) {
                StringRef fname = new StringRef(A18.getValue());
                if (!fs.exists((Twine)new Twine(fname))) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(342L), (StringRef)new StringRef(fname)).$destroy();
                } else {
                    A18.render(Args, (SmallVector)CmdArgs);
                }
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue()))) {
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue())) && types.isCXX(InputType)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fapple-kext"));
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fbuiltin.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fno-builtin"));
                }
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fno_builtin.getValue()));
            } else if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fbuiltin.getValue()), new OptSpecifier((long)options.ID.OPT_fno_builtin.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-builtin"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fassume_sane_operator_new.getValue()), new OptSpecifier((long)options.ID.OPT_fno_assume_sane_operator_new.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-assume-sane-operator-new"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fblocks.getValue()), new OptSpecifier((long)options.ID.OPT_fno_blocks.getValue()), this.getToolChain().IsBlocksDefault()) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fgnu_runtime.getValue())) && Args.hasArg(new OptSpecifier((long)options.ID.OPT_fobjc_nonfragile_abi.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_fno_blocks.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fblocks"));
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fgnu_runtime.getValue())) && !this.getToolChain().hasBlocksRuntime()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fblocks-runtime-optional"));
                }
            }
            boolean HaveModules = false;
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fmodules.getValue()), new OptSpecifier((long)options.ID.OPT_fno_modules.getValue()), false) && ((AllowedInCXX = Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fcxx_modules.getValue()), new OptSpecifier((long)options.ID.OPT_fno_cxx_modules.getValue()), true)) || !types.isCXX(InputType))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fmodules"));
                HaveModules = true;
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fmodule_maps.getValue()), new OptSpecifier((long)options.ID.OPT_fno_module_maps.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fmodule-maps"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fmodules_decluse.getValue()), new OptSpecifier((long)options.ID.OPT_fno_modules_decluse.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fmodules-decluse"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fmodules_strict_decluse.getValue()), new OptSpecifier((long)options.ID.OPT_fno_modules_strict_decluse.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fmodules-strict-decluse"));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodule_name.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodule_map_file.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodule_file.getValue()));
            ModuleCachePath = new SmallString(128);
            Arg A19 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fmodules_cache_path.getValue()));
            if (A19 != null) {
                ModuleCachePath.$assign(A19.getValue());
            }
            if (HaveModules) {
                if (C.isForDiagnostics()) {
                    ModuleCachePath.$assign(Output.getFilename());
                    path.replace_extension((SmallString)ModuleCachePath, (Twine)new Twine(NativePointer.$((String)".cache")));
                    path.append((SmallString)ModuleCachePath, (char.ptr)NativePointer.$((String)"modules"));
                } else if (ModuleCachePath.empty()) {
                    path.system_temp_directory((boolean)false, (SmallString)ModuleCachePath);
                    path.append((SmallString)ModuleCachePath, (char.ptr)NativePointer.$((String)"org.llvm.clang"));
                    path.append((SmallString)ModuleCachePath, (char.ptr)NativePointer.$((String)"ModuleCache"));
                }
                char.ptr Arg2 = NativePointer.$((String)"-fmodules-cache-path=");
                ModuleCachePath.insert(ModuleCachePath.begin(), (char.iterator)Arg2, (char.iterator)Arg2.$add(std.strlen((char.ptr)Arg2)));
                CmdArgs.push_back((Object)Args.MakeArgString(ModuleCachePath.$StringRef()));
            }
            if (HaveModules && C.isForDiagnostics()) {
                SmallString VFSDir = null;
                try {
                    VFSDir = new SmallString(new StringRef(Output.getFilename()), 128);
                    path.replace_extension((SmallString)VFSDir, (Twine)new Twine(NativePointer.$((String)".cache")));
                    C.addTempFile(Args.MakeArgString(VFSDir.$StringRef()));
                    path.append((SmallString)VFSDir, (char.ptr)NativePointer.$((String)"vfs"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-module-dependency-dir"));
                    CmdArgs.push_back((Object)Args.MakeArgString(VFSDir.$StringRef()));
                }
                finally {
                    if (VFSDir != null) {
                        VFSDir.$destroy();
                    }
                }
            }
            if (HaveModules) {
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodules_user_build_path.getValue()));
            }
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodules_ignore_macro.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodules_prune_interval.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodules_prune_after.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fbuild_session_timestamp.getValue()));
            A19 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fbuild_session_file.getValue()));
            if (A19 != null) {
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fbuild_session_timestamp.getValue()))) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(A19.getAsString(Args))), (char.ptr)NativePointer.$((String)"-fbuild-session-timestamp")).$destroy();
                }
                fs.file_status Status = new fs.file_status();
                if (fs.status((Twine)new Twine(A19.getValue()), (fs.file_status)Status).$boolean()) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(342L), (char.ptr)A19.getValue()).$destroy();
                }
                byte[] TimeStampBuffer = NativePointer.new$char((int)48, (byte[])new byte[0]);
                char.ptr TimeStamp = NativePointer.create_char$ptr((byte[])TimeStampBuffer);
                std.snprintf((char.ptr)TimeStamp, (long)TimeStampBuffer.length, (char.ptr)NativePointer.$((String)"-fbuild-session-timestamp=%lu"), (Object[])new Object[]{Status.getLastModificationTime().toEpochTime()});
                CmdArgs.push_back((Object)Args.MakeArgString(TimeStamp));
            }
            if (Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fmodules_validate_once_per_build_session.getValue())) != null) {
                if (Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fbuild_session_timestamp.getValue()), new OptSpecifier((long)options.ID.OPT_fbuild_session_file.getValue())) == null) {
                    D.Diag(336L).$destroy();
                }
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodules_validate_once_per_build_session.getValue()));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fmodules_validate_system_headers.getValue()));
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fno_access_control.getValue()), new OptSpecifier((long)options.ID.OPT_faccess_control.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-access-control"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fno_elide_constructors.getValue()), new OptSpecifier((long)options.ID.OPT_felide_constructors.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-elide-constructors"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_frtti.getValue()), new OptSpecifier((long)options.ID.OPT_fno_rtti.getValue())) || KernelOrKext) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-rtti"));
                if (Sanitize.sanitizesVptr()) {
                    std.string NoRttiArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue()), new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue()), new OptSpecifier((long)options.ID.OPT_fno_rtti.getValue())).getAsString(Args);
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(306L), (char.ptr)NativePointer.$((String)"-fsanitize=vptr")), (StringRef)new StringRef(NoRttiArg)).$destroy();
                }
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fshort_enums.getValue()), new OptSpecifier((long)options.ID.OPT_fno_short_enums.getValue()), this.getToolChain().getArch() == Triple.ArchType.hexagon)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fshort-enums"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fsigned_char.getValue()), new OptSpecifier((long)options.ID.OPT_funsigned_char.getValue()), ToolsStatics.isSignedCharDefault(this.getToolChain().getTriple()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-signed-char"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fthreadsafe_statics.getValue()), new OptSpecifier((long)options.ID.OPT_fno_threadsafe_statics.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-threadsafe-statics"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fuse_cxa_atexit.getValue()), new OptSpecifier((long)options.ID.OPT_fno_use_cxa_atexit.getValue()), !IsWindowsCygnus && !IsWindowsGNU && this.getToolChain().getArch() != Triple.ArchType.hexagon && this.getToolChain().getArch() != Triple.ArchType.xcore) || KernelOrKext) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-use-cxa-atexit"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fms_extensions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_ms_extensions.getValue()), IsWindowsMSVC)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fms-extensions"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fms_compatibility.getValue()), new OptSpecifier((long)options.ID.OPT_fno_ms_compatibility.getValue()), IsWindowsMSVC && Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fms_extensions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_ms_extensions.getValue()), true))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fms-compatibility"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fms_extensions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_ms_extensions.getValue()), IsWindowsMSVC) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fmsc_version.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fms_compatibility_version.getValue()))) {
                std.string Ver = null;
                try {
                    Arg MSCVersion = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fmsc_version.getValue()));
                    Arg MSCompatibilityVersion = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fms_compatibility_version.getValue()));
                    if (MSCVersion != null && MSCompatibilityVersion != null) {
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(MSCVersion.getAsString(Args))), (StringRef)new StringRef(MSCompatibilityVersion.getAsString(Args))).$destroy();
                    }
                    Ver = new std.string();
                    if (MSCompatibilityVersion != null) {
                        Ver.$assign(Args.getLastArgValue(new OptSpecifier((long)options.ID.OPT_fms_compatibility_version.getValue())).$basic_string());
                    } else if (MSCVersion != null) {
                        Ver.$assign(ToolsStatics.getMSCompatibilityVersion(MSCVersion.getValue()));
                    }
                    if (Ver.empty()) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-fms-compatibility-version=17.00"));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-fms-compatibility-version="), (std.string)Ver)));
                    }
                }
                finally {
                    if (Ver != null) {
                        Ver.$destroy();
                    }
                }
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fborland_extensions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_borland_extensions.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fborland-extensions"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fdelayed_template_parsing.getValue()), new OptSpecifier((long)options.ID.OPT_fno_delayed_template_parsing.getValue()), IsWindowsMSVC)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fdelayed-template-parsing"));
            }
            if ((A19 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fgnu_keywords.getValue()), new OptSpecifier((long)options.ID.OPT_fno_gnu_keywords.getValue()))) != null) {
                A19.render(Args, (SmallVector)CmdArgs);
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fgnu89_inline.getValue()), new OptSpecifier((long)options.ID.OPT_fno_gnu89_inline.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fgnu89-inline"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fno_inline.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-inline"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fno_inline_functions.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-inline-functions"));
            }
            if ((objcRuntime = this.AddObjCRuntimeArgs(Args, CmdArgs, rewriteKind)).isNonFragile() && !Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fobjc_legacy_dispatch.getValue()), new OptSpecifier((long)options.ID.OPT_fno_objc_legacy_dispatch.getValue()), objcRuntime.isLegacyDispatchDefaultForArch(this.getToolChain().getArch()))) {
                if (this.getToolChain().UseObjCMixedDispatch()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-dispatch-method=mixed"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-dispatch-method=non-legacy"));
                }
            }
            if (this.getToolChain().getTriple().getArch() == Triple.ArchType.x86 && this.getToolChain().getTriple().isMacOSX() && this.getToolChain().getTriple().isMacOSXVersionLT(10L, 7L) == 0L && objcRuntime.getKind() == ObjCRuntime.Kind.FragileMacOSX && objcRuntime.isNeXTFamily()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-subscripting-legacy-runtime"));
            }
            if (this.getToolChain().IsEncodeExtendedBlockSignatureDefault()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fencode-extended-block-signature"));
            }
            if (ARC = ToolsStatics.isObjCAutoRefCount(Args)) {
                this.getToolChain().CheckObjCARC();
                CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-arc"));
                if (types.isCXX(InputType) && types.isObjC(InputType)) {
                    if (this.getToolChain().GetCXXStdlibType(Args) == ToolChain.CXXStdlibType.CST_Libcxx) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-arc-cxxlib=libc++"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-arc-cxxlib=libstdc++"));
                    }
                }
                if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fobjc_arc_exceptions.getValue()), new OptSpecifier((long)options.ID.OPT_fno_objc_arc_exceptions.getValue()), types.isCXX(InputType))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-arc-exceptions"));
                }
            }
            if (rewriteKind != RewriteKind.RK_None) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-objc-infer-related-result-type"));
            }
            if ((GCArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fobjc_gc_only.getValue()))) == null) {
                GCArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fobjc_gc.getValue()));
            }
            if (GCArg != null) {
                if (ARC) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(343L), (StringRef)new StringRef(GCArg.getAsString(Args))).$destroy();
                } else if (this.getToolChain().SupportsObjCGC()) {
                    GCArg.render(Args, (SmallVector)CmdArgs);
                } else {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(373L), (StringRef)new StringRef(GCArg.getAsString(Args))).$destroy();
                }
            }
            if (!C.getDriver().IsCLMode()) {
                ToolsStatics.addExceptionArgs(Args, InputType, this.getToolChain().getTriple(), KernelOrKext, objcRuntime, CmdArgs);
            }
            if (this.getToolChain().UseSjLjExceptions()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fsjlj-exceptions"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fassume_sane_operator_new.getValue()), new OptSpecifier((long)options.ID.OPT_fno_assume_sane_operator_new.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-assume-sane-operator-new"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fconstant_cfstrings.getValue()), new OptSpecifier((long)options.ID.OPT_fno_constant_cfstrings.getValue())) || !Args.hasFlag(new OptSpecifier((long)options.ID.OPT_mconstant_cfstrings.getValue()), new OptSpecifier((long)options.ID.OPT_mno_constant_cfstrings.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-constant-cfstrings"));
            }
            if ((A3 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fshort_wchar.getValue()), new OptSpecifier((long)options.ID.OPT_fno_short_wchar.getValue()))) != null) {
                A3.render(Args, (SmallVector)CmdArgs);
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fpascal_strings.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pascal_strings.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fpascal-strings"));
            }
            if ((A3 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fpack_struct_EQ.getValue()))) != null) {
                std.string PackStructStr = new std.string(NativePointer.$((String)"-fpack-struct="));
                PackStructStr.$addassign(A3.getValue());
                CmdArgs.push_back((Object)Args.MakeArgString(new std.string(PackStructStr)));
            } else if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fpack_struct.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pack_struct.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fpack-struct=1"));
            }
            boolean SkipMaxTypeAlign = Args.hasArg(new OptSpecifier((long)options.ID.OPT_fno_max_type_align.getValue()));
            Arg A20 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fmax_type_align_EQ.getValue()));
            if (A20 != null) {
                if (!SkipMaxTypeAlign) {
                    MaxTypeAlignStr = new std.string(NativePointer.$((String)"-fmax-type-align="));
                    MaxTypeAlignStr.$addassign(A20.getValue());
                    CmdArgs.push_back((Object)Args.MakeArgString(new std.string(MaxTypeAlignStr)));
                }
            } else if (this.getToolChain().getTriple().isOSDarwin() && !SkipMaxTypeAlign) {
                MaxTypeAlignStr = new std.string(NativePointer.$((String)"-fmax-type-align=16"));
                CmdArgs.push_back((Object)Args.MakeArgString(new std.string(MaxTypeAlignStr)));
            }
            if (KernelOrKext || ToolsStatics.isNoCommonDefault(this.getToolChain().getTriple())) {
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_fcommon.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fno-common"));
                }
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fno_common.getValue()));
            } else if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fcommon.getValue()), new OptSpecifier((long)options.ID.OPT_fno_common.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-common"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fsigned_bitfields.getValue()), new OptSpecifier((long)options.ID.OPT_funsigned_bitfields.getValue()))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(368L), (StringRef)new StringRef(Args.getLastArg(new OptSpecifier((long)options.ID.OPT_funsigned_bitfields.getValue())).getAsString(Args))).$destroy();
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_ffor_scope.getValue()), new OptSpecifier((long)options.ID.OPT_fno_for_scope.getValue()))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(309L), (StringRef)new StringRef(Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fno_for_scope.getValue())).getAsString(Args))).$destroy();
            }
            if ((inputCharset = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_finput_charset_EQ.getValue()))) != null && llvm.$noteq_StringRef((StringRef)new StringRef((StringRef)(value = new StringRef(inputCharset.getValue()))), (StringRef)new StringRef(NativePointer.$((String)"UTF-8")))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(331L), (StringRef)new StringRef(inputCharset.getAsString(Args))), (StringRef)new StringRef((StringRef)value)).$destroy();
            }
            if ((execCharset = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fexec_charset_EQ.getValue()))) != null && llvm.$noteq_StringRef((StringRef)new StringRef((StringRef)(value = new StringRef(execCharset.getValue()))), (StringRef)new StringRef(NativePointer.$((String)"UTF-8")))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(331L), (StringRef)new StringRef(execCharset.getAsString(Args))), (StringRef)new StringRef((StringRef)value)).$destroy();
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fcaret_diagnostics.getValue()), new OptSpecifier((long)options.ID.OPT_fno_caret_diagnostics.getValue()), true)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-caret-diagnostics"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fdiagnostics_fixit_info.getValue()), new OptSpecifier((long)options.ID.OPT_fno_diagnostics_fixit_info.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-diagnostics-fixit-info"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fdiagnostics_show_option.getValue()), new OptSpecifier((long)options.ID.OPT_fno_diagnostics_show_option.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fdiagnostics-show-option"));
            }
            if ((A20 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fdiagnostics_show_category_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fdiagnostics-show-category"));
                CmdArgs.push_back((Object)A20.getValue());
            }
            if ((A20 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fdiagnostics_format_EQ.getValue()))) != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fdiagnostics-format"));
                CmdArgs.push_back((Object)A20.getValue());
            }
            if ((A20 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fdiagnostics_show_note_include_stack.getValue()), new OptSpecifier((long)options.ID.OPT_fno_diagnostics_show_note_include_stack.getValue()))) != null) {
                if (A20.getOption().matches(new OptSpecifier((long)options.ID.OPT_fdiagnostics_show_note_include_stack.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fdiagnostics-show-note-include-stack"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fno-diagnostics-show-note-include-stack"));
                }
            }
            Unnamed_enum ShowColors = Unnamed_enum.Colors_Auto;
            for (Arg Arg3 : Args) {
                Option O = Arg3.getOption();
                if (!O.matches(new OptSpecifier((long)options.ID.OPT_fcolor_diagnostics.getValue())) && !O.matches(new OptSpecifier((long)options.ID.OPT_fdiagnostics_color.getValue())) && !O.matches(new OptSpecifier((long)options.ID.OPT_fno_color_diagnostics.getValue())) && !O.matches(new OptSpecifier((long)options.ID.OPT_fno_diagnostics_color.getValue())) && !O.matches(new OptSpecifier((long)options.ID.OPT_fdiagnostics_color_EQ.getValue()))) continue;
                Arg3.claim();
                if (O.matches(new OptSpecifier((long)options.ID.OPT_fcolor_diagnostics.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fdiagnostics_color.getValue()))) {
                    ShowColors = Unnamed_enum.Colors_On;
                    continue;
                }
                if (O.matches(new OptSpecifier((long)options.ID.OPT_fno_color_diagnostics.getValue())) || O.matches(new OptSpecifier((long)options.ID.OPT_fno_diagnostics_color.getValue()))) {
                    ShowColors = Unnamed_enum.Colors_Off;
                    continue;
                }
                assert (O.matches(new OptSpecifier((long)options.ID.OPT_fdiagnostics_color_EQ.getValue())));
                StringRef value2 = new StringRef(Arg3.getValue());
                if (llvm.$eq_StringRef((StringRef)new StringRef(value2), (StringRef)new StringRef(NativePointer.$((String)"always")))) {
                    ShowColors = Unnamed_enum.Colors_On;
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(value2), (StringRef)new StringRef(NativePointer.$((String)"never")))) {
                    ShowColors = Unnamed_enum.Colors_Off;
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(value2), (StringRef)new StringRef(NativePointer.$((String)"auto")))) {
                    ShowColors = Unnamed_enum.Colors_Auto;
                    continue;
                }
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getToolChain().getDriver().Diag(309L), (StringRef)new StringRef(llvm.$plus_char$ptr_StringRef((char.ptr)NativePointer.$((String)"-fdiagnostics-color="), (StringRef)value2).str())).$destroy();
            }
            if (ShowColors == Unnamed_enum.Colors_On || ShowColors == Unnamed_enum.Colors_Auto && Process.StandardErrHasColors()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fcolor-diagnostics"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fansi_escape_codes.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fansi-escape-codes"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fshow_source_location.getValue()), new OptSpecifier((long)options.ID.OPT_fno_show_source_location.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-show-source-location"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fshow_column.getValue()), new OptSpecifier((long)options.ID.OPT_fno_show_column.getValue()), true)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-show-column"));
            }
            if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fspell_checking.getValue()), new OptSpecifier((long)options.ID.OPT_fno_spell_checking.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-spell-checking"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fasm_blocks.getValue()), new OptSpecifier((long)options.ID.OPT_fno_asm_blocks.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fasm-blocks"));
            }
            OptSpecifier VectorizeAliasOption = new OptSpecifier((EnableVec = ToolsStatics.shouldEnableVectorizerAtOLevel(Args, false)) ? (long)options.ID.OPT_O_Group.getValue() : (long)options.ID.OPT_fvectorize.getValue());
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fvectorize.getValue()), new OptSpecifier(VectorizeAliasOption), new OptSpecifier((long)options.ID.OPT_fno_vectorize.getValue()), EnableVec)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-vectorize-loops"));
            }
            OptSpecifier SLPVectAliasOption = new OptSpecifier((EnableSLPVec = ToolsStatics.shouldEnableVectorizerAtOLevel(Args, true)) ? (long)options.ID.OPT_O_Group.getValue() : (long)options.ID.OPT_fslp_vectorize.getValue());
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fslp_vectorize.getValue()), new OptSpecifier(SLPVectAliasOption), new OptSpecifier((long)options.ID.OPT_fno_slp_vectorize.getValue()), EnableSLPVec)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-vectorize-slp"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fslp_vectorize_aggressive.getValue()), new OptSpecifier((long)options.ID.OPT_fno_slp_vectorize_aggressive.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-vectorize-slp-aggressive"));
            }
            if ((A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fshow_overloads_EQ.getValue()))) != null) {
                A2.render(Args, (SmallVector)CmdArgs);
            }
            if ((A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fdollars_in_identifiers.getValue()), new OptSpecifier((long)options.ID.OPT_fno_dollars_in_identifiers.getValue()))) != null) {
                if (A2.getOption().matches(new OptSpecifier((long)options.ID.OPT_fdollars_in_identifiers.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fdollars-in-identifiers"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-fno-dollars-in-identifiers"));
                }
            }
            if ((A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_funit_at_a_time.getValue()), new OptSpecifier((long)options.ID.OPT_fno_unit_at_a_time.getValue()))) != null && A2.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_unit_at_a_time.getValue()))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(368L), (StringRef)new StringRef(A2.getAsString(Args))).$destroy();
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fapple_pragma_pack.getValue()), new OptSpecifier((long)options.ID.OPT_fno_apple_pragma_pack.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fapple-pragma-pack"));
            }
            if (this.getToolChain().getArch() == Triple.ArchType.le32) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fno-math-builtin"));
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_frewrite_includes.getValue()), new OptSpecifier((long)options.ID.OPT_fno_rewrite_includes.getValue()), false) || C.isForDiagnostics() && !HaveModules) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-frewrite-includes"));
            }
            if ((A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_traditional.getValue()), new OptSpecifier((long)options.ID.OPT_traditional_cpp.getValue()))) != null) {
                if (llvm.isa(PreprocessJobAction.class, (Object)JA)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-traditional-cpp"));
                } else {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(309L), (StringRef)new StringRef(A2.getAsString(Args))).$destroy();
                }
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_dM.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_dD.getValue()));
            A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__serialize_diags.getValue()));
            if (A2 != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-serialize-diagnostic-file"));
                CmdArgs.push_back((Object)Args.MakeArgString(A2.getValue()));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fretain_comments_from_system_headers.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-fretain-comments-from-system-headers"));
            }
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fcomment_block_commands.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_fparse_all_comments.getValue()));
            Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Xclang.getValue()));
            boolean OptDisabled = false;
            arg_iterator it3 = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_mllvm.getValue()));
            arg_iterator ie3 = Args.filtered_end();
            while (OptGlobals.$noteq_arg_iterator((arg_iterator)new arg_iterator(it3), (arg_iterator)new arg_iterator(ie3))) {
                it3.$star().claim();
                if (llvm.$eq_StringRef((StringRef)new StringRef(it3.$star().getValue(0L)), (StringRef)new StringRef(NativePointer.$((String)"-disable-llvm-optzns")))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-disable-llvm-optzns"));
                    OptDisabled = true;
                } else {
                    it3.$star().render(Args, (SmallVector)CmdArgs);
                }
                it3.$preInc();
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue())) && !OptDisabled && llvm.isa(CompileJobAction.class, (Object)JA)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-disable-llvm-optzns"));
            }
            if (Output.getType() != types.ID.TY_Dependencies) {
                if (Output.isFilename()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                    CmdArgs.push_back((Object)Output.getFilename());
                } else assert (Output.isNothing()) : "Invalid output.";
            }
            for (InputInfo II : Inputs) {
                ToolsStatics.addDashXForInput(Args, II, CmdArgs);
                if (II.isFilename()) {
                    CmdArgs.push_back((Object)II.getFilename());
                    continue;
                }
                II.getInputArg().renderAsInput(Args, (SmallVector)CmdArgs);
            }
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_undef.getValue()));
            char.ptr Exec = Native.$tryClone((char.ptr)this.getToolChain().getDriver().getClangProgramPath());
            if (this.getToolChain().UseDwarfDebugFlags()) {
                ArgStringList OriginalArgs = null;
                SmallString Flags = null;
                try {
                    OriginalArgs = new ArgStringList();
                    for (Arg Arg4 : Args) {
                        Arg4.render(Args, (SmallVector)OriginalArgs);
                    }
                    Flags = new SmallString(256);
                    Flags.$addassign(Exec);
                    long e = OriginalArgs.size();
                    for (long i = 0L; i != e; ++i) {
                        SmallString EscapedArg = null;
                        try {
                            EscapedArg = new SmallString(128);
                            ToolsStatics.EscapeSpacesAndBackslashes((char.ptr)OriginalArgs.$at(i), (SmallVectorImplChar)EscapedArg);
                            Flags.$addassign((CharSequence)" ");
                            Flags.$addassign((SmallVectorImplChar)EscapedArg);
                            continue;
                        }
                        finally {
                            if (EscapedArg != null) {
                                EscapedArg.$destroy();
                            }
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-dwarf-debug-flags"));
                    CmdArgs.push_back((Object)Args.MakeArgString(Flags.str()));
                }
                finally {
                    if (Flags != null) {
                        Flags.$destroy();
                    }
                    if (OriginalArgs != null) {
                        OriginalArgs.$destroy();
                    }
                }
            }
            boolean SplitDwarf = Args.hasArg(new OptSpecifier((long)options.ID.OPT_gsplit_dwarf.getValue())) && this.getToolChain().getTriple().isOSLinux() && (llvm.isa(AssembleJobAction.class, (Object)JA) || llvm.isa(CompileJobAction.class, (Object)JA) || llvm.isa(BackendJobAction.class, (Object)JA));
            char.ptr SplitDwarfOut = null;
            if (SplitDwarf) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-split-dwarf-file"));
                SplitDwarfOut = Native.$tryClone((char.ptr)ToolsStatics.SplitDebugName(Args, Inputs));
                CmdArgs.push_back((Object)SplitDwarfOut);
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_fallback.getValue())) && Output.getType() == types.ID.TY_Object && (InputType == types.ID.TY_C || InputType == types.ID.TY_CXX)) {
                std_ptr.unique_ptr<Command> CLCommand = this.getCLFallback().GetCommand(C, JA, Output, Inputs, Args, LinkingOutput);
                C.addCommand((std_ptr.unique_ptr<Command>)new std_ptr.unique_ptr(llvm.make_unique((Object)new FallbackCommand(JA, this, Exec, CmdArgs, (std_ptr.unique_ptr<Command>)std.move(CLCommand)))));
            } else {
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            if (SplitDwarf && !llvm.isa(CompileJobAction.class, (Object)JA) && !llvm.isa(BackendJobAction.class, (Object)JA)) {
                ToolsStatics.SplitDebugInfo(this.getToolChain(), C, this, JA, Args, Output, SplitDwarfOut);
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) != null && Args.hasArg(new OptSpecifier((long)options.ID.OPT_fomit_frame_pointer.getValue()))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(306L), (char.ptr)NativePointer.$((String)"-fomit-frame-pointer")), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
            }
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_fpch_preprocess.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_clang_ignored_f_Group.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_clang_ignored_m_Group.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue()));
        }
        finally {
            if (ModuleCachePath != null) {
                ModuleCachePath.$destroy();
            }
            if (ETriple != null) {
                ETriple.$destroy();
            }
            if (Triple2 != null) {
                Triple2.$destroy();
            }
            if (TT != null) {
                TT.$destroy();
            }
            if (CmdArgs != null) {
                CmdArgs.$destroy();
            }
        }
    }

    @Override
    public void $destroy() {
        this.CLFallback.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "CLFallback=" + this.CLFallback + super.toString();
    }

    private static final class Unnamed_enum
    extends Enum<Unnamed_enum> {
        public static final /* enum */ Unnamed_enum Colors_On = new Unnamed_enum(0L);
        public static final /* enum */ Unnamed_enum Colors_Off = new Unnamed_enum(Colors_On.getValue() + 1);
        public static final /* enum */ Unnamed_enum Colors_Auto = new Unnamed_enum(Colors_Off.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{Colors_On, Colors_Off, Colors_Auto};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }

    private static final class RewriteKind
    extends Enum<RewriteKind> {
        public static final /* enum */ RewriteKind RK_None = new RewriteKind(0L);
        public static final /* enum */ RewriteKind RK_Fragile = new RewriteKind(RK_None.getValue() + 1);
        public static final /* enum */ RewriteKind RK_NonFragile = new RewriteKind(RK_Fragile.getValue() + 1);
        private final int value;
        private static final /* synthetic */ RewriteKind[] $VALUES;

        public static RewriteKind[] values() {
            return (RewriteKind[])$VALUES.clone();
        }

        public static RewriteKind valueOf(String name) {
            return Enum.valueOf(RewriteKind.class, name);
        }

        public static RewriteKind valueOf(int val) {
            RewriteKind out;
            RewriteKind rewriteKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private RewriteKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new RewriteKind[]{RK_None, RK_Fragile, RK_NonFragile};
        }

        private static final class Values {
            private static final RewriteKind[] VALUES;
            private static final RewriteKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (RewriteKind kind : RewriteKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new RewriteKind[min < 0 ? 1 - min : 0];
                VALUES = new RewriteKind[max >= 0 ? 1 + max : 0];
                for (RewriteKind kind : RewriteKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((RewriteKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((RewriteKind)kind).value] = kind;
                }
            }
        }
    }
}

