/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Driver;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.sys.sys;

public final class arm {
    public static StringRef getARMTargetCPU(ArgList Args, Triple Triple2) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            StringRef MCPU = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)new StringRef(MCPU), (StringRef)new StringRef(NativePointer.$((String)"native")))) {
                return sys.getHostCPUName();
            }
            return MCPU;
        }
        return new StringRef(arm.getARMCPUForMArch(Args, Triple2));
    }

    public static char.ptr getARMCPUForMArch(ArgList Args, Triple Triple2) {
        std.string CPU;
        StringRef MArch = new StringRef();
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            MArch.$assign(new StringRef(A.getValue()));
        } else {
            MArch.$assign(Triple2.getArchName());
        }
        if (llvm.$eq_StringRef((StringRef)new StringRef(MArch), (StringRef)new StringRef(NativePointer.$((String)"native"))) && std.$noteq_str_T((std.string)(CPU = sys.getHostCPUName().$basic_string()), (char.iterator)NativePointer.$((String)"generic"))) {
            MArch.$assign(new StringRef(std.$plus_str_T((std.string)new std.string(NativePointer.$((String)"arm")), (char.iterator)arm.getLLVMArchSuffixForARM(new StringRef(CPU)))));
        }
        return Triple2.getARMCPUForArch(new StringRef(MArch));
    }

    public static char.ptr getLLVMArchSuffixForARM(StringRef CPU) {
        return (char.ptr)new StringSwitch(new StringRef(CPU)).Case(NativePointer.$((String)"strongarm"), (Object)NativePointer.$((String)"v4")).Cases(NativePointer.$((String)"arm7tdmi"), NativePointer.$((String)"arm7tdmi-s"), NativePointer.$((String)"arm710t"), (Object)NativePointer.$((String)"v4t")).Cases(NativePointer.$((String)"arm720t"), NativePointer.$((String)"arm9"), NativePointer.$((String)"arm9tdmi"), (Object)NativePointer.$((String)"v4t")).Cases(NativePointer.$((String)"arm920"), NativePointer.$((String)"arm920t"), NativePointer.$((String)"arm922t"), (Object)NativePointer.$((String)"v4t")).Cases(NativePointer.$((String)"arm940t"), NativePointer.$((String)"ep9312"), (Object)NativePointer.$((String)"v4t")).Cases(NativePointer.$((String)"arm10tdmi"), NativePointer.$((String)"arm1020t"), (Object)NativePointer.$((String)"v5")).Cases(NativePointer.$((String)"arm9e"), NativePointer.$((String)"arm926ej-s"), NativePointer.$((String)"arm946e-s"), (Object)NativePointer.$((String)"v5e")).Cases(NativePointer.$((String)"arm966e-s"), NativePointer.$((String)"arm968e-s"), NativePointer.$((String)"arm10e"), (Object)NativePointer.$((String)"v5e")).Cases(NativePointer.$((String)"arm1020e"), NativePointer.$((String)"arm1022e"), NativePointer.$((String)"xscale"), NativePointer.$((String)"iwmmxt"), (Object)NativePointer.$((String)"v5e")).Cases(NativePointer.$((String)"arm1136j-s"), NativePointer.$((String)"arm1136jf-s"), NativePointer.$((String)"arm1176jz-s"), (Object)NativePointer.$((String)"v6")).Cases(NativePointer.$((String)"arm1176jzf-s"), NativePointer.$((String)"mpcorenovfp"), NativePointer.$((String)"mpcore"), (Object)NativePointer.$((String)"v6")).Cases(NativePointer.$((String)"arm1156t2-s"), NativePointer.$((String)"arm1156t2f-s"), (Object)NativePointer.$((String)"v6t2")).Cases(NativePointer.$((String)"cortex-a5"), NativePointer.$((String)"cortex-a7"), NativePointer.$((String)"cortex-a8"), (Object)NativePointer.$((String)"v7")).Cases(NativePointer.$((String)"cortex-a9"), NativePointer.$((String)"cortex-a12"), NativePointer.$((String)"cortex-a15"), NativePointer.$((String)"cortex-a17"), NativePointer.$((String)"krait"), (Object)NativePointer.$((String)"v7")).Cases(NativePointer.$((String)"cortex-r4"), NativePointer.$((String)"cortex-r5"), (Object)NativePointer.$((String)"v7r")).Case(NativePointer.$((String)"cortex-m0"), (Object)NativePointer.$((String)"v6m")).Case(NativePointer.$((String)"cortex-m3"), (Object)NativePointer.$((String)"v7m")).Cases(NativePointer.$((String)"cortex-m4"), NativePointer.$((String)"cortex-m7"), (Object)NativePointer.$((String)"v7em")).Case(NativePointer.$((String)"swift"), (Object)NativePointer.$((String)"v7s")).Case(NativePointer.$((String)"cyclone"), (Object)NativePointer.$((String)"v8")).Cases(NativePointer.$((String)"cortex-a53"), NativePointer.$((String)"cortex-a57"), (Object)NativePointer.$((String)"v8")).Default((Object)NativePointer.$((String)""));
    }

    public static void appendEBLinkFlags(ArgList Args, ArgStringList CmdArgs, Triple Triple2) {
        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_r.getValue()))) {
            return;
        }
        StringRef Suffix = new StringRef(arm.getLLVMArchSuffixForARM(new StringRef(arm.getARMCPUForMArch(Args, Triple2))));
        char.ptr LinkFlag = Native.$tryClone((char.ptr)((char.ptr)new StringSwitch(new StringRef(Suffix)).Cases(NativePointer.$((String)"v4"), NativePointer.$((String)"v4t"), NativePointer.$((String)"v5"), NativePointer.$((String)"v5e"), null).Cases(NativePointer.$((String)"v6"), NativePointer.$((String)"v6t2"), null).Default((Object)NativePointer.$((String)"--be8"))));
        if (LinkFlag != null) {
            CmdArgs.push_back((Object)LinkFlag);
        }
    }

    public static StringRef getARMFloatABI(Driver D, ArgList Args, Triple Triple2) {
        StringRef FloatABI = new StringRef();
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()), new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()), new OptSpecifier((long)options.ID.OPT_mfloat_abi_EQ.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_msoft_float.getValue()))) {
                FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
            } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mhard_float.getValue()))) {
                FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
            } else {
                FloatABI.$assign(new StringRef(A.getValue()));
                if (llvm.$noteq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"soft"))) && llvm.$noteq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"softfp"))) && llvm.$noteq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"hard")))) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(325L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
                    FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
                }
            }
        }
        if (FloatABI.empty()) {
            block0 : switch (Triple2.getOS()) {
                case Darwin: 
                case MacOSX: 
                case IOS: {
                    std.string ArchName = new std.string(arm.getLLVMArchSuffixForARM(arm.getARMTargetCPU(Args, Triple2)));
                    if (new StringRef(ArchName).startswith((CharSequence)"v6") || new StringRef(ArchName).startswith((CharSequence)"v7")) {
                        FloatABI.$assign(new StringRef(NativePointer.$((String)"softfp")));
                        break;
                    }
                    FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
                    break;
                }
                case Win32: {
                    FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
                    break;
                }
                case FreeBSD: {
                    switch (Triple2.getEnvironment()) {
                        case GNUEABIHF: {
                            FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
                            break block0;
                        }
                    }
                    FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
                    break;
                }
                default: {
                    std.string ArchName;
                    switch (Triple2.getEnvironment()) {
                        case GNUEABIHF: {
                            FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
                            break block0;
                        }
                        case GNUEABI: {
                            FloatABI.$assign(new StringRef(NativePointer.$((String)"softfp")));
                            break block0;
                        }
                        case EABIHF: {
                            FloatABI.$assign(new StringRef(NativePointer.$((String)"hard")));
                            break block0;
                        }
                        case EABI: {
                            FloatABI.$assign(new StringRef(NativePointer.$((String)"softfp")));
                            break block0;
                        }
                        case Android: {
                            ArchName = new std.string(arm.getLLVMArchSuffixForARM(arm.getARMTargetCPU(Args, Triple2)));
                            if (new StringRef(ArchName).startswith((CharSequence)"v7")) {
                                FloatABI.$assign(new StringRef(NativePointer.$((String)"softfp")));
                                break block0;
                            }
                            FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
                            break block0;
                        }
                    }
                    FloatABI.$assign(new StringRef(NativePointer.$((String)"soft")));
                    if (Triple2.getOS() == Triple.OSType.UnknownOS && Triple2.isOSBinFormatMachO()) break;
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)D.Diag(367L), (char.ptr)NativePointer.$((String)"soft")).$destroy();
                }
            }
        }
        return FloatABI;
    }
}

