/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.LibOpenMP;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.impl.toolchains;
import org.clang.driver.options;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.sys.WindowsEncodingMethod;

public final class darwin {
    public static Triple.ArchType getArchTypeForMachOArchName(StringRef Str) {
        return (Triple.ArchType)new StringSwitch(Str).Cases(NativePointer.$((String)"ppc"), NativePointer.$((String)"ppc601"), NativePointer.$((String)"ppc603"), NativePointer.$((String)"ppc604"), NativePointer.$((String)"ppc604e"), (Object)Triple.ArchType.ppc).Cases(NativePointer.$((String)"ppc750"), NativePointer.$((String)"ppc7400"), NativePointer.$((String)"ppc7450"), NativePointer.$((String)"ppc970"), (Object)Triple.ArchType.ppc).Case(NativePointer.$((String)"ppc64"), (Object)Triple.ArchType.ppc64).Cases(NativePointer.$((String)"i386"), NativePointer.$((String)"i486"), NativePointer.$((String)"i486SX"), NativePointer.$((String)"i586"), NativePointer.$((String)"i686"), (Object)Triple.ArchType.x86).Cases(NativePointer.$((String)"pentium"), NativePointer.$((String)"pentpro"), NativePointer.$((String)"pentIIm3"), NativePointer.$((String)"pentIIm5"), NativePointer.$((String)"pentium4"), (Object)Triple.ArchType.x86).Cases(NativePointer.$((String)"x86_64"), NativePointer.$((String)"x86_64h"), (Object)Triple.ArchType.x86_64).Cases(NativePointer.$((String)"arm"), NativePointer.$((String)"armv4t"), NativePointer.$((String)"armv5"), NativePointer.$((String)"armv6"), NativePointer.$((String)"armv6m"), (Object)Triple.ArchType.arm).Cases(NativePointer.$((String)"armv7"), NativePointer.$((String)"armv7em"), NativePointer.$((String)"armv7k"), NativePointer.$((String)"armv7m"), (Object)Triple.ArchType.arm).Cases(NativePointer.$((String)"armv7s"), NativePointer.$((String)"xscale"), (Object)Triple.ArchType.arm).Case(NativePointer.$((String)"arm64"), (Object)Triple.ArchType.aarch64).Case(NativePointer.$((String)"r600"), (Object)Triple.ArchType.r600).Case(NativePointer.$((String)"amdgcn"), (Object)Triple.ArchType.amdgcn).Case(NativePointer.$((String)"nvptx"), (Object)Triple.ArchType.nvptx).Case(NativePointer.$((String)"nvptx64"), (Object)Triple.ArchType.nvptx64).Case(NativePointer.$((String)"amdil"), (Object)Triple.ArchType.amdil).Case(NativePointer.$((String)"spir"), (Object)Triple.ArchType.spir).Default((Object)Triple.ArchType.UnknownArch);
    }

    public static void setTripleTypeForMachOArchName(Triple T, StringRef Str) {
        Triple.ArchType Arch = darwin.getArchTypeForMachOArchName(Str);
        T.setArch(Arch);
        if (llvm.$eq_StringRef((StringRef)Str, (StringRef)new StringRef(NativePointer.$((String)"x86_64h")))) {
            T.setArchName(Str);
        } else if (llvm.$eq_StringRef((StringRef)Str, (StringRef)new StringRef(NativePointer.$((String)"armv6m"))) || llvm.$eq_StringRef((StringRef)Str, (StringRef)new StringRef(NativePointer.$((String)"armv7m"))) || llvm.$eq_StringRef((StringRef)Str, (StringRef)new StringRef(NativePointer.$((String)"armv7em")))) {
            T.setOS(Triple.OSType.UnknownOS);
            T.setObjectFormat(Triple.ObjectFormatType.MachO);
        }
    }

    public static class VerifyDebug
    extends MachOTool {
        public VerifyDebug(ToolChain TC) {
            super(NativePointer.$((String)"darwin::VerifyDebug"), NativePointer.$((String)"dwarfdump"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)NativePointer.$((String)"--verify"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--debug-info"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--quiet"));
                assert (Inputs.size() == 1) : "Unable to handle multiple inputs.";
                InputInfo Input = (InputInfo)Inputs.$at(0);
                assert (Input.isFilename()) : "Unexpected verify input";
                CmdArgs.push_back((Object)Input.getFilename());
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"dwarfdump"))));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Dsymutil
    extends MachOTool {
        public Dsymutil(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Dsymutil"), NativePointer.$((String)"dsymutil"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isDsymutilJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                assert (Inputs.size() == 1) : "Unable to handle multiple inputs.";
                InputInfo Input = (InputInfo)Inputs.$at(0);
                assert (Input.isFilename()) : "Unexpected dsymutil input.";
                CmdArgs.push_back((Object)Input.getFilename());
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"dsymutil"))));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Lipo
    extends MachOTool {
        public Lipo(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Lipo"), NativePointer.$((String)"lipo"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)NativePointer.$((String)"-create"));
                assert (Output.isFilename()) : "Unexpected lipo output.";
                CmdArgs.push_back((Object)NativePointer.$((String)"-output"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    assert (II.isFilename()) : "Unexpected lipo input.";
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"lipo"))));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Link
    extends MachOTool {
        private boolean NeedsTempPath(SmallVector<InputInfo> Inputs) {
            for (InputInfo Input : Inputs) {
                if (Input.getType() == types.ID.TY_Object) continue;
                return true;
            }
            return false;
        }

        private void AddLinkArgs(Compilation C, ArgList Args, ArgStringList CmdArgs, SmallVector<InputInfo> Inputs) {
            Driver D = this.getToolChain().getDriver();
            toolchains.MachO MachOTC = this.getMachOToolChain();
            long[] Version = NativePointer.new$long((int)3, (int[])new int[]{0, 0, 0});
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mlinker_version_EQ.getValue()));
            if (A != null) {
                bool.ref HadExtra = NativePointer.create_bool$ref((boolean)false);
                if (!Driver.GetReleaseVersion(A.getValue(), NativePointer.create_uint$ref((long[])Version, (long)0L), NativePointer.create_uint$ref((long[])Version, (long)1L), NativePointer.create_uint$ref((long[])Version, (long)2L), HadExtra) || HadExtra.$deref()) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(332L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
                }
            }
            if (Version[0] >= 100L && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_Z_Xlinker__no_demangle.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-demangle"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rdynamic.getValue())) && Version[0] >= 137L) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-export_dynamic"));
            }
            if (Version[0] >= 116L && D.IsUsingLTO(Args) && this.NeedsTempPath(Inputs)) {
                char.ptr TmpPath = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(D.GetTemporaryPath(new StringRef(NativePointer.$((String)"cc")), types.getTypeTempSuffix(types.ID.TY_Object))));
                C.addTempFile(TmpPath);
                CmdArgs.push_back((Object)NativePointer.$((String)"-object_path_lto"));
                CmdArgs.push_back((Object)TmpPath);
            }
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_static.getValue()));
            if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic"));
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fgnu_runtime.getValue()))) {
                // empty if block
            }
            if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_dynamiclib.getValue()))) {
                this.AddMachOArch(Args, CmdArgs);
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_force__cpusubtype__ALL.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_bundle.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_bundle__loader.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_client__name.getValue()));
                A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_compatibility__version.getValue()));
                if (A != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_current__version.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_install__name.getValue()))) != null) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(307L), (StringRef)new StringRef(A.getAsString(Args))), (char.ptr)NativePointer.$((String)"-dynamiclib")).$destroy();
                }
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_force__flat__namespace.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_keep__private__externs.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_private__bundle.getValue()));
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"-dylib"));
                A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_bundle.getValue()));
                if (A != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_bundle__loader.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_client__name.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_force__flat__namespace.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_keep__private__externs.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_private__bundle.getValue()))) != null) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(A.getAsString(Args))), (char.ptr)NativePointer.$((String)"-dynamiclib")).$destroy();
                }
                Args.AddAllArgsTranslated((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_compatibility__version.getValue()), NativePointer.$((String)"-dylib_compatibility_version"));
                Args.AddAllArgsTranslated((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_current__version.getValue()), NativePointer.$((String)"-dylib_current_version"));
                this.AddMachOArch(Args, CmdArgs);
                Args.AddAllArgsTranslated((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_install__name.getValue()), NativePointer.$((String)"-dylib_install_name"));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_all__load.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_allowable__client.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_bind__at__load.getValue()));
            if (MachOTC.isTargetIOSBased()) {
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_arch__errors__fatal.getValue()));
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_dead__strip.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_no__dead__strip__inits__and__terms.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_dylib__file.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_dynamic.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_exported__symbols__list.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_flat__namespace.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_force__load.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_headerpad__max__install__names.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_image__base.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_init.getValue()));
            MachOTC.addMinVersionArgs(Args, CmdArgs);
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_nomultidefs.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_multi__module.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_single__module.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_multiply__defined.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_multiply__defined__unused.getValue()));
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fpie.getValue()), new OptSpecifier((long)options.ID.OPT_fPIE.getValue()), new OptSpecifier((long)options.ID.OPT_fno_pie.getValue()), new OptSpecifier((long)options.ID.OPT_fno_PIE.getValue()));
            if (A != null) {
                if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fpie.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fPIE.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-no_pie"));
                }
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_prebind.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_noprebind.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_nofixprebinding.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_prebind__all__twolevel__modules.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_read__only__relocs.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_sectcreate.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_sectorder.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_seg1addr.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_segprot.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_segaddr.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_segs__read__only__addr.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_segs__read__write__addr.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_seg__addr__table.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_seg__addr__table__filename.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_sub__library.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_sub__umbrella.getValue()));
            StringRef sysroot = C.getSysRoot();
            if (llvm.$noteq_StringRef((StringRef)sysroot, (StringRef)StringRef.EMPTY)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-syslibroot"));
                CmdArgs.push_back((Object)C.getArgs().MakeArgString(sysroot));
            } else {
                Arg A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_isysroot.getValue()));
                if (A2 != null) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-syslibroot"));
                    CmdArgs.push_back((Object)A2.getValue());
                }
            }
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_twolevel__namespace.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_twolevel__namespace__hints.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_umbrella.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_undefined.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_unexported__symbols__list.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_weak__reference__mismatches.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_X_Flag.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_y.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_w.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_pagezero__size.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_segs__read__.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_seglinkedit.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_noseglinkedit.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_sectalign.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_sectobjectsymbols.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_segcreate.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_whyload.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_whatsloaded.getValue()));
            Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_dylinker__install__name.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_dylinker.getValue()));
            Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Mach.getValue()));
        }

        public Link(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Link"), NativePointer.$((String)"linker"), TC, Tool.ResponseFileSupport.RF_FileList, WindowsEncodingMethod.WEM_UTF8, NativePointer.$((String)"-filelist"));
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList InputFileList = null;
            ArgStringList CmdArgs = null;
            try {
                assert (Output.getType() == types.ID.TY_Image) : "Invalid linker output type.";
                InputFileList = new ArgStringList();
                CmdArgs = new ArgStringList();
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ccc_arcmt_check.getValue()), new OptSpecifier((long)options.ID.OPT_ccc_arcmt_migrate.getValue()))) {
                    for (Arg Arg2 : Args) {
                        Arg2.claim();
                    }
                    char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"touch"))));
                    CmdArgs.push_back((Object)Output.getFilename());
                    C.addCommand((std_ptr.unique_ptr<Command>)std.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
                    return;
                }
                this.AddLinkArgs(C, Args, CmdArgs, Inputs);
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_d_Flag.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_s.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_t.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Z_Flag.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_u_Group.getValue()));
                Args.AddLastArg((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_e.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_r.getValue()));
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ObjC.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_ObjCXX.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-ObjC"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    this.getMachOToolChain().addStartObjectFileArgs(Args, CmdArgs);
                }
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_L.getValue()));
                LibOpenMP UsedOpenMPLib = LibOpenMP.LibUnknown;
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fopenmp.getValue()))) {
                    UsedOpenMPLib = LibOpenMP.LibGOMP;
                } else {
                    Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fopenmp_EQ.getValue()));
                    if (A != null && (UsedOpenMPLib = (LibOpenMP)((Object)new StringSwitch(new StringRef(A.getValue())).Case(NativePointer.$((String)"libgomp"), (Object)LibOpenMP.LibGOMP).Case(NativePointer.$((String)"libiomp5"), (Object)LibOpenMP.LibIOMP5).Default((Object)LibOpenMP.LibUnknown))) == LibOpenMP.LibUnknown) {
                        ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getToolChain().getDriver().Diag(356L), (StringRef)A.getOption().getName()), (char.ptr)A.getValue()).$destroy();
                    }
                }
                switch (UsedOpenMPLib) {
                    case LibGOMP: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgomp"));
                        break;
                    }
                    case LibIOMP5: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-liomp5"));
                        break;
                    }
                }
                ToolsStatics.AddLinkerInputs(this.getToolChain(), Inputs, Args, CmdArgs);
                for (InputInfo II : Inputs) {
                    if (!II.isFilename()) {
                        if (InputFileList.size() <= 0) continue;
                        break;
                    }
                    InputFileList.push_back((Object)II.getFilename());
                }
                if (ToolsStatics.isObjCRuntimeLinked(Args) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    this.getMachOToolChain().AddLinkARCArgs(Args, CmdArgs);
                    CmdArgs.push_back((Object)NativePointer.$((String)"-framework"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"Foundation"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lobjc"));
                }
                if (LinkingOutput != null) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-arch_multiple"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-final_output"));
                    CmdArgs.push_back((Object)LinkingOutput);
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fnested_functions.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-allow_stack_execute"));
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    if (this.getToolChain().getDriver().CCCIsCXX()) {
                        this.getToolChain().AddCXXStdlibLibArgs(Args, CmdArgs);
                    }
                    this.getMachOToolChain().AddLinkRuntimeLibArgs(Args, CmdArgs);
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) || !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    // empty if block
                }
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_T_Group.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_F.getValue()));
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetLinkerPath()));
                std_ptr.unique_ptr Cmd = llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs));
                ((Command)Cmd.$arrow()).setInputFileList((ArgStringList)std.move((Object)InputFileList));
                C.addCommand((std_ptr.unique_ptr<Command>)std.move((std_ptr.unique_ptr)Cmd));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
                if (InputFileList != null) {
                    InputFileList.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assemble
    extends MachOTool {
        public Assemble(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Assemble"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                Triple T;
                CmdArgs = new ArgStringList();
                assert (Inputs.size() == 1) : "Unexpected number of inputs.";
                InputInfo Input = (InputInfo)Inputs.$at(0);
                Action SourceAction = JA;
                while (SourceAction.getKind() != Action.ActionClass.InputClass) {
                    assert (!SourceAction.getInputs().empty()) : "unexpected root action!";
                    SourceAction = (Action)SourceAction.getInputs().$at(0);
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fno_integrated_as.getValue())) && (!(T = new Triple(this.getToolChain().getTriple())).isMacOSX() || T.isMacOSXVersionLT(10L, 7L) == 0L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Q"));
                }
                if (SourceAction.getType() == types.ID.TY_Asm || SourceAction.getType() == types.ID.TY_PP_Asm) {
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_gstabs.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--gstabs"));
                    } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-g"));
                    }
                }
                this.AddMachOArch(Args, CmdArgs);
                if (this.getToolChain().getArch() == Triple.ArchType.x86 || this.getToolChain().getArch() == Triple.ArchType.x86_64 || Args.hasArg(new OptSpecifier((long)options.ID.OPT_force__cpusubtype__ALL.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-force_cpusubtype_ALL"));
                }
                if (this.getToolChain().getArch() != Triple.ArchType.x86_64 && ((Args.hasArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue()))) && this.getMachOToolChain().isKernelStatic() || Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-static"));
                }
                Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xassembler.getValue()));
                assert (Output.isFilename()) : "Unexpected lipo output.";
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                assert (Input.isFilename()) : "Invalid input.";
                CmdArgs.push_back((Object)Input.getFilename());
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"as"))));
                C.addCommand((std_ptr.unique_ptr<Command>)std.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static abstract class MachOTool
    extends Tool
    implements Destructors.ClassWithDestructor {
        protected void anchor() {
        }

        protected void AddMachOArch(ArgList Args, ArgStringList CmdArgs) {
            StringRef ArchName = this.getMachOToolChain().getMachOArchName(Args);
            CmdArgs.push_back((Object)NativePointer.$((String)"-arch"));
            CmdArgs.push_back((Object)Args.MakeArgString(ArchName));
            if (llvm.$eq_StringRef((StringRef)ArchName, (StringRef)new StringRef(NativePointer.$((String)"arm")))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-force_cpusubtype_ALL"));
            }
        }

        protected toolchains.MachO getMachOToolChain() {
            return (toolchains.MachO)this.getToolChain();
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC) {
            this(Name, ShortName, TC, Tool.ResponseFileSupport.RF_None, WindowsEncodingMethod.WEM_UTF8, NativePointer.$((String)"@"));
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC, Tool.ResponseFileSupport ResponseSupport) {
            this(Name, ShortName, TC, ResponseSupport, WindowsEncodingMethod.WEM_UTF8, NativePointer.$((String)"@"));
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC, Tool.ResponseFileSupport ResponseSupport, WindowsEncodingMethod ResponseEncoding) {
            this(Name, ShortName, TC, ResponseSupport, ResponseEncoding, NativePointer.$((String)"@"));
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC, Tool.ResponseFileSupport ResponseSupport, WindowsEncodingMethod ResponseEncoding, char.ptr ResponseFlag) {
            super(Name, ShortName, TC, ResponseSupport, ResponseEncoding, ResponseFlag);
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

