/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import java.util.Iterator;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.impl.toolchains;
import org.clang.driver.options;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.arm;
import org.clang.driver.tools.impl.mips;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class freebsd {

    public static class Link
    extends GnuTool {
        public Link(ToolChain TC) {
            super(NativePointer.$((String)"freebsd::Link"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                toolchains.FreeBSD ToolChain2 = (toolchains.FreeBSD)this.getToolChain();
                Driver D = ToolChain2.getDriver();
                boolean IsPIE = !Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) && (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pie.getValue())) || ToolChain2.isPIEDefault());
                CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_w.getValue()));
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"--sysroot="), (std.string)D.SysRoot)));
                }
                if (IsPIE) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                } else {
                    Triple.ArchType Arch;
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rdynamic.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bshareable"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"/libexec/ld-elf.so.1"));
                    }
                    if (ToolChain2.getTriple().getOSMajorVersion() >= 9L && ((Arch = ToolChain2.getArch()) == Triple.ArchType.arm || Arch == Triple.ArchType.sparc || Arch == Triple.ArchType.x86 || Arch == Triple.ArchType.x86_64)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--hash-style=both"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"--enable-new-dtags"));
                }
                if (ToolChain2.getArch() == Triple.ArchType.x86) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"elf_i386_fbsd"));
                }
                if (ToolChain2.getArch() == Triple.ArchType.ppc) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"elf32ppc_fbsd"));
                }
                if (Output.isFilename()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                    CmdArgs.push_back((Object)Output.getFilename());
                } else assert (Output.isNothing()) : "Invalid output.";
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    char.ptr crt1 = null;
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        crt1 = Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue())) ? NativePointer.$((String)"gcrt1.o") : (IsPIE ? NativePointer.$((String)"Scrt1.o") : NativePointer.$((String)"crt1.o"));
                    }
                    if (crt1 != null) {
                        CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(crt1)));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(NativePointer.$((String)"crti.o"))));
                    Iterator crtbegin = null;
                    crtbegin = Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) ? NativePointer.$((String)"crtbeginT.o") : (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) || IsPIE ? NativePointer.$((String)"crtbeginS.o") : NativePointer.$((String)"crtbegin.o"));
                    CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath((char.ptr)crtbegin)));
                }
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_L.getValue()));
                SmallVector<std.string> Paths = ToolChain2.getFilePaths();
                for (std.string Path : Paths) {
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_Twine((Twine)new Twine(new StringRef(NativePointer.$((String)"-L"))), (Twine)new Twine(Path))));
                }
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_T_Group.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_e.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_s.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_t.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Z_Flag.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_r.getValue()));
                if (D.IsUsingLTO(Args)) {
                    ToolsStatics.AddGoldPlugin(ToolChain2, Args, CmdArgs);
                }
                boolean NeedsSanitizerDeps = ToolsStatics.addSanitizerRuntimes(ToolChain2, Args, CmdArgs);
                ToolsStatics.AddLinkerInputs(ToolChain2, Inputs, Args, CmdArgs);
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    if (D.CCCIsCXX()) {
                        ToolChain2.AddCXXStdlibLibArgs(Args, CmdArgs);
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                        }
                    }
                    if (NeedsSanitizerDeps) {
                        ToolsStatics.linkSanitizerRuntimeDeps(ToolChain2, CmdArgs);
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
                    } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pthread.getValue()))) {
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        }
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc_p"));
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
                    } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                    }
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) || IsPIE) {
                        CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(NativePointer.$((String)"crtendS.o"))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(NativePointer.$((String)"crtend.o"))));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(ToolChain2.GetFilePath(NativePointer.$((String)"crtn.o"))));
                }
                ToolsStatics.addProfileRT(ToolChain2, Args, CmdArgs);
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetLinkerPath()));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assemble
    extends GnuTool {
        public Assemble(ToolChain TC) {
            super(NativePointer.$((String)"freebsd::Assemble"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                CmdArgs = new ArgStringList();
                if (this.getToolChain().getArch() == Triple.ArchType.x86) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.ppc) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-a32"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mipsel || this.getToolChain().getArch() == Triple.ArchType.mips64 || this.getToolChain().getArch() == Triple.ArchType.mips64el) {
                    StringRef CPUName = new StringRef();
                    StringRef ABIName = new StringRef();
                    mips.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), CPUName, ABIName);
                    CmdArgs.push_back((Object)NativePointer.$((String)"-march"));
                    CmdArgs.push_back((Object)CPUName.data());
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                    CmdArgs.push_back((Object)ToolsStatics.getGnuCompatibleMipsABIName(new StringRef(ABIName)).data());
                    if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mips64) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                    }
                    ToolsStatics.addAssemblerKPIC(Args, CmdArgs);
                } else if (this.getToolChain().getArch() == Triple.ArchType.arm || this.getToolChain().getArch() == Triple.ArchType.armeb || this.getToolChain().getArch() == Triple.ArchType.thumb || this.getToolChain().getArch() == Triple.ArchType.thumbeb) {
                    Triple Triple2;
                    Driver D = this.getToolChain().getDriver();
                    StringRef FloatABI = arm.getARMFloatABI(D, Args, Triple2 = this.getToolChain().getTriple());
                    if (llvm.$eq_StringRef((StringRef)new StringRef(FloatABI), (StringRef)new StringRef(NativePointer.$((String)"hard")))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=vfp"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=softvfp"));
                    }
                    switch (this.getToolChain().getTriple().getEnvironment()) {
                        case GNUEABIHF: 
                        case GNUEABI: 
                        case EABI: {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-meabi=5"));
                            break;
                        }
                        default: {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-matpcs"));
                            break;
                        }
                    }
                } else if (this.getToolChain().getArch() == Triple.ArchType.sparc || this.getToolChain().getArch() == Triple.ArchType.sparcv9) {
                    if (this.getToolChain().getArch() == Triple.ArchType.sparc) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Av8plusa"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Av9a"));
                    }
                    ToolsStatics.addAssemblerKPIC(Args, CmdArgs);
                }
                Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"as"))));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

