/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class mips {
    public static void getMipsCPUAndABI(ArgList Args, Triple Triple2, StringRef CPUName, StringRef ABIName) {
        Arg A;
        char.ptr DefMips32CPU = NativePointer.$((String)"mips32r2");
        char.ptr DefMips64CPU = NativePointer.$((String)"mips64r2");
        if (Triple2.getVendor() == Triple.VendorType.ImaginationTechnologies && Triple2.getEnvironment() == Triple.EnvironmentType.GNU) {
            DefMips32CPU = NativePointer.$((String)"mips32r6");
            DefMips64CPU = NativePointer.$((String)"mips64r6");
        }
        if (Triple2.getOS() == Triple.OSType.OpenBSD) {
            DefMips64CPU = NativePointer.$((String)"mips3");
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()))) != null) {
            CPUName.$assign(new StringRef(A.getValue()));
        }
        if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mabi_EQ.getValue()))) != null) {
            ABIName.$assign(new StringRef(A.getValue()));
            ABIName.$assign((StringRef)new StringSwitch(new StringRef(ABIName)).Case(NativePointer.$((String)"32"), (Object)new StringRef(NativePointer.$((String)"o32"))).Case(NativePointer.$((String)"64"), (Object)new StringRef(NativePointer.$((String)"n64"))).Default((Object)ABIName));
        }
        if (CPUName.empty() && ABIName.empty()) {
            switch (Triple2.getArch()) {
                default: {
                    throw new llvm_unreachable((CharSequence)"Unexpected triple arch name");
                }
                case mips: 
                case mipsel: {
                    CPUName.$assign(new StringRef(DefMips32CPU));
                    break;
                }
                case mips64: 
                case mips64el: {
                    CPUName.$assign(new StringRef(DefMips64CPU));
                }
            }
        }
        if (ABIName.empty()) {
            if (Triple2.getArch() == Triple.ArchType.mips || Triple2.getArch() == Triple.ArchType.mipsel) {
                ABIName.$assign(new StringRef(NativePointer.$((String)"o32")));
            } else {
                ABIName.$assign(new StringRef(NativePointer.$((String)"n64")));
            }
        }
        if (CPUName.empty()) {
            CPUName.$assign(new StringRef((char.ptr)new StringSwitch(new StringRef(ABIName)).Cases(NativePointer.$((String)"o32"), NativePointer.$((String)"eabi"), (Object)DefMips32CPU).Cases(NativePointer.$((String)"n32"), NativePointer.$((String)"n64"), (Object)DefMips64CPU).Default((Object)NativePointer.$((String)""))));
        }
    }

    public static boolean hasMipsAbiArg(ArgList Args, char.ptr Value) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mabi_EQ.getValue()));
        return A != null && llvm.$eq_StringRef((StringRef)new StringRef(A.getValue()), (StringRef)new StringRef(Value));
    }

    public static boolean isUCLibc(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_m_libc_Group.getValue()));
        return A != null && A.getOption().matches(new OptSpecifier((long)options.ID.OPT_muclibc.getValue()));
    }

    public static boolean isNaN2008(ArgList Args, Triple Triple2) {
        Arg NaNArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mnan_EQ.getValue()));
        if (NaNArg != null) {
            return (Boolean)new StringSwitch(new StringRef(NaNArg.getValue())).Case(NativePointer.$((String)"2008"), (Object)true).Case(NativePointer.$((String)"legacy"), (Object)false).Default((Object)false);
        }
        return (Boolean)new StringSwitch(new StringRef(ToolsStatics.getCPUName(Args, Triple2))).Cases(NativePointer.$((String)"mips32r6"), NativePointer.$((String)"mips64r6"), (Object)true).Default((Object)false);
    }

    public static boolean isFPXXDefault(Triple Triple2, StringRef CPUName, StringRef ABIName) {
        if (Triple2.getVendor() != Triple.VendorType.ImaginationTechnologies && Triple2.getVendor() != Triple.VendorType.MipsTechnologies) {
            return false;
        }
        if (llvm.$noteq_StringRef((StringRef)new StringRef(ABIName), (StringRef)new StringRef(NativePointer.$((String)"32")))) {
            return false;
        }
        return (Boolean)new StringSwitch(new StringRef(CPUName)).Cases(NativePointer.$((String)"mips2"), NativePointer.$((String)"mips3"), NativePointer.$((String)"mips4"), NativePointer.$((String)"mips5"), (Object)true).Cases(NativePointer.$((String)"mips32"), NativePointer.$((String)"mips32r2"), (Object)true).Cases(NativePointer.$((String)"mips64"), NativePointer.$((String)"mips64r2"), (Object)true).Default((Object)false);
    }
}

