/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints.formatstring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.highlight.hints.formatstring.FormatError;
import org.netbeans.modules.cnd.highlight.hints.formatstring.FormatStringAudit;
import org.openide.util.NbBundle;

class Utilities {
    Utilities() {
    }

    static boolean isFormattedPrintFunction(CsmObject object) {
        CsmFunction function;
        if (CsmKindUtilities.isFunction((CsmObject)object) && (function = (CsmFunction)object).getName().toString().endsWith("printf")) {
            CsmFile srcFile = function.getContainingFile();
            for (CsmInclude include : CsmFileInfoQuery.getDefault().getIncludeStack(srcFile)) {
                if (!include.getIncludeName().toString().equals("stdio.h")) continue;
                return true;
            }
        }
        return false;
    }

    static List<String> typeToFormat(String type) {
        if (type.contains("*")) {
            if (type.contains("wchar_t")) {
                return Arrays.asList("s", "p", "ls", "S");
            }
            if (type.contains("char")) {
                return Arrays.asList("s", "p", "hhn");
            }
            if (type.contains("short")) {
                return Arrays.asList("p", "hn");
            }
            if (type.contains("long long")) {
                return Arrays.asList("p", "lln");
            }
            if (type.contains("long")) {
                return Arrays.asList("p", "ln");
            }
            if (type.contains("intmax_t")) {
                return Arrays.asList("p", "jn");
            }
            if (type.contains("int")) {
                return Arrays.asList("p", "n");
            }
            if (type.contains("size_t")) {
                return Arrays.asList("p", "zn");
            }
            if (type.contains("ptrdiff_t")) {
                return Arrays.asList("p", "tn");
            }
            return Collections.singletonList("p");
        }
        if (type.startsWith("unsigned")) {
            if (type.contains("char")) {
                return Arrays.asList("hho", "hhu", "hhx", "hhX");
            }
            if (type.contains("short")) {
                return Arrays.asList("ho", "hu", "hx", "hX");
            }
            if (type.contains("long long")) {
                return Arrays.asList("llo", "llu", "llx", "llX");
            }
            if (type.contains("long")) {
                return Arrays.asList("lo", "lu", "lx", "lX");
            }
            if (type.contains("int")) {
                return Arrays.asList("o", "u", "x", "X");
            }
        } else {
            if (type.contains("signed char")) {
                return Arrays.asList("hhd", "hhi");
            }
            if (type.contains("char")) {
                return Arrays.asList("c");
            }
            if (type.contains("short")) {
                return Arrays.asList("hd", "hi");
            }
            if (type.contains("intmax_t")) {
                return Arrays.asList("jd", "ji");
            }
            if (type.contains("uintmax_t")) {
                return Arrays.asList("jo", "ju", "jx", "jX");
            }
            if (type.contains("size_t")) {
                return Arrays.asList("zd", "zi", "zo", "zu", "zx", "zX");
            }
            if (type.contains("ptrdiff_t")) {
                return Arrays.asList("td", "ti", "to", "tu", "tx", "tX");
            }
            if (type.contains("wint_t")) {
                return Arrays.asList("c", "lc", "C");
            }
            if (type.contains("float")) {
                return Arrays.asList("f", "lf", "llf", "F", "lF", "llF", "e", "le", "lle", "E", "lE", "llE", "g", "lg", "llg", "G", "lG", "llG", "a", "la", "lla", "A", "lA", "llA");
            }
            if (type.contains("long double")) {
                return Arrays.asList("f", "lf", "llf", "Lf", "F", "lF", "llF", "LF", "e", "le", "lle", "Le", "E", "lE", "llE", "LE", "g", "lg", "llg", "Lg", "G", "lG", "llG", "LG", "a", "la", "lla", "La", "A", "lA", "llA", "LA");
            }
            if (type.contains("double")) {
                return Arrays.asList("f", "lf", "llf", "F", "lF", "llF", "e", "le", "lle", "E", "lE", "llE", "g", "lg", "llg", "G", "lG", "llG", "a", "la", "lla", "A", "lA", "llA");
            }
            if (type.contains("long long")) {
                return Arrays.asList("lld", "lli");
            }
            if (type.contains("long")) {
                return Arrays.asList("ld", "li");
            }
            if (type.contains("int")) {
                return Arrays.asList("d", "i", "c");
            }
        }
        return Collections.EMPTY_LIST;
    }

    static String getMessageForError(FormatError error) {
        switch (error.getType()) {
            case FLAG: {
                return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.message.incompatibleFlag", (Object)error.getFlag(), (Object)error.getSpecifier());
            }
            case LENGTH: {
                return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.message.incompatibleLength", (Object)error.getFlag(), (Object)error.getSpecifier());
            }
            case TYPE_MISMATCH: {
                return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.message.type", (Object)error.getFlag(), (Object)error.getSpecifier());
            }
            case TYPE_NOTEXIST: {
                return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.message.notexist", (Object)error.getSpecifier());
            }
            case TYPE_WILDCARD: {
                return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.message.wildcard", (Object)error.getFlag());
            }
            case ARGS: {
                return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.message.argnum");
            }
        }
        return null;
    }
}

