/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.ignore;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.ignore.IgnoreAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class UnignoreAction
extends MultipleRepositoryAction {
    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        return this.unignore(repository, roots);
    }

    @Override
    protected boolean enableFull(Node[] activatedNodes) {
        boolean enabled = super.enableFull(activatedNodes);
        if (enabled) {
            enabled = false;
            FileStatusCache cache = Git.getInstance().getFileStatusCache();
            for (File root : this.getCurrentContext(activatedNodes).getRootFiles()) {
                if (!cache.getStatus(root).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) continue;
                File parent = root.getParentFile();
                enabled = parent == null || !cache.getStatus(parent).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED);
                break;
            }
        }
        return enabled;
    }

    public RequestProcessor.Task unignore(File repository, File[] roots) {
        final File[] toUnignore = UnignoreAction.filterRoots(roots);
        if (toUnignore.length == 0) {
            return null;
        }
        GitProgressSupport supp = new GitProgressSupport(){
            private final Set<File> notifiedFiles = new HashSet<File>();
            private File[] modifiedIgnores = new File[0];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(toUnignore));
                    client.addNotificationListener((NotificationListener)new FileListener(){

                        public void notifyFile(File file, String relativePathToRoot) {
                            notifiedFiles.add(file);
                        }
                    });
                    this.modifiedIgnores = client.unignore(toUnignore, this.getProgressMonitor());
                    ((IgnoreAction)SystemAction.get(IgnoreAction.class)).setEnabled(false);
                    ((UnignoreAction)SystemAction.get(UnignoreAction.class)).setEnabled(false);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    if (this.modifiedIgnores.length > 0) {
                        FileUtil.refreshFor((File[])this.modifiedIgnores);
                        this.notifiedFiles.addAll(Arrays.asList(this.modifiedIgnores));
                    }
                    if (!this.notifiedFiles.isEmpty()) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), this.notifiedFiles));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(UnignoreAction.class, (String)"LBL_UnignoreAction.progressName"));
        return supp.getTask();
    }

    private static File[] filterRoots(File[] roots) {
        LinkedList<File> toUnignore = new LinkedList<File>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (File root : roots) {
            FileInformation info = cache.getStatus(root);
            if (!info.containsStatus(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED))) continue;
            toUnignore.add(root);
        }
        return toUnignore.toArray(new File[toUnignore.size()]);
    }
}

