/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.RevisionInfoListener;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.versioning.history.LinkButton;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class RevisionListPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private ProgressMonitor.DefaultProgressMonitor listHistoryMonitor;
    private final List<GitRevisionInfoDelegate> revisionModel;
    private final DefaultListModel revisionDisplayModel;
    private GitProgressSupport supp;
    private final Object LOCK = new Object();
    private String lastHWRevision;
    private File lastHWRepository;
    private Revision currRevision;
    private File currRepository;
    private File[] currRoots;
    private int currLimit;
    private boolean addition;
    private final int DEFAULT_LIMIT = 10;
    private LinkButton btnAll;
    private LinkButton btnNext10;
    private LinkButton btnRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    final JList lstRevisions = new JList();
    private JTextField txtFilter;

    public RevisionListPanel() {
        this.revisionModel = new ArrayList<GitRevisionInfoDelegate>();
        this.revisionDisplayModel = new DefaultListModel();
        this.lstRevisions.setModel(this.revisionDisplayModel);
        this.lstRevisions.setFixedCellHeight(-1);
        this.lstRevisions.setCellRenderer(new RevisionRenderer());
        this.initComponents();
        this.attachListeners();
    }

    @Override
    public void removeNotify() {
        this.cancelBackgroundTasks();
        super.removeNotify();
    }

    private void attachListeners() {
        this.btnAll.addActionListener((ActionListener)this);
        this.btnNext10.addActionListener((ActionListener)this);
        this.btnRefresh.addActionListener((ActionListener)this);
        this.txtFilter.getDocument().addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateFilter();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateFilter();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        int limit;
        Revision revision;
        File[] roots;
        File repo;
        boolean add = true;
        Object object = this.LOCK;
        synchronized (object) {
            repo = this.currRepository;
            roots = this.currRoots;
            revision = this.currRevision;
            limit = this.currLimit;
        }
        if (this.btnAll == e.getSource()) {
            limit = -1;
        } else if (this.btnNext10 == e.getSource()) {
            limit += 10;
        } else if (this.btnRefresh == e.getSource()) {
            add = false;
            limit = 10;
        }
        this.updateHistory(repo, roots, revision, limit, add);
    }

    GitRevisionInfo getSelectedRevision() {
        GitRevisionInfoDelegate delegate = (GitRevisionInfoDelegate)this.lstRevisions.getSelectedValue();
        return delegate == null ? null : delegate.info;
    }

    private void updateFilter() {
        this.revisionDisplayModel.clear();
        for (GitRevisionInfoDelegate info : this.revisionModel) {
            if (!this.applyToFilter(info)) continue;
            this.revisionDisplayModel.addElement(info);
        }
    }

    private void addToDisplayModel(GitRevisionInfoDelegate info) {
        if (this.applyToFilter(info)) {
            this.revisionDisplayModel.addElement(info);
        }
    }

    private boolean applyToFilter(GitRevisionInfoDelegate info) {
        String filter = this.txtFilter.getText().toLowerCase();
        boolean apply = info.getMessage().toLowerCase().contains(filter) || info.getRevision().toLowerCase().contains(filter);
        return apply;
    }

    private void enableButtons(final boolean enabled) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RevisionListPanel.this.btnAll.setEnabled(enabled);
                RevisionListPanel.this.btnNext10.setEnabled(enabled);
                RevisionListPanel.this.btnRefresh.setEnabled(enabled);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelBackgroundTasks() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.supp != null) {
                this.supp.cancel();
            }
            if (this.listHistoryMonitor != null) {
                this.listHistoryMonitor.cancel();
            }
        }
    }

    void updateHistory(File repository, File[] roots, Revision revision) {
        this.updateHistory(repository, roots, revision, 10, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(File repository, File[] roots, Revision revision, int limit, Boolean addition) {
        Object object = this.LOCK;
        synchronized (object) {
            if (addition == null && (repository == this.lastHWRepository || this.lastHWRepository != null && this.lastHWRepository.equals(repository)) && (revision == null && this.lastHWRevision == null || this.lastHWRevision != null && revision != null && this.lastHWRevision.equals(revision.getCommitId()))) {
                return;
            }
            this.addition = Boolean.TRUE.equals(addition);
            this.lastHWRepository = repository;
            this.lastHWRevision = revision == null ? null : revision.getCommitId();
            this.currRepository = repository;
            this.currRevision = revision;
            this.currRoots = roots;
            this.currLimit = limit;
            this.cancelBackgroundTasks();
            this.supp = new ListHistoryProgressSupport();
            this.supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(RevisionListPanel.class, (String)"LBL_RevisionList.LoadingRevisions"));
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.btnNext10 = new LinkButton();
        this.jLabel2 = new JLabel();
        this.btnAll = new LinkButton();
        this.jLabel3 = new JLabel();
        this.btnRefresh = new LinkButton();
        this.jLabel4 = new JLabel();
        this.txtFilter = new JTextField();
        this.lstRevisions.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstRevisions);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNext10, (String)NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.btnNext10.text"));
        this.btnNext10.setToolTipText(NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.btnNext10.TTtext"));
        this.btnNext10.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAll, (String)NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.btnAll.text"));
        this.btnAll.setToolTipText(NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.btnAll.TTtext"));
        this.btnAll.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefresh, (String)NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.btnRefresh.text"));
        this.btnRefresh.setToolTipText(NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.btnRefresh.toolTipText"));
        this.jLabel4.setLabelFor(this.txtFilter);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.jLabel4.text"));
        this.jLabel4.setToolTipText(NbBundle.getMessage(RevisionListPanel.class, (String)"RevisionListPanel.jLabel4.TTtext"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 402, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnNext10, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jLabel2).addGap(5, 5, 5).addComponent((Component)this.btnAll, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jLabel3).addGap(5, 5, 5).addComponent((Component)this.btnRefresh, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFilter))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 22, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.btnNext10, -2, -1, -2).addComponent((Component)this.btnAll, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent((Component)this.btnRefresh, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.txtFilter, -2, -1, -2))));
    }

    private static class GitRevisionInfoDelegate {
        private final GitRevisionInfo info;

        public GitRevisionInfoDelegate(GitRevisionInfo info) {
            this.info = info;
        }

        public String getRevision() {
            return this.info.getRevision();
        }

        public String getMessage() {
            return this.info.getShortMessage();
        }

        public String toString() {
            return this.getRevision();
        }
    }

    private class ListHistoryProgressSupport
    extends GitProgressSupport.NoOutputLogging
    implements RevisionInfoListener,
    ListSelectionListener {
        private final List<GitRevisionInfo> revisions = new LinkedList<GitRevisionInfo>();
        private final Set<String> displayedRevisions = new HashSet<String>(10);
        private boolean reselected;
        private GitRevisionInfoDelegate selectedRevision;
        private int limit;

        private ListHistoryProgressSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void perform() {
            boolean add;
            File[] roots;
            File repository;
            Revision rev;
            List<GitRevisionInfo> list = RevisionListPanel.this.LOCK;
            synchronized (list) {
                rev = RevisionListPanel.this.currRevision;
                repository = RevisionListPanel.this.currRepository;
                roots = RevisionListPanel.this.currRoots;
                this.limit = RevisionListPanel.this.currLimit;
                add = RevisionListPanel.this.addition;
            }
            list = this.revisions;
            synchronized (list) {
                this.revisions.clear();
            }
            if (repository != null) {
                boolean isFinished;
                RevisionListPanel.this.listHistoryMonitor = new ProgressMonitor.DefaultProgressMonitor();
                if (this.isCanceled()) {
                    return;
                }
                boolean finished = false;
                try {
                    GitClient client = this.getClient();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ListHistoryProgressSupport.this.selectedRevision = (GitRevisionInfoDelegate)RevisionListPanel.this.lstRevisions.getSelectedValue();
                            ListHistoryProgressSupport.this.displayedRevisions.clear();
                            if (add) {
                                for (GitRevisionInfoDelegate info : RevisionListPanel.this.revisionModel) {
                                    ListHistoryProgressSupport.this.displayedRevisions.add(info.getRevision());
                                }
                            } else {
                                RevisionListPanel.this.revisionModel.clear();
                                RevisionListPanel.this.updateFilter();
                            }
                            ListHistoryProgressSupport.this.reselected = false;
                            RevisionListPanel.this.enableButtons(false);
                        }
                    });
                    RevisionListPanel.this.lstRevisions.addListSelectionListener(this);
                    client.addNotificationListener((NotificationListener)this);
                    SearchCriteria criteria = new SearchCriteria();
                    criteria.setFiles(roots);
                    if (this.limit > 0) {
                        criteria.setLimit(this.limit + 1);
                    }
                    if (rev != null) {
                        criteria.setRevisionTo(rev.getCommitId());
                    }
                    final GitRevisionInfo[] revs = client.log(criteria, false, (ProgressMonitor)RevisionListPanel.this.listHistoryMonitor);
                    if (!this.isCanceled()) {
                        finished = true;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RevisionListPanel.this.btnRefresh.setEnabled(true);
                                if (ListHistoryProgressSupport.this.limit > 0 && revs.length > ListHistoryProgressSupport.this.limit) {
                                    RevisionListPanel.this.btnAll.setEnabled(true);
                                    RevisionListPanel.this.btnNext10.setEnabled(true);
                                }
                            }
                        });
                    }
                    isFinished = finished;
                    RevisionListPanel.this.lstRevisions.removeListSelectionListener(this);
                }
                catch (GitException.MissingObjectException ex) {
                    if (ex.getObjectType() != GitObjectType.HEAD) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    boolean isFinished2 = finished;
                    RevisionListPanel.this.lstRevisions.removeListSelectionListener(this);
                    EventQueue.invokeLater(new Runnable(isFinished2){
                        final /* synthetic */ boolean val$isFinished;
                        {
                            this.val$isFinished = bl;
                        }

                        @Override
                        public void run() {
                            if (!this.val$isFinished) {
                                RevisionListPanel.this.enableButtons(true);
                            }
                            ListHistoryProgressSupport.this.selectedRevision = null;
                        }
                    });
                }
                catch (GitException ex2) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex2), true);
                    boolean isFinished3 = finished;
                    RevisionListPanel.this.lstRevisions.removeListSelectionListener(this);
                    {
                        catch (Throwable throwable) {
                            boolean isFinished4 = finished;
                            RevisionListPanel.this.lstRevisions.removeListSelectionListener(this);
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyRevisionInfo(GitRevisionInfo revisionInfo) {
            List<GitRevisionInfo> list = this.revisions;
            synchronized (list) {
                this.revisions.add(revisionInfo);
            }
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ListHistoryProgressSupport.this.revisions;
                    synchronized (list) {
                        while (!ListHistoryProgressSupport.this.revisions.isEmpty()) {
                            GitRevisionInfoDelegate info = new GitRevisionInfoDelegate((GitRevisionInfo)ListHistoryProgressSupport.this.revisions.remove(0));
                            if (ListHistoryProgressSupport.this.limit >= 0 && ListHistoryProgressSupport.this.limit <= RevisionListPanel.this.revisionModel.size() || ListHistoryProgressSupport.this.displayedRevisions.contains(info.getRevision())) continue;
                            RevisionListPanel.this.revisionModel.add(info);
                            RevisionListPanel.this.addToDisplayModel(info);
                            if (ListHistoryProgressSupport.this.reselected || ListHistoryProgressSupport.this.selectedRevision == null || !info.getRevision().equals(ListHistoryProgressSupport.this.selectedRevision.getRevision())) continue;
                            RevisionListPanel.this.lstRevisions.setSelectedValue(info, false);
                            ListHistoryProgressSupport.this.reselected = true;
                            ListHistoryProgressSupport.this.selectedRevision = null;
                        }
                    }
                }
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && e.getLastIndex() > -1 && e.getFirstIndex() > -1) {
                this.reselected = true;
                this.selectedRevision = null;
            }
        }
    }

    private class RevisionRenderer
    extends JTextPane
    implements ListCellRenderer {
        private Style selectedStyle;
        private Style normalStyle;
        private Color selectionBackground = new JList().getSelectionBackground();
        private Color selectionForeground = new JList().getSelectionForeground();

        public RevisionRenderer() {
            this.selectedStyle = this.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, this.selectionForeground);
            StyleConstants.setBackground(this.selectedStyle, this.selectionBackground);
            this.normalStyle = this.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.setLayout(new BorderLayout());
            this.setBorder(null);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Style style;
            Color backgroundColor;
            GitRevisionInfoDelegate revision = (GitRevisionInfoDelegate)value;
            StyledDocument sd = this.getStyledDocument();
            String tooltip = null;
            if (isSelected) {
                backgroundColor = this.selectionBackground;
                style = this.selectedStyle;
            } else {
                backgroundColor = UIManager.getColor("List.background");
                style = this.normalStyle;
            }
            this.setBackground(backgroundColor);
            try {
                StringBuilder sb = new StringBuilder();
                String revStr = revision.getRevision();
                sb.append(revStr.length() > 7 ? revStr.substring(0, 7) : revStr).append(" - ");
                sb.append(revision.getMessage());
                tooltip = sb.toString();
                sd.remove(0, sd.getLength());
                String text = sb.toString();
                sd.insertString(0, text, style);
                String filter = RevisionListPanel.this.txtFilter.getText().toLowerCase();
                if (!isSelected && !filter.isEmpty()) {
                    text = text.toLowerCase();
                    int pos = -filter.length();
                    while ((pos = text.indexOf(filter, pos + filter.length())) > -1) {
                        sd.setCharacterAttributes(pos, filter.length(), this.selectedStyle, false);
                    }
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }
}

