/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp.file;

import java.awt.EventQueue;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.gulp.exec.GulpExecutable;
import org.netbeans.modules.javascript.gulp.file.Gulpfile;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public final class GulpTasks
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(GulpTasks.class.getName());
    public static final String DEFAULT_TASK = "default";
    private final Project project;
    final FileChangeListener nodeModulesListener = new NodeModulesListener();
    private volatile List<String> tasks;

    private GulpTasks(Project project) {
        assert (project != null);
        this.project = project;
    }

    public static GulpTasks create(Project project, Gulpfile gulpfile) {
        assert (project != null);
        assert (gulpfile != null);
        GulpTasks gulpTasks = new GulpTasks(project);
        gulpfile.addChangeListener(gulpTasks);
        FileUtil.addFileChangeListener((FileChangeListener)gulpTasks.nodeModulesListener, (File)new File(gulpfile.getFile().getParent(), "node_modules"));
        return gulpTasks;
    }

    @CheckForNull
    public List<String> getTasks() {
        List<String> tasksRef = this.tasks;
        return tasksRef == null ? null : Collections.unmodifiableList(tasksRef);
    }

    public List<String> loadTasks(@NullAllowed Long timeout, @NullAllowed TimeUnit unit) throws ExecutionException, TimeoutException {
        List<String> tasksRef = this.tasks;
        if (tasksRef != null) {
            return Collections.unmodifiableList(tasksRef);
        }
        assert (!EventQueue.isDispatchThread());
        Future<List<String>> tasksJob = this.getTasksJob();
        if (tasksJob == null) {
            return null;
        }
        try {
            List<String> allTasks;
            if (timeout != null) {
                assert (unit != null);
                allTasks = tasksJob.get(timeout, unit);
            } else {
                allTasks = tasksJob.get();
            }
            this.tasks = new CopyOnWriteArrayList<String>(allTasks);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this.getTasks();
    }

    @CheckForNull
    private Future<List<String>> getTasksJob() {
        GulpExecutable gulp = GulpExecutable.getDefault(this.project, false);
        if (gulp == null) {
            return null;
        }
        return gulp.listTasks();
    }

    public void reset() {
        this.tasks = null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.reset();
    }

    private final class NodeModulesListener
    extends FileChangeAdapter {
        private NodeModulesListener() {
        }

        public void fileRenamed(FileRenameEvent fe) {
            GulpTasks.this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            GulpTasks.this.reset();
        }

        public void fileFolderCreated(FileEvent fe) {
            GulpTasks.this.reset();
        }
    }
}

