/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public abstract class ProfilingPointFactory {
    public static final String AVAILABILITY_PROPERTY = ProfilingPointFactory.class.getName() + "#AVAILABILITY";
    private static final String PROFILING_POINT_STORAGE_EXT = "pp";
    public static final int SCOPE_CODE = 1;
    public static final int SCOPE_GLOBAL = 2;
    public static final Icon SCOPE_CODE_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Code");
    public static final Icon SCOPE_GLOBAL_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Global");
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ValidityAwarePanel customizer = null;

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isAvailable() {
        return true;
    }

    public abstract String getDescription();

    public String getHint() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract Icon getDisabledIcon();

    public abstract int getScope();

    public abstract String getType();

    public ProfilingPoint create() {
        return this.create(null);
    }

    public abstract ProfilingPoint create(Lookup.Provider var1);

    public abstract boolean supportsCPU();

    public abstract boolean supportsMemory();

    public abstract boolean supportsMonitor();

    public Icon getScopeIcon() {
        switch (this.getScope()) {
            case 1: {
                return SCOPE_CODE_ICON;
            }
            case 2: {
                return SCOPE_GLOBAL_ICON;
            }
        }
        return null;
    }

    protected abstract Class getProfilingPointsClass();

    protected abstract ValidityAwarePanel createCustomizer();

    protected abstract ProfilingPoint loadProfilingPoint(Lookup.Provider var1, Properties var2, int var3);

    protected abstract void storeProfilingPoint(ProfilingPoint var1, int var2, Properties var3);

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    ValidityAwarePanel getCustomizer() {
        if (this.customizer == null) {
            this.customizer = this.createCustomizer();
        }
        ValidityAwarePanel safeCustomizer = ProfilingPointsManager.getDefault().safeGetCustomizer(this.customizer);
        return safeCustomizer;
    }

    ProfilingPoint[] loadProfilingPoints(Lookup.Provider project) throws IOException, InvalidPropertiesFormatException {
        Properties properties = new Properties();
        ProfilerStorage.loadProjectProperties((Properties)properties, (Lookup.Provider)project, (String)this.getProfilingPointsStorage());
        int index = 0;
        ArrayList<ProfilingPoint> profilingPoints = new ArrayList<ProfilingPoint>();
        while (properties.getProperty(index + "_" + "p_name") != null) {
            ProfilingPoint profilingPoint = this.loadProfilingPoint(project, properties, index);
            if (profilingPoint != null) {
                profilingPoints.add(profilingPoint);
            } else {
                ErrorManager.getDefault().log(65536, "Invalid " + this.getType() + " Profiling Point format at index " + index + " in project " + ProjectUtilities.getDisplayName((Lookup.Provider)project));
            }
            ++index;
        }
        ProfilingPoint[] profilingPointsArr = new ProfilingPoint[profilingPoints.size()];
        profilingPoints.toArray(profilingPointsArr);
        return profilingPointsArr;
    }

    void saveProfilingPoints(Lookup.Provider project) throws IOException {
        List<ProfilingPoint> profilingPoints = ProfilingPointsManager.getDefault().getProfilingPoints(this.getProfilingPointsClass(), project, false);
        this.saveProfilingPoints(profilingPoints.toArray(new ProfilingPoint[profilingPoints.size()]), project);
    }

    private void saveProfilingPoints(ProfilingPoint[] profilingPoints, Lookup.Provider project) throws IOException {
        String storage = this.getProfilingPointsStorage();
        if (profilingPoints.length > 0) {
            Properties properties = new Properties();
            for (int i = 0; i < profilingPoints.length; ++i) {
                this.storeProfilingPoint(profilingPoints[i], i, properties);
            }
            ProfilerStorage.saveProjectProperties((Properties)properties, (Lookup.Provider)project, (String)storage);
        } else {
            ProfilerStorage.deleteProjectProperties((Lookup.Provider)project, (String)storage);
        }
    }

    private String getProfilingPointsStorage() {
        String fullClass = this.getProfilingPointsClass().getName();
        return fullClass.substring(fullClass.lastIndexOf(46) + 1);
    }
}

