/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;

public final class RepositoryInfo {
    static final String DEFAULT_INDEX_SUFFIX = ".index/";
    private final String id;
    @NonNull
    private final String name;
    private final String repositoryPath;
    private final String repositoryUrl;
    private final String indexUpdateUrl;
    private final List<RepositoryInfo> mirrorOf = new ArrayList<RepositoryInfo>();
    private MirrorStrategy mirrorStrategy = MirrorStrategy.NON_WILDCARD;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public RepositoryInfo(String id, @NullAllowed String name, String repositoryPath, String repositoryUrl) throws URISyntaxException {
        this(id, name, repositoryPath, repositoryUrl, null);
    }

    RepositoryInfo(String id, @NullAllowed String name, String repositoryPath, String repositoryUrl, String indexUpdateUrl) throws URISyntaxException {
        this.id = id;
        this.name = name != null ? name : id;
        this.repositoryPath = repositoryPath;
        if (repositoryUrl != null && !repositoryUrl.endsWith("/")) {
            repositoryUrl = repositoryUrl + "/";
        }
        if (repositoryUrl != null) {
            new URI(repositoryUrl);
        }
        this.repositoryUrl = repositoryUrl;
        String string = this.indexUpdateUrl = indexUpdateUrl != null ? indexUpdateUrl : (repositoryUrl != null ? repositoryUrl + DEFAULT_INDEX_SUFFIX : null);
        if (!this.isLocal() ^ this.isRemoteDownloadable()) {
            throw new IllegalArgumentException("Cannot have both local and remote index fields filled in. Repository: " + id + " Path=" + repositoryPath + " Remote URL:" + indexUpdateUrl);
        }
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    @CheckForNull
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @CheckForNull
    public String getIndexUpdateUrl() {
        return this.indexUpdateUrl;
    }

    public boolean isRemoteDownloadable() {
        return this.indexUpdateUrl != null;
    }

    public boolean isLocal() {
        return this.repositoryPath != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeIndex() {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMirror() {
        List<RepositoryInfo> list = this.mirrorOf;
        synchronized (list) {
            return !this.mirrorOf.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryInfo> getMirroredRepositories() {
        List<RepositoryInfo> list = this.mirrorOf;
        synchronized (list) {
            return new ArrayList<RepositoryInfo>(this.mirrorOf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMirrorOfRepository(RepositoryInfo info) {
        assert (this.isRemoteDownloadable());
        List<RepositoryInfo> list = this.mirrorOf;
        synchronized (list) {
            this.mirrorOf.add(info);
        }
    }

    public MirrorStrategy getMirrorStrategy() {
        return this.mirrorStrategy;
    }

    public void setMirrorStrategy(MirrorStrategy mirrorStrategy) {
        this.mirrorStrategy = mirrorStrategy;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryInfo other = (RepositoryInfo)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.repositoryPath == null ? other.repositoryPath != null : !this.repositoryPath.equals(other.repositoryPath)) {
            return false;
        }
        return !(this.repositoryUrl == null ? other.repositoryUrl != null : !this.repositoryUrl.equals(other.repositoryUrl));
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 53 * hash + (this.repositoryPath != null ? this.repositoryPath.hashCode() : 0);
        hash = 53 * hash + (this.repositoryUrl != null ? this.repositoryUrl.hashCode() : 0);
        return hash;
    }

    public static enum MirrorStrategy {
        NONE,
        ALL,
        NON_WILDCARD;

    }
}

