/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.indexer.NexusRepositoryIndexerImpl;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.QueryRequest;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.Redo;
import org.netbeans.modules.project.spi.intern.ProjectIDEServices;
import org.openide.util.Lookup;

public final class RepositoryQueries {
    @NonNull
    private static BaseQueries findBaseQueries() {
        return (BaseQueries)Lookup.getDefault().lookup(BaseQueries.class);
    }

    public static Result<String> getGroupsResult(@NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().getGroups(repos);
    }

    public static Result<String> filterGroupIdsResult(String prefix, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().filterGroupIds(prefix, repos);
    }

    public static Result<NBVersionInfo> getRecordsResult(String groupId, String artifactId, String version, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().getRecords(groupId, artifactId, version, repos);
    }

    public static Result<String> getGAVsForPackaging(String packaging, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().getGAVsForPackaging(packaging, repos);
    }

    public static Result<String> getArtifactsResult(String groupId, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().getArtifacts(groupId, repos);
    }

    public static Result<NBVersionInfo> getVersionsResult(String groupId, String artifactId, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().getVersions(groupId, artifactId, repos);
    }

    @NonNull
    private static DependencyInfoQueries findDIQ() {
        return (DependencyInfoQueries)Lookup.getDefault().lookup(DependencyInfoQueries.class);
    }

    public static Result<NBGroupInfo> findDependencyUsageResult(String groupId, String artifactId, String version, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findDIQ().findDependencyUsageGroups(groupId, artifactId, version, repos);
    }

    public static Result<NBVersionInfo> findBySHA1Result(File file, @NullAllowed List<RepositoryInfo> repos) {
        try {
            String calculateChecksum = RepositoryUtil.calculateSHA1Checksum(file);
            return RepositoryQueries.findBySHA1(calculateChecksum, repos);
        }
        catch (IOException ex) {
            Logger.getLogger(RepositoryQueries.class.getName()).log(Level.INFO, "Could not determine SHA-1 of " + file, ex);
            return NexusRepositoryIndexerImpl.Accessor.ACCESSOR.createVersionResult(new Redo<NBVersionInfo>(){

                @Override
                public void run(Result<NBVersionInfo> result) {
                }
            });
        }
    }

    private static ChecksumQueries findChecksumQueries() {
        return (ChecksumQueries)Lookup.getDefault().lookup(ChecksumQueries.class);
    }

    private static Result<NBVersionInfo> findBySHA1(String sha1, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findChecksumQueries().findBySHA1(sha1, repos);
    }

    @NonNull
    private static ClassesQuery findClassesQueries() {
        return (ClassesQuery)Lookup.getDefault().lookup(ClassesQuery.class);
    }

    public static Result<NBVersionInfo> findVersionsByClassResult(String className, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findClassesQueries().findVersionsByClass(className, repos);
    }

    public static void findVersionsByClass(QueryRequest query) {
        Iterator<RepositoryInfo> it1 = query.getRepositories().iterator();
        while (it1.hasNext()) {
            RepositoryInfo repositoryInfo = it1.next();
            ArrayList<RepositoryInfo> repositoryInfoL = new ArrayList<RepositoryInfo>(1);
            repositoryInfoL.add(repositoryInfo);
            query.addResults(RepositoryQueries.findClassesQueries().findVersionsByClass(query.getClassName(), repositoryInfoL).getResults(), !it1.hasNext());
            if (query.countObservers() != 0) continue;
            return;
        }
        if (!query.isFinished()) {
            query.addResults(null, true);
        }
    }

    @NonNull
    private static ClassUsageQuery findClassUsageQuery() {
        return (ClassUsageQuery)Lookup.getDefault().lookup(ClassUsageQuery.class);
    }

    public static Result<ClassUsage> findClassUsagesResult(String className, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findClassUsageQuery().findClassUsages(className, repos);
    }

    @NonNull
    private static ArchetypeQueries findArchetypeQueries() {
        return (ArchetypeQueries)Lookup.getDefault().lookup(ArchetypeQueries.class);
    }

    public static Result<NBVersionInfo> findArchetypesResult(@NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findArchetypeQueries().findArchetypes(repos);
    }

    public static Result<String> filterPluginArtifactIdsResult(String groupId, String prefix, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().filterPluginArtifactIds(groupId, prefix, repos);
    }

    public static Result<String> filterPluginGroupIdsResult(String prefix, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().filterPluginGroupIds(prefix, repos);
    }

    @NonNull
    private static GenericFindQuery findFindQuery() {
        return (GenericFindQuery)Lookup.getDefault().lookup(GenericFindQuery.class);
    }

    public static Result<NBVersionInfo> findResult(List<QueryField> fields, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findFindQuery().find(fields, repos);
    }

    public static void find(QueryRequest query) {
        Iterator<RepositoryInfo> it1 = query.getRepositories().iterator();
        while (it1.hasNext()) {
            RepositoryInfo repositoryInfo = it1.next();
            ArrayList<RepositoryInfo> repositoryInfoL = new ArrayList<RepositoryInfo>(1);
            repositoryInfoL.add(repositoryInfo);
            query.addResults(RepositoryQueries.findFindQuery().find(query.getQueryFields(), repositoryInfoL).getResults(), !it1.hasNext());
            if (query.countObservers() != 0) continue;
            return;
        }
        if (!query.isFinished()) {
            query.addResults(null, true);
        }
    }

    @NonNull
    public static List<RepositoryInfo> getLoadedContexts() {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>();
        ContextLoadedQuery clq = (ContextLoadedQuery)Lookup.getDefault().lookup(ContextLoadedQuery.class);
        assert (clq != null);
        toRet.addAll(clq.getLoaded(RepositoryPreferences.getInstance().getRepositoryInfos()));
        return toRet;
    }

    public static Result<String> filterArtifactIdForGroupIdResult(String groupId, String prefix, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.findBaseQueries().filterArtifactIdForGroupId(groupId, prefix, repos);
    }

    static {
        new AccessorImpl();
    }

    public static final class ClassUsage {
        private final NBVersionInfo artifact;
        private final Set<String> classes;

        public ClassUsage(NBVersionInfo artifact, Set<String> classes) {
            this.artifact = artifact;
            this.classes = classes;
        }

        public NBVersionInfo getArtifact() {
            return this.artifact;
        }

        public Set<String> getClasses() {
            return this.classes;
        }

        public String toString() {
            return "" + this.artifact + this.classes;
        }
    }

    static class AccessorImpl
    extends NexusRepositoryIndexerImpl.Accessor {
        AccessorImpl() {
        }

        @Override
        public void addSkipped(Result<?> result, Collection<RepositoryInfo> infos) {
            result.addSkipped(infos);
        }

        @Override
        public List<RepositoryInfo> getSkipped(Result<?> result) {
            return result.getSkipped();
        }

        @Override
        public void addSkipped(Result<?> result, RepositoryInfo info) {
            result.addSkipped(info);
        }

        @Override
        public Result<String> createStringResult(Redo<String> redo) {
            return new Result<String>(redo);
        }

        @Override
        public Result<NBVersionInfo> createVersionResult(Redo<NBVersionInfo> redo) {
            return new Result<NBVersionInfo>(redo);
        }

        @Override
        public void setStringResults(Result<String> result, Collection<String> newResults) {
            result.setResults(newResults);
        }

        @Override
        public void setVersionResults(Result<NBVersionInfo> result, Collection<NBVersionInfo> newResults) {
            result.setResults(newResults);
        }

        @Override
        public Result<NBGroupInfo> createGroupResult(Redo<NBGroupInfo> redo) {
            return new Result<NBGroupInfo>(redo);
        }

        @Override
        public void setGroupResults(Result<NBGroupInfo> result, Collection<NBGroupInfo> newResults) {
            result.setResults(newResults);
        }

        @Override
        public Result<ClassUsage> createClassResult(Redo<ClassUsage> redo) {
            return new Result<ClassUsage>(redo);
        }

        @Override
        public void setClassResults(Result<ClassUsage> result, Collection<ClassUsage> newResults) {
            result.setResults(newResults);
        }

        @Override
        public void addTotalResults(Result<?> result, int moreResults) {
            result.addTotalResultCount(moreResults);
        }

        @Override
        public void addReturnedResults(Result<?> result, int moreResults) {
            result.addReturnedResultCount(moreResults);
        }
    }

    public static final class Result<T> {
        private final List<RepositoryInfo> skipped = new ArrayList<RepositoryInfo>();
        private List<T> results = new ArrayList<T>();
        private final Redo<T> redoAction;
        int totalResults = 0;
        int returnedResults = 0;

        Result(Redo<T> redo) {
            this.redoAction = redo;
        }

        public synchronized boolean isPartial() {
            return !this.skipped.isEmpty();
        }

        synchronized void addSkipped(RepositoryInfo info) {
            this.skipped.add(info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForSkipped() {
            assert (!ProjectIDEServices.isEventDispatchThread());
            this.redoAction.run(this);
            Result result = this;
            synchronized (result) {
                this.skipped.clear();
            }
        }

        synchronized void setResults(Collection<T> newResults) {
            this.results.clear();
            this.results.addAll(newResults);
        }

        public synchronized List<T> getResults() {
            return Collections.unmodifiableList(this.results);
        }

        synchronized void addSkipped(Collection<RepositoryInfo> infos) {
            this.skipped.addAll(infos);
        }

        synchronized List<RepositoryInfo> getSkipped() {
            return Collections.unmodifiableList(this.skipped);
        }

        public int getTotalResultCount() {
            return this.totalResults;
        }

        void addTotalResultCount(int moreTotalResults) {
            this.totalResults += moreTotalResults;
        }

        public int getReturnedResultCount() {
            return this.returnedResults;
        }

        void addReturnedResultCount(int moreReturnedResults) {
            this.returnedResults += moreReturnedResults;
        }
    }
}

