/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.common.xmlutils;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.SAXParseError;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.XMLJ2eeEditorSupport;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLJ2eeDataObject
extends XMLDataObject
implements CookieSet.Factory {
    protected boolean nodeDirty = false;
    private boolean documentDirty = true;
    private boolean savingDocument;
    private InputStream inputStream;
    private InputOutput inOut;
    protected XMLJ2eeEditorSupport editor;
    private boolean documentValid = true;
    private SAXParseError error;
    private Annotation errorAnnotation;
    private static final long serialVersionUID = -515751072013886985L;
    public static final String PROP_DOC_VALID = "documentValid";

    public XMLJ2eeDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        CookieSet cs = this.getCookieSet();
        cs.add(XMLJ2eeEditorSupport.class, (CookieSet.Factory)this);
        cs.add(EditCookie.class, (CookieSet.Factory)this);
        cs.add(EditorCookie.class, (CookieSet.Factory)this);
        cs.add(LineCookie.class, (CookieSet.Factory)this);
        cs.add(PrintCookie.class, (CookieSet.Factory)this);
        cs.add(CloseCookie.class, (CookieSet.Factory)this);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        cs.add((Node.Cookie)checkCookie);
    }

    protected String getEditorMimeType() {
        return null;
    }

    protected EditorCookie createEditorCookie() {
        return this.getEditorSupport();
    }

    protected abstract SAXParseError updateNode(InputSource var1) throws IOException;

    protected abstract String getIconBaseForValidDocument();

    protected abstract String getIconBaseForInvalidDocument();

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(XMLJ2eeEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    protected synchronized XMLJ2eeEditorSupport getEditorSupport() {
        if (this.editor == null) {
            this.editor = new XMLJ2eeEditorSupport(this);
        }
        return this.editor;
    }

    public String getOutputStringForInvalidDocument(SAXParseError error) {
        String mes = NbBundle.getMessage(XMLJ2eeDataObject.class, (String)"TXT_errorMessage", (Object[])new Object[]{error.getErrorText(), new Integer(error.getErrorLine()), new Integer(error.getErrorColumn())});
        return mes;
    }

    public boolean isNodeDirty() {
        return this.nodeDirty;
    }

    public void setDocumentDirty(boolean dirty) {
        this.documentDirty = dirty;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public void setNodeDirty(boolean dirty) {
        this.nodeDirty = dirty;
    }

    protected void repairNode() {
        if (this.inOut != null) {
            this.inOut.closeInputOutput();
            this.errorAnnotation.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsingDocument() {
        SAXParseError err = null;
        try {
            err = this.updateNode(this.prepareInputSource());
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            this.setDocumentValid(false);
            return;
        }
        finally {
            this.closeInputSource();
            this.documentDirty = false;
        }
        if (err == null) {
            this.setDocumentValid(true);
        } else {
            this.setDocumentValid(false);
        }
    }

    protected InputSource prepareInputSource() throws IOException {
        if (this.editor != null && this.editor.isDocumentLoaded()) {
            final StyledDocument doc = this.editor.getDocument();
            final String[] str = new String[1];
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        str[0] = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            doc.render(run);
            StringReader reader = new StringReader(str[0]);
            return new InputSource(reader);
        }
        this.inputStream = new BufferedInputStream(this.getPrimaryFile().getInputStream());
        return new InputSource(this.inputStream);
    }

    protected void closeInputSource() {
        InputStream is = this.inputStream;
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is == this.inputStream) {
                this.inputStream = null;
            }
        }
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void setDocumentValid(boolean valid) {
        if (this.documentValid != valid) {
            if (valid) {
                this.repairNode();
            }
            this.documentValid = valid;
            this.firePropertyChange(PROP_DOC_VALID, !this.documentValid ? Boolean.TRUE : Boolean.FALSE, this.documentValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void addSaveCookie(SaveCookie cookie) {
        this.getCookieSet().add((Node.Cookie)cookie);
    }

    public void removeSaveCookie() {
        Node.Cookie cookie = this.getCookie(SaveCookie.class);
        if (cookie != null) {
            this.getCookieSet().remove(cookie);
        }
    }

    public void setSavingDocument(boolean saving) {
        this.savingDocument = saving;
    }

    public boolean isSavingDocument() {
        return this.savingDocument;
    }

    public void displayErrorMessage() {
        if (this.error == null) {
            return;
        }
        if (this.errorAnnotation == null) {
            this.errorAnnotation = new Annotation(){

                public String getAnnotationType() {
                    return "xml-j2ee-annotation";
                }

                public String getShortDescription() {
                    return NbBundle.getMessage(XMLJ2eeDataObject.class, (String)"HINT_XMLErrorDescription");
                }
            };
        }
        if (this.inOut == null) {
            this.inOut = IOProvider.getDefault().getIO(NbBundle.getMessage(XMLJ2eeDataObject.class, (String)"TXT_parser"), false);
        }
        this.inOut.setFocusTaken(false);
        OutputWriter outputWriter = this.inOut.getOut();
        int line = Math.max(0, this.error.getErrorLine());
        LineCookie cookie = (LineCookie)this.getCookie(LineCookie.class);
        Line xline = cookie.getLineSet().getCurrent(line == 0 ? 0 : line - 1);
        this.errorAnnotation.attach((Annotatable)xline);
        try {
            outputWriter.reset();
            IOCtl outList = new IOCtl(xline);
            outputWriter.println(this.getOutputStringForInvalidDocument(this.error), (OutputListener)outList);
        }
        catch (IOException e) {
            Logger.getLogger("XMLJ2eeDataObject").log(Level.FINE, "ignored exception", e);
        }
    }

    public void setValid(boolean valid) throws PropertyVetoException {
        if (!valid && this.inOut != null) {
            this.inOut.closeInputOutput();
        }
        super.setValid(valid);
    }

    private void createSAXParseError(SAXParseException error) {
        this.error = new SAXParseError(error);
    }

    public static class J2eeErrorHandler
    implements ErrorHandler {
        private XMLJ2eeDataObject xmlJ2eeDataObject;

        public J2eeErrorHandler(XMLJ2eeDataObject obj) {
            this.xmlJ2eeDataObject = obj;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.xmlJ2eeDataObject.createSAXParseError(exception);
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.xmlJ2eeDataObject.createSAXParseError(exception);
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.xmlJ2eeDataObject.createSAXParseError(exception);
            throw exception;
        }
    }

    final class IOCtl
    implements OutputListener {
        Line xline;

        public IOCtl(Line xline) {
            this.xline = xline;
        }

        public void outputLineSelected(OutputEvent ev) {
            XMLJ2eeDataObject.this.errorAnnotation.attach((Annotatable)this.xline);
            this.xline.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE);
        }

        public void outputLineAction(OutputEvent ev) {
            XMLJ2eeDataObject.this.errorAnnotation.attach((Annotatable)this.xline);
            this.xline.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE);
        }

        public void outputLineCleared(OutputEvent ev) {
            XMLJ2eeDataObject.this.errorAnnotation.detach();
        }
    }
}

