/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelModel;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.toolchain.compilerset.APIAccessor;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.ui.options.DownloadUtils;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsPanel;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsUtils;
import org.netbeans.modules.cnd.toolchain.ui.options.VersionCommand;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class ToolCollectionPanel
extends JPanel
implements DocumentListener,
ItemListener {
    private final String MAKE_NAME = "make";
    private final String DEBUGGER_NAME = "debugger";
    private final String C_NAME = "C";
    private final String CPP_NAME = "C++";
    private final String FORTRAN_NAME = "Fortran";
    private final String ASSEMBLER_NAME = "Assembler";
    private final String QMAKE_NAME = "QMake";
    private final String CMAKE_NAME = "CMake";
    private Color tfColor = null;
    private boolean isUrl = false;
    private boolean update = false;
    private Map<ToolKind, Boolean> lastValid = new ConcurrentHashMap<ToolKind, Boolean>();
    private final RequestProcessor RP = new RequestProcessor("ToolCollectionPanel: check remote file", 1);
    private final ToolsPanel manager;
    private JButton btAsBrowse;
    private JButton btCBrowse;
    private JButton btCMakeBrowse;
    private JButton btCppBrowse;
    private JButton btDebuggerBrowse;
    private JButton btFortranBrowse;
    private JButton btInstall;
    private JButton btMakeBrowse;
    private JButton btQMakeBrowse;
    private JCheckBox cbAsRequired;
    private JCheckBox cbCRequired;
    private JCheckBox cbCppRequired;
    private JCheckBox cbDebuggerRequired;
    private JCheckBox cbFortranRequired;
    private JCheckBox cbMakeRequired;
    private JCheckBox cbQMakeRequired;
    private JComboBox encodingComboBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lbAsCommand;
    private JLabel lbBaseDirectory;
    private JLabel lbCCommand;
    private JLabel lbCMakePath;
    private JLabel lbCppCommand;
    private JLabel lbDebuggerCommand;
    private JLabel lbEncoding;
    private JLabel lbFamily;
    private JLabel lbFamilyValue;
    private JLabel lbFortranCommand;
    private JLabel lbMakeCommand;
    private JLabel lbQMakePath;
    private JSeparator requiredSeparator;
    private JLabel requiredToolsLabel;
    private JScrollPane scrollPane;
    private JTextField tfAsPath;
    private JTextField tfBaseDirectory;
    private JTextField tfCMakePath;
    private JTextField tfCPath;
    private JTextField tfCppPath;
    private JTextField tfDebuggerPath;
    private JTextField tfFortranPath;
    private JTextField tfMakePath;
    private JTextField tfQMakePath;
    private JTextPane tpInstall;

    public ToolCollectionPanel(ToolsPanel manager) {
        this.manager = manager;
        this.initComponents();
        this.encodingComboBox.setModel(ProjectCustomizer.encodingModel((String)"UTF-8"));
        this.encodingComboBox.setRenderer(ProjectCustomizer.encodingRenderer());
        this.tpInstall.setContentType("text/html");
        this.btInstall.setVisible(this.isUrl);
        this.scrollPane.setVisible(this.isUrl);
        this.cbDebuggerRequired.setName("debugger");
        this.cbCRequired.setName("c");
        this.cbCppRequired.setName("c++");
        this.cbFortranRequired.setName("fortran");
        this.cbQMakeRequired.setName("qmake");
        this.cbAsRequired.setName("assembler");
    }

    void initializeUI() {
        if (!this.manager.getModel().showRequiredTools()) {
            this.requiredToolsLabel.setVisible(false);
            this.requiredSeparator.setVisible(false);
        }
        this.tfMakePath.setEditable(false);
        this.tfDebuggerPath.setEditable(false);
        this.tfQMakePath.setEditable(false);
        this.tfCMakePath.setEditable(false);
        if (this.manager.getModel().enableRequiredCompilerCB()) {
            this.cbCRequired.setEnabled(true);
            this.cbCppRequired.setEnabled(true);
            this.cbFortranRequired.setEnabled(true);
            this.cbQMakeRequired.setEnabled(true);
            this.cbAsRequired.setEnabled(true);
            this.encodingComboBox.setEnabled(true);
        } else {
            this.cbCRequired.setEnabled(false);
            this.cbCppRequired.setEnabled(false);
            this.cbFortranRequired.setEnabled(false);
            this.cbQMakeRequired.setEnabled(false);
            this.cbAsRequired.setEnabled(false);
            this.encodingComboBox.setEnabled(false);
        }
        this.cbMakeRequired.setSelected(this.manager.getModel().isMakeRequired());
        this.cbDebuggerRequired.setSelected(this.manager.getModel().isDebuggerRequired());
        this.cbCRequired.setSelected(this.manager.getModel().isCRequired());
        this.cbCppRequired.setSelected(this.manager.getModel().isCppRequired());
        this.cbFortranRequired.setSelected(this.manager.getModel().isFortranRequired());
        this.cbQMakeRequired.setSelected(this.manager.getModel().isQMakeRequired());
        this.cbAsRequired.setSelected(this.manager.getModel().isAsRequired());
    }

    void updateUI(boolean doInitialize, CompilerSet selectedCS) {
        this.lbDebuggerCommand.setVisible(this.manager.isCustomizableDebugger());
        this.tfDebuggerPath.setVisible(this.manager.isCustomizableDebugger());
        this.btDebuggerBrowse.setVisible(this.manager.isCustomizableDebugger());
        this.cbMakeRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbDebuggerRequired.setVisible(this.manager.getModel().showRequiredDebugTools() && this.manager.isCustomizableDebugger());
        this.cbCppRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbCRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbFortranRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbQMakeRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbAsRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
    }

    void removeCompilerSet() {
        this.lbFamilyValue.setText("");
        this.tfBaseDirectory.setText("");
        this.tfCPath.setText("");
        this.tfCppPath.setText("");
        this.tfFortranPath.setText("");
        this.tfAsPath.setText("");
        this.tfMakePath.setText("");
        this.tfDebuggerPath.setText("");
        this.tfQMakePath.setText("");
        this.tfCMakePath.setText("");
    }

    void updateCompilerSet(CompilerSet cs, boolean force) {
        if (cs.isUrlPointer()) {
            return;
        }
        if (force) {
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.CCompiler), this.tfCPath.getText());
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.CCCompiler), this.tfCppPath.getText());
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.FortranCompiler), this.tfFortranPath.getText());
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.Assembler), this.tfAsPath.getText());
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.MakeTool), this.tfMakePath.getText());
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.DebuggerTool), this.tfDebuggerPath.getText());
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.QMakeTool), this.tfQMakePath.getText());
            APIAccessor.get().setToolPath(cs.getTool(PredefinedToolKind.CMakeTool), this.tfCMakePath.getText());
        } else {
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.CCompiler), this.tfCPath.getText());
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.CCCompiler), this.tfCppPath.getText());
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.FortranCompiler), this.tfFortranPath.getText());
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.Assembler), this.tfAsPath.getText());
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.MakeTool), this.tfMakePath.getText());
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.DebuggerTool), this.tfDebuggerPath.getText());
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.QMakeTool), this.tfQMakePath.getText());
            APIAccessor.get().setToolPath(cs.findTool(PredefinedToolKind.CMakeTool), this.tfCMakePath.getText());
        }
        if (this.encodingComboBox.getSelectedItem() instanceof Charset) {
            APIAccessor.get().setCharset((Charset)this.encodingComboBox.getSelectedItem(), cs);
        }
    }

    void applyChanges() {
        ToolsPanelModel model = this.manager.getModel();
        if (model != null) {
            if (model.isDebuggerRequired() != this.cbDebuggerRequired.isSelected()) {
                model.setDebuggerRequired(this.cbDebuggerRequired.isSelected());
            }
            if (model.isCRequired() != this.cbCRequired.isSelected()) {
                model.setCRequired(this.cbCRequired.isSelected());
            }
            if (model.isCppRequired() != this.cbCppRequired.isSelected()) {
                model.setCppRequired(this.cbCppRequired.isSelected());
            }
            if (model.isFortranRequired() != this.cbFortranRequired.isSelected()) {
                model.setFortranRequired(this.cbFortranRequired.isSelected());
            }
            if (model.isAsRequired() != this.cbAsRequired.isSelected()) {
                model.setAsRequired(this.cbAsRequired.isSelected());
            }
            if (model.isQMakeRequired() != this.cbQMakeRequired.isSelected()) {
                model.setFortranRequired(this.cbQMakeRequired.isSelected());
            }
        }
    }

    void preChangeCompilerSet(CompilerSet cs) {
        if (cs == null) {
            this.lbFamilyValue.setText("");
            this.updateToolsControls(false, false, true);
            return;
        }
        if (cs.isUrlPointer()) {
            this.isUrl = true;
            String selected = cs.getCompilerFlavor().toString();
            String name = cs.getDisplayName();
            String uc = cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl();
            String message = ToolsPanel.getString("ToolsPanel.UpdateCenterMessage", selected, name, uc);
            this.tpInstall.setText(message);
            this.tpInstall.setBackground(this.getBackground());
            this.tpInstall.select(this.tpInstall.getDocument().getLength() - 1, this.tpInstall.getDocument().getLength() - 1);
        } else {
            this.isUrl = false;
            this.tfBaseDirectory.setText(cs.getDirectory());
        }
        this.scrollPane.setVisible(this.isUrl);
        this.btInstall.setVisible(this.isUrl);
        this.lbFamily.setVisible(!this.isUrl);
        this.lbEncoding.setVisible(!this.isUrl);
        this.encodingComboBox.setVisible(!this.isUrl);
        this.lbFamilyValue.setVisible(!this.isUrl);
        this.lbAsCommand.setVisible(!this.isUrl);
        this.lbBaseDirectory.setVisible(!this.isUrl);
        this.lbCCommand.setVisible(!this.isUrl);
        this.lbCMakePath.setVisible(!this.isUrl);
        this.lbCppCommand.setVisible(!this.isUrl);
        this.lbDebuggerCommand.setVisible(!this.isUrl && this.manager.isCustomizableDebugger());
        this.lbFortranCommand.setVisible(!this.isUrl);
        this.lbMakeCommand.setVisible(!this.isUrl);
        this.lbQMakePath.setVisible(!this.isUrl);
        this.tfAsPath.setVisible(!this.isUrl);
        this.tfBaseDirectory.setVisible(!this.isUrl);
        this.tfCMakePath.setVisible(!this.isUrl);
        this.tfCPath.setVisible(!this.isUrl);
        this.tfCppPath.setVisible(!this.isUrl);
        this.tfDebuggerPath.setVisible(!this.isUrl && this.manager.isCustomizableDebugger());
        this.tfFortranPath.setVisible(!this.isUrl);
        this.tfMakePath.setVisible(!this.isUrl);
        this.tfQMakePath.setVisible(!this.isUrl);
        this.btAsBrowse.setVisible(!this.isUrl);
        this.btCBrowse.setVisible(!this.isUrl);
        this.btCMakeBrowse.setVisible(!this.isUrl);
        this.btCppBrowse.setVisible(!this.isUrl);
        this.btDebuggerBrowse.setVisible(!this.isUrl && this.manager.isCustomizableDebugger());
        this.btFortranBrowse.setVisible(!this.isUrl);
        this.btMakeBrowse.setVisible(!this.isUrl);
        this.btQMakeBrowse.setVisible(!this.isUrl);
        this.lbFamilyValue.setText(cs.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeCompilerSet(CompilerSet cs) {
        this.update = true;
        try {
            Tool cSelection = null;
            Tool cppSelection = null;
            Tool fortranSelection = null;
            Tool asSelection = null;
            Tool makeToolSelection = null;
            Tool debuggerToolSelection = null;
            Tool qmakeToolSelection = null;
            Tool cmakeToolSelection = null;
            if (!cs.isUrlPointer()) {
                cSelection = cs.getTool(PredefinedToolKind.CCompiler);
                cppSelection = cs.getTool(PredefinedToolKind.CCCompiler);
                fortranSelection = cs.getTool(PredefinedToolKind.FortranCompiler);
                asSelection = cs.getTool(PredefinedToolKind.Assembler);
                makeToolSelection = cs.getTool(PredefinedToolKind.MakeTool);
                debuggerToolSelection = cs.getTool(PredefinedToolKind.DebuggerTool);
                qmakeToolSelection = cs.getTool(PredefinedToolKind.QMakeTool);
                cmakeToolSelection = cs.getTool(PredefinedToolKind.CMakeTool);
            }
            if (cSelection != null) {
                this.setCPathField(cSelection.getPath());
            } else {
                this.tfCPath.setText("");
            }
            if (cppSelection != null) {
                this.setCppPathField(cppSelection.getPath());
            } else {
                this.tfCppPath.setText("");
            }
            if (fortranSelection != null) {
                this.setFortranPathField(fortranSelection.getPath());
            } else {
                this.tfFortranPath.setText("");
            }
            if (asSelection != null) {
                this.setAsPathField(asSelection.getPath());
            } else {
                this.tfAsPath.setText("");
            }
            if (qmakeToolSelection != null) {
                this.setQMakePathField(qmakeToolSelection.getPath());
            } else {
                this.tfQMakePath.setText("");
            }
            if (cmakeToolSelection != null) {
                this.setCMakePathField(cmakeToolSelection.getPath());
            } else {
                this.tfCMakePath.setText("");
            }
            if (makeToolSelection != null) {
                this.setMakePathField(makeToolSelection.getPath());
            } else {
                this.tfMakePath.setText("");
            }
            if (debuggerToolSelection != null) {
                this.setGdbPathField(debuggerToolSelection.getPath());
            } else {
                this.tfDebuggerPath.setText("");
            }
            this.encodingComboBox.setSelectedItem(cs.getEncoding());
        }
        finally {
            this.update = false;
        }
    }

    private void setMakePathField(String path) {
        this.tfMakePath.setText(path);
    }

    private void validateMakePathField() {
        this.postIsPathFieldValid(this.tfMakePath, PredefinedToolKind.MakeTool);
    }

    private void setGdbPathField(String path) {
        this.tfDebuggerPath.setText(path);
    }

    private void validateGdbPathField() {
        this.postIsPathFieldValid(this.tfDebuggerPath, PredefinedToolKind.DebuggerTool);
    }

    private void setCPathField(String path) {
        this.tfCPath.setText(path);
    }

    private void validateCPathField() {
        this.postIsPathFieldValid(this.tfCPath, PredefinedToolKind.CCompiler);
    }

    private void setCppPathField(String path) {
        this.tfCppPath.setText(path);
    }

    private void validateCppPathField() {
        this.postIsPathFieldValid(this.tfCppPath, PredefinedToolKind.CCCompiler);
    }

    private void setFortranPathField(String path) {
        this.tfFortranPath.setText(path);
    }

    private void validateFortranPathField() {
        this.postIsPathFieldValid(this.tfFortranPath, PredefinedToolKind.FortranCompiler);
    }

    private void setAsPathField(String path) {
        this.tfAsPath.setText(path);
    }

    private void validateAsPathField() {
        this.postIsPathFieldValid(this.tfAsPath, PredefinedToolKind.Assembler);
    }

    private void setQMakePathField(String path) {
        this.tfQMakePath.setText(path);
    }

    private void validateQMakePathField() {
        this.postIsPathFieldValid(this.tfQMakePath, PredefinedToolKind.QMakeTool);
    }

    private void setCMakePathField(String path) {
        this.tfCMakePath.setText(path);
    }

    private void validateCMakePathField() {
        this.postIsPathFieldValid(this.tfCMakePath, PredefinedToolKind.CMakeTool);
    }

    private void setPathFieldValid(JTextField field, boolean valid, PredefinedToolKind tool) {
        if (valid) {
            field.setForeground(this.tfColor);
        } else {
            field.setForeground(Color.RED);
        }
        JCheckBox box = null;
        switch (tool) {
            case CCompiler: {
                box = this.cbCRequired;
                break;
            }
            case CCCompiler: {
                box = this.cbCppRequired;
                break;
            }
            case FortranCompiler: {
                box = this.cbFortranRequired;
                break;
            }
            case Assembler: {
                box = this.cbAsRequired;
                break;
            }
            case MakeTool: {
                box = this.cbMakeRequired;
                break;
            }
            case DebuggerTool: {
                box = this.cbDebuggerRequired;
                break;
            }
            case QMakeTool: {
                box = this.cbQMakeRequired;
            }
        }
        if (box != null) {
            ((MyCheckBox)box).setInvalid(!valid);
        }
    }

    private boolean getLastToolValidation(ToolKind tool) {
        Boolean get = this.lastValid.get(tool);
        return get != null && get != false;
    }

    boolean isToolsValid() {
        boolean makeValid = this.cbMakeRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.MakeTool) : true;
        boolean debuggerValid = this.cbDebuggerRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.DebuggerTool) : true;
        boolean cValid = this.cbCRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.CCompiler) : true;
        boolean cppValid = this.cbCppRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.CCCompiler) : true;
        boolean fortranValid = this.cbFortranRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.FortranCompiler) : true;
        boolean qmakeValid = this.cbQMakeRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.QMakeTool) : true;
        boolean asValid = this.cbAsRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.Assembler) : true;
        return makeValid && debuggerValid && cValid && cppValid && fortranValid && asValid && qmakeValid;
    }

    void getErrors(List<String> errors) {
        boolean asValid;
        boolean makeValid = this.cbMakeRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.MakeTool) : true;
        boolean debuggerValid = this.cbDebuggerRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.DebuggerTool) : true;
        boolean cValid = this.cbCRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.CCompiler) : true;
        boolean cppValid = this.cbCppRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.CCCompiler) : true;
        boolean fortranValid = this.cbFortranRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.FortranCompiler) : true;
        boolean qmakeValid = this.cbQMakeRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.QMakeTool) : true;
        boolean bl = asValid = this.cbAsRequired.isSelected() ? this.getLastToolValidation(PredefinedToolKind.Assembler) : true;
        if (this.cbMakeRequired.isSelected() && !makeValid) {
            if (ToolsPanelSupport.isUnsupportedMake(this.tfMakePath.getText())) {
                errors.add(ToolsPanel.getString("TP_ErrorMessage_UnsupportedMake", "mingw32-make"));
            } else {
                errors.add(ToolsPanel.getString("TP_ErrorMessage_MissedMake"));
            }
        }
        if (this.cbCRequired.isSelected() && !cValid) {
            errors.add(ToolsPanel.getString("TP_ErrorMessage_MissedCCompiler"));
        }
        if (this.cbCppRequired.isSelected() && !cppValid) {
            errors.add(ToolsPanel.getString("TP_ErrorMessage_MissedCppCompiler"));
        }
        if (this.cbDebuggerRequired.isSelected() && !debuggerValid && this.manager.isCustomizableDebugger()) {
            errors.add(ToolsPanel.getString("TP_ErrorMessage_MissedDebugger"));
        }
        if (this.cbFortranRequired.isSelected() && !fortranValid) {
            errors.add(ToolsPanel.getString("TP_ErrorMessage_MissedFortranCompiler"));
        }
        if (this.cbQMakeRequired.isSelected() && !qmakeValid) {
            errors.add(ToolsPanel.getString("TP_ErrorMessage_MissedQMake"));
        }
        if (this.cbAsRequired.isSelected() && !asValid) {
            errors.add(ToolsPanel.getString("TP_ErrorMessage_MissedAssembler"));
        }
    }

    void updateToolsControls(boolean enableText, boolean enableVersions, boolean cleanText) {
        this.updateTextField(this.tfMakePath, enableText, cleanText);
        this.btMakeBrowse.setEnabled(enableText);
        this.updateTextField(this.tfDebuggerPath, enableText, cleanText);
        this.btDebuggerBrowse.setEnabled(enableText);
        this.updateTextField(this.tfBaseDirectory, false, cleanText);
        this.updateTextField(this.tfCPath, enableText, cleanText);
        this.btCBrowse.setEnabled(enableText);
        this.updateTextField(this.tfCppPath, enableText, cleanText);
        this.btCppBrowse.setEnabled(enableText);
        this.updateTextField(this.tfFortranPath, enableText, cleanText);
        this.btFortranBrowse.setEnabled(enableText);
        this.updateTextField(this.tfAsPath, enableText, cleanText);
        this.btAsBrowse.setEnabled(enableText);
        this.updateTextField(this.tfQMakePath, enableText, cleanText);
        this.btQMakeBrowse.setEnabled(enableText);
        this.updateTextField(this.tfCMakePath, enableText, cleanText);
        this.btCMakeBrowse.setEnabled(enableText);
    }

    private void updateTextField(JTextField tf, boolean editable, boolean cleanText) {
        if (cleanText) {
            tf.setText("");
        }
        tf.setEditable(editable);
    }

    private void updateField(final JTextField field, final boolean valid, final PredefinedToolKind tool) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolCollectionPanel.this.setPathFieldValid(field, valid, tool);
                ToolCollectionPanel.this.manager.dataValid();
            }
        });
    }

    void postIsPathFieldValid(final JTextField field, final PredefinedToolKind tool) {
        final String txt = field.getText();
        if (txt.length() == 0) {
            this.lastValid.put(tool, false);
            this.updateField(field, false, tool);
            return;
        }
        if (tool == PredefinedToolKind.MakeTool && ToolsPanelSupport.isUnsupportedMake(txt)) {
            this.lastValid.put(tool, false);
            this.updateField(field, false, tool);
            return;
        }
        if (this.manager.getExecutionEnvironment().isLocal()) {
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    File file = new File(txt);
                    boolean ok = false;
                    if (Utilities.isWindows()) {
                        ok = txt.endsWith(".lnk") ? false : (file.exists() || new File(txt + ".lnk").exists()) && !file.isDirectory();
                    } else {
                        boolean bl = ok = file.exists() && !file.isDirectory();
                    }
                    if (!ok) {
                        String p;
                        Iterator i$ = Path.getPath().iterator();
                        while (i$.hasNext() && !(ok = (file = new File((p = (String)i$.next()) + File.separatorChar + txt)).exists() && !file.isDirectory())) {
                        }
                    }
                    ToolCollectionPanel.this.lastValid.put(tool, ok);
                    ToolCollectionPanel.this.updateField(field, ok, tool);
                }
            });
        } else {
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    boolean exists = false;
                    if (ServerList.get((ExecutionEnvironment)ToolCollectionPanel.this.manager.getExecutionEnvironment()).isOnline()) {
                        exists = ServerList.isValidExecutable((ExecutionEnvironment)ToolCollectionPanel.this.manager.getExecutionEnvironment(), (String)txt);
                    }
                    ToolCollectionPanel.this.lastValid.put(tool, exists);
                    ToolCollectionPanel.this.updateField(field, exists, tool);
                }
            });
        }
    }

    private boolean selectTool(JTextField tf, boolean checkBaseFolder) {
        String seed = tf.getText().trim();
        if (seed.length() > 0 && !seed.endsWith("/")) {
            int pos = seed.lastIndexOf(47);
            if (pos > 0) {
                seed = seed.substring(0, pos);
            }
        } else {
            seed = ToolsUtils.getDefaultDirectory(this.manager.getExecutionEnvironment());
        }
        FileChooserBuilder.JFileChooserEx fileChooser = new FileChooserBuilder(this.manager.getExecutionEnvironment()).createFileChooser(seed);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle(ToolsPanel.getString("SELECT_TOOL_TITLE"));
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return false;
        }
        String aPath = fileChooser.getSelectedFile().getPath();
        if (Utilities.isWindows() && aPath.endsWith(".lnk")) {
            aPath = aPath.substring(0, aPath.length() - 4);
        }
        tf.setText(aPath);
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        boolean userChange;
        boolean bl = userChange = !this.manager.isUpdatindOrChangingCompilerSet();
        if (userChange) {
            this.manager.setChanged(true);
        }
        Document doc = ev.getDocument();
        String title = (String)doc.getProperty("title");
        PredefinedToolKind toolKind = PredefinedToolKind.UnknownTool;
        String toolPath = null;
        if (title.equals("make")) {
            this.validateMakePathField();
            toolKind = PredefinedToolKind.MakeTool;
            toolPath = this.tfMakePath.getText();
        } else if (title.equals("debugger")) {
            this.validateGdbPathField();
            toolKind = PredefinedToolKind.DebuggerTool;
            toolPath = this.tfDebuggerPath.getText();
        } else if (title.equals("C")) {
            this.validateCPathField();
            toolKind = PredefinedToolKind.CCompiler;
            toolPath = this.tfCPath.getText();
        } else if (title.equals("C++")) {
            this.validateCppPathField();
            toolKind = PredefinedToolKind.CCCompiler;
            toolPath = this.tfCppPath.getText();
        } else if (title.equals("Fortran")) {
            this.validateFortranPathField();
            toolKind = PredefinedToolKind.FortranCompiler;
            toolPath = this.tfFortranPath.getText();
        } else if (title.equals("Assembler")) {
            this.validateAsPathField();
            toolKind = PredefinedToolKind.Assembler;
            toolPath = this.tfAsPath.getText();
        } else if (title.equals("QMake")) {
            this.validateQMakePathField();
            toolKind = PredefinedToolKind.QMakeTool;
            toolPath = this.tfQMakePath.getText();
        } else if (title.equals("CMake")) {
            this.validateCMakePathField();
            toolKind = PredefinedToolKind.CMakeTool;
            toolPath = this.tfCMakePath.getText();
        }
        if (userChange && toolKind != PredefinedToolKind.UnknownTool) {
            Tool tool = this.manager.getCurrentCompilerSet().getTool(toolKind);
            APIAccessor.get().setToolPath(tool, toolPath);
            if (tool instanceof AbstractCompiler) {
                ((AbstractCompiler)tool).resetSystemProperties(true);
            }
            this.manager.fireCompilerSetChange();
            this.manager.fireCompilerSetModified();
        }
        this.manager.fireToolColectionPanelChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
        this.insertUpdate(ev);
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        Object o = ev.getSource();
        if (o instanceof JCheckBox && !this.manager.isUpdatindOrChangingCompilerSet()) {
            this.manager.dataValid();
        }
    }

    private String getToolVersion(Tool tool, JTextField tf) {
        StringBuilder version = new StringBuilder();
        version.append(tool.getDisplayName()).append(": ");
        if (this.getLastToolValidation(tool.getKind())) {
            String v;
            String path = tf.getText();
            if (!ToolUtils.isPathAbsolute(path)) {
                path = Path.findCommand((String)path);
            }
            if ((v = this.postVersionInfo(tool, path)) != null) {
                version.append(v);
            } else {
                version.append(ToolsPanel.getString("TOOL_VERSION_NOT_FOUND"));
            }
        } else {
            version.append(ToolsPanel.getString("TOOL_NOT_FOUND"));
        }
        return version.toString();
    }

    private String postVersionInfo(Tool tool, String path) {
        if (path == null) {
            return null;
        }
        return new VersionCommand(tool, path).getVersion();
    }

    String getVersion(CompilerSet cs) {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)ToolsPanel.getString("LBL_VersionInfo_Progress"));
        handle.start(this.manager.isCustomizableDebugger() ? 8 : 7);
        StringBuilder versions = new StringBuilder();
        int i = 0;
        versions.append('\n');
        versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.CCompiler), this.tfCPath)).append('\n');
        handle.progress(++i);
        versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.CCCompiler), this.tfCppPath)).append('\n');
        handle.progress(++i);
        versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.FortranCompiler), this.tfFortranPath)).append('\n');
        handle.progress(++i);
        versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.Assembler), this.tfAsPath)).append('\n');
        handle.progress(++i);
        versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.MakeTool), this.tfMakePath)).append('\n');
        if (this.manager.isCustomizableDebugger()) {
            handle.progress(++i);
            versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.DebuggerTool), this.tfDebuggerPath)).append('\n');
        }
        handle.progress(++i);
        versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.QMakeTool), this.tfQMakePath)).append('\n');
        handle.progress(++i);
        versions.append(this.getToolVersion(cs.findTool(PredefinedToolKind.CMakeTool), this.tfCMakePath)).append('\n');
        handle.finish();
        String upgradeUrl = cs.getCompilerFlavor().getToolchainDescriptor().getUpgradeUrl();
        if (upgradeUrl != null) {
            versions.append('\n').append(ToolsPanel.getString("TOOL_UPGRADE", upgradeUrl)).append('\n');
        }
        return versions.toString();
    }

    boolean isBaseDirValid() {
        return !this.isUrl && new File(this.tfBaseDirectory.getText()).exists();
    }

    private void initComponents() {
        this.lbMakeCommand = new JLabel();
        this.tfMakePath = new JTextField();
        this.tfMakePath.getDocument().putProperty("title", "make");
        this.tfMakePath.getDocument().addDocumentListener(this);
        this.btMakeBrowse = new JButton();
        this.lbDebuggerCommand = new JLabel();
        this.tfDebuggerPath = new JTextField();
        this.tfDebuggerPath.getDocument().putProperty("title", "debugger");
        this.tfDebuggerPath.getDocument().addDocumentListener(this);
        this.btDebuggerBrowse = new JButton();
        this.lbCCommand = new JLabel();
        this.tfCPath = new JTextField();
        this.tfCPath.getDocument().putProperty("title", "C");
        this.tfCPath.getDocument().addDocumentListener(this);
        this.btCBrowse = new JButton();
        this.lbCppCommand = new JLabel();
        this.tfCppPath = new JTextField();
        this.tfCppPath.getDocument().putProperty("title", "C++");
        this.tfCppPath.getDocument().addDocumentListener(this);
        this.btCppBrowse = new JButton();
        this.lbFortranCommand = new JLabel();
        this.tfFortranPath = new JTextField();
        this.tfFortranPath.getDocument().putProperty("title", "Fortran");
        this.tfFortranPath.getDocument().addDocumentListener(this);
        this.btFortranBrowse = new JButton();
        this.lbFamily = new JLabel();
        this.requiredToolsLabel = new JLabel();
        this.cbQMakeRequired = new MyCheckBox();
        this.cbMakeRequired = new MyCheckBox();
        this.cbDebuggerRequired = new MyCheckBox();
        this.cbDebuggerRequired.addItemListener(this);
        this.cbCRequired = new MyCheckBox();
        this.cbCRequired.addItemListener(this);
        this.cbCppRequired = new MyCheckBox();
        this.cbCppRequired.addItemListener(this);
        this.cbFortranRequired = new MyCheckBox();
        this.cbFortranRequired.addItemListener(this);
        this.cbAsRequired = new MyCheckBox();
        this.cbFortranRequired.addItemListener(this);
        this.lbBaseDirectory = new JLabel();
        this.tfBaseDirectory = new JTextField();
        this.lbAsCommand = new JLabel();
        this.tfAsPath = new JTextField();
        this.tfAsPath.getDocument().putProperty("title", "Assembler");
        this.tfAsPath.getDocument().addDocumentListener(this);
        this.btAsBrowse = new JButton();
        this.lbQMakePath = new JLabel();
        this.lbCMakePath = new JLabel();
        this.tfQMakePath = new JTextField();
        this.tfQMakePath.getDocument().putProperty("title", "QMake");
        this.tfQMakePath.getDocument().addDocumentListener(this);
        this.tfCMakePath = new JTextField();
        this.tfCMakePath.getDocument().putProperty("title", "CMake");
        this.tfCMakePath.getDocument().addDocumentListener(this);
        this.btQMakeBrowse = new JButton();
        this.btCMakeBrowse = new JButton();
        this.btInstall = new JButton();
        this.scrollPane = new JScrollPane();
        this.tpInstall = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lbFamilyValue = new JLabel();
        this.lbEncoding = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.requiredSeparator = new JSeparator();
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(200, 200));
        this.setLayout(new GridBagLayout());
        this.lbMakeCommand.setLabelFor(this.tfMakePath);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/options/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.lbMakeCommand, (String)bundle.getString("ToolCollectionPanel.lbMakeCommand.text"));
        this.lbMakeCommand.setToolTipText(bundle.getString("ToolCollectionPanel.lbMakeCommand.toolTipText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbMakeCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfMakePath, gridBagConstraints);
        this.btMakeBrowse.setText(bundle.getString("ToolCollectionPanel.btMakeBrowse.text"));
        this.btMakeBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btMakeBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btMakeBrowse, gridBagConstraints);
        this.lbDebuggerCommand.setLabelFor(this.tfDebuggerPath);
        Mnemonics.setLocalizedText((JLabel)this.lbDebuggerCommand, (String)bundle.getString("ToolCollectionPanel.lbDebuggerCommand.text"));
        this.lbDebuggerCommand.setToolTipText(bundle.getString("ToolCollectionPanel.lbDebuggerCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbDebuggerCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfDebuggerPath, gridBagConstraints);
        this.btDebuggerBrowse.setText(bundle.getString("ToolCollectionPanel.btDebuggerBrowse.text"));
        this.btDebuggerBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btDebuggerBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btDebuggerBrowse, gridBagConstraints);
        this.lbCCommand.setLabelFor(this.tfCPath);
        Mnemonics.setLocalizedText((JLabel)this.lbCCommand, (String)bundle.getString("ToolCollectionPanel.lbCCommand.text"));
        this.lbCCommand.setToolTipText(bundle.getString("ToolCollectionPanel.lbCCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCCommand, gridBagConstraints);
        this.tfCPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCPath, gridBagConstraints);
        this.btCBrowse.setText(bundle.getString("ToolCollectionPanel.btCBrowse.text"));
        this.btCBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btCBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btCBrowse, gridBagConstraints);
        this.lbCppCommand.setLabelFor(this.tfCppPath);
        Mnemonics.setLocalizedText((JLabel)this.lbCppCommand, (String)bundle.getString("ToolCollectionPanel.lbCppCommand.text"));
        this.lbCppCommand.setToolTipText(bundle.getString("ToolCollectionPanel.lbCppCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCppCommand, gridBagConstraints);
        this.tfCppPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCppPath, gridBagConstraints);
        this.btCppBrowse.setText(bundle.getString("ToolCollectionPanel.btCppBrowse.text"));
        this.btCppBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btCppBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btCppBrowse, gridBagConstraints);
        this.lbFortranCommand.setLabelFor(this.tfFortranPath);
        Mnemonics.setLocalizedText((JLabel)this.lbFortranCommand, (String)bundle.getString("ToolCollectionPanel.lbFortranCommand.text"));
        this.lbFortranCommand.setToolTipText(bundle.getString("ToolCollectionPanel.lbFortranCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbFortranCommand, gridBagConstraints);
        this.tfFortranPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfFortranPath, gridBagConstraints);
        this.btFortranBrowse.setText(bundle.getString("ToolCollectionPanel.btFortranBrowse.text"));
        this.btFortranBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btFortranBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btFortranBrowse, gridBagConstraints);
        this.lbFamily.setText(bundle.getString("ToolCollectionPanel.lbFamily.text"));
        this.lbFamily.setToolTipText(bundle.getString("ToolCollectionPanel.lbFamily.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.lbFamily, gridBagConstraints);
        this.requiredToolsLabel.setText(bundle.getString("ToolCollectionPanel.requiredToolsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.add((Component)this.requiredToolsLabel, gridBagConstraints);
        this.cbQMakeRequired.setToolTipText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.cbQMakeRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cbQMakeRequired, gridBagConstraints);
        this.cbMakeRequired.setSelected(true);
        this.cbMakeRequired.setToolTipText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.cbMakeRequired.text"));
        this.cbMakeRequired.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cbMakeRequired, gridBagConstraints);
        this.cbDebuggerRequired.setToolTipText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.cbDebuggerRequired.text"));
        this.cbDebuggerRequired.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cbDebuggerRequired, gridBagConstraints);
        this.cbCRequired.setToolTipText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.cbCRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cbCRequired, gridBagConstraints);
        this.cbCppRequired.setToolTipText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.cbCppRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cbCppRequired, gridBagConstraints);
        this.cbFortranRequired.setToolTipText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.cbFortranRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cbFortranRequired, gridBagConstraints);
        this.cbAsRequired.setToolTipText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.cbAsRequired.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cbAsRequired, gridBagConstraints);
        this.lbBaseDirectory.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbBaseDirectory.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.add((Component)this.tfBaseDirectory, gridBagConstraints);
        this.lbAsCommand.setLabelFor(this.tfAsPath);
        Mnemonics.setLocalizedText((JLabel)this.lbAsCommand, (String)bundle.getString("ToolCollectionPanel.lbAsCommand.text"));
        this.lbAsCommand.setToolTipText(bundle.getString("ToolCollectionPanel.lbAsCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbAsCommand, gridBagConstraints);
        this.tfAsPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfAsPath, gridBagConstraints);
        this.btAsBrowse.setText(bundle.getString("ToolCollectionPanel.btAsBrowse.text"));
        this.btAsBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btAsBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btAsBrowse, gridBagConstraints);
        this.lbQMakePath.setLabelFor(this.tfQMakePath);
        Mnemonics.setLocalizedText((JLabel)this.lbQMakePath, (String)NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbQMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbQMakePath, gridBagConstraints);
        this.lbCMakePath.setLabelFor(this.tfCMakePath);
        Mnemonics.setLocalizedText((JLabel)this.lbCMakePath, (String)NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbCMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCMakePath, gridBagConstraints);
        this.tfQMakePath.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.tfQMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfQMakePath, gridBagConstraints);
        this.tfCMakePath.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.tfCMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCMakePath, gridBagConstraints);
        this.btQMakeBrowse.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.btQMakeBrowse.text"));
        this.btQMakeBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btQMakeBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btQMakeBrowse, gridBagConstraints);
        this.btCMakeBrowse.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.btCMakeBrowse.text"));
        this.btCMakeBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btCMakeBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btCMakeBrowse, gridBagConstraints);
        this.btInstall.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolsPanel.UpdateCenterInstallButton"));
        this.btInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.btInstallActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.btInstall, gridBagConstraints);
        this.scrollPane.setBorder(null);
        this.scrollPane.setMinimumSize(new Dimension(0, 0));
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        this.scrollPane.setViewportView(this.tpInstall);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lbFamilyValue.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbFamilyValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.lbFamilyValue, gridBagConstraints);
        this.lbEncoding.setLabelFor(this.encodingComboBox);
        Mnemonics.setLocalizedText((JLabel)this.lbEncoding, (String)NbBundle.getMessage(ToolCollectionPanel.class, (String)"EncodingLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel2.add((Component)this.lbEncoding, gridBagConstraints);
        this.encodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolCollectionPanel.this.encodingComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.jPanel2.add((Component)this.encodingComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.requiredSeparator, gridBagConstraints);
    }

    private void btMakeBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfMakePath, false);
    }

    private void btDebuggerBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfDebuggerPath, false);
    }

    private void btCBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfCPath, true);
    }

    private void btCppBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfCppPath, true);
    }

    private void btFortranBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfFortranPath, true);
    }

    private void btAsBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfAsPath, true);
    }

    private void btQMakeBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfQMakePath, false);
    }

    private void btCMakeBrowseActionPerformed(ActionEvent evt) {
        this.selectTool(this.tfCMakePath, false);
    }

    private void btInstallActionPerformed(ActionEvent evt) {
        CompilerSet cs = this.manager.getCurrentCompilerSet();
        DownloadUtils.downloadCompilerSet(cs);
        this.manager.fireToolColectionPanelChanged();
    }

    private void encodingComboBoxActionPerformed(ActionEvent evt) {
        CompilerSet currentCompilerSet;
        if (!this.update && this.encodingComboBox.getSelectedItem() instanceof Charset && (currentCompilerSet = this.manager.getCurrentCompilerSet()) != null) {
            APIAccessor.get().setCharset((Charset)this.encodingComboBox.getSelectedItem(), currentCompilerSet);
            this.manager.fireToolColectionPanelChanged();
        }
    }

    private static final class MyCheckBox
    extends JCheckBox {
        private boolean invalid = true;
        private final JLabel test = new JLabel();

        private MyCheckBox() {
        }

        private void setInvalid(boolean invalid) {
            this.invalid = invalid;
            this.invalidate();
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            String s;
            Rectangle clipBounds = g.getClipBounds();
            g.setColor(this.test.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            String string = s = this.isSelected() ? "*" : " ";
            if (this.invalid) {
                g.setColor(Color.RED);
            } else {
                g.setColor(this.test.getForeground());
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font bold = new Font(g.getFont().getFamily(), 1, g.getFont().getSize());
            g.setFont(bold);
            FontMetrics fontMetrics = g.getFontMetrics();
            g.drawString(s, (this.getWidth() - fontMetrics.stringWidth(s)) / 2, fontMetrics.getHeight());
        }
    }
}

