/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.options;

import java.io.IOException;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public class ToolsUtils {
    private ToolsUtils() {
    }

    public static void ensureHostSetup(ExecutionEnvironment env) {
        if (env != null) {
            ServerList.get((ExecutionEnvironment)env);
        }
    }

    public static boolean isDevHostValid(ExecutionEnvironment env) {
        ServerRecord record = ServerList.get((ExecutionEnvironment)env);
        return record != null && record.isOnline();
    }

    public static String getDefaultDirectory(ExecutionEnvironment env) {
        String seed;
        if (env.isLocal()) {
            seed = System.getProperty("user.home");
        } else if (!HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env) || !ConnectionManager.getInstance().isConnectedTo(env)) {
            seed = null;
        } else {
            try {
                seed = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir();
            }
            catch (IOException ex) {
                seed = null;
            }
            catch (ConnectionManager.CancellationException ex) {
                seed = null;
            }
        }
        return seed;
    }
}

