/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.annotation;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.javascript2.debug.tooltip.DebuggerTooltipSupport;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;

public class WebJSDebuggerTooltipSupport
implements DebuggerTooltipSupport {
    private final Debugger debugger;
    private final CallFrame frame;
    private Debugger.Listener closeableListener;

    public WebJSDebuggerTooltipSupport(Debugger debugger, CallFrame frame) {
        this.debugger = debugger;
        this.frame = frame;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public CallFrame getFrame() {
        return this.frame;
    }

    public void addCloseable(Closeable closeable) {
        this.closeableListener = new CloseableDebuggerListener(closeable);
        this.debugger.addListener(this.closeableListener);
    }

    public void removeCloseable(Closeable closeable) {
        this.debugger.removeListener(this.closeableListener);
    }

    private static class CloseableDebuggerListener
    implements Debugger.Listener {
        private final Closeable closeable;

        public CloseableDebuggerListener(Closeable closeable) {
            this.closeable = closeable;
        }

        public void paused(List<CallFrame> callStack, String reason) {
        }

        public void resumed() {
            this.doClose();
        }

        public void reset() {
            this.doClose();
        }

        public void enabled(boolean enabled) {
            if (!enabled) {
                this.doClose();
            }
        }

        private void doClose() {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

