/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompilerSettings;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.FSImpl;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.Relocatable;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapperImpl;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class BaseProvider
implements DiscoveryProvider {
    private final AtomicBoolean isStoped = new AtomicBoolean(false);
    private final Interrupter stopIterrupter = new Interrupter(){

        public boolean cancelled() {
            if (BaseProvider.this.isStoped.get()) {
                return true;
            }
            Interrupter aProjectInterrupter = BaseProvider.this.projectInterrupter;
            return aProjectInterrupter != null && aProjectInterrupter.cancelled();
        }
    };
    private Interrupter projectInterrupter;
    private RelocatablePathMapperImpl mapper;
    private CompilerSettings myCommpilerSettings;
    private FileSystem fileSystem;
    private RelocatablePathMapper.FS fs;
    protected final ProviderProperty<String> RESTRICT_SOURCE_ROOT_PROPERTY = new ProviderProperty<String>(){
        private String myPath = "";

        public String getName() {
            return BaseProvider.i18n("RESTRICT_SOURCE_ROOT");
        }

        public String getDescription() {
            return BaseProvider.i18n("RESTRICT_SOURCE_ROOT");
        }

        public String getValue() {
            return this.myPath;
        }

        public void setValue(String value) {
            this.myPath = value;
        }

        public ProviderPropertyType<String> getPropertyType() {
            return ProviderPropertyType.RestrictSourceRootPropertyType;
        }
    };
    protected final ProviderProperty<String> RESTRICT_COMPILE_ROOT_PROPERTY = new ProviderProperty<String>(){
        private String myPath = "";

        public String getName() {
            return BaseProvider.i18n("RESTRICT_COMPILE_ROOT");
        }

        public String getDescription() {
            return BaseProvider.i18n("RESTRICT_COMPILE_ROOT");
        }

        public String getValue() {
            return this.myPath;
        }

        public void setValue(String value) {
            this.myPath = value;
        }

        public ProviderPropertyType<String> getPropertyType() {
            return ProviderPropertyType.RestrictCompileRootPropertyType;
        }
    };

    public final void init(ProjectProxy project) {
        this.myCommpilerSettings = new CompilerSettings(project);
        this.mapper = new RelocatablePathMapperImpl(project);
        this.fileSystem = this.getFileSystem(project);
        this.fs = new FSImpl(this.fileSystem);
    }

    public final void store(ProjectProxy project) {
        this.mapper.save();
    }

    public boolean isApplicable(ProjectProxy project) {
        return true;
    }

    public final boolean cancel() {
        this.isStoped.set(true);
        return true;
    }

    protected final void resetStopInterrupter(Interrupter projectInterrupter) {
        this.projectInterrupter = projectInterrupter;
        this.isStoped.set(false);
    }

    protected final Interrupter getStopInterrupter() {
        return this.stopIterrupter;
    }

    protected final FileSystem getFileSystem(ProjectProxy project) {
        Project p;
        if (project != null && (p = project.getProject()) != null) {
            return RemoteFileUtil.getProjectSourceFileSystem((Lookup.Provider)p);
        }
        return CndFileUtils.getLocalFileSystem();
    }

    protected FileSystem getSourceFileSystem() {
        return this.fileSystem;
    }

    protected final RelocatablePathMapper getRelocatablePathMapper() {
        return this.mapper;
    }

    protected final CompilerSettings getCommpilerSettings() {
        return this.myCommpilerSettings;
    }

    protected abstract List<SourceFileProperties> getSourceFileProperties(String var1, Map<String, SourceFileProperties> var2, ProjectProxy var3, Set<String> var4, List<String> var5, CompileLineStorage var6);

    protected void before() {
    }

    protected void after() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<SourceFileProperties> getSourceFileProperties(String[] objFileName, Progress progress, ProjectProxy project, Set<String> dlls, List<String> buildArtifacts, CompileLineStorage storage) {
        try {
            this.before();
            ConcurrentHashMap<String, SourceFileProperties> map = new ConcurrentHashMap<String, SourceFileProperties>();
            if (objFileName.length == 1) {
                String oldThreadName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("Analyzing " + objFileName[0]);
                    this.processArtifactFile(objFileName[0], map, progress, project, dlls, buildArtifacts, storage);
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                }
                Thread.currentThread().setName(oldThreadName);
            } else {
                CountDownLatch countDownLatch = new CountDownLatch(objFileName.length);
                RequestProcessor rp = new RequestProcessor("Parallel analyzing", CndUtils.getNumberCndWorkerThreads());
                for (String file : objFileName) {
                    MyRunnable r = new MyRunnable(countDownLatch, file, map, progress, project, dlls, buildArtifacts, storage);
                    rp.post((Runnable)r);
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ArrayList<SourceFileProperties> list = new ArrayList<SourceFileProperties>();
            list.addAll(map.values());
            ArrayList<SourceFileProperties> arrayList = list;
            return arrayList;
        }
        finally {
            PathCache.dispose();
            this.getCommpilerSettings().dispose();
            this.after();
        }
    }

    private FileObject resolvePath(ProjectProxy project, String buildArtifact, SourceFileProperties f, String name) {
        RelocatablePathMapper.ResolvedPath resolvedPath;
        FileObject fo = this.fileSystem.findResource(name);
        if (!(f instanceof Relocatable)) {
            return fo;
        }
        String sourceRoot = null;
        if (project != null && (sourceRoot = project.getSourceRoot()) != null && sourceRoot.length() < 2) {
            sourceRoot = null;
        }
        if (sourceRoot == null && (sourceRoot = PathUtilities.getDirName((String)buildArtifact)) != null && sourceRoot.length() < 2) {
            sourceRoot = null;
        }
        if (sourceRoot != null) {
            sourceRoot = sourceRoot.replace('\\', '/');
        }
        if (fo == null || !fo.isValid()) {
            resolvedPath = this.mapper.getPath(name);
            if (resolvedPath == null) {
                if (sourceRoot != null && this.mapper.discover(this.fs, sourceRoot, name) && (fo = this.fileSystem.findResource((resolvedPath = this.mapper.getPath(name)).getPath())) != null && fo.isValid() && fo.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, this.fs);
                    return fo;
                }
            } else {
                fo = this.fileSystem.findResource(resolvedPath.getPath());
                if (fo != null && fo.isValid() && fo.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, this.fs);
                    return fo;
                }
            }
        }
        if (fo != null && fo.isData()) {
            name = fo.getPath();
            resolvedPath = this.mapper.getPath(name);
            if (resolvedPath == null) {
                FileObject resolved;
                if (sourceRoot != null && !name.startsWith(sourceRoot) && this.mapper.discover(this.fs, sourceRoot, name) && (resolved = this.fileSystem.findResource((resolvedPath = this.mapper.getPath(name)).getPath())) != null && resolved.isValid() && resolved.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, this.fs);
                    return resolved;
                }
            } else {
                FileObject resolved = this.fileSystem.findResource(resolvedPath.getPath());
                if (resolved != null && resolved.isValid() && resolved.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, this.fs);
                    return resolved;
                }
            }
            sourceRoot = null;
            if (project != null && (sourceRoot = project.getSourceRoot()) != null && sourceRoot.length() < 2) {
                sourceRoot = null;
            }
            if (sourceRoot == null && (sourceRoot = PathUtilities.getBaseName((String)name)) != null && sourceRoot.length() < 2) {
                sourceRoot = null;
            }
            if (sourceRoot != null) {
                ((Relocatable)f).resolveIncludePaths(sourceRoot, this.mapper, this.fs);
            }
            return fo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processArtifactFile(String file, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy project, Set<String> dlls, List<String> buildArtifacts, CompileLineStorage storage) {
        String restrictCompileRoot;
        String restrictSourceRoot;
        if (this.isStoped.get()) {
            return true;
        }
        ProjectBridge bridge = null;
        if (project.getProject() != null) {
            bridge = new ProjectBridge(project.getProject());
        }
        if ((restrictSourceRoot = (String)this.RESTRICT_SOURCE_ROOT_PROPERTY.getValue()) != null && !restrictSourceRoot.isEmpty()) {
            restrictSourceRoot = CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)restrictSourceRoot);
        }
        if ((restrictCompileRoot = (String)this.RESTRICT_COMPILE_ROOT_PROPERTY.getValue()) != null && !restrictCompileRoot.isEmpty()) {
            restrictCompileRoot = CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)restrictCompileRoot);
        }
        for (SourceFileProperties f : this.getSourceFileProperties(file, map, project, dlls, buildArtifacts, storage)) {
            if (this.isStoped.get()) break;
            String name = f.getItemPath();
            if (name == null || restrictSourceRoot != null && !name.startsWith(restrictSourceRoot)) continue;
            FileObject fo = this.resolvePath(project, file, f, name);
            if (fo == null) {
                if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                DwarfSource.LOG.log(Level.FINE, "Not Exist {0}", name);
                continue;
            }
            boolean skip = false;
            if (restrictCompileRoot != null && f.getCompilePath() != null && !f.getCompilePath().startsWith(restrictCompileRoot)) {
                String relPath;
                Item item;
                skip = true;
                if (bridge != null && (item = bridge.getProjectItem(relPath = bridge.getRelativepath(fo.getPath()))) != null) {
                    skip = false;
                }
            }
            if (skip) {
                if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                DwarfSource.LOG.log(Level.FINE, "Skiped {0}", name);
                continue;
            }
            name = fo.getPath();
            SourceFileProperties existed = map.get(name);
            if (existed == null) {
                map.put(name, f);
                continue;
            }
            if (existed.getUserInludePaths().size() < f.getUserInludePaths().size()) {
                map.put(name, f);
                continue;
            }
            if (existed.getUserInludePaths().size() != f.getUserInludePaths().size()) continue;
            if (existed.getUserMacros().size() < f.getUserMacros().size()) {
                map.put(name, f);
                continue;
            }
            if (existed.getUserMacros().size() != f.getUserMacros().size() || this.macrosWeight(existed) >= this.macrosWeight(f)) continue;
            map.put(name, f);
        }
        if (progress != null) {
            Progress progress2 = progress;
            synchronized (progress2) {
                progress.increment(file);
            }
        }
        return false;
    }

    private int macrosWeight(SourceFileProperties f) {
        int sum = 0;
        for (String m : f.getUserMacros().keySet()) {
            for (int i = 0; i < m.length(); ++i) {
                sum += m.charAt(i);
            }
        }
        return sum;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(BaseProvider.class, (String)id);
    }

    private class MyRunnable
    implements Runnable {
        private final String file;
        private final Map<String, SourceFileProperties> map;
        private final Progress progress;
        private final CountDownLatch countDownLatch;
        private final ProjectProxy project;
        private final Set<String> dlls;
        private final List<String> buildArtifacts;
        private final CompileLineStorage storage;

        private MyRunnable(CountDownLatch countDownLatch, String file, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy project, Set<String> dlls, List<String> buildArtifacts, CompileLineStorage storage) {
            this.file = file;
            this.map = map;
            this.progress = progress;
            this.countDownLatch = countDownLatch;
            this.project = project;
            this.dlls = dlls;
            this.buildArtifacts = buildArtifacts;
            this.storage = storage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!BaseProvider.this.isStoped.get()) {
                    Thread.currentThread().setName("Parallel analyzing " + this.file);
                    BaseProvider.this.processArtifactFile(this.file, this.map, this.progress, this.project, this.dlls, this.buildArtifacts, this.storage);
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

