/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.DriverFactory;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompilerSettings;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.FSImpl;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatableImpl;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;
import org.netbeans.modules.cnd.dwarfdump.source.Artifacts;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class ExecLogReader {
    private static final String CYG_DRIVE = "/cygdrive/";
    private final String root;
    private final FileObject logFileObject;
    private List<SourceFileProperties> result;
    private List<String> buildArtifacts;
    private final ProjectProxy project;
    private final PathMap pathMapper;
    private final RelocatablePathMapper localMapper;
    private final FileSystem fileSystem;
    private final RelocatablePathMapper.FS fs;
    private final CompilerSettings compilerSettings;
    private final Set<String> C_NAMES;
    private final Set<String> CPP_NAMES;
    private final Set<String> FORTRAN_NAMES;
    private final Set<String> LIBREARIES_NAMES;
    private int logType = 0;

    public ExecLogReader(FileObject logFileObject, String root, ProjectProxy project, RelocatablePathMapper relocatablePathMapper, FileSystem fileSystem) {
        String sourceRoot;
        this.logFileObject = logFileObject;
        this.project = project;
        this.pathMapper = this.getPathMapper(project);
        this.localMapper = relocatablePathMapper;
        this.fileSystem = fileSystem;
        this.fs = new FSImpl(fileSystem);
        this.compilerSettings = new CompilerSettings(project);
        this.C_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.CCompiler);
        this.CPP_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.CCCompiler);
        this.FORTRAN_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.FortranCompiler);
        this.LIBREARIES_NAMES = new HashSet<String>();
        this.LIBREARIES_NAMES.add("ld");
        this.LIBREARIES_NAMES.add("ar");
        if (project != null && root.isEmpty() && (sourceRoot = project.getSourceRoot()) != null && sourceRoot.length() > 1) {
            root = sourceRoot;
        }
        if (root.isEmpty() && (sourceRoot = PathUtilities.getDirName((String)logFileObject.getPath())) != null && sourceRoot.length() > 1) {
            root = sourceRoot;
        }
        this.root = root.length() > 0 ? CndFileUtils.normalizeAbsolutePath((FileSystem)fileSystem, (String)root) : root;
    }

    private PathMap getPathMapper(ProjectProxy project) {
        Project p;
        if (project != null && (p = project.getProject()) != null) {
            return RemoteSyncSupport.getPathMap((Lookup.Provider)p);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isSupportedLog(FileObject file) {
        block24: {
            if (!(file != null && file.isValid() && file.isData() && file.canRead())) {
                return false;
            }
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new InputStreamReader(file.getInputStream()));
                do {
                    if ((line = in.readLine()) != null) continue;
                    break block24;
                } while ((line = line.trim()).isEmpty());
                if (line.startsWith("called:")) {
                    boolean bl = true;
                    return bl;
                }
                if (line.trim().startsWith("[") || line.trim().startsWith("{")) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Progress progress, Interrupter isStoped, CompileLineStorage storage) {
        this.result = new ArrayList<SourceFileProperties>();
        this.buildArtifacts = new ArrayList<String>();
        if (this.logFileObject != null && this.logFileObject.isValid() && this.logFileObject.canRead()) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.logFileObject.getInputStream()));
                long length = this.logFileObject.getSize();
                long read = 0L;
                int done = 0;
                if (length <= 0L) {
                    progress = null;
                }
                if (progress != null) {
                    progress.start(100);
                }
                try {
                    String tool = null;
                    ArrayList<String> params = new ArrayList<String>();
                    String directory = null;
                    String command = null;
                    String cu = null;
                    while (!isStoped.cancelled()) {
                        String line = in.readLine();
                        if (line == null) {
                            break;
                        }
                        if (this.logType == 0) {
                            if (line.startsWith("called:")) {
                                this.logType = 1;
                            } else if (line.trim().startsWith("[") || line.trim().startsWith("{")) {
                                this.logType = 2;
                            }
                        }
                        if ((read += (long)(line.length() + 1)) * 100L / length > (long)done && done < 100) {
                            ++done;
                            if (progress != null) {
                                progress.increment(null);
                            }
                        }
                        if (this.logType == 1) {
                            if (line.startsWith("called:")) {
                                tool = line.substring(7).trim();
                                continue;
                            }
                            if (line.startsWith("\t")) {
                                params.add(line.substring(1).trim());
                                continue;
                            }
                            if (line.length() != 0) continue;
                            try {
                                this.addSources(tool, params, storage);
                            }
                            catch (Throwable ex) {
                                DwarfSource.LOG.log(Level.INFO, "Tool:" + tool, ex);
                                for (String p : params) {
                                    DwarfSource.LOG.log(Level.INFO, "\t{0}", p);
                                }
                            }
                            tool = null;
                            params = new ArrayList();
                            continue;
                        }
                        if (this.logType != 2 || (line = line.trim()).startsWith("[") || line.startsWith("]") || line.startsWith("{")) continue;
                        if (line.startsWith("}")) {
                            if (directory != null && command != null && cu != null) {
                                try {
                                    this.addSources(directory, command, cu, storage);
                                }
                                catch (Throwable ex) {
                                    DwarfSource.LOG.log(Level.INFO, "directory:" + directory + "\ncommand:" + command + "\nfile:" + this.logFileObject, ex);
                                }
                            }
                            directory = null;
                            command = null;
                            cu = null;
                            continue;
                        }
                        String pattern = "\"directory\":";
                        if (line.startsWith(pattern)) {
                            directory = line.substring(pattern.length() + 1).trim();
                        }
                        if (line.startsWith(pattern = "\"command\":")) {
                            command = line.substring(pattern.length() + 1).trim();
                        }
                        if (!line.startsWith(pattern = "\"file\":")) continue;
                        cu = line.substring(pattern.length() + 1).trim();
                    }
                }
                finally {
                    if (progress != null) {
                        progress.done();
                    }
                }
                in.close();
            }
            catch (IOException ex) {
                DwarfSource.LOG.log(Level.INFO, "Cannot read file " + this.logFileObject, ex);
            }
        }
    }

    public List<SourceFileProperties> getResults(Progress progress, Interrupter isStoped, CompileLineStorage storage) {
        if (this.result == null) {
            this.run(progress, isStoped, storage);
        }
        return this.result;
    }

    public List<String> getArtifacts(Progress progress, Interrupter isStoped, CompileLineStorage storage) {
        if (this.buildArtifacts == null) {
            this.run(progress, isStoped, storage);
        }
        return this.buildArtifacts;
    }

    private String removeQuotes(String s) {
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return DiscoveryUtils.removeQuotes((String)s);
    }

    private void addSources(String directory, String command, String cu, CompileLineStorage storage) {
        directory = this.removeQuotes(directory);
        List parseArgs = ImportUtils.parseArgs((String)(command = this.removeQuotes(command)));
        if (parseArgs.isEmpty()) {
            throw new IllegalArgumentException("Wrong entry");
        }
        Iterator<String> iterator = parseArgs.iterator();
        String tool = (String)iterator.next();
        String compiler = (tool = tool.replace('\\', '/')).lastIndexOf(47) > 0 ? tool.substring(tool.lastIndexOf(47) + 1) : tool;
        if (compiler.endsWith(".exe")) {
            compiler = compiler.substring(0, compiler.lastIndexOf(46));
        }
        ItemProperties.LanguageKind language = this.C_NAMES.contains(compiler) ? ItemProperties.LanguageKind.C : (this.CPP_NAMES.contains(compiler) ? ItemProperties.LanguageKind.CPP : (this.FORTRAN_NAMES.contains(compiler) ? ItemProperties.LanguageKind.Fortran : ItemProperties.LanguageKind.Unknown));
        cu = this.removeQuotes(cu);
        this.addSource(compiler, language, iterator, directory, storage, cu);
    }

    private void addSources(String tool, List<String> args, CompileLineStorage storage) {
        Iterator<String> iterator;
        ItemProperties.LanguageKind language;
        String compilePath = null;
        String compiler = tool.lastIndexOf(47) > 0 ? tool.substring(tool.lastIndexOf(47) + 1) : tool;
        if (this.C_NAMES.contains(compiler)) {
            language = ItemProperties.LanguageKind.C;
        } else if (this.CPP_NAMES.contains(compiler)) {
            language = ItemProperties.LanguageKind.CPP;
        } else if (this.FORTRAN_NAMES.contains(compiler)) {
            language = ItemProperties.LanguageKind.Fortran;
        } else {
            if (this.LIBREARIES_NAMES.contains(compiler)) {
                this.processLibrary(compiler, args, storage);
                return;
            }
            language = ItemProperties.LanguageKind.Unknown;
        }
        if (args.size() > 0) {
            if (this.pathMapper != null) {
                compilePath = this.pathMapper.getLocalPath(args.get(0));
                if (compilePath == null) {
                    compilePath = args.get(0);
                } else if (Utilities.isWindows()) {
                    compilePath = compilePath.replace('\\', '/');
                }
            } else {
                compilePath = args.get(0);
            }
        }
        if ((iterator = args.iterator()).hasNext()) {
            iterator.next();
        }
        if (iterator.hasNext()) {
            iterator.next();
        }
        this.addSource(compiler, language, iterator, compilePath, storage, null);
    }

    private String convertCygwinPath(String path) {
        if (Utilities.isWindows() && path.startsWith(CYG_DRIVE) && path.length() >= CYG_DRIVE.length() + 2 && path.charAt(CYG_DRIVE.length() + 1) == '/') {
            path = path.substring(CYG_DRIVE.length());
            path = "" + Character.toUpperCase(path.charAt(0)) + ':' + path.substring(1);
        }
        return path;
    }

    private void addSource(String compiler, ItemProperties.LanguageKind language, Iterator<String> iterator, String compilePath, CompileLineStorage storage, String cu) {
        compilePath = this.convertCygwinPath(compilePath);
        ArrayList<String> args = new ArrayList<String>();
        while (iterator.hasNext()) {
            String relPath;
            String filePath;
            FileObject fo;
            String next = iterator.next();
            if (next.startsWith("@") && (fo = this.fileSystem.findResource(filePath = CndPathUtilities.isPathAbsolute((CharSequence)(relPath = next.substring(1))) ? relPath : compilePath + "/" + relPath)) != null && fo.isValid()) {
                try {
                    List lines = fo.asLines();
                    if (lines == null || lines.size() <= 0) continue;
                    next = ((String)lines.get(0)).trim();
                    List additional = this.compilerSettings.getDriver().splitCommandLine(next, CompileLineOrigin.DwarfCompileLine);
                    for (String option : additional) {
                        if ((option.startsWith("'") && option.endsWith("'") || option.startsWith("\"") && option.endsWith("\"")) && option.length() >= 2) {
                            option = option.substring(1, option.length() - 1);
                        }
                        args.add(option);
                    }
                    continue;
                }
                catch (IOException ex) {
                    continue;
                }
            }
            args.add(next);
        }
        Artifacts artifacts = this.compilerSettings.getDriver().gatherCompilerLine(args.listIterator(), CompileLineOrigin.ExecLog, language == ItemProperties.LanguageKind.CPP);
        if (cu != null) {
            artifacts.getInput().clear();
            artifacts.getInput().add(cu);
        }
        for (String what : artifacts.getInput()) {
            String resolvedLink;
            String mime;
            String sourceName;
            String fullName;
            String mapped;
            if (what == null || what.endsWith(".s") || what.endsWith(".S")) continue;
            ArrayList<String> userIncludes = new ArrayList<String>(artifacts.getUserIncludes().size());
            for (String s : artifacts.getUserIncludes()) {
                if (CndPathUtilities.isPathAbsolute((CharSequence)s) && this.pathMapper != null && (mapped = this.pathMapper.getLocalPath(s)) != null) {
                    s = mapped;
                    if (Utilities.isWindows()) {
                        s = s.replace('\\', '/');
                    }
                }
                s = this.convertCygwinPath(s);
                userIncludes.add(PathCache.getString(s));
            }
            ArrayList userFiles = new ArrayList(artifacts.getUserFiles().size());
            userFiles.addAll(artifacts.getUserFiles());
            HashMap<String, String> userMacros = new HashMap<String, String>(artifacts.getUserMacros().size());
            for (Map.Entry e : artifacts.getUserMacros().entrySet()) {
                if (e.getValue() == null) {
                    userMacros.put(PathCache.getString((String)e.getKey()), null);
                    continue;
                }
                userMacros.put(PathCache.getString((String)e.getKey()), PathCache.getString((String)e.getValue()));
            }
            if (CndPathUtilities.isPathAbsolute((CharSequence)what)) {
                if (this.pathMapper != null && (mapped = this.pathMapper.getLocalPath(what)) != null) {
                    what = mapped;
                    if (Utilities.isWindows()) {
                        what = what.replace('\\', '/');
                    }
                }
                fullName = what = this.convertCygwinPath(what);
                sourceName = DiscoveryUtils.getRelativePath((String)compilePath, (String)what);
            } else {
                fullName = compilePath + "/" + what;
                sourceName = what;
            }
            fullName = PathCache.getString(fullName);
            if (artifacts.getLanguageArtifacts().contains("c")) {
                language = ItemProperties.LanguageKind.C;
            } else if (artifacts.getLanguageArtifacts().contains("c++")) {
                language = ItemProperties.LanguageKind.CPP;
            } else if (language == ItemProperties.LanguageKind.Unknown) {
                mime = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)fullName);
                if ("text/x-c++".equals(mime)) {
                    language = ItemProperties.LanguageKind.CPP;
                } else if ("text/x-c".equals(mime)) {
                    language = ItemProperties.LanguageKind.C;
                }
            } else if (language == ItemProperties.LanguageKind.C && !compiler.equals("cc") && "text/x-c++".equals(mime = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)fullName))) {
                language = ItemProperties.LanguageKind.CPP;
            }
            ExecSource res = new ExecSource(storage);
            res.compilePath = compilePath;
            res.compiler = compiler;
            res.sourceName = sourceName;
            if (this.project.resolveSymbolicLinks() && (resolvedLink = DiscoveryUtils.resolveSymbolicLink((FileSystem)this.fileSystem, (String)fullName)) != null) {
                fullName = resolvedLink;
            }
            res.fullName = fullName = this.compilerSettings.normalizePath(fullName);
            res.language = language;
            res.userIncludes = userIncludes;
            res.userFiles = userFiles;
            res.userMacros = userMacros;
            res.undefinedMacros = artifacts.getUserUndefinedMacros();
            res.importantFlags = DriverFactory.importantFlagsToString((Artifacts)artifacts);
            res.standard = DriverFactory.getLanguageStandard((ItemProperties.LanguageStandard)res.standard, (Artifacts)artifacts);
            if (storage != null) {
                StringBuilder buf = new StringBuilder();
                for (String s : args) {
                    String s2;
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    if (s.equals(s2 = CndPathUtilities.quoteIfNecessary((String)s))) {
                        int j;
                        if (s.indexOf(34) > 0 && (j = s.indexOf("\\\"")) < 0) {
                            s = s.replace("\"", "\\\"");
                        }
                    } else {
                        s = s2;
                    }
                    buf.append(s);
                }
                res.handler = storage.putCompileLine(buf.toString());
            }
            this.result.add(res);
        }
    }

    private FileObject convertPath(String path) {
        FileObject fo = this.fileSystem.findResource(path);
        if (!(this.localMapper == null || fo != null && fo.isValid())) {
            RelocatablePathMapper.ResolvedPath resolvedPath = this.localMapper.getPath(path);
            if (resolvedPath == null) {
                if (this.root != null && this.localMapper.discover(this.fs, this.root, path)) {
                    resolvedPath = this.localMapper.getPath(path);
                    fo = this.fileSystem.findResource(resolvedPath.getPath());
                }
            } else {
                fo = this.fileSystem.findResource(resolvedPath.getPath());
            }
        }
        return fo;
    }

    private void processLibrary(String tool, List<String> args, CompileLineStorage storage) {
        if (!"ar".equals(tool) && "ld".equals(tool)) {
            String anCompilePath;
            Iterator<String> iterator = args.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            String compilePath = iterator.next();
            if (this.pathMapper != null && (anCompilePath = this.pathMapper.getLocalPath(compilePath)) != null) {
                compilePath = anCompilePath;
            }
            if (!iterator.hasNext()) {
                return;
            }
            iterator.next();
            String binary = null;
            while (iterator.hasNext()) {
                String option = iterator.next();
                if (!"-o".equals(option) || !iterator.hasNext()) continue;
                binary = iterator.next();
                break;
            }
            if (binary != null) {
                FileObject folder;
                String fullName;
                if (CndPathUtilities.isPathAbsolute(binary)) {
                    String mapped;
                    if (this.pathMapper != null && (mapped = this.pathMapper.getLocalPath(binary)) != null) {
                        binary = mapped;
                    }
                    fullName = binary;
                } else {
                    fullName = compilePath + "/" + binary;
                }
                FileObject f = this.fileSystem.findResource(fullName);
                if (f == null && (folder = this.fileSystem.findResource(compilePath)) != null && folder.isValid() && folder.isFolder()) {
                    folder.refresh();
                    f = this.fileSystem.findResource(fullName);
                }
                if (f != null && f.isValid() && f.isData()) {
                    this.buildArtifacts.add(fullName);
                } else {
                    f = this.convertPath(fullName);
                    if (f != null && f.isValid() && f.isData()) {
                        this.buildArtifacts.add(fullName);
                    }
                }
            }
        }
    }

    private static final class ExecSource
    extends RelocatableImpl
    implements SourceFileProperties {
        private String sourceName;
        private String compiler;
        private ItemProperties.LanguageKind language;
        private ItemProperties.LanguageStandard standard = ItemProperties.LanguageStandard.Unknown;
        private final List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private List<String> undefinedMacros;
        private final Map<String, String> systemMacros = Collections.emptyMap();
        private final CompileLineStorage storage;
        private int handler = -1;
        private String importantFlags;

        private ExecSource(CompileLineStorage storage) {
            this.storage = storage;
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getCompileLine() {
            return this.storage.getCompileLine(this.handler);
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getUserInludeFiles() {
            return this.userFiles;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public List<String> getUndefinedMacros() {
            return this.undefinedMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }

        public String getCompilerName() {
            return this.compiler;
        }

        public ItemProperties.LanguageStandard getLanguageStandard() {
            return this.standard;
        }

        public String getImportantFlags() {
            return this.importantFlags;
        }
    }
}

