/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.Relocatable;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;

public class RelocatableImpl
implements Relocatable {
    protected String compilePath;
    protected String fullName;
    protected List<String> userIncludes;
    protected List<String> userFiles;
    protected Set<String> includedFiles = Collections.emptySet();

    @Override
    public void resetItemPath(RelocatablePathMapper.ResolvedPath resolved, RelocatablePathMapper mapper, RelocatablePathMapper.FS fs) {
        String path = resolved.getPath();
        RelocatablePathMapper.ResolvedPath resolverCompilePath = mapper.getPath(this.compilePath);
        if (resolverCompilePath != null) {
            this.compilePath = PathCache.getString(resolverCompilePath.getPath());
        }
        this.resolveIncludePaths(resolved.getRoot(), mapper, fs);
        this.fullName = PathCache.getString(path);
    }

    @Override
    public void resolveIncludePaths(String root, RelocatablePathMapper mapper, RelocatablePathMapper.FS fs) {
        HashSet<String> newIncludedFiles = new HashSet<String>();
        for (String incl : this.includedFiles) {
            RelocatablePathMapper.ResolvedPath resolvedIncluded = mapper.getPath(incl);
            if (resolvedIncluded != null) {
                newIncludedFiles.add(PathCache.getString(resolvedIncluded.getPath()));
                continue;
            }
            newIncludedFiles.add(incl);
        }
        this.includedFiles = newIncludedFiles;
        ArrayList<String> newUserIncludes = new ArrayList<String>();
        for (String incl : this.userIncludes) {
            String newIncl = null;
            if ((incl.startsWith("/") || incl.length() > 2 && incl.charAt(1) == ':') && !incl.startsWith(root)) {
                RelocatablePathMapper.ResolvedPath resolvedIncluded = mapper.getPath(incl);
                if (resolvedIncluded != null) {
                    newIncl = PathCache.getString(resolvedIncluded.getPath());
                } else if (mapper.discover(fs, root, incl)) {
                    newIncl = PathCache.getString(mapper.getPath(incl).getPath());
                }
            }
            if (newIncl == null) {
                newIncl = incl;
            }
            newUserIncludes.add(newIncl);
        }
        this.userIncludes = newUserIncludes;
        ArrayList<String> newUserFiles = new ArrayList<String>();
        for (String incl : this.userFiles) {
            String newIncl = null;
            if ((incl.startsWith("/") || incl.length() > 2 && incl.charAt(1) == ':') && !incl.startsWith(root)) {
                RelocatablePathMapper.ResolvedPath resolvedIncluded = mapper.getPath(incl);
                if (resolvedIncluded != null) {
                    newIncl = PathCache.getString(resolvedIncluded.getPath());
                } else if (mapper.discover(fs, root, incl)) {
                    newIncl = PathCache.getString(mapper.getPath(incl).getPath());
                }
            }
            if (newIncl == null) {
                newIncl = incl;
            }
            newUserFiles.add(newIncl);
        }
        this.userFiles = newUserFiles;
    }
}

