/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.knockout.index;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.knockout.index.KnockoutCustomElement;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class KnockoutIndexer
extends EmbeddingIndexer {
    public static final String CUSTOM_ELEMENT = "ce";
    private static final Logger LOG = Logger.getLogger(KnockoutIndexer.class.getName());
    private static final ThreadLocal<Map<URI, Collection<KnockoutCustomElement>>> customElements = new ThreadLocal();

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        Map<URI, Collection<KnockoutCustomElement>> cElements = customElements.get();
        if (cElements != null && !cElements.isEmpty()) {
            IndexingSupport support;
            try {
                support = IndexingSupport.getInstance((Context)context);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
                return;
            }
            for (Map.Entry<URI, Collection<KnockoutCustomElement>> entry : cElements.entrySet()) {
                URI uri = entry.getKey();
                Collection<KnockoutCustomElement> collection = entry.getValue();
                File file = Utilities.toFile((URI)uri);
                FileObject fo = FileUtil.toFileObject((File)file);
                IndexDocument elementDocument = support.createDocument(fo);
                for (KnockoutCustomElement customElement : collection) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(customElement.getName()).append(":");
                    sb.append(customElement.getFqn()).append(":");
                    sb.append(customElement.getOffset());
                    if (!customElement.getParameters().isEmpty()) {
                        sb.append(":");
                        for (int i = 0; i < customElement.getParameters().size(); ++i) {
                            sb.append(customElement.getParameters().get(i));
                            if (i == customElement.getParameters().size() - 1) continue;
                            sb.append(";");
                        }
                    }
                    elementDocument.addPair(CUSTOM_ELEMENT, sb.toString(), true, true);
                }
                support.addDocument(elementDocument);
            }
        }
    }

    public static void addCustomElement(URI uri, KnockoutCustomElement customElement) {
        Map<URI, Collection<KnockoutCustomElement>> map = customElements.get();
        if (map == null) {
            throw new IllegalStateException("KnockoutIndexer.addCustomElement can be called only from scanner thread.");
        }
        Collection<KnockoutCustomElement> elements = map.get(uri);
        if (elements == null) {
            elements = new ArrayList<KnockoutCustomElement>();
            elements.add(customElement);
            map.put(uri, elements);
        } else {
            elements.add(customElement);
        }
    }

    public static boolean isScannerThread() {
        return customElements.get() != null;
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "knockoutjs";
        public static final int VERSION = 1;
        private static final int PRIORITY = 220;
        private static final ThreadLocal<Collection<Runnable>> postScanTasks = new ThreadLocal();

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new KnockoutIndexer();
            }
            return null;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 1;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            return "text/javascript".equals(snapshot.getMimeType());
        }

        public boolean scanStarted(Context context) {
            postScanTasks.set(new LinkedList());
            customElements.set(new HashMap());
            return super.scanStarted(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scanFinished(Context context) {
            try {
                for (Runnable task : postScanTasks.get()) {
                    task.run();
                }
            }
            finally {
                postScanTasks.remove();
                super.scanFinished(context);
            }
        }

        public static boolean isScannerThread() {
            return postScanTasks.get() != null;
        }

        public static void addPostScanTask(Runnable task) {
            Parameters.notNull((CharSequence)"task", (Object)task);
            Collection<Runnable> tasks = postScanTasks.get();
            if (tasks == null) {
                throw new IllegalStateException("JsIndexer.postScanTask can be called only from scanner thread.");
            }
            tasks.add(task);
        }

        public int getPriority() {
            return 220;
        }
    }
}

