/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.misc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.util.RequestProcessor;

public final class NpmLibrariesUsageLogger
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(NpmLibrariesUsageLogger.class);
    private final PackageJson packageJson;

    private NpmLibrariesUsageLogger(Project project) {
        assert (project != null);
        this.packageJson = new PackageJson(project.getProjectDirectory());
    }

    void startListening() {
        this.packageJson.addPropertyChangeListener(this);
    }

    void stopListening() {
        this.packageJson.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("DEPENDENCIES".equals(propertyName) || "DEV_DEPENDENCIES".equals(propertyName) || "OPTIONAL_DEPENDENCIES".equals(propertyName) || "PEER_DEPENDENCIES".equals(propertyName)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    NpmLibrariesUsageLogger.this.logLibraries();
                }
            });
        }
    }

    void logLibraries() {
        PackageJson.NpmDependencies dependencies = this.packageJson.getDependencies();
        this.logLibraries("REGULAR", dependencies.dependencies);
        this.logLibraries("DEVELOPMENT", dependencies.devDependencies);
        this.logLibraries("OPTIONAL", dependencies.optionalDependencies);
        this.logLibraries("PEER", dependencies.peerDependencies);
    }

    private void logLibraries(String type, Map<String, String> dependencies) {
        for (Map.Entry<String, String> dependency : dependencies.entrySet()) {
            NodeJsUtils.logUsageNpmLibrary(type, dependency.getKey(), dependency.getValue());
        }
    }

    public static NpmLibrariesUsageLogger usageLogger(Project project) {
        return new NpmLibrariesUsageLogger(project);
    }

    public static ProjectOpenedHook projectOpenedHook(Project project) {
        return new NpmProjectOpenedHook(project);
    }

    private static final class NpmProjectOpenedHook
    extends ProjectOpenedHook {
        private final Project project;

        public NpmProjectOpenedHook(Project project) {
            assert (project != null);
            this.project = project;
        }

        protected void projectOpened() {
            this.getUsageLogger().startListening();
        }

        protected void projectClosed() {
            this.getUsageLogger().stopListening();
        }

        private NpmLibrariesUsageLogger getUsageLogger() {
            NpmLibrariesUsageLogger usageLogger = (NpmLibrariesUsageLogger)this.project.getLookup().lookup(NpmLibrariesUsageLogger.class);
            assert (usageLogger != null) : "Usage logger must be found in lookup of: " + this.project.getClass().getName();
            return usageLogger;
        }
    }
}

