/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.build.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class AdvancedTaskPanel
extends JPanel {
    private final String buildToolExec;
    DialogDescriptor descriptor;
    private JLabel optionsLabel;
    private JTextField optionsTextField;
    private JLabel parametersLabel;
    private JTextField parametersTextField;
    private JLabel previewLabel;
    private JTextField previewTextField;
    private JCheckBox sharedCheckBox;
    private JComboBox<String> tasksComboBox;
    private JLabel tasksLabel;

    private AdvancedTaskPanel(String tasksLabel, String buildToolExec, List<String> tasks) {
        assert (EventQueue.isDispatchThread());
        assert (tasksLabel != null);
        assert (buildToolExec != null);
        assert (tasks != null);
        this.buildToolExec = buildToolExec;
        this.initComponents();
        this.init(tasksLabel, tasks);
    }

    @CheckForNull
    public static Pair<Boolean, String> open(String title, String tasksLabel, String buildToolExec, List<String> tasks) {
        DialogDescriptor descriptor;
        assert (EventQueue.isDispatchThread());
        AdvancedTaskPanel panel = new AdvancedTaskPanel(tasksLabel, buildToolExec, tasks);
        panel.descriptor = descriptor = new DialogDescriptor((Object)panel, title, true, null);
        panel.taskChanged();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
            return Pair.of((Object)panel.isSharedTask(), (Object)panel.getTask());
        }
        return null;
    }

    private void init(String tasksLabel, List<String> tasks) {
        Mnemonics.setLocalizedText((JLabel)this.tasksLabel, (String)tasksLabel);
        this.tasksComboBox.setModel(new DefaultComboBoxModel<String>(tasks.toArray(new String[tasks.size()])));
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.optionsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.tasksComboBox.addActionListener(new DefaultActionListener());
        this.parametersTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    String getTask() {
        String parameters;
        String tasks;
        StringBuilder sb = new StringBuilder();
        String options = this.optionsTextField.getText();
        if (StringUtilities.hasText(options)) {
            sb.append(options);
        }
        if (StringUtilities.hasText(tasks = (String)this.tasksComboBox.getSelectedItem())) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(tasks);
        }
        if (StringUtilities.hasText(parameters = this.parametersTextField.getText())) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(parameters);
        }
        return sb.toString();
    }

    boolean isSharedTask() {
        return this.sharedCheckBox.isSelected();
    }

    void taskChanged() {
        this.validateTask();
        this.setPreview();
    }

    private void validateTask() {
        assert (EventQueue.isDispatchThread());
        this.descriptor.setValid(StringUtilities.hasText(this.getTask()));
    }

    private void setPreview() {
        this.previewTextField.setText(this.buildToolExec + " " + this.getTask());
    }

    private void initComponents() {
        this.optionsLabel = new JLabel();
        this.optionsTextField = new JTextField();
        this.tasksLabel = new JLabel();
        this.tasksComboBox = new JComboBox();
        this.parametersLabel = new JLabel();
        this.parametersTextField = new JTextField();
        this.previewLabel = new JLabel();
        this.previewTextField = new JTextField();
        this.sharedCheckBox = new JCheckBox();
        this.optionsLabel.setLabelFor(this.optionsTextField);
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(AdvancedTaskPanel.class, (String)"AdvancedTaskPanel.optionsLabel.text"));
        this.tasksLabel.setLabelFor(this.tasksComboBox);
        Mnemonics.setLocalizedText((JLabel)this.tasksLabel, (String)"TASKS:");
        this.tasksComboBox.setEditable(true);
        this.parametersLabel.setLabelFor(this.parametersTextField);
        Mnemonics.setLocalizedText((JLabel)this.parametersLabel, (String)NbBundle.getMessage(AdvancedTaskPanel.class, (String)"AdvancedTaskPanel.parametersLabel.text"));
        this.previewLabel.setLabelFor(this.previewTextField);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(AdvancedTaskPanel.class, (String)"AdvancedTaskPanel.previewLabel.text"));
        this.previewTextField.setEditable(false);
        this.sharedCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.sharedCheckBox, (String)NbBundle.getMessage(AdvancedTaskPanel.class, (String)"AdvancedTaskPanel.sharedCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parametersLabel).addComponent(this.tasksLabel).addComponent(this.optionsLabel).addComponent(this.previewLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsTextField).addComponent(this.parametersTextField).addComponent(this.previewTextField).addGroup(layout.createSequentialGroup().addComponent(this.sharedCheckBox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.tasksComboBox, 0, 487, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel).addComponent(this.optionsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tasksLabel).addComponent(this.tasksComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parametersLabel).addComponent(this.parametersTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previewTextField, -2, -1, -2).addComponent(this.previewLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sharedCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedTaskPanel.this.taskChanged();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            AdvancedTaskPanel.this.taskChanged();
        }
    }
}

