/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerEvent;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public final class BookmarksNodeTree {
    private static final Logger LOG = Logger.getLogger(BookmarksNodeTree.class.getName());
    private BookmarksRootNode rootNode = new BookmarksRootNode();

    BookmarksNodeTree() {
    }

    Node rootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodeTree() {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            this.rootNode.children().updateKeys(lockedBookmarkManager.getSortedActiveProjectBookmarks());
            List projectNodes = this.rootNode.getChildren().snapshot();
            for (Node pNode : projectNodes) {
                ProjectBookmarksChildren pChildren = (ProjectBookmarksChildren)pNode.getChildren();
                pChildren.updateKeys(lockedBookmarkManager.getSortedFileBookmarks(pChildren.projectBookmarks));
                for (Node fNode : pChildren.snapshot()) {
                    FileBookmarksChildren fChildren = (FileBookmarksChildren)fNode.getChildren();
                    fChildren.updateKeys(lockedBookmarkManager.getSortedBookmarks(fChildren.fileBookmarks));
                }
            }
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    public void updateBookmarkNodes(BookmarkManagerEvent evt) {
        List<BookmarkNode> bookmarkNodes = this.bookmarkNodes(false);
        for (BookmarkNode bookmarkNode : bookmarkNodes) {
            if (evt.getChange(bookmarkNode.getBookmarkInfo()) == null) continue;
            bookmarkNode.notifyBookmarkChanged();
        }
    }

    public Map<BookmarkInfo, BookmarkNode> createBookmark2NodeMap() {
        List<BookmarkNode> bNodes = this.bookmarkNodes(true);
        HashMap<BookmarkInfo, BookmarkNode> bookmark2NodeMap = new HashMap<BookmarkInfo, BookmarkNode>(bNodes.size() << 1, 0.5f);
        for (BookmarkNode bNode : bNodes) {
            bookmark2NodeMap.put(bNode.getBookmarkInfo(), bNode);
        }
        return bookmark2NodeMap;
    }

    public List<BookmarkNode> bookmarkNodes(boolean addBookmarksWindowNode) {
        ArrayList<BookmarkNode> bookmarkNodes = new ArrayList<BookmarkNode>();
        if (addBookmarksWindowNode) {
            bookmarkNodes.add(new BookmarkNode(BookmarkInfo.BOOKMARKS_WINDOW));
        }
        this.collectBookmarkNodes(bookmarkNodes, (Node)this.rootNode);
        return bookmarkNodes;
    }

    public Node findFirstBookmarkNode(ProjectBookmarks projectBookmarks, FileObject fo) {
        if (this.rootNode != null) {
            List projectNodes = this.rootNode.getChildren().snapshot();
            for (Node pNode : projectNodes) {
                ProjectBookmarksChildren pChildren = (ProjectBookmarksChildren)pNode.getChildren();
                if (pChildren.projectBookmarks != projectBookmarks) continue;
                for (Node fNode : pChildren.snapshot()) {
                    List bNodes;
                    FileBookmarksChildren fChildren = (FileBookmarksChildren)fNode.getChildren();
                    if (fChildren.fileBookmarks.getFileObject() != fo || (bNodes = fChildren.snapshot()).isEmpty()) continue;
                    return (Node)bNodes.get(0);
                }
            }
        }
        return null;
    }

    private void collectBookmarkNodes(List<BookmarkNode> bookmarkNodes, Node n) {
        if (n instanceof BookmarkNode) {
            bookmarkNodes.add((BookmarkNode)n);
        } else {
            for (Node cn : n.getChildren().getNodes(true)) {
                this.collectBookmarkNodes(bookmarkNodes, cn);
            }
        }
    }

    static final class FileBookmarksChildren
    extends Children.Keys<BookmarkInfo> {
        final FileBookmarks fileBookmarks;

        FileBookmarksChildren(FileBookmarks fileBookmarks) {
            this.fileBookmarks = fileBookmarks;
        }

        public FileBookmarks getFileBookmarks() {
            return this.fileBookmarks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addNotify() {
            super.addNotify();
            BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
            try {
                this.updateKeys(lockedBookmarkManager.getSortedBookmarks(this.fileBookmarks));
            }
            finally {
                lockedBookmarkManager.unlock();
            }
        }

        void updateKeys(BookmarkInfo[] bookmarks) {
            this.setKeys(bookmarks);
        }

        protected Node[] createNodes(BookmarkInfo bookmark) {
            return new Node[]{new BookmarkNode(bookmark)};
        }
    }

    static final class ProjectBookmarksChildren
    extends Children.Keys<FileBookmarks> {
        final ProjectBookmarks projectBookmarks;

        ProjectBookmarksChildren(ProjectBookmarks projectBookmarks) {
            this.projectBookmarks = projectBookmarks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addNotify() {
            super.addNotify();
            BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
            try {
                this.updateKeys(lockedBookmarkManager.getSortedFileBookmarks(this.projectBookmarks));
            }
            finally {
                lockedBookmarkManager.unlock();
            }
        }

        void updateKeys(FileBookmarks[] sortedFileBookmarks) {
            this.setKeys(sortedFileBookmarks);
        }

        protected Node[] createNodes(FileBookmarks fileBookmarks) {
            Node foNode;
            FileObject fo = fileBookmarks.getFileObject();
            if (fo == null) {
                return null;
            }
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                foNode = dob.getNodeDelegate().cloneNode();
            }
            catch (DataObjectNotFoundException ex) {
                foNode = new AbstractNode(Children.LEAF);
                foNode.setDisplayName(fo.getNameExt());
            }
            return new Node[]{new FilterNode(foNode, (Children)new FileBookmarksChildren(fileBookmarks)){

                public boolean canCopy() {
                    return false;
                }

                public boolean canCut() {
                    return false;
                }

                public boolean canDestroy() {
                    return false;
                }

                public boolean canRename() {
                    return false;
                }
            }};
        }
    }

    static final class BookmarksRootNodeChildren
    extends Children.Keys<ProjectBookmarks> {
        BookmarksRootNodeChildren() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addNotify() {
            super.addNotify();
            BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
            try {
                this.updateKeys(lockedBookmarkManager.getSortedActiveProjectBookmarks());
            }
            finally {
                lockedBookmarkManager.unlock();
            }
        }

        void updateKeys(List<ProjectBookmarks> sortedProjectBookmarks) {
            this.updateKeys(sortedProjectBookmarks.toArray(new ProjectBookmarks[sortedProjectBookmarks.size()]));
        }

        void updateKeys(ProjectBookmarks[] sortedProjectBookmarks) {
            this.setKeys(sortedProjectBookmarks);
        }

        protected Node[] createNodes(ProjectBookmarks projectBookmarks) {
            Node prjNode;
            URI prjURI = projectBookmarks.getProjectURI();
            Project prj = BookmarkUtils.findProject(prjURI);
            LogicalViewProvider lvp = prj != null ? (LogicalViewProvider)prj.getLookup().lookup(LogicalViewProvider.class) : null;
            Node node = prjNode = lvp != null ? lvp.createLogicalView() : null;
            if (prjNode == null) {
                prjNode = new AbstractNode(Children.LEAF);
                prjNode.setDisplayName(projectBookmarks.getProjectDisplayName());
            }
            FilterNode retNode = new FilterNode(prjNode, (Children)new ProjectBookmarksChildren(projectBookmarks)){

                public boolean canCopy() {
                    return false;
                }

                public boolean canCut() {
                    return false;
                }

                public boolean canDestroy() {
                    return false;
                }

                public boolean canRename() {
                    return false;
                }
            };
            return new Node[]{retNode};
        }
    }

    static final class BookmarksRootNode
    extends AbstractNode {
        public BookmarksRootNode() {
            super((Children)new BookmarksRootNodeChildren());
        }

        BookmarksRootNodeChildren children() {
            return (BookmarksRootNodeChildren)this.getChildren();
        }
    }
}

