/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.sync.TimeStamps;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferInfo;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigRemoteValidator;
import org.netbeans.modules.php.project.ui.actions.Bundle;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.support.RememberAsSyncPanel;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public abstract class RemoteCommand
extends Command {
    private static final char SEP_CHAR = '=';
    private static final int MAX_TYPE_SIZE = RemoteCommand.getFileTypeLabelMaxSize() + 2;
    private static final Color COLOR_SUCCESS = Color.GREEN.darker().darker();
    private static final Color COLOR_IGNORE = Color.ORANGE.darker();
    private static final RequestProcessor RP = new RequestProcessor("Remote connection", 1);
    private static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        @Override
        public void run() {
            Runnable toRun = (Runnable)RUNNABLES.poll();
            while (toRun != null) {
                toRun.run();
                toRun = (Runnable)RUNNABLES.poll();
            }
        }
    }, true);
    private static final AtomicBoolean ASK_REMEMBER_SYNC = new AtomicBoolean(true);
    private static final AtomicBoolean DO_SYNC = new AtomicBoolean(true);

    public RemoteCommand(PhpProject project) {
        super(project);
    }

    @Override
    public boolean isFileSensitive() {
        return true;
    }

    @Override
    public final void invokeActionInternal(Lookup context) {
        assert (this.getConfigAction().getClass().getSimpleName().equals("ConfigActionRemote")) : "Remote config action expected but found: " + this.getConfigAction().getClass().getSimpleName();
        if (RunConfigRemoteValidator.validateRemoteTransfer(RunConfigRemote.forProject(this.getProject())) != null) {
            PhpProjectUtils.openCustomizerRun(this.getProject());
            return;
        }
        RUNNABLES.add(this.getContextRunnable(context));
        TASK.schedule(0);
    }

    @Override
    public final boolean isActionEnabledInternal(Lookup context) {
        return this.isRemoteConfigSelected() && TASK.isFinished();
    }

    protected abstract Runnable getContextRunnable(Lookup var1);

    @Override
    public final boolean asyncCallRequired() {
        return false;
    }

    public static InputOutput getRemoteLog(String displayName) {
        return RemoteCommand.getRemoteLog(displayName, true);
    }

    public static InputOutput getRemoteLog(String displayName, boolean select) {
        InputOutput io = IOProvider.getDefault().getIO(NbBundle.getMessage(Command.class, (String)"LBL_RemoteLog", (Object)displayName), false);
        if (select) {
            io.select();
        }
        try {
            io.getOut().reset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return io;
    }

    protected RemoteClient getRemoteClient(InputOutput io) {
        RunConfigRemote runConfig = RunConfigRemote.forProject(this.getProject());
        return new RemoteClient(runConfig.getRemoteConfiguration(), new RemoteClient.AdvancedProperties().setInputOutput(io).setAdditionalInitialSubdirectory(runConfig.getUploadDirectory()).setPreservePermissions(runConfig.arePermissionsPreserved()).setUploadDirectly(runConfig.getUploadDirectly()).setPhpVisibilityQuery(PhpVisibilityQuery.forProject(this.getProject())));
    }

    protected boolean isRemoteConfigSelected() {
        PhpProjectProperties.RunAsType runAs = ProjectPropertiesSupport.getRunAs(this.getProject());
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)runAs);
    }

    protected static void processTransferInfo(TransferInfo transferInfo, InputOutput io) {
        RemoteCommand.processTransferInfo(transferInfo, io, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSummary"));
    }

    /*
     * WARNING - void declaration
     */
    protected static void processTransferInfo(TransferInfo transferInfo, InputOutput io, String title) {
        void var12_21;
        Cloneable sorted;
        OutputWriter out = io.getOut();
        OutputWriter err = io.getErr();
        out.println();
        out.println(title);
        StringBuilder sep = new StringBuilder(20);
        for (int i = 0; i < sep.capacity(); ++i) {
            sep.append('=');
        }
        out.println(sep.toString());
        int maxRelativePath = RemoteCommand.getRelativePathMaxSize(transferInfo);
        long size = 0L;
        int files = 0;
        if (transferInfo.hasAnyTransfered()) {
            RemoteCommand.printSuccess(io, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSucceeded"));
            sorted = new ArrayList<TransferFile>(transferInfo.getTransfered());
            Collections.sort(sorted, TransferFile.TRANSFER_FILE_COMPARATOR);
            Iterator<Object> i$ = ((ArrayList)sorted).iterator();
            while (i$.hasNext()) {
                TransferFile transferFile = (TransferFile)i$.next();
                RemoteCommand.printSuccess(io, maxRelativePath, transferFile);
                if (!transferFile.isFile()) continue;
                size += transferFile.getSize();
                ++files;
            }
        }
        if (transferInfo.hasAnyFailed()) {
            err.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteFailed"));
            sorted = new TreeMap(TransferFile.TRANSFER_FILE_COMPARATOR);
            sorted.putAll(transferInfo.getFailed());
            for (Map.Entry entry : sorted.entrySet()) {
                RemoteCommand.printError(err, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyPartiallyFailed()) {
            err.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemotePartiallyFailed"));
            sorted = new TreeMap(TransferFile.TRANSFER_FILE_COMPARATOR);
            sorted.putAll(transferInfo.getPartiallyFailed());
            for (Map.Entry entry : sorted.entrySet()) {
                RemoteCommand.printError(err, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyIgnored()) {
            RemoteCommand.printIgnore(io, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteIgnored"));
            sorted = new TreeMap(TransferFile.TRANSFER_FILE_COMPARATOR);
            sorted.putAll(transferInfo.getIgnored());
            for (Map.Entry entry : sorted.entrySet()) {
                RemoteCommand.printIgnore(io, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        long runtime = transferInfo.getRuntime();
        String string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitMilisecond");
        if (runtime > 1000L) {
            runtime /= 1000L;
            String string2 = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitSecond");
        }
        double s = (double)size / 1024.0;
        String sizeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitKilobyte");
        if (s > 1024.0) {
            s /= 1024.0;
            sizeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitMegabyte");
        }
        Object[] params = new Object[]{runtime, var12_21, files, s, sizeUnit};
        out.println(NbBundle.getMessage(RemoteCommand.class, (String)"MSG_RemoteRuntimeAndSize", (Object[])params));
    }

    private static void print(InputOutput io, String message, Color color) {
        try {
            IOColorLines.println((InputOutput)io, (CharSequence)message, (Color)color);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void printSuccess(InputOutput io, String message) {
        RemoteCommand.print(io, message.trim(), COLOR_SUCCESS);
    }

    private static void printSuccess(InputOutput io, int maxRelativePath, TransferFile file) {
        String message = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s", RemoteCommand.getFileTypeLabel(file), file.getRemotePath());
        RemoteCommand.printSuccess(io, message);
    }

    private static void printError(OutputWriter writer, int maxRelativePath, TransferFile file, String reason) {
        String msg = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s   %s", RemoteCommand.getFileTypeLabel(file), file.getRemotePath(), reason);
        writer.println(msg);
    }

    private static void printIgnore(InputOutput io, String message) {
        RemoteCommand.print(io, message, COLOR_IGNORE);
    }

    private static void printIgnore(InputOutput io, int maxRelativePath, TransferFile file, String reason) {
        String msg = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s   %s", RemoteCommand.getFileTypeLabel(file), file.getRemotePath(), reason);
        RemoteCommand.printIgnore(io, msg);
    }

    private static String getFileTypeLabel(TransferFile file) {
        String type = null;
        type = file.isDirectory() ? "LBL_TypeDirectory" : (file.isFile() ? "LBL_TypeFile" : (file.isLink() ? "LBL_TypeLink" : "LBL_TypeUnknown"));
        return NbBundle.getMessage(RemoteCommand.class, (String)type);
    }

    private static int getFileTypeLabelMaxSize() {
        int max = 0;
        for (String label : Arrays.asList("LBL_TypeDirectory", "LBL_TypeFile", "LBL_TypeLink", "LBL_TypeUnknown")) {
            int length = NbBundle.getMessage(RemoteCommand.class, (String)label).length();
            if (max >= length) continue;
            max = length;
        }
        return max;
    }

    private static int getRelativePathMaxSize(TransferInfo transferInfo) {
        int max = RemoteCommand.getRelativePathMaxSize(transferInfo.getTransfered());
        int size = RemoteCommand.getRelativePathMaxSize(transferInfo.getFailed().keySet());
        if (size > max) {
            max = size;
        }
        if ((size = RemoteCommand.getRelativePathMaxSize(transferInfo.getPartiallyFailed().keySet())) > max) {
            max = size;
        }
        if ((size = RemoteCommand.getRelativePathMaxSize(transferInfo.getIgnored().keySet())) > max) {
            max = size;
        }
        return max + 2;
    }

    private static int getRelativePathMaxSize(Collection<TransferFile> files) {
        int max = 0;
        for (TransferFile file : files) {
            int length = file.getRemotePath().length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    protected final boolean sourcesFilesOnly(FileObject sources, FileObject[] selectedFiles) {
        for (FileObject file : selectedFiles) {
            if (FileUtil.isParentOf((FileObject)sources, (FileObject)file) || sources.equals(file)) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoteCommand.class, (String)"MSG_TransferSourcesOnly"), 0));
            return false;
        }
        return true;
    }

    protected static boolean isSourcesSelected(FileObject sources, FileObject[] selectedFiles) {
        for (FileObject fo : selectedFiles) {
            if (!sources.equals(fo)) continue;
            return true;
        }
        return false;
    }

    protected static void storeLastSync(final PhpProject project, final RemoteClient remoteClient, final FileObject sources, boolean possiblyAskUser) {
        if (!DO_SYNC.get()) {
            return;
        }
        if (possiblyAskUser && ASK_REMEMBER_SYNC.get()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean store;
                    RememberAsSyncPanel panel = new RememberAsSyncPanel();
                    NotifyDescriptor descriptor = new NotifyDescriptor((Object)panel, Bundle.RemoteCommand_sync_remember_title(), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.NO_OPTION);
                    boolean bl = store = DialogDisplayer.getDefault().notify(descriptor) == NotifyDescriptor.YES_OPTION;
                    if (panel.isDoNotAskAgain()) {
                        ASK_REMEMBER_SYNC.set(false);
                        DO_SYNC.set(store);
                    }
                    if (store) {
                        RUNNABLES.add(new Runnable(){

                            @Override
                            public void run() {
                                RemoteCommand.storeLastSyncInternal(project, remoteClient, sources);
                            }
                        });
                        TASK.schedule(0);
                    }
                }
            });
            return;
        }
        RemoteCommand.storeLastSyncInternal(project, remoteClient, sources);
    }

    static void storeLastSyncInternal(PhpProject project, RemoteClient remoteClient, FileObject sources) {
        assert (!EventQueue.isDispatchThread());
        assert (DO_SYNC.get());
        TimeStamps timeStamps = new TimeStamps(project);
        timeStamps.setSyncTimestamp(RemoteCommand.getRemoteRoot(remoteClient, sources));
    }

    static TransferFile getRemoteRoot(RemoteClient remoteClient, FileObject sources) {
        File sourceDir = FileUtil.toFile((FileObject)sources);
        return TransferFile.fromFile(remoteClient.createRemoteClientImplementation(sourceDir.getAbsolutePath()), null, sourceDir);
    }

    public static final class DefaultOperationMonitor
    implements RemoteClient.OperationMonitor {
        private static final Logger LOGGER = Logger.getLogger(DefaultOperationMonitor.class.getName());
        private final Deque<RemoteClient.Operation> operations = new ArrayDeque<RemoteClient.Operation>();
        private final ProgressHandle progressHandle;
        private int workUnits = 0;
        private int workUnit = 0;
        private boolean sizeIssueLogged = false;

        public DefaultOperationMonitor(ProgressHandle progressHandle, Set<TransferFile> forFiles) {
            if (progressHandle == null) {
                throw new IllegalStateException("Progress handle must be set");
            }
            this.progressHandle = progressHandle;
            this.workUnits = this.getWorkUnits(forFiles);
            if (this.workUnits < 0) {
                LOGGER.log(Level.WARNING, "Negative number of workunits {0} for transfer files {1}", new Object[]{this.workUnits, forFiles});
                this.workUnits = forFiles.size();
            }
        }

        @Override
        public void operationStart(RemoteClient.Operation operation, Collection<TransferFile> forFiles) {
            if (this.operations.isEmpty()) {
                assert (this.workUnits >= 0) : this.workUnits + " :: " + forFiles;
                this.progressHandle.start(this.workUnits);
            }
            this.operations.offerFirst(operation);
            if (operation == RemoteClient.Operation.LIST) {
                this.progressHandle.progress(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_ListingFiles", (Object)forFiles.iterator().next().getName()));
                this.progressHandle.switchToIndeterminate();
            }
        }

        @Override
        public void operationProcess(RemoteClient.Operation operation, TransferFile forFile) {
            int size = this.getSize(forFile);
            switch (operation) {
                case LIST: {
                    if (size <= 0) break;
                    this.workUnits += size;
                    break;
                }
                case UPLOAD: 
                case DOWNLOAD: {
                    if (size <= 0) break;
                    String processMessageKey = operation == RemoteClient.Operation.DOWNLOAD ? "LBL_Downloading" : "LBL_Uploading";
                    this.progressHandle.progress(NbBundle.getMessage(DefaultOperationMonitor.class, (String)processMessageKey, (Object)forFile.getName()), this.workUnit);
                    this.workUnit += size;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported operation: " + (Object)((Object)operation));
                }
            }
        }

        @Override
        public void operationFinish(RemoteClient.Operation operation, Collection<TransferFile> forFiles) {
            this.operations.pollFirst();
            if (operation == RemoteClient.Operation.LIST) {
                this.progressHandle.switchToDeterminate(this.workUnits);
                this.progressHandle.progress(this.workUnit);
            }
            if (this.operations.isEmpty()) {
                this.progressHandle.finish();
            }
        }

        @Override
        public void addUnits(Collection<TransferFile> files) {
            this.progressHandle.switchToIndeterminate();
            this.workUnits += this.getWorkUnits(files);
            this.progressHandle.switchToDeterminate(this.workUnits);
        }

        private int getWorkUnits(Collection<TransferFile> forFiles) {
            int size = 0;
            for (TransferFile file : forFiles) {
                size += this.getSize(file);
            }
            return size;
        }

        private int getSize(TransferFile file) {
            long size = file.getSize();
            if (size < 0L) {
                if (!this.sizeIssueLogged) {
                    LOGGER.log(Level.WARNING, "Negative size {0} of transfer file {1}", new Object[]{size, file});
                    this.sizeIssueLogged = true;
                }
                return 1;
            }
            return (int)(size / 1024L);
        }
    }
}

