/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.php.project.ui.testrunner.Bundle;
import org.netbeans.modules.php.project.ui.testrunner.TestSuiteImpl;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.coverage.Coverage;
import org.netbeans.modules.php.spi.testing.run.OutputLineHandler;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.openide.windows.OutputWriter;

public class TestSessionImpl
implements TestSession {
    private final Manager manager;
    private final org.netbeans.modules.gsf.testrunner.api.TestSession testSession;
    private final PhpTestingProvider testingProvider;
    private volatile Coverage coverage;
    private volatile boolean coverageSet = false;
    private volatile boolean frozen = false;
    private volatile boolean testException = false;

    TestSessionImpl(Manager manager, org.netbeans.modules.gsf.testrunner.api.TestSession testSession, PhpTestingProvider testingProvider) {
        assert (manager != null);
        assert (testSession != null);
        assert (testingProvider != null);
        this.manager = manager;
        this.testSession = testSession;
        this.testingProvider = testingProvider;
    }

    public org.netbeans.modules.php.spi.testing.run.TestSuite addTestSuite(String name, FileObject location) {
        Parameters.notWhitespace((CharSequence)"name", (CharSequence)name);
        this.checkFrozen();
        String suiteName = Bundle.TestSessionImpl_suite_name(this.testingProvider.getDisplayName(), name);
        TestSuite testSuite = new TestSuite(suiteName);
        this.manager.displaySuiteRunning(this.testSession, suiteName);
        this.testSession.addSuite(testSuite);
        return new TestSuiteImpl(this, testSuite, location);
    }

    public void setOutputLineHandler(OutputLineHandler outputLineHandler) {
        Parameters.notNull((CharSequence)"outputLineHandler", (Object)outputLineHandler);
        Manager.getInstance().setOutputLineHandler(this.map(outputLineHandler));
    }

    public void printMessage(String message, boolean error) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        this.manager.displayOutput(this.testSession, message, error);
    }

    public PhpTestingProvider getTestingProvider() {
        return this.testingProvider;
    }

    public void setCoverage(Coverage coverage) {
        this.coverageSet = true;
        this.coverage = coverage;
    }

    @CheckForNull
    public Coverage getCoverage() {
        return this.coverage;
    }

    public boolean isCoverageSet() {
        return this.coverageSet;
    }

    public Manager getManager() {
        return this.manager;
    }

    public org.netbeans.modules.gsf.testrunner.api.TestSession getTestSession() {
        return this.testSession;
    }

    public boolean isTestException() {
        return this.testException;
    }

    public void setTestException(boolean testException) {
        this.testException = testException;
    }

    void freeze() {
        this.frozen = true;
    }

    void checkFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Test session is already frozen (PhpTestingProvider.runTests() already finished)");
        }
    }

    private org.netbeans.modules.gsf.testrunner.ui.api.OutputLineHandler map(final OutputLineHandler outputLineHandler) {
        return new org.netbeans.modules.gsf.testrunner.ui.api.OutputLineHandler(){

            public void handleLine(OutputWriter out, String text) {
                outputLineHandler.handleLine(out, text);
            }
        };
    }
}

