/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.analysis.api;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.filesystems.FileObject;

public class Line2Offset {
    private int[] lines;

    public Line2Offset(FileObject fileObject) {
        try {
            this.init(fileObject);
        }
        catch (IOException ex) {
            this.lines = new int[0];
        }
    }

    private void init(FileObject fileObject) throws IOException {
        LinkedList<Integer> lso = new LinkedList<Integer>();
        lso.add(0);
        int currentPosition = 0;
        for (String s : fileObject.asLines(this.getEncoding(fileObject))) {
            currentPosition += s.length();
            lso.add(++currentPosition);
        }
        this.lines = new int[lso.size() + 1];
        int idx = 0;
        for (Integer offset : lso) {
            this.lines[idx++] = offset;
        }
        this.lines[idx] = currentPosition;
    }

    private String getEncoding(FileObject fo) {
        Charset cs = null;
        if (fo != null && fo.isValid()) {
            cs = FileEncodingQuery.getEncoding((FileObject)fo);
        }
        if (cs == null) {
            cs = FileEncodingQuery.getDefaultEncoding();
        }
        return cs.name();
    }

    public int[] getLineOffset(int line) {
        if (--line < this.lines.length) {
            int start = this.lines[line];
            if (line + 1 < this.lines.length) {
                int end = this.lines[line + 1];
                return new int[]{start, end};
            }
            return new int[]{start, start + 1};
        }
        return new int[]{0, 1};
    }

    public int getLineByOffset(int offset) {
        int low = 0;
        int high = this.lines.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.lines[mid];
            if (midVal < offset) {
                if (low == high) {
                    return low + 1;
                }
                low = mid + 1;
                continue;
            }
            if (midVal > offset) {
                if (low == high) {
                    return low;
                }
                high = mid - 1;
                continue;
            }
            return mid + 1;
        }
        return low;
    }
}

