/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.FileStatusProvider;
import org.netbeans.modules.subversion.FilesystemHandler;
import org.netbeans.modules.subversion.HistoryProvider;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SubversionVisibilityQuery;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnClientRefreshHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.PasswordFile;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.kenai.SvnKenaiAccessor;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Subversion {
    public static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    static final String PROP_BASE_FILE_CHANGED = "baseFileChanged";
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final int STATUS_DIFFABLE = 83192;
    private static Subversion instance;
    private FileStatusCache fileStatusCache;
    private FilesystemHandler filesystemHandler;
    private FileStatusProvider fileStatusProvider;
    private SvnClientRefreshHandler refreshHandler;
    private Annotator annotator;
    private HashMap<String, RequestProcessor> processorsToUrl;
    private List<ISVNNotifyListener> svnNotifyListeners;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final Logger LOG;
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private RequestProcessor parallelRP;
    private HistoryProvider historyProvider;
    RequestProcessor.Task cleanupTask;
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));

    public static synchronized Subversion getInstance() {
        if (instance == null) {
            instance = new Subversion();
            instance.init();
        }
        return instance;
    }

    private Subversion() {
    }

    private void init() {
        this.fileStatusCache = new FileStatusCache();
        this.annotator = new Annotator(this);
        this.fileStatusProvider = new FileStatusProvider();
        this.filesystemHandler = new FilesystemHandler(this);
        this.refreshHandler = new SvnClientRefreshHandler();
        this.prepareCache();
        this.asyncInit();
    }

    public void attachListeners(SubversionVCS svcs) {
        this.fileStatusCache.addVersioningListener(svcs);
        this.addPropertyChangeListener(svcs);
    }

    private void asyncInit() {
        this.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                SvnKenaiAccessor.getInstance().registerVCSNoficationListener();
            }
        }, 500);
    }

    private void prepareCache() {
        this.cleanupTask = this.getRequestProcessor().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Subversion.this.fileStatusCache.ready()) {
                    Subversion.this.fileStatusCache.computeIndex();
                }
                if (DelayScanRegistry.getInstance().isDelayed(Subversion.this.cleanupTask, LOG, "Subversion.cleanupTask")) {
                    return;
                }
                try {
                    LOG.fine("Cleaning up cache");
                    Subversion.this.fileStatusCache.cleanUp();
                }
                finally {
                    LOG.fine("END Cleaning up cache");
                    Subversion.this.cleanupTask = null;
                }
            }
        });
        this.cleanupTask.schedule(500);
    }

    public void shutdown() {
        this.fileStatusProvider.shutdown();
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public HistoryProvider getHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new HistoryProvider();
        }
        return this.historyProvider;
    }

    public SvnClientRefreshHandler getRefreshHandler() {
        return this.refreshHandler;
    }

    public boolean checkClientAvailable() {
        if (SvnClientFactory.wasJavahlCrash()) {
            throw new RuntimeException("It appears that subversion javahl initialization caused trouble in a previous Netbeans session. Please report.");
        }
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return false;
        }
        return true;
    }

    public SvnClient getClient(SVNUrl repositoryUrl, String username, char[] password) throws SVNClientException {
        return this.getClient(repositoryUrl, username, password, 196652);
    }

    public SvnClient getClient(SVNUrl repositoryUrl, String username, char[] password, int handledExceptions) throws SVNClientException {
        SvnClient client = SvnClientFactory.getInstance().createSvnClient(repositoryUrl, null, username, password, handledExceptions);
        this.attachListeners(client);
        return client;
    }

    public SvnClient getClient(SVNUrl repositoryUrl, SvnProgressSupport progressSupport) throws SVNClientException {
        Parameters.notNull((CharSequence)"repositoryUrl", (Object)repositoryUrl);
        String username = "";
        char[] password = null;
        SvnKenaiAccessor kenaiSupport = SvnKenaiAccessor.getInstance();
        if (kenaiSupport.isKenai(repositoryUrl.toString())) {
            PasswordAuthentication pa = kenaiSupport.getPasswordAuthentication(repositoryUrl.toString(), false);
            if (pa != null) {
                username = pa.getUserName();
                password = pa.getPassword();
            }
        } else {
            PasswordFile pf;
            RepositoryConnection rc = SvnModuleConfig.getDefault().getRepositoryConnection(repositoryUrl.toString());
            if (rc != null) {
                username = rc.getUsername();
                password = rc.getPassword();
            } else if (!Utilities.isWindows() && (pf = PasswordFile.findFileForUrl(repositoryUrl)) != null) {
                username = pf.getUsername();
                String psswdString = pf.getPassword();
                password = psswdString != null ? psswdString.toCharArray() : null;
            }
        }
        return this.getClient(repositoryUrl, username, password, progressSupport);
    }

    public SvnClient getClient(SVNUrl repositoryUrl, String username, char[] password, SvnProgressSupport support) throws SVNClientException {
        SvnClient client = SvnClientFactory.getInstance().createSvnClient(repositoryUrl, support, username, password, 196652);
        this.attachListeners(client);
        return client;
    }

    public SvnClient getClient(File file) throws SVNClientException {
        return this.getClient(file, null);
    }

    public SvnClient getClient(File file, SvnProgressSupport support) throws SVNClientException {
        SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(file);
        assert (repositoryUrl != null) : "Unable to get repository: " + file.getAbsolutePath() + " is probably unmanaged.";
        return repositoryUrl == null ? null : this.getClient(repositoryUrl, support);
    }

    public SvnClient getClient(Context ctx, SvnProgressSupport support) throws SVNClientException {
        File[] roots = ctx.getRootFiles();
        SVNUrl repositoryUrl = null;
        for (File root : roots) {
            if (!SvnUtils.isManaged(root)) {
                LOG.log(Level.WARNING, "getClient: unmanaged file in context: {0}", root.getAbsoluteFile());
            }
            if ((repositoryUrl = SvnUtils.getRepositoryRootUrl(root)) != null) break;
            LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
        }
        if (repositoryUrl == null) {
            StringBuilder sb = new StringBuilder("Cannot determine repositoryRootUrl for selected context:");
            for (File root : roots) {
                sb.append("\n").append(root.getAbsolutePath());
            }
            throw new SVNClientException(sb.toString());
        }
        return this.getClient(repositoryUrl, support);
    }

    public SvnClient getClient(SVNUrl repositoryUrl) throws SVNClientException {
        return this.getClient(repositoryUrl, null);
    }

    public SvnClient getClient(boolean attachListeners) throws SVNClientException {
        this.cleanupFilesystem();
        SvnClient client = SvnClientFactory.getInstance().createSvnClient();
        if (attachListeners) {
            this.attachListeners(client);
        }
        return client;
    }

    public void versionedFilesChanged() {
        this.unversionedParents.clear();
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void cleanupFilesystem() {
        this.filesystemHandler.removeInvalidMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachListeners(SvnClient client) {
        client.addNotifyListener(this.getLogger(client.getSvnUrl()));
        client.addNotifyListener(this.refreshHandler);
        List<ISVNNotifyListener> l = this.getSVNNotifyListeners();
        ISVNNotifyListener[] listeners = null;
        List<ISVNNotifyListener> list = l;
        synchronized (list) {
            listeners = l.toArray(new ISVNNotifyListener[l.size()]);
        }
        for (ISVNNotifyListener listener : listeners) {
            client.addNotifyListener(listener);
        }
    }

    public OutputLogger getLogger(SVNUrl repositoryRoot) {
        return OutputLogger.getLogger(repositoryRoot);
    }

    boolean isIgnored(File file) {
        File parent;
        String name;
        block10: {
            int pstatus;
            name = file.getName();
            parent = (file = FileUtil.normalizeFile((File)file)).getParentFile();
            if (parent != null && ((pstatus = this.fileStatusCache.getStatus(parent).getStatus()) & 0x15DF8) != 0) {
                try {
                    SvnClient client = this.getClient(false);
                    List<String> gignores = SvnConfigFiles.getInstance().getGlobalIgnores();
                    if (gignores != null && SvnUtils.getMatchinIgnoreParterns(gignores, name, true).size() > 0) {
                        return true;
                    }
                    List patterns = client.getIgnoredPatterns(parent);
                    if (patterns != null && SvnUtils.getMatchinIgnoreParterns(patterns, name, true).size() > 0) {
                        return true;
                    }
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage()) || SvnClientExceptionHandler.isCancelledAction(ex.getMessage()) || WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block10;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
        }
        if (SharabilityQuery.getSharability((File)file) == 2) {
            block11: {
                try {
                    FileInformation info = this.fileStatusCache.getCachedStatus(file);
                    if (SubversionVisibilityQuery.isHiddenFolder(info, file)) {
                        return false;
                    }
                    if (SharabilityQuery.getSharability((File)parent) != 2 && (this.fileStatusCache.getStatus(parent).getStatus() & 0x15DF8) != 0) {
                        IgnoreAction.ignore(file);
                    }
                }
                catch (SVNClientException ex) {
                    if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block11;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            return true;
        }
        return ".nbintdb".equals(name);
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor(null);
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("Subversion.ParallelTasks", 5, true);
        }
        return this.parallelRP;
    }

    public RequestProcessor getRequestProcessor(SVNUrl url) {
        String key;
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(key = url != null ? url.toString() : "ANY_URL")) == null) {
            rp = new RequestProcessor("Subversion - " + key, 1, true);
            this.processorsToUrl.put(key, rp);
        }
        return rp;
    }

    public File getTopmostManagedAncestor(File file) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "looking for managed parent for {0}", new Object[]{file});
        }
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        File metadataRoot = null;
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            LOG.fine(" part of metaddata");
            while (file != null) {
                if (SvnUtils.isAdministrative(file)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, " will use parent {0}", new Object[]{file});
                    }
                    metadataRoot = file;
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        File topmost = null;
        HashSet<File> done = new HashSet<File>();
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (Utils.isScanForbidden((File)file)) break;
            boolean forbiddenFolder = Utils.isForbiddenFolder((String)file.getAbsolutePath());
            if (!forbiddenFolder && SvnUtils.hasMetadata(file)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                }
                topmost = file;
                done.clear();
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                }
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (topmost == null && metadataRoot != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "setting metadata root as managed parent {0}", new Object[]{metadataRoot});
            }
            topmost = metadataRoot;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "returning managed parent {0}", new Object[]{topmost});
        }
        return topmost;
    }

    FileStatusProvider getVCSAnnotator() {
        return this.fileStatusProvider;
    }

    VCSInterceptor getVCSInterceptor() {
        return this.filesystemHandler;
    }

    private List<ISVNNotifyListener> getSVNNotifyListeners() {
        if (this.svnNotifyListeners == null) {
            this.svnNotifyListeners = new ArrayList<ISVNNotifyListener>();
        }
        return this.svnNotifyListeners;
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void refreshAnnotations(File ... files) {
        HashSet<File> s = new HashSet<File>(Arrays.asList(files));
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, s);
    }

    public void refreshAnnotationsAndSidebars(File ... files) {
        HashSet<File> s = files == null ? null : new HashSet<File>(Arrays.asList(files));
        this.support.firePropertyChange(PROP_BASE_FILE_CHANGED, null, s);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSVNNotifyListener(ISVNNotifyListener listener) {
        List<ISVNNotifyListener> listeners;
        List<ISVNNotifyListener> list = listeners = this.getSVNNotifyListeners();
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSVNNotifyListener(ISVNNotifyListener listener) {
        List<ISVNNotifyListener> listeners;
        List<ISVNNotifyListener> list = listeners = this.getSVNNotifyListeners();
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        block5: {
            FileInformation info = this.fileStatusCache.getStatus(workingCopy);
            if ((info.getStatus() & 0x144F8) == 0) {
                return;
            }
            File original = null;
            try {
                SvnClientFactory.checkClientAvailable();
                original = VersionsCache.getInstance().getBaseRevisionFile(workingCopy);
                if (original == null) {
                    throw new IOException("Unable to get BASE revision of " + workingCopy);
                }
                Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(originalFile), (InputStream)new FileInputStream(original));
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Unable to get original file", e);
            }
            catch (SVNClientException ex) {
                LOG.log(Level.INFO, "Subversion.getOriginalFile: file is managed but svn client is unavailable (file {0})", workingCopy.getAbsolutePath());
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, null, ex);
            }
        }
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.emptyList();
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.subversion");
    }
}

