/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.HyperCompoundModel;
import org.netbeans.modules.viewmodel.ModelRootChangeListener;
import org.netbeans.modules.viewmodel.TreeModelHyperNode;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.Models;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class TreeModelRoot {
    static final long serialVersionUID = -1259352660663524178L;
    private Models.CompoundModel model;
    private HyperCompoundModel hyperModel;
    private ModelChangeListener[] modelListeners;
    private TreeModelNode rootNode;
    private final WeakHashMap<Object, WeakReference<TreeModelNode>[]> objectToNode = new WeakHashMap();
    private DefaultTreeFeatures treeFeatures;
    private ExplorerManager manager;
    private OutlineView outlineView;
    private MessageFormat treeNodeDisplayFormat;

    public TreeModelRoot(Models.CompoundModel model, TreeView treeView) {
        this.model = model;
        this.manager = ExplorerManager.find((Component)treeView);
        this.treeFeatures = new DefaultTreeFeatures(treeView);
        this.modelListeners = new ModelChangeListener[]{new ModelChangeListener(model)};
        model.addModelListener(this.modelListeners[0]);
    }

    public TreeModelRoot(HyperCompoundModel model, TreeView treeView) {
        this.hyperModel = model;
        this.model = model.getMain();
        this.manager = ExplorerManager.find((Component)treeView);
        this.treeFeatures = new DefaultTreeFeatures(treeView);
        int nl = model.getModels().length;
        this.modelListeners = new ModelChangeListener[nl];
        for (int i = 0; i < nl; ++i) {
            Models.CompoundModel m = model.getModels()[i];
            this.modelListeners[i] = new ModelChangeListener(m);
            m.addModelListener(this.modelListeners[i]);
        }
    }

    public TreeModelRoot(Models.CompoundModel model, OutlineView outlineView) {
        this.model = model;
        this.manager = ExplorerManager.find((Component)outlineView);
        this.treeFeatures = new DefaultTreeFeatures(outlineView);
        this.outlineView = outlineView;
        this.modelListeners = new ModelChangeListener[]{new ModelChangeListener(model)};
        model.addModelListener(this.modelListeners[0]);
    }

    public TreeModelRoot(HyperCompoundModel model, OutlineView outlineView) {
        this.hyperModel = model;
        this.model = model.getMain();
        this.manager = ExplorerManager.find((Component)outlineView);
        this.treeFeatures = new DefaultTreeFeatures(outlineView);
        this.outlineView = outlineView;
        int nl = model.getModels().length;
        this.modelListeners = new ModelChangeListener[nl];
        for (int i = 0; i < nl; ++i) {
            Models.CompoundModel m = model.getModels()[i];
            this.modelListeners[i] = new ModelChangeListener(m);
            m.addModelListener(this.modelListeners[i]);
        }
    }

    public Models.TreeFeatures getTreeFeatures() {
        return this.treeFeatures;
    }

    public OutlineView getOutlineView() {
        return this.outlineView;
    }

    public TreeModelNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.hyperModel != null ? new TreeModelHyperNode(this.hyperModel, this, this.model.getRoot()) : new TreeModelNode(this.model, this, this.model.getRoot());
        }
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNode(Object o, TreeModelNode n) {
        WeakHashMap<Object, WeakReference<TreeModelNode>[]> weakHashMap = this.objectToNode;
        synchronized (weakHashMap) {
            WeakReference<TreeModelNode>[] wrs = this.objectToNode.get(o);
            if (wrs == null) {
                this.objectToNode.put(o, new WeakReference[]{new WeakReference<TreeModelNode>(n)});
            } else {
                for (int i = 0; i < wrs.length; ++i) {
                    WeakReference<TreeModelNode> wr = wrs[i];
                    TreeModelNode tn = (TreeModelNode)((Object)wr.get());
                    if (tn == n) {
                        return;
                    }
                    if (tn != null) continue;
                    wrs[i] = new WeakReference<TreeModelNode>(n);
                    return;
                }
                WeakReference[] wrs2 = new WeakReference[wrs.length + 1];
                System.arraycopy(wrs, 0, wrs2, 0, wrs.length);
                wrs2[wrs.length] = new WeakReference<TreeModelNode>(n);
                this.objectToNode.put(o, wrs2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterNode(Object o, TreeModelNode n) {
        WeakHashMap<Object, WeakReference<TreeModelNode>[]> weakHashMap = this.objectToNode;
        synchronized (weakHashMap) {
            WeakReference<TreeModelNode>[] wrs = this.objectToNode.get(o);
            if (wrs != null) {
                for (int i = 0; i < wrs.length; ++i) {
                    WeakReference<TreeModelNode> wr = wrs[i];
                    TreeModelNode tn = (TreeModelNode)((Object)wr.get());
                    if (tn != n) continue;
                    if (wrs.length == 1) {
                        this.objectToNode.remove(o);
                    } else if (wrs.length == 2) {
                        wrs = new WeakReference[]{wrs[(i + 1) % 2]};
                        this.objectToNode.put(o, wrs);
                    } else {
                        WeakReference[] nwrs = new WeakReference[wrs.length - 1];
                        if (i > 0) {
                            System.arraycopy(wrs, 0, nwrs, 0, i);
                        }
                        if (i < wrs.length - 1) {
                            System.arraycopy(wrs, i + 1, nwrs, i, wrs.length - i - 1);
                        }
                        this.objectToNode.put(o, nwrs);
                    }
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeModelNode[] findNode(Object o) {
        WeakReference<TreeModelNode>[] wrs;
        WeakHashMap<Object, WeakReference<TreeModelNode>[]> weakHashMap = this.objectToNode;
        synchronized (weakHashMap) {
            wrs = this.objectToNode.get(o);
        }
        TreeModelNode[] tns = null;
        if (wrs != null) {
            for (int i = 0; i < wrs.length; ++i) {
                WeakReference<TreeModelNode> wr = wrs[i];
                TreeModelNode tn = (TreeModelNode)((Object)wr.get());
                if (tn == null) continue;
                if (tns == null) {
                    tns = new TreeModelNode[]{tn};
                    continue;
                }
                TreeModelNode[] ntns = new TreeModelNode[tns.length + 1];
                System.arraycopy(tns, 0, ntns, 0, tns.length);
                ntns[tns.length] = tn;
                tns = ntns;
            }
        }
        if (tns == null) {
            return new TreeModelNode[0];
        }
        return tns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.model != null) {
            for (ModelChangeListener mchl : this.modelListeners) {
                Models.CompoundModel cm = mchl.getModel();
                if (cm == null) continue;
                cm.removeModelListener(mchl);
            }
            this.treeFeatures.destroy();
            this.treeFeatures = null;
        }
        this.model = null;
        if (this.hyperModel != null) {
            this.hyperModel = null;
        }
        WeakHashMap<Object, WeakReference<TreeModelNode>[]> weakHashMap = this.objectToNode;
        synchronized (weakHashMap) {
            this.objectToNode.clear();
        }
    }

    public synchronized Models.CompoundModel getModel() {
        return this.model;
    }

    void setTreeNodeDisplayFormat(MessageFormat treeNodeDisplayFormat) {
        this.treeNodeDisplayFormat = treeNodeDisplayFormat;
    }

    MessageFormat getTreeNodeDisplayFormat() {
        return this.treeNodeDisplayFormat;
    }

    private final class DefaultTreeFeatures
    extends Models.TreeFeatures
    implements TreeExpansionListener {
        private TreeView view;
        private OutlineView outline;

        private DefaultTreeFeatures(TreeView view) {
            JTree tree;
            this.view = view;
            try {
                Field treeField = TreeView.class.getDeclaredField("tree");
                treeField.setAccessible(true);
                tree = (JTree)treeField.get(view);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            tree.addTreeExpansionListener(this);
        }

        private DefaultTreeFeatures(OutlineView view) {
            this.outline = view;
            view.addTreeExpansionListener((TreeExpansionListener)this);
        }

        public void destroy() {
            if (this.outline != null) {
                this.outline.removeTreeExpansionListener((TreeExpansionListener)this);
            } else {
                JTree tree;
                try {
                    Field treeField = TreeView.class.getDeclaredField("tree");
                    treeField.setAccessible(true);
                    tree = (JTree)treeField.get(this.view);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                tree.removeTreeExpansionListener(this);
            }
        }

        @Override
        public boolean isExpanded(Object node) {
            TreeModelNode[] ns = TreeModelRoot.this.findNode(node);
            if (ns.length == 0) {
                return false;
            }
            if (this.outline != null) {
                return this.outline.isExpanded((Node)ns[0]);
            }
            return this.view.isExpanded((Node)ns[0]);
        }

        @Override
        public void expandNode(Object node) {
            TreeModelNode[] ns;
            for (TreeModelNode n : ns = TreeModelRoot.this.findNode(node)) {
                if (this.outline != null) {
                    this.outline.expandNode((Node)n);
                    continue;
                }
                this.view.expandNode((Node)n);
            }
        }

        @Override
        public void collapseNode(Object node) {
            TreeModelNode[] ns;
            for (TreeModelNode n : ns = TreeModelRoot.this.findNode(node)) {
                if (this.outline != null) {
                    this.outline.collapseNode((Node)n);
                    continue;
                }
                this.view.collapseNode((Node)n);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            Models.CompoundModel model = TreeModelRoot.this.getModel();
            if (model != null) {
                model.nodeExpanded(this.initExpandCollapseNotify(event));
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            Models.CompoundModel model = TreeModelRoot.this.getModel();
            if (model != null) {
                model.nodeCollapsed(this.initExpandCollapseNotify(event));
            }
        }

        private Object initExpandCollapseNotify(TreeExpansionEvent event) {
            Children ch;
            Node node = Visualizer.findNode((Object)event.getPath().getLastPathComponent());
            Object obj = node.getLookup().lookup(Object.class);
            Integer actOn = (node = node.getParentNode()) == null ? new Integer(0) : ((ch = node.getChildren()) instanceof TreeModelNode.TreeModelChildren ? ((TreeModelNode.TreeModelChildren)ch).getTreeDepth() : ch);
            Models.CompoundModel model = TreeModelRoot.this.getModel();
            if (model != null) {
                DefaultTreeExpansionManager.get(model).setChildrenToActOn(actOn);
            }
            return obj;
        }
    }

    private final class ModelChangeListener
    implements ModelRootChangeListener {
        private final Reference<Models.CompoundModel> modelRef;

        public ModelChangeListener(Models.CompoundModel model) {
            this.modelRef = new WeakReference<Models.CompoundModel>(model);
        }

        Models.CompoundModel getModel() {
            return this.modelRef.get();
        }

        @Override
        public void modelChanged(final ModelEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModelEvent.TableValueChanged tvEvent;
                    Object node;
                    Models.CompoundModel model = ModelChangeListener.this.getModel();
                    if (model == null) {
                        return;
                    }
                    if (event instanceof ModelEvent.TableValueChanged && (node = (tvEvent = (ModelEvent.TableValueChanged)event).getNode()) != null) {
                        TreeModelNode[] tmNodes = TreeModelRoot.this.findNode(node);
                        int change = tvEvent.getChange();
                        for (TreeModelNode tmNode : tmNodes) {
                            String column = tvEvent.getColumnID();
                            if (column != null) {
                                tmNode.refreshColumn(column, change);
                                continue;
                            }
                            tmNode.refresh(model);
                        }
                        return;
                    }
                    if (event instanceof ModelEvent.NodeChanged) {
                        ModelEvent.NodeChanged nchEvent = (ModelEvent.NodeChanged)event;
                        node = nchEvent.getNode();
                        if (node != null) {
                            TreeModelNode[] tmNodes;
                            for (TreeModelNode tmNode : tmNodes = TreeModelRoot.this.findNode(node)) {
                                tmNode.refresh(model, nchEvent.getChange());
                            }
                            return;
                        }
                        ArrayList<TreeModelNode> nodes = new ArrayList<TreeModelNode>(TreeModelRoot.this.objectToNode.size());
                        Iterator<Object> i$ = TreeModelRoot.this.objectToNode.values().iterator();
                        while (i$.hasNext()) {
                            WeakReference[] wrs;
                            for (WeakReference wr : wrs = (WeakReference[])i$.next()) {
                                TreeModelNode tm = (TreeModelNode)((Object)wr.get());
                                if (tm == null) continue;
                                nodes.add(tm);
                            }
                        }
                        for (TreeModelNode tmNode : nodes) {
                            tmNode.refresh(model, nchEvent.getChange());
                        }
                        return;
                    }
                    if (event instanceof ModelEvent.SelectionChanged) {
                        final Object[] nodes = ((ModelEvent.SelectionChanged)event).getNodes();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<TreeModelNode> tmNodes = new ArrayList<TreeModelNode>(nodes.length);
                                for (Object node : nodes) {
                                    TreeModelNode[] tmNodesf;
                                    for (TreeModelNode tmNode : tmNodesf = TreeModelRoot.this.findNode(node)) {
                                        tmNodes.add(tmNode);
                                    }
                                }
                                try {
                                    TreeModelRoot.this.manager.setSelectedNodes(tmNodes.toArray(new Node[0]));
                                }
                                catch (PropertyVetoException ex) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Selection of " + Arrays.toString(nodes) + " vetoed.", ex);
                                }
                            }
                        });
                        return;
                    }
                    TreeModelRoot.this.rootNode.setObject(model, model.getRoot());
                }
            });
        }
    }
}

