/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.lexer.SLanguageHierarchy;
import org.netbeans.modules.languages.lexer.SLexer;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.RequestProcessor;

public class ParserManagerImpl
extends ParserManager {
    private Document document;
    private TokenHierarchy tokenHierarchy;
    private ASTNode ast = ASTNode.create(null, "Root", 0);
    private ParserManager.State state = ParserManager.State.NOT_PARSED;
    private List<SyntaxError> syntaxErrors = Collections.emptyList();
    private boolean[] cancel = new boolean[]{false};
    private Set<ParserManagerListener> listeners;
    private Map<String, Set<ASTEvaluator>> evaluatorsMap;
    private static RequestProcessor rp = new RequestProcessor("Parser");
    private RequestProcessor.Task parsingTask;
    private static Map<Document, WeakReference<ParserManager>> managers = new WeakHashMap<Document, WeakReference<ParserManager>>();

    public ParserManagerImpl(Document doc) {
        this.document = doc;
        this.tokenHierarchy = TokenHierarchy.get((Document)doc);
        String mimeType = (String)doc.getProperty("mimeType");
        if (this.tokenHierarchy == null && mimeType != null) {
            try {
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                if (language.getParser() != null) {
                    doc.putProperty(org.netbeans.api.lexer.Language.class, new SLanguageHierarchy(language).language());
                    this.tokenHierarchy = TokenHierarchy.get((Document)doc);
                }
            }
            catch (LanguageDefinitionNotFoundException ex) {
                // empty catch block
            }
        }
        if (this.tokenHierarchy != null) {
            new DocListener(this, this.tokenHierarchy);
            if (mimeType != null && this.state == ParserManager.State.NOT_PARSED) {
                try {
                    LanguagesManager.getDefault().getLanguage(mimeType);
                    this.startParsing();
                }
                catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                    // empty catch block
                }
            }
        }
        managers.put(doc, new WeakReference<ParserManagerImpl>(this));
    }

    public static ParserManagerImpl getImpl(Document document) {
        return (ParserManagerImpl)ParserManagerImpl.get(document);
    }

    @Override
    public ParserManager.State getState() {
        return this.state;
    }

    public List<SyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    @Override
    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    @Override
    public ASTNode getAST() {
        return this.ast;
    }

    @Override
    public void addListener(ParserManagerListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ParserManagerListener>();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeListener(ParserManagerListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    @Override
    public void addASTEvaluator(ASTEvaluator e) {
        Set<ASTEvaluator> evaluatorsSet;
        if (this.evaluatorsMap == null) {
            this.evaluatorsMap = new HashMap<String, Set<ASTEvaluator>>();
        }
        if ((evaluatorsSet = this.evaluatorsMap.get(e.getFeatureName())) == null) {
            evaluatorsSet = new HashSet<ASTEvaluator>();
            this.evaluatorsMap.put(e.getFeatureName(), evaluatorsSet);
        }
        evaluatorsSet.add(e);
    }

    @Override
    public void removeASTEvaluator(ASTEvaluator e) {
        Set<ASTEvaluator> evaluatorsSet;
        if (this.evaluatorsMap != null && (evaluatorsSet = this.evaluatorsMap.get(e.getFeatureName())) != null) {
            evaluatorsSet.remove(e);
        }
    }

    public void fire(final ParserManager.State state, final List<ParserManagerListener> listeners, final Map<String, Set<ASTEvaluator>> evaluators, final ASTNode root) {
        if (root == null) {
            throw new NullPointerException();
        }
        this.parsingTask = rp.post(new Runnable(){

            @Override
            public void run() {
                ((ParserManagerImpl)ParserManagerImpl.this).cancel[0] = false;
                ParserManagerImpl.this.fire2(state, listeners, evaluators, root);
            }
        });
    }

    private synchronized void startParsing() {
        this.setChange(ParserManager.State.PARSING, this.ast);
        this.cancel[0] = true;
        if (this.parsingTask != null) {
            this.parsingTask.cancel();
        }
        this.parsingTask = rp.post(new Runnable(){

            @Override
            public void run() {
                ((ParserManagerImpl)ParserManagerImpl.this).cancel[0] = false;
                ParserManagerImpl.this.parse();
            }
        }, 1000);
    }

    private void setChange(ParserManager.State state, ASTNode root) {
        if (state == this.state) {
            return;
        }
        this.state = state;
        this.ast = root;
        ArrayList<ParserManagerListener> listeners = this.listeners == null ? null : new ArrayList<ParserManagerListener>(this.listeners);
        HashMap<String, Set<ASTEvaluator>> evaluatorsMap = this.evaluatorsMap == null ? null : new HashMap<String, Set<ASTEvaluator>>(this.evaluatorsMap);
        this.fire2(state, listeners, evaluatorsMap, root);
    }

    private void fire2(ParserManager.State state, List<ParserManagerListener> listeners, Map<String, Set<ASTEvaluator>> evaluators, ASTNode root) {
        if (state == ParserManager.State.PARSING) {
            return;
        }
        if (evaluators != null && !evaluators.isEmpty()) {
            Iterator<Object> it = evaluators.values().iterator();
            while (it.hasNext()) {
                for (ASTEvaluator e : (Set)it.next()) {
                    e.beforeEvaluation(state, root);
                    if (!this.cancel[0]) continue;
                    return;
                }
            }
            this.evaluate(state, root, new ArrayList<ASTItem>(), evaluators);
            if (this.cancel[0]) {
                return;
            }
            it = evaluators.values().iterator();
            while (it.hasNext()) {
                for (ASTEvaluator e : (Set)it.next()) {
                    e.afterEvaluation(state, root);
                    if (!this.cancel[0]) continue;
                    return;
                }
            }
        }
        if (listeners != null) {
            for (ParserManagerListener l : listeners) {
                l.parsed(state, this.ast);
                if (!this.cancel[0]) continue;
                return;
            }
        }
    }

    private void evaluate(ParserManager.State state, ASTItem item, List<ASTItem> path, Map<String, Set<ASTEvaluator>> evaluatorsMap2) {
        path.add(item);
        Language language = (Language)item.getLanguage();
        if (language != null) {
            language.getFeatureList().evaluate(state, path, evaluatorsMap2);
        }
        Iterator<ASTItem> it2 = item.getChildren().iterator();
        while (it2.hasNext()) {
            if (this.cancel[0]) {
                return;
            }
            this.evaluate(state, it2.next(), path, evaluatorsMap2);
        }
        path.remove(path.size() - 1);
    }

    private void parse() {
        this.setChange(ParserManager.State.PARSING, this.ast);
        String mimeType = (String)this.document.getProperty("mimeType");
        Language language = this.getLanguage(mimeType);
        LLSyntaxAnalyser analyser = language.getAnalyser();
        TokenInput input = this.createTokenInput();
        if (this.cancel[0]) {
            return;
        }
        ArrayList<SyntaxError> newSyntaxErrors = new ArrayList<SyntaxError>();
        try {
            this.ast = analyser.read(input, true, newSyntaxErrors, this.cancel);
            this.syntaxErrors = newSyntaxErrors;
        }
        catch (ParseException ex) {
            Utils.notify(ex);
            this.ast = ASTNode.create(language, "Root", 0);
            this.setChange(ParserManager.State.OK, this.ast);
            return;
        }
        if (this.cancel[0]) {
            return;
        }
        try {
            ASTNode processedAst;
            Feature astProperties = language.getFeatureList().getFeature("AST");
            if (astProperties != null && (processedAst = (ASTNode)astProperties.getValue("process", SyntaxContext.create(this.document, ASTPath.create(this.ast)))) != null) {
                this.ast = processedAst;
            }
        }
        catch (Exception ex) {
            Utils.notify(ex);
            this.ast = ASTNode.create(language, "Root", 0);
        }
        if (this.ast == null) {
            Utils.notify(new NullPointerException());
            this.ast = ASTNode.create(language, "Root", 0);
        }
        this.setChange(ParserManager.State.OK, this.ast);
    }

    private TokenInput createTokenInput() {
        final TokenInput[] result = new TokenInput[1];
        this.document.render(new Runnable(){

            @Override
            public void run() {
                if (ParserManagerImpl.this.tokenHierarchy == null) {
                    result[0] = TokenInputUtils.create(Collections.emptyList());
                    return;
                }
                TokenSequence ts = ParserManagerImpl.this.tokenHierarchy.tokenSequence();
                List tokens = ParserManagerImpl.this.getTokens(ts);
                if (ParserManagerImpl.this.cancel[0]) {
                    return;
                }
                result[0] = TokenInputUtils.create(tokens);
            }
        });
        return result[0];
    }

    private List<ASTToken> getTokens(TokenSequence ts) {
        ArrayList<ASTToken> tokens = new ArrayList<ASTToken>();
        if (ts == null) {
            return tokens;
        }
        Language language = null;
        try {
            language = LanguagesManager.getDefault().getLanguage(ts.language().mimeType());
        }
        catch (LanguageDefinitionNotFoundException ex) {
            // empty catch block
        }
        if (!ts.moveNext()) {
            return tokens;
        }
        Token t = ts.token();
        int type = t.id().ordinal();
        int offset = ts.offset();
        String ttype = (String)t.getProperty((Object)"type");
        List<ASTToken> firstInjection = null;
        if (ttype == SLexer.INJECTED_CODE) {
            TokenSequence ts2 = ts.embedded();
            firstInjection = this.getTokens(ts2);
            if (!ts.moveNext()) {
                tokens.add(ASTToken.create((org.netbeans.api.languages.Language)language, 0, "", offset, 0, firstInjection));
                return tokens;
            }
            t = ts.token();
            type = t.id().ordinal();
            offset = ts.offset();
            ttype = (String)t.getProperty((Object)"type");
        }
        while (!this.cancel[0]) {
            if (ttype == null) {
                List<ASTToken> children = this.getTokens(ts.embedded());
                if (firstInjection != null) {
                    if (children != null) {
                        children.addAll(firstInjection);
                    } else {
                        children = firstInjection;
                    }
                    firstInjection = null;
                }
                tokens.add(ASTToken.create((org.netbeans.api.languages.Language)language, type, t.text().toString(), offset, t.length(), children));
                children = null;
            } else if (ttype == SLexer.CONTINUOUS_TOKEN_START) {
                StringBuilder sb = new StringBuilder(t.text());
                ArrayList<ASTToken> children = new ArrayList<ASTToken>();
                TokenSequence ts2 = ts.embedded();
                while (ts.moveNext()) {
                    if (this.cancel[0]) {
                        return null;
                    }
                    t = ts.token();
                    ttype = (String)t.getProperty((Object)"type");
                    if (ttype == null) {
                        ts.movePrevious();
                        break;
                    }
                    if (ttype == SLexer.INJECTED_CODE) {
                        ts2 = ts.embedded();
                        if (ts2 == null) continue;
                        List<ASTToken> tokens2 = this.getTokens(ts2);
                        if (this.cancel[0]) {
                            return null;
                        }
                        children.addAll(tokens2);
                        continue;
                    }
                    if (ttype == SLexer.CONTINUOUS_TOKEN_START) {
                        ts.movePrevious();
                        break;
                    }
                    if (ttype != SLexer.CONTINUOUS_TOKEN) {
                        throw new IllegalArgumentException();
                    }
                    if (type != t.id().ordinal()) {
                        throw new IllegalArgumentException();
                    }
                    sb.append(t.text());
                }
                int no = ts.offset() + ts.token().length();
                tokens.add(ASTToken.create((org.netbeans.api.languages.Language)language, type, sb.toString(), offset, no - offset, children));
            } else {
                throw new IllegalArgumentException();
            }
            if (!ts.moveNext()) {
                return tokens;
            }
            t = ts.token();
            type = t.id().ordinal();
            offset = ts.offset();
            ttype = (String)t.getProperty((Object)"type");
        }
        return null;
    }

    private Language getLanguage(String mimeType) {
        try {
            return LanguagesManager.getDefault().getLanguage(mimeType);
        }
        catch (LanguageDefinitionNotFoundException ex) {
            return Language.create(LanguagesManager.normalizeMimeType(mimeType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshHack() {
        for (AbstractDocument abstractDocument : managers.keySet()) {
            abstractDocument.readLock();
            try {
                MutableTextInput mti = (MutableTextInput)abstractDocument.getProperty(MutableTextInput.class);
                mti.tokenHierarchyControl().rebuild();
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
    }

    private static class DocListener
    implements TokenHierarchyListener {
        private WeakReference<ParserManagerImpl> pmwr;

        DocListener(ParserManagerImpl pm, TokenHierarchy hierarchy) {
            this.pmwr = new WeakReference<ParserManagerImpl>(pm);
            hierarchy.addTokenHierarchyListener((TokenHierarchyListener)this);
        }

        private ParserManagerImpl getPM() {
            ParserManagerImpl pm = (ParserManagerImpl)this.pmwr.get();
            if (pm != null) {
                return pm;
            }
            return null;
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
            ParserManagerImpl pm = this.getPM();
            if (pm == null) {
                return;
            }
            pm.startParsing();
        }
    }
}

