/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.maven.Bundle;

public class TextValueCompleter
implements DocumentListener {
    private static final String ACTION_FILLIN = "fill-in";
    private static final String ACTION_HIDEPOPUP = "hidepopup";
    private static final String ACTION_LISTDOWN = "listdown";
    private static final String ACTION_LISTPAGEDOWN = "listpagedown";
    private static final String ACTION_LISTUP = "listup";
    private static final String ACTION_LISTPAGEUP = "listpageup";
    private static final String ACTION_SHOWPOPUP = "showpopup";
    private Pattern pattern;
    private Collection<String> completions;
    private JList completionList;
    private DefaultListModel completionListModel;
    private JScrollPane listScroller;
    private Popup popup;
    private JTextField field;
    private String separators;
    private CaretListener caretListener;
    private boolean loading;
    private static final String LOADING = Bundle.LBL_Loading();
    private boolean partial;

    public TextValueCompleter(Collection<String> completions, JTextField fld) {
        this.completions = completions;
        this.field = fld;
        this.field.getDocument().addDocumentListener(this);
        this.field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TextValueCompleter.this.hidePopup();
            }
        });
        this.caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                if (TextValueCompleter.this.completionList.isDisplayable() && TextValueCompleter.this.completionList.isVisible()) {
                    TextValueCompleter.this.buildAndShowPopup();
                }
            }
        };
        this.field.addCaretListener(this.caretListener);
        this.completionListModel = new DefaultListModel();
        this.completionList = new JList(this.completionListModel);
        this.completionList.setFocusable(false);
        this.completionList.setPrototypeCellValue("lets have it at least this wide and add some more just in case");
        this.completionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    if (LOADING.endsWith(TextValueCompleter.this.completionList.getSelectedValue().toString())) {
                        return;
                    }
                    TextValueCompleter.this.field.getDocument().removeDocumentListener(TextValueCompleter.this);
                    TextValueCompleter.this.applyCompletion(TextValueCompleter.this.completionList.getSelectedValue().toString());
                    TextValueCompleter.this.hidePopup();
                    TextValueCompleter.this.field.getDocument().addDocumentListener(TextValueCompleter.this);
                }
            }
        });
        this.completionList.setSelectionMode(0);
        this.listScroller = new JScrollPane(this.completionList, 20, 31);
        this.listScroller.setFocusable(false);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_LISTDOWN);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_LISTUP);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(33, 0), ACTION_LISTPAGEUP);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(34, 0), ACTION_LISTPAGEDOWN);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(32, 128), ACTION_SHOWPOPUP);
        this.field.getActionMap().put(ACTION_LISTDOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextValueCompleter.this.popup == null) {
                    TextValueCompleter.this.buildAndShowPopup();
                }
                TextValueCompleter.this.completionList.setSelectedIndex(Math.min(TextValueCompleter.this.completionList.getSelectedIndex() + 1, TextValueCompleter.this.completionList.getModel().getSize()));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_LISTUP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextValueCompleter.this.popup == null) {
                    TextValueCompleter.this.buildAndShowPopup();
                }
                TextValueCompleter.this.completionList.setSelectedIndex(Math.max(TextValueCompleter.this.completionList.getSelectedIndex() - 1, 0));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_LISTPAGEDOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextValueCompleter.this.completionList.setSelectedIndex(Math.min(TextValueCompleter.this.completionList.getSelectedIndex() + TextValueCompleter.this.completionList.getVisibleRowCount(), TextValueCompleter.this.completionList.getModel().getSize()));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_LISTPAGEUP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextValueCompleter.this.completionList.setSelectedIndex(Math.max(TextValueCompleter.this.completionList.getSelectedIndex() - TextValueCompleter.this.completionList.getVisibleRowCount(), 0));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_FILLIN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selVal = TextValueCompleter.this.completionList.getSelectedValue();
                if (selVal != null && LOADING.endsWith(selVal.toString())) {
                    return;
                }
                TextValueCompleter.this.field.getDocument().removeDocumentListener(TextValueCompleter.this);
                if (selVal != null) {
                    TextValueCompleter.this.applyCompletion(selVal.toString());
                }
                TextValueCompleter.this.hidePopup();
                TextValueCompleter.this.field.getDocument().addDocumentListener(TextValueCompleter.this);
            }
        });
        this.field.getActionMap().put(ACTION_HIDEPOPUP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextValueCompleter.this.hidePopup();
            }
        });
        this.field.getActionMap().put(ACTION_SHOWPOPUP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextValueCompleter.this.buildAndShowPopup();
            }
        });
    }

    public TextValueCompleter(Collection<String> completions, JTextField fld, String separators) {
        this(completions, fld);
        this.separators = separators;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
        if (loading) {
            this.completionListModel.removeAllElements();
            this.completionListModel.addElement(LOADING);
        } else {
            this.completionListModel.removeElement(LOADING);
        }
    }

    private void buildPopup() {
        this.pattern = Pattern.compile(this.getCompletionPrefix() + ".+");
        int entryindex = 0;
        for (String completion : this.completions) {
            Matcher matcher = this.pattern.matcher(completion);
            if (matcher.matches()) {
                if (!this.completionListModel.contains(completion)) {
                    this.completionListModel.add(entryindex, completion);
                }
                ++entryindex;
                continue;
            }
            this.completionListModel.removeElement(completion);
        }
        this.completionListModel.removeElement(Bundle.PARTIAL_RESULT());
        if (this.partial) {
            this.completionListModel.addElement(Bundle.PARTIAL_RESULT());
        }
    }

    private void applyCompletion(String completed) {
        this.field.removeCaretListener(this.caretListener);
        if (this.separators != null) {
            int pos = this.field.getCaretPosition();
            String currentText = this.field.getText();
            int caretPosition = 0;
            StringTokenizer tok = new StringTokenizer(currentText, this.separators, true);
            int tokens = tok.countTokens();
            int count = 0;
            String newValue = "";
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (count + token.length() >= pos) {
                    if (this.separators.indexOf(token.charAt(0)) != -1) {
                        newValue = newValue + token;
                    }
                    newValue = newValue + completed + this.separators;
                    caretPosition = newValue.length();
                    while (tok.hasMoreTokens()) {
                        newValue = newValue + tok.nextToken();
                    }
                    this.field.setText(newValue);
                    this.field.setCaretPosition(caretPosition);
                    this.field.addCaretListener(this.caretListener);
                    return;
                }
                count += token.length();
                newValue = newValue + token;
            }
            newValue = newValue + completed + this.separators;
            this.field.setText(newValue);
            this.field.setCaretPosition(newValue.length());
        } else {
            this.field.setText(completed);
        }
        this.field.addCaretListener(this.caretListener);
    }

    private String getCompletionPrefix() {
        if (this.separators != null) {
            int pos = this.field.getCaretPosition();
            String currentText = this.field.getText();
            StringTokenizer tok = new StringTokenizer(currentText, this.separators, true);
            int count = 0;
            String lastToken = "";
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (count + token.length() >= pos) {
                    if (this.separators.indexOf(token.charAt(0)) != -1) {
                        return "";
                    }
                    return Pattern.quote(token.substring(0, pos - count));
                }
                count += token.length();
                lastToken = token;
            }
            if (lastToken.length() > 0 && this.separators.indexOf(lastToken.charAt(0)) == -1) {
                return Pattern.quote(lastToken);
            }
            return "";
        }
        return Pattern.quote(this.field.getText().trim());
    }

    private void showPopup() {
        this.hidePopup();
        if (this.completionListModel.getSize() == 0) {
            return;
        }
        Point los = this.field.getLocationOnScreen();
        int popX = los.x;
        int popY = los.y + this.field.getHeight();
        this.popup = PopupFactory.getSharedInstance().getPopup(this.field, this.listScroller, popX, popY);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(27, 0), ACTION_HIDEPOPUP);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ACTION_FILLIN);
        this.popup.show();
        if (this.completionList.getSelectedIndex() != -1) {
            this.completionList.ensureIndexIsVisible(this.completionList.getSelectedIndex());
        }
    }

    private void hidePopup() {
        this.field.getInputMap().remove(KeyStroke.getKeyStroke(27, 0));
        this.field.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private void buildAndShowPopup() {
        this.buildPopup();
        this.showPopup();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.field.isFocusOwner()) {
            this.buildAndShowPopup();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.field.isFocusOwner() && this.completionList.isDisplayable() && this.completionList.isVisible()) {
            this.buildAndShowPopup();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.field.isFocusOwner()) {
            this.buildAndShowPopup();
        }
    }

    public void setValueList(Collection<String> values, boolean partial) {
        assert (SwingUtilities.isEventDispatchThread());
        this.completionListModel.removeAllElements();
        this.completions = values;
        this.partial = partial;
        if (this.field.isFocusOwner() && this.completionList.isDisplayable() && this.completionList.isVisible()) {
            this.buildAndShowPopup();
        }
    }
}

