/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MissingModulesProblemProvider
implements ProjectProblemsProvider {
    private static final RequestProcessor RP = new RequestProcessor(MissingModulesProblemProvider.class);
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Project project;
    private EnablementListener listener;
    private String lastPackaging;
    private final AtomicBoolean projectListenerSet = new AtomicBoolean(false);
    private final PropertyChangeListener projectListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName()) && MissingModulesProblemProvider.this.lastPackaging != null && !MissingModulesProblemProvider.this.lastPackaging.equals(((NbMavenProject)MissingModulesProblemProvider.this.project.getLookup().lookup(NbMavenProject.class)).getPackagingType())) {
                MissingModulesProblemProvider.this.firePropertyChange();
            }
        }
    };
    private final Set<String> packagings;
    private final String moduleCodenameBase;
    private final String kitCodeNameBase;
    private final String problemDescription;
    private final String problemName;

    public static ProjectProblemsProvider j2ee(Project project) {
        HashSet<String> packs = new HashSet<String>();
        packs.add("war");
        packs.add("ear");
        packs.add("ejb");
        return new MissingModulesProblemProvider(project, packs, "org.netbeans.modules.maven.j2ee", "org.netbeans.modules.j2ee.kit", Bundle.ERR_MissingJ2eeModule(), Bundle.MSG_MissingJ2eeModule());
    }

    public static ProjectProblemsProvider apisupport(Project project) {
        HashSet<String> packs = new HashSet<String>();
        packs.add("nbm");
        packs.add("nbm-application");
        return new MissingModulesProblemProvider(project, packs, "org.netbeans.modules.maven.apisupport", "org.netbeans.modules.apisupport.kit", Bundle.ERR_MissingApisupportModule(), Bundle.MSG_MissingApisupportModule());
    }

    private MissingModulesProblemProvider(Project project, Set<String> packagings, String moduleCodenameBase, String kitCodeNameBase, String errorMessage, String errorDescription) {
        this.project = project;
        this.packagings = packagings;
        this.moduleCodenameBase = moduleCodenameBase;
        this.kitCodeNameBase = kitCodeNameBase;
        this.problemName = errorMessage;
        this.problemDescription = errorDescription;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        if (this.projectListenerSet.compareAndSet(false, true)) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.projectListener);
        }
        return this.doIDEConfigChecks();
    }

    public synchronized Collection<ProjectProblemsProvider.ProjectProblem> doIDEConfigChecks() {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        NbMavenProject nbproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        String packaging = nbproject.getPackagingType();
        if (this.packagings.contains(packaging)) {
            boolean foundModule;
            ModuleInfo moduleInfo = this.listener != null ? this.listener.info : this.findModule(this.moduleCodenameBase);
            boolean bl = foundModule = moduleInfo != null && moduleInfo.isEnabled();
            if (!foundModule) {
                if (this.listener == null) {
                    ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createWarning((String)this.problemName, (String)this.problemDescription, (ProjectProblemResolver)new InstallModulesResolver(this.kitCodeNameBase));
                    this.listener = new EnablementListener(moduleInfo, problem);
                    this.listener.startListening();
                }
                toRet.add(this.listener.problem);
            } else if (this.listener != null) {
                this.listener.stopListening();
                this.listener = null;
            }
        }
        this.lastPackaging = packaging;
        return toRet;
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("problems", null, null);
    }

    private ModuleInfo findModule(@NonNull String codenamebase) {
        Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo info : infos) {
            if (!codenamebase.equals(info.getCodeNameBase())) continue;
            return info;
        }
        return null;
    }

    private static class InstallModulesResolver
    implements ProjectProblemResolver {
        private final String codenamebase;

        public InstallModulesResolver(String codenamebase) {
            this.codenamebase = codenamebase;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FutureTask<ProjectProblemsProvider.Result> task = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

                @Override
                public ProjectProblemsProvider.Result call() throws Exception {
                    final ProjectProblemsProvider.Result[] res = new ProjectProblemsProvider.Result[1];
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Object retval = PluginManager.install(Collections.singleton(InstallModulesResolver.this.codenamebase), (Object[])new Object[0]);
                                res[0] = retval == null ? ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED) : ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        res[0] = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                    }
                    catch (InvocationTargetException ex) {
                        res[0] = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                    }
                    return res[0];
                }
            });
            RP.execute(task);
            return task;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.codenamebase != null ? this.codenamebase.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstallModulesResolver other = (InstallModulesResolver)obj;
            return !(this.codenamebase == null ? other.codenamebase != null : !this.codenamebase.equals(other.codenamebase));
        }
    }

    private class EnablementListener
    implements PropertyChangeListener {
        @NullAllowed
        private final ModuleInfo info;
        @NonNull
        private final ProjectProblemsProvider.ProjectProblem problem;

        public EnablementListener(@NonNull ModuleInfo info, ProjectProblemsProvider.ProjectProblem problem) {
            this.info = info;
            this.problem = problem;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName()) && this.info != null && this.info.isEnabled()) {
                this.info.removePropertyChangeListener((PropertyChangeListener)this);
                MissingModulesProblemProvider.this.firePropertyChange();
            }
        }

        public void stopListening() {
            if (this.info != null) {
                this.info.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private void startListening() {
            if (this.info != null) {
                this.info.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

