/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class RunJarStartupArgs
implements LateBoundPrerequisitesChecker {
    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        StartupExtender.StartMode mode;
        String actionName = config.getActionName();
        if ("run".equals(actionName) || "run.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if ("debug".equals(actionName) || "debug.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if ("profile".equals(actionName) || "profile.single".equals(actionName) || "profile.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if ("profile.test.single".equals(actionName)) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return true;
        }
        boolean isTestScope = false;
        for (Map.Entry<? extends String, ? extends String> entry : config.getProperties().entrySet()) {
            if (entry.getKey().equals("exec.args")) {
                ArrayList args = new ArrayList();
                InstanceContent ic = new InstanceContent();
                Project p = config.getProject();
                if (p != null) {
                    ic.add((Object)p);
                    ActiveJ2SEPlatformProvider pp = (ActiveJ2SEPlatformProvider)p.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
                    if (pp != null) {
                        ic.add((Object)pp.getJavaPlatform());
                    }
                }
                for (StartupExtender group : StartupExtender.getExtenders((Lookup)new AbstractLookup((AbstractLookup.Content)ic), (StartupExtender.StartMode)mode)) {
                    args.addAll(group.getArguments());
                }
                if (!args.isEmpty()) {
                    StringBuilder b = new StringBuilder();
                    for (String arg : args) {
                        b.append(arg).append(' ');
                    }
                    b.append(entry.getValue());
                    config.setProperty(entry.getKey(), b.toString());
                }
            }
            if (!entry.getKey().equals("exec.classpathScope") || !"test".equals(entry.getValue())) continue;
            isTestScope = true;
        }
        if (isTestScope) {
            String[] goals = config.getGoals().toArray(new String[0]);
            for (int i = 0; i < goals.length; ++i) {
                if (!"process-classes".equals(goals[i])) continue;
                goals[i] = "process-test-classes";
            }
            ((BeanRunConfig)config).setGoals(new ArrayList<String>(Arrays.asList(goals)));
        }
        return true;
    }
}

