/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

public final class MessageBuilder<T> {
    private final T payload;
    private MessageHeaderAccessor headerAccessor;
    private final Message<T> originalMessage;

    private MessageBuilder(T payload, Message<T> originalMessage) {
        Assert.notNull(payload, (String)"payload must not be null");
        this.payload = payload;
        this.originalMessage = originalMessage;
        this.headerAccessor = new MessageHeaderAccessor(originalMessage);
    }

    public static <T> MessageBuilder<T> fromMessage(Message<T> message) {
        Assert.notNull(message, (String)"message must not be null");
        return new MessageBuilder<T>(message.getPayload(), message);
    }

    public static <T> MessageBuilder<T> withPayload(T payload) {
        return new MessageBuilder<T>(payload, null);
    }

    public MessageBuilder<T> setHeaders(MessageHeaderAccessor headerAccessor) {
        Assert.notNull((Object)headerAccessor, (String)"HeaderAccessor must not be null");
        this.headerAccessor = headerAccessor;
        return this;
    }

    public MessageBuilder<T> setHeader(String headerName, Object headerValue) {
        this.headerAccessor.setHeader(headerName, headerValue);
        return this;
    }

    public MessageBuilder<T> setHeaderIfAbsent(String headerName, Object headerValue) {
        this.headerAccessor.setHeaderIfAbsent(headerName, headerValue);
        return this;
    }

    public MessageBuilder<T> removeHeaders(String ... headerPatterns) {
        this.headerAccessor.removeHeaders(headerPatterns);
        return this;
    }

    public MessageBuilder<T> removeHeader(String headerName) {
        this.headerAccessor.removeHeader(headerName);
        return this;
    }

    public MessageBuilder<T> copyHeaders(Map<String, ?> headersToCopy) {
        this.headerAccessor.copyHeaders(headersToCopy);
        return this;
    }

    public MessageBuilder<T> copyHeadersIfAbsent(Map<String, ?> headersToCopy) {
        this.headerAccessor.copyHeadersIfAbsent(headersToCopy);
        return this;
    }

    public MessageBuilder<T> setReplyChannel(MessageChannel replyChannel) {
        this.headerAccessor.setReplyChannel(replyChannel);
        return this;
    }

    public MessageBuilder<T> setReplyChannelName(String replyChannelName) {
        this.headerAccessor.setReplyChannelName(replyChannelName);
        return this;
    }

    public MessageBuilder<T> setErrorChannel(MessageChannel errorChannel) {
        this.headerAccessor.setErrorChannel(errorChannel);
        return this;
    }

    public MessageBuilder<T> setErrorChannelName(String errorChannelName) {
        this.headerAccessor.setErrorChannelName(errorChannelName);
        return this;
    }

    public Message<T> build() {
        if (this.originalMessage != null && !this.headerAccessor.isModified()) {
            return this.originalMessage;
        }
        if (this.payload instanceof Throwable) {
            return new ErrorMessage((Throwable)this.payload, this.headerAccessor.toMap());
        }
        return new GenericMessage<T>(this.payload, this.headerAccessor.toMap());
    }
}

